"""
	File generated by UShareSoft
"""

import objects
import StringIO
import urllib

class _Objects(object):
	@classmethod
	def parseEtree(cls, inFileName, silence=False):
		exception = Exception('No parser found')
		for xsd in filter(lambda d: not d.startswith('__'), dir(objects)):
			try:
				return getattr(objects, xsd).parseEtree(inFileName, silence)
			except BaseException as e:
				exception = e
		raise exception

	@classmethod
	def parse(cls, inFileName, silence=False):
		exception = Exception('No parser found')
		for xsd in filter(lambda d: not d.startswith('__'), dir(objects)):
			try:
				return getattr(objects, xsd).parse(inFileName, silence)
			except BaseException as e:
				exception = e
		raise exception

	@classmethod
	def parseLiteral(cls, inFileName, silence=False):
		exception = Exception('No parser found')
		for xsd in filter(lambda d: not d.startswith('__'), dir(objects)):
			try:
				return getattr(objects, xsd).parseLiteral(inFileName, silence)
			except BaseException as e:
				exception = e
		raise exception

	@classmethod
	def parseString(cls, string, silence=False):
		exception = Exception('No parser found')
		for xsd in filter(lambda d: not d.startswith('__'), dir(objects)):
			try:
				return getattr(objects, xsd).parseString(string, silence)
			except BaseException as e:
				exception = e
		raise exception

class _CommonAPIClass(object):
	def _get(self, arg):
		if hasattr(self, arg):
			ret = getattr(self, arg)
			delattr(self, arg)
			return ret
		elif hasattr(self, '_parent') and self._parent:
			return self._parent._get(arg)
		else:
			raise Exception('Argument "%s" is not set' % (arg))
	def _REST(self, url, method, body, **kwargs):
		obj = self
		while obj <> None and not hasattr(obj, '_client'):
			if hasattr(obj, '_parent'):
				obj = obj._parent
			else:
				obj = None
		if obj == None:
			raise Exception('HTTP client not found')

		# Build headers
		requestHttpHeader = dict(obj._headers)
		requestHttpHeader['Content-Type'] = 'application/xml'
		requestHttpHeader['Accept'] = 'application/xml'

		# Build request
		fullUrl = obj._url + url
		if kwargs:
			fullUrl+="?"
			for key, value in kwargs.iteritems():
				if value is not None:
					keyVal=urllib.urlencode({ key : value})
					fullUrl+=keyVal+"&"
			if fullUrl[-1]=="&" or fullUrl[-1]=="?":
				fullUrl=fullUrl[:-1]
		if body:
			try:
				io = StringIO.StringIO()
				body.export(io, 0)
				body = io.getvalue()
			except:
				pass

		resp, content = obj._client.request(fullUrl, method.upper(), body = body, headers = requestHttpHeader)
		if resp.status < 200 or resp.status >= 300:
			raise Exception(_Objects.parseString(content, True))
		if 'content-type' in resp and resp['content-type']=="application/xml":
			return _Objects.parseString(content, True)
		else:
			return content
class Api(_CommonAPIClass):
	def __init__(self, url, client = None, headers = {}):
		self._client = client
		self._headers = headers
		self._url = url
		self.Status = Api._Status(self)
		self.Statistics = Api._Statistics(self)
		self.Users = Api._Users(self)
		self.Galleries = Api._Galleries(self)
		self.Usage = Api._Usage(self)
		self.Usergroups = Api._Usergroups(self)
		self.Uforge = Api._Uforge(self)
		self.Entitlements = Api._Entitlements(self)
		self.Orgs = Api._Orgs(self)
		self.Oas = Api._Oas(self)
		self.Distributions = Api._Distributions(self)
		pass
	
	class _Status(_CommonAPIClass):
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			pass
		
		#URL: status
		def Get(self, body=None):
			kwargs = {}
			return self._REST('/status', 'GET', body, **kwargs)
		
	
	class _Statistics(_CommonAPIClass):
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			pass
		
		#URL: statistics
		def Get(self, Type, Filter, Fromdate, Todate, Graphtype, Nb, Order, Groupby, Periodicity, Org, body=None):
			kwargs = {'type': Type, 'filter': Filter, 'fromDate': Fromdate, 'toDate': Todate, 'graphType': Graphtype, 'nb': Nb, 'order': Order, 'groupby': Groupby, 'periodicity': Periodicity, 'org': Org}
			return self._REST('/statistics', 'GET', body, **kwargs)
		
	
	class _Users(_CommonAPIClass):
		def __call__(self, Uid=None):
			self.Uid = Uid
			return self
	
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			self.Imports = Api._Users._Imports(self)
			self.Galleries = Api._Users._Galleries(self)
			self.Quotas = Api._Users._Quotas(self)
			self.Instances = Api._Users._Instances(self)
			self.Accounts = Api._Users._Accounts(self)
			self.Appliances = Api._Users._Appliances(self)
			self.Images = Api._Users._Images(self)
			self.Apikeys = Api._Users._Apikeys(self)
			self.Distros = Api._Users._Distros(self)
			self.Stats = Api._Users._Stats(self)
			self.Mysoftware = Api._Users._Mysoftware(self)
			self.Migrations = Api._Users._Migrations(self)
			self.Photo = Api._Users._Photo(self)
			self.Usage = Api._Users._Usage(self)
			self.Scans = Api._Users._Scans(self)
			self.Activities = Api._Users._Activities(self)
			self.Workspaces = Api._Users._Workspaces(self)
			self.Forgotpassword = Api._Users._Forgotpassword(self)
			self.Sshkeys = Api._Users._Sshkeys(self)
			self.Blueprints = Api._Users._Blueprints(self)
			self.Roles = Api._Users._Roles(self)
			self.Pimages = Api._Users._Pimages(self)
			self.Scannedinstances = Api._Users._Scannedinstances(self)
			self.Formats = Api._Users._Formats(self)
			self.Orgs = Api._Users._Orgs(self)
			pass
		
		#URL: users/{uid}
		def Get(self, body=None):
			kwargs = {}
			return self._REST('/users/' + str(self._get('Uid')) + '', 'GET', body, **kwargs)
		
		#URL: users
		def Getall(self, Orgname=None, Active=None, body=None):
			kwargs = {'orgName': Orgname, 'active': Active}
			return self._REST('/users', 'GET', body, **kwargs)
		
		#URL: users
		def Create(self, Notify, Notifyadmin, Org, Publisher=None, Admin=None, Autopasswd=None, body=None):
			kwargs = {'notify': Notify, 'notifyAdmin': Notifyadmin, 'org': Org, 'publisher': Publisher, 'admin': Admin, 'autopasswd': Autopasswd}
			return self._REST('/users', 'POST', body, **kwargs)
		
		#URL: users/{uid}
		def Update(self, body=None):
			kwargs = {}
			return self._REST('/users/' + str(self._get('Uid')) + '', 'PUT', body, **kwargs)
		class _Imports(_CommonAPIClass):
			def __call__(self, Iid=None):
				self.Iid = Iid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Status = Api._Users._Imports._Status(self)
				self.Uploads = Api._Users._Imports._Uploads(self)
				pass
			
			#URL: users/{uid}/imports
			def Import(self, Appliancename, Applianceversion, Imported, Force, Reusebundles, Usemajor=None, body=None):
				kwargs = {'applianceName': Appliancename, 'applianceVersion': Applianceversion, 'imported': Imported, 'force': Force, 'reuseBundles': Reusebundles, 'useMajor': Usemajor}
				return self._REST('/users/' + str(self._get('Uid')) + '/imports', 'POST', body, **kwargs)
			
			#URL: users/{uid}/imports/{iid}
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/imports/' + str(self._get('Iid')) + '', 'GET', body, **kwargs)
			class _Status(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/imports/{iid}/status
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/imports/' + str(self._get('Iid')) + '/status', 'GET', body, **kwargs)
				
			
			class _Uploads(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/imports/{iid}/uploads
				def Upload(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/imports/' + str(self._get('Iid')) + '/uploads', 'POST', body, **kwargs)
				
			
		
		class _Galleries(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/galleries
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/galleries', 'GET', body, **kwargs)
			
		
		class _Quotas(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/quotas
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/quotas', 'GET', body, **kwargs)
			
			#URL: users/{uid}/quotas
			def Update(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/quotas', 'PUT', body, **kwargs)
			
		
		class _Instances(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/instances
			def Get(self, Refresh, Id=None, body=None):
				kwargs = {'refresh': Refresh, 'id': Id}
				return self._REST('/users/' + str(self._get('Uid')) + '/instances', 'GET', body, **kwargs)
			
		
		class _Accounts(_CommonAPIClass):
			def __call__(self, Caid=None):
				self.Caid = Caid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Certs = Api._Users._Accounts._Certs(self)
				self.Resources = Api._Users._Accounts._Resources(self)
				pass
			
			#URL: users/{uid}/accounts/{caid}
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/accounts/' + str(self._get('Caid')) + '', 'GET', body, **kwargs)
			
			#URL: users/{uid}/accounts/{caid}
			def Delete(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/accounts/' + str(self._get('Caid')) + '', 'DELETE', body, **kwargs)
			
			#URL: users/{uid}/accounts
			def Create(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/accounts', 'POST', body, **kwargs)
			
			#URL: users/{uid}/accounts/{caid}
			def Update(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/accounts/' + str(self._get('Caid')) + '', 'PUT', body, **kwargs)
			
			#URL: users/{uid}/accounts
			def Getall(self, Name=None, body=None):
				kwargs = {'name': Name}
				return self._REST('/users/' + str(self._get('Uid')) + '/accounts', 'GET', body, **kwargs)
			class _Certs(_CommonAPIClass):
				def __call__(self, Certid=None, Filename=None):
					self.Certid = Certid
					self.Filename = Filename
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/accounts/{caid}/certs/{certid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/accounts/' + str(self._get('Caid')) + '/certs/' + str(self._get('Certid')) + '', 'DELETE', body, **kwargs)
				
				#URL: users/{uid}/accounts/{caid}/certs
				def Create(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/accounts/' + str(self._get('Caid')) + '/certs', 'POST', body, **kwargs)
				
				#URL: users/{uid}/accounts/{caid}/certs/{certid}/{fileName}
				def Upload(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/accounts/' + str(self._get('Caid')) + '/certs/' + str(self._get('Certid')) + '/' + str(self._get('Filename')) + '', 'POST', body, **kwargs)
				
				#URL: users/{uid}/accounts/{caid}/certs/{certid}
				def Get(self, Downloadid=None, body=None):
					kwargs = {'downloadId': Downloadid}
					return self._REST('/users/' + str(self._get('Uid')) + '/accounts/' + str(self._get('Caid')) + '/certs/' + str(self._get('Certid')) + '', 'GET', body, **kwargs)
				
			
			class _Resources(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/accounts/{caid}/resources
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/accounts/' + str(self._get('Caid')) + '/resources', 'GET', body, **kwargs)
				
			
		
		class _Appliances(_CommonAPIClass):
			def __call__(self, Aid=None):
				self.Aid = Aid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Exports = Api._Users._Appliances._Exports(self)
				self.Osprofile = Api._Users._Appliances._Osprofile(self)
				self.Logs = Api._Users._Appliances._Logs(self)
				self.Pimages = Api._Users._Appliances._Pimages(self)
				self.Mysoftware = Api._Users._Appliances._Mysoftware(self)
				self.Sharedtemplates = Api._Users._Appliances._Sharedtemplates(self)
				self.Clones = Api._Users._Appliances._Clones(self)
				self.Bootscripts = Api._Users._Appliances._Bootscripts(self)
				self.Oas = Api._Users._Appliances._Oas(self)
				self.Confmgmtplts = Api._Users._Appliances._Confmgmtplts(self)
				self.Images = Api._Users._Appliances._Images(self)
				self.Logo = Api._Users._Appliances._Logo(self)
				self.Installprofile = Api._Users._Appliances._Installprofile(self)
				self.Projects = Api._Users._Appliances._Projects(self)
				pass
			
			#URL: users/{uid}/appliances/{aid}
			def Delete(self, Force=None, body=None):
				kwargs = {'force': Force}
				return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '', 'DELETE', body, **kwargs)
			
			#URL: users/{uid}/appliances/{aid}
			def Update(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '', 'PUT', body, **kwargs)
			
			#URL: users/{uid}/appliances
			def Create(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/appliances', 'POST', body, **kwargs)
			
			#URL: users/{uid}/appliances
			def Getall(self, Name=None, Version=None, body=None):
				kwargs = {'name': Name, 'version': Version}
				return self._REST('/users/' + str(self._get('Uid')) + '/appliances', 'GET', body, **kwargs)
			
			#URL: users/{uid}/appliances/{aid}
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '', 'GET', body, **kwargs)
			class _Exports(_CommonAPIClass):
				def __call__(self, Eid=None):
					self.Eid = Eid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Status = Api._Users._Appliances._Exports._Status(self)
					self.Downloads = Api._Users._Appliances._Exports._Downloads(self)
					pass
				
				#URL: users/{uid}/appliances/{aid}/exports
				def Export(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/exports', 'POST', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/exports/{eid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/exports/' + str(self._get('Eid')) + '', 'DELETE', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/exports/{eid}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/exports/' + str(self._get('Eid')) + '', 'GET', body, **kwargs)
				class _Status(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/exports/{eid}/status
					def Cancel(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/exports/' + str(self._get('Eid')) + '/status', 'DELETE', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/exports/{eid}/status
					def Get(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/exports/' + str(self._get('Eid')) + '/status', 'GET', body, **kwargs)
					
				
				class _Downloads(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/exports/{eid}/downloads
					def Download(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/exports/' + str(self._get('Eid')) + '/downloads', 'GET', body, **kwargs)
					
				
			
			class _Osprofile(_CommonAPIClass):
				def __call__(self, Osid=None):
					self.Osid = Osid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Services = Api._Users._Appliances._Osprofile._Services(self)
					self.Updates = Api._Users._Appliances._Osprofile._Updates(self)
					self.Pkgs = Api._Users._Appliances._Osprofile._Pkgs(self)
					pass
				
				#URL: users/{uid}/appliances/{aid}/osprofile
				def Create(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/osprofile', 'POST', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/osprofile/{osid}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/osprofile/' + str(self._get('Osid')) + '', 'GET', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/osprofile/{osid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/osprofile/' + str(self._get('Osid')) + '', 'DELETE', body, **kwargs)
				class _Services(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/osprofile/{osid}/services
					def Getall(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/osprofile/' + str(self._get('Osid')) + '/services', 'GET', body, **kwargs)
					
				
				class _Updates(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/osprofile/{osid}/updates
					def Save(self, At, body=None):
						kwargs = {'at': At}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/osprofile/' + str(self._get('Osid')) + '/updates', 'PUT', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/osprofile/{osid}/updates
					def Get(self, From=None, To=None, Simulate=None, At=None, body=None):
						kwargs = {'from': From, 'to': To, 'simulate': Simulate, 'at': At}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/osprofile/' + str(self._get('Osid')) + '/updates', 'GET', body, **kwargs)
					
				
				class _Pkgs(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/osprofile/{osid}/pkgs
					def Getall(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/osprofile/' + str(self._get('Osid')) + '/pkgs', 'GET', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/osprofile/{osid}/pkgs
					def Updateall(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/osprofile/' + str(self._get('Osid')) + '/pkgs', 'PUT', body, **kwargs)
					
				
			
			class _Logs(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/appliances/{aid}/logs
				def Deleteall(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/logs', 'DELETE', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/logs
				def Getall(self, From=None, To=None, body=None):
					kwargs = {'from': From, 'to': To}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/logs', 'GET', body, **kwargs)
				
			
			class _Pimages(_CommonAPIClass):
				def __call__(self, Pitid=None):
					self.Pitid = Pitid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Downloads = Api._Users._Appliances._Pimages._Downloads(self)
					self.Statuses = Api._Users._Appliances._Pimages._Statuses(self)
					pass
				
				#URL: users/{uid}/appliances/{aid}/pimages
				def Getall(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/pimages', 'GET', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/pimages
				def Publish(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/pimages', 'POST', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/pimages
				def Deleteall(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/pimages', 'DELETE', body, **kwargs)
				class _Downloads(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/pimages/{pitid}/downloads
					def Download(self, Id, body=None):
						kwargs = {'id': Id}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/pimages/' + str(self._get('Pitid')) + '/downloads', 'GET', body, **kwargs)
					
				
				class _Statuses(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/pimages/statuses
					def Getall(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/pimages/statuses', 'GET', body, **kwargs)
					
				
			
			class _Mysoftware(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/appliances/{aid}/mysoftware
				def Getall(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/mysoftware', 'GET', body, **kwargs)
				
			
			class _Sharedtemplates(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Statuses = Api._Users._Appliances._Sharedtemplates._Statuses(self)
					pass
				
				#URL: users/{uid}/appliances/{aid}/sharedTemplates
				def Get(self, Parent=None, body=None):
					kwargs = {'parent': Parent}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/sharedTemplates', 'GET', body, **kwargs)
				class _Statuses(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/sharedTemplates/statuses
					def Get(self, Parent=None, body=None):
						kwargs = {'parent': Parent}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/sharedTemplates/statuses', 'GET', body, **kwargs)
					
				
			
			class _Clones(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/appliances/{aid}/clones
				def Clone(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/clones', 'POST', body, **kwargs)
				
			
			class _Bootscripts(_CommonAPIClass):
				def __call__(self, Bsid=None):
					self.Bsid = Bsid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Bin = Api._Users._Appliances._Bootscripts._Bin(self)
					pass
				
				#URL: users/{uid}/appliances/{aid}/bootscripts
				def Create(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/bootscripts', 'POST', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/bootscripts/{bsid}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/bootscripts/' + str(self._get('Bsid')) + '', 'GET', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/bootscripts/{bsid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/bootscripts/' + str(self._get('Bsid')) + '', 'DELETE', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/bootscripts
				def Getall(self, Name=None, body=None):
					kwargs = {'name': Name}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/bootscripts', 'GET', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/bootscripts
				def Deleteall(self, Id=None, Type=None, Name=None, body=None):
					kwargs = {'id': Id, 'type': Type, 'name': Name}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/bootscripts', 'DELETE', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/bootscripts/{bsid}
				def Update(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/bootscripts/' + str(self._get('Bsid')) + '', 'PUT', body, **kwargs)
				class _Bin(_CommonAPIClass):
					def __call__(self, Filename=None):
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/bootscripts/{bsid}/bin/{fileName}
					def Upload(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/bootscripts/' + str(self._get('Bsid')) + '/bin/' + str(self._get('Filename')) + '', 'POST', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/bootscripts/{bsid}/bin/{fileName}
					def Download(self, Downloadid=None, body=None):
						kwargs = {'downloadId': Downloadid}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/bootscripts/' + str(self._get('Bsid')) + '/bin/' + str(self._get('Filename')) + '', 'GET', body, **kwargs)
					
				
			
			class _Oas(_CommonAPIClass):
				def __call__(self, Oaspkgid=None):
					self.Oaspkgid = Oaspkgid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Bin = Api._Users._Appliances._Oas._Bin(self)
					self.Licenses = Api._Users._Appliances._Oas._Licenses(self)
					pass
				
				#URL: users/{uid}/appliances/{aid}/oas/{oaspkgid}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/oas/' + str(self._get('Oaspkgid')) + '', 'GET', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/oas/{oaspkgid}
				def Update(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/oas/' + str(self._get('Oaspkgid')) + '', 'PUT', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/oas/{oaspkgid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/oas/' + str(self._get('Oaspkgid')) + '', 'DELETE', body, **kwargs)
				class _Bin(_CommonAPIClass):
					def __call__(self, Filename=None):
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/oas/{oaspkgid}/bin
					def Download(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/oas/' + str(self._get('Oaspkgid')) + '/bin', 'GET', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/oas/{oaspkgid}/bin/{fileName}
					def Upload(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/oas/' + str(self._get('Oaspkgid')) + '/bin/{fileName}', 'POST', body, **kwargs)
					
				
				class _Licenses(_CommonAPIClass):
					def __call__(self, Oaslid=None, Filename=None):
						self.Oaslid = Oaslid
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/oas/{oaspkgid}/licenses/{oaslid}/{fileName}
					def Upload(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/oas/' + str(self._get('Oaspkgid')) + '/licenses/' + str(self._get('Oaslid')) + '/' + str(self._get('Filename')) + '', 'POST', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/oas/{oaspkgid}/licenses/{oaslid}
					def Get(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/oas/' + str(self._get('Oaspkgid')) + '/licenses/' + str(self._get('Oaslid')) + '', 'GET', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/oas/{oaspkgid}/licenses/{oaslid}
					def Delete(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/oas/' + str(self._get('Oaspkgid')) + '/licenses/' + str(self._get('Oaslid')) + '', 'DELETE', body, **kwargs)
					
				
			
			class _Confmgmtplts(_CommonAPIClass):
				def __call__(self, Cmid=None):
					self.Cmid = Cmid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/appliances/{aid}/confmgmtplts/{cmid}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/confmgmtplts/' + str(self._get('Cmid')) + '', 'GET', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/confmgmtplts
				def Create(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/confmgmtplts', 'POST', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/confmgmtplts
				def Getall(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/confmgmtplts', 'GET', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/confmgmtplts/{cmid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/confmgmtplts/' + str(self._get('Cmid')) + '', 'DELETE', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/confmgmtplts/{cmid}
				def Update(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/confmgmtplts/' + str(self._get('Cmid')) + '', 'PUT', body, **kwargs)
				
			
			class _Images(_CommonAPIClass):
				def __call__(self, Itid=None):
					self.Itid = Itid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Status = Api._Users._Appliances._Images._Status(self)
					self.Pimages = Api._Users._Appliances._Images._Pimages(self)
					self.Downloads = Api._Users._Appliances._Images._Downloads(self)
					self.Pkgs = Api._Users._Appliances._Images._Pkgs(self)
					self.Statuses = Api._Users._Appliances._Images._Statuses(self)
					pass
				
				#URL: users/{uid}/appliances/{aid}/images/{itid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '', 'DELETE', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/images
				def Deleteall(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images', 'DELETE', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/images/{itid}
				def Regenerate(self, Force=None, body=None):
					kwargs = {'force': Force}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '', 'POST', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/images
				def Generate(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images', 'POST', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/images
				def Getall(self, Format=None, Latest=None, body=None):
					kwargs = {'format': Format, 'latest': Latest}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images', 'GET', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/images/{itid}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '', 'GET', body, **kwargs)
				class _Status(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/images/{itid}/status
					def Cancel(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/status', 'DELETE', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/images/{itid}/status
					def Get(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/status', 'GET', body, **kwargs)
					
				
				class _Pimages(_CommonAPIClass):
					def __call__(self, Pitid=None):
						self.Pitid = Pitid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Status = Api._Users._Appliances._Images._Pimages._Status(self)
						self.Instances = Api._Users._Appliances._Images._Pimages._Instances(self)
						self.Cancel = Api._Users._Appliances._Images._Pimages._Cancel(self)
						pass
					
					#URL: users/{uid}/appliances/{aid}/images/{itid}/pimages
					def Publish(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/pimages', 'POST', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/images/{itid}/pimages/{pitid}
					def Delete(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '', 'DELETE', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/images/{itid}/pimages/{pitid}
					def Get(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '', 'GET', body, **kwargs)
					class _Status(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/appliances/{aid}/images/{itid}/pimages/{pitid}/status
						def Get(self, body=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/status', 'GET', body, **kwargs)
						
					
					class _Instances(_CommonAPIClass):
						def __call__(self, Riid=None):
							self.Riid = Riid
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							self.Status = Api._Users._Appliances._Images._Pimages._Instances._Status(self)
							self.States = Api._Users._Appliances._Images._Pimages._Instances._States(self)
							pass
						
						#URL: users/{uid}/appliances/{aid}/images/{itid}/pimages/{pitid}/instances/{riid}
						def Delete(self, Force, body=None):
							kwargs = {'force': Force}
							return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/{itid}/pimages/' + str(self._get('Pitid')) + '/instances/' + str(self._get('Riid')) + '', 'DELETE', body, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/images/{itid}/pimages/{pitid}/instances/{riid}
						def Get(self, body=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/{itid}/pimages/' + str(self._get('Pitid')) + '/instances/' + str(self._get('Riid')) + '', 'GET', body, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/images/{itid}/pimages/{pitid}/instances
						def Start(self, body=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/{itid}/pimages/' + str(self._get('Pitid')) + '/instances', 'POST', body, **kwargs)
						class _Status(_CommonAPIClass):
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								pass
							
							#URL: users/{uid}/appliances/{aid}/images/{itid}/pimages/{pitid}/instances/{riid}/status
							def Get(self, body=None):
								kwargs = {}
								return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/{itid}/pimages/' + str(self._get('Pitid')) + '/instances/' + str(self._get('Riid')) + '/status', 'GET', body, **kwargs)
							
						
						class _States(_CommonAPIClass):
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								pass
							
							#URL: users/{uid}/appliances/{aid}/images/{itid}/pimages/{pitid}/instances/{riid}/states
							def Change(self, Action, body=None):
								kwargs = {'action': Action}
								return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/{itid}/pimages/' + str(self._get('Pitid')) + '/instances/' + str(self._get('Riid')) + '/states', 'PUT', body, **kwargs)
							
						
					
					class _Cancel(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/appliances/{aid}/images/{itid}/pimages/{pitid}/cancel
						def Cancel(self, body=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/cancel', 'DELETE', body, **kwargs)
						
					
				
				class _Downloads(_CommonAPIClass):
					def __call__(self, Filename=None):
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/images/{itid}/downloads/{fileName}
					def Download(self, Downloadid=None, body=None):
						kwargs = {'downloadId': Downloadid}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/downloads/' + str(self._get('Filename')) + '', 'GET', body, **kwargs)
					
				
				class _Pkgs(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/images/{itid}/pkgs
					def Getall(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/' + str(self._get('Itid')) + '/pkgs', 'GET', body, **kwargs)
					
				
				class _Statuses(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/images/statuses
					def Getall(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/images/statuses', 'GET', body, **kwargs)
					
				
			
			class _Logo(_CommonAPIClass):
				def __call__(self, Logoid=None, Filename=None):
					self.Logoid = Logoid
					self.Filename = Filename
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/appliances/{aid}/logo/{logoId}/{fileName}
				def Upload(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/logo/' + str(self._get('Logoid')) + '/' + str(self._get('Filename')) + '', 'POST', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/logo/{logoId}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/logo/' + str(self._get('Logoid')) + '', 'DELETE', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/logo/{logoId}/{fileName}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/logo/' + str(self._get('Logoid')) + '/' + str(self._get('Filename')) + '', 'GET', body, **kwargs)
				
			
			class _Installprofile(_CommonAPIClass):
				def __call__(self, Ipid=None):
					self.Ipid = Ipid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Groups = Api._Users._Appliances._Installprofile._Groups(self)
					self.Pt = Api._Users._Appliances._Installprofile._Pt(self)
					self.Users = Api._Users._Appliances._Installprofile._Users(self)
					pass
				
				#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}
				def Update(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '', 'PUT', body, **kwargs)
				
				#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '', 'GET', body, **kwargs)
				class _Groups(_CommonAPIClass):
					def __call__(self, Osgid=None):
						self.Osgid = Osgid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/groups/{osgid}
					def Deletegroup(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/groups/' + str(self._get('Osgid')) + '', 'DELETE', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/groups/{osgid}
					def Updategroup(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/groups/' + str(self._get('Osgid')) + '', 'PUT', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/groups/{osgid}
					def Getgroup(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/groups/' + str(self._get('Osgid')) + '', 'GET', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/groups
					def Deletegroups(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/groups', 'DELETE', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/groups
					def Getgroups(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/groups', 'GET', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/groups
					def Creategroup(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/groups', 'POST', body, **kwargs)
					
				
				class _Pt(_CommonAPIClass):
					def __call__(self, Ptid=None):
						self.Ptid = Ptid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Disks = Api._Users._Appliances._Installprofile._Pt._Disks(self)
						self.Volumes = Api._Users._Appliances._Installprofile._Pt._Volumes(self)
						self.Groups = Api._Users._Appliances._Installprofile._Pt._Groups(self)
						pass
					
					class _Disks(_CommonAPIClass):
						def __call__(self, Did=None):
							self.Did = Did
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							self.Partitions = Api._Users._Appliances._Installprofile._Pt._Disks._Partitions(self)
							pass
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}
						def Get(self, body=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '', 'GET', body, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks
						def Getall(self, Name=None, body=None):
							kwargs = {'name': Name}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks', 'GET', body, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks
						def Create(self, body=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks', 'POST', body, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}
						def Update(self, body=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '', 'PUT', body, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}
						def Delete(self, body=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '', 'DELETE', body, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks
						def Deleteall(self, body=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks', 'DELETE', body, **kwargs)
						class _Partitions(_CommonAPIClass):
							def __call__(self, Pid=None):
								self.Pid = Pid
								return self
						
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								self.Lpartitions = Api._Users._Appliances._Installprofile._Pt._Disks._Partitions._Lpartitions(self)
								pass
							
							#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions/{pid}
							def Delete(self, body=None):
								kwargs = {}
								return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions/' + str(self._get('Pid')) + '', 'DELETE', body, **kwargs)
							
							#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions
							def Deleteall(self, body=None):
								kwargs = {}
								return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions', 'DELETE', body, **kwargs)
							
							#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions/{pid}
							def Get(self, body=None):
								kwargs = {}
								return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions/' + str(self._get('Pid')) + '', 'GET', body, **kwargs)
							
							#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions
							def Create(self, body=None):
								kwargs = {}
								return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions', 'POST', body, **kwargs)
							
							#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions
							def Getall(self, Name=None, body=None):
								kwargs = {'name': Name}
								return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions', 'GET', body, **kwargs)
							
							#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions/{pid}
							def Update(self, body=None):
								kwargs = {}
								return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions/' + str(self._get('Pid')) + '', 'PUT', body, **kwargs)
							class _Lpartitions(_CommonAPIClass):
								def __call__(self, Lpid=None):
									self.Lpid = Lpid
									return self
							
								def __init__(self, parent, **kwargs):
									self._parent = parent
									self.__dict__.update(kwargs)
									pass
								
								#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions/{pid}/lpartitions
								def Create(self, body=None):
									kwargs = {}
									return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions/' + str(self._get('Pid')) + '/lpartitions', 'POST', body, **kwargs)
								
								#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions/{pid}/lpartitions/{lpid}
								def Delete(self, body=None):
									kwargs = {}
									return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions/' + str(self._get('Pid')) + '/lpartitions/' + str(self._get('Lpid')) + '', 'DELETE', body, **kwargs)
								
								#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions/{pid}/lpartitions/{lpid}
								def Get(self, body=None):
									kwargs = {}
									return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions/' + str(self._get('Pid')) + '/lpartitions/' + str(self._get('Lpid')) + '', 'GET', body, **kwargs)
								
								#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions/{pid}/lpartitions
								def Deleteall(self, body=None):
									kwargs = {}
									return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions/' + str(self._get('Pid')) + '/lpartitions', 'DELETE', body, **kwargs)
								
								#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions/{pid}/lpartitions/{lpid}
								def Update(self, body=None):
									kwargs = {}
									return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions/' + str(self._get('Pid')) + '/lpartitions/' + str(self._get('Lpid')) + '', 'PUT', body, **kwargs)
								
								#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/disks/{did}/partitions/{pid}/lpartitions
								def Getall(self, Name=None, body=None):
									kwargs = {'name': Name}
									return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/disks/' + str(self._get('Did')) + '/partitions/' + str(self._get('Pid')) + '/lpartitions', 'GET', body, **kwargs)
								
							
						
					
					class _Volumes(_CommonAPIClass):
						def __call__(self, Vid=None):
							self.Vid = Vid
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/volumes/{vid}
						def Delete(self, body=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/volumes/' + str(self._get('Vid')) + '', 'DELETE', body, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/volumes/{vid}
						def Get(self, body=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/volumes/' + str(self._get('Vid')) + '', 'GET', body, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/volumes
						def Deleteall(self, body=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/volumes', 'DELETE', body, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/volumes/{vid}
						def Update(self, body=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/volumes/' + str(self._get('Vid')) + '', 'PUT', body, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/volumes
						def Create(self, body=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/volumes', 'POST', body, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/volumes
						def Getall(self, Name=None, body=None):
							kwargs = {'name': Name}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/volumes', 'GET', body, **kwargs)
						
					
					class _Groups(_CommonAPIClass):
						def __call__(self, Gid=None):
							self.Gid = Gid
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/groups
						def Create(self, body=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/groups', 'POST', body, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/groups
						def Deleteall(self, body=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/groups', 'DELETE', body, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/groups/{gid}
						def Update(self, body=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/groups/' + str(self._get('Gid')) + '', 'PUT', body, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/groups
						def Getall(self, Name=None, body=None):
							kwargs = {'name': Name}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/groups', 'GET', body, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/groups/{gid}
						def Get(self, body=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/groups/' + str(self._get('Gid')) + '', 'GET', body, **kwargs)
						
						#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/pt/{ptid}/groups/{gid}
						def Delete(self, body=None):
							kwargs = {}
							return self._REST('users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/{ipid}/pt/' + str(self._get('Ptid')) + '/groups/' + str(self._get('Gid')) + '', 'DELETE', body, **kwargs)
						
					
				
				class _Users(_CommonAPIClass):
					def __call__(self, Osuid=None):
						self.Osuid = Osuid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/users
					def Deleteusers(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/users', 'DELETE', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/users
					def Createuser(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/users', 'POST', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/users/{osuid}
					def Updateuser(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/users/' + str(self._get('Osuid')) + '', 'PUT', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/users/{osuid}
					def Deleteuser(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/users/' + str(self._get('Osuid')) + '', 'DELETE', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/users
					def Getusers(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/users', 'GET', body, **kwargs)
					
					#URL: users/{uid}/appliances/{aid}/installProfile/{ipid}/users/{osuid}
					def Getuser(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/installProfile/' + str(self._get('Ipid')) + '/users/' + str(self._get('Osuid')) + '', 'GET', body, **kwargs)
					
				
			
			class _Projects(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/appliances/{aid}/projects
				def Getall(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/appliances/' + str(self._get('Aid')) + '/projects', 'GET', body, **kwargs)
				
			
		
		class _Images(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/images
			def Get(self, Img=None, Status=None, body=None):
				kwargs = {'img': Img, 'status': Status}
				return self._REST('/users/' + str(self._get('Uid')) + '/images', 'GET', body, **kwargs)
			
		
		class _Apikeys(_CommonAPIClass):
			def __call__(self, Akid=None):
				self.Akid = Akid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/apikeys
			def Getall(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/apikeys', 'GET', body, **kwargs)
			
			#URL: users/{uid}/apikeys
			def Create(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/apikeys', 'POST', body, **kwargs)
			
			#URL: users/{uid}/apikeys/{akid}
			def Delete(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/apikeys/' + str(self._get('Akid')) + '', 'DELETE', body, **kwargs)
			
		
		class _Distros(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/distros
			def Update(self, Org, Orguri, body=None):
				kwargs = {'org': Org, 'orguri': Orguri}
				return self._REST('/users/' + str(self._get('Uid')) + '/distros', 'PUT', body, **kwargs)
			
			#URL: users/{uid}/distros
			def Getall(self, Org, Orguri, Info=None, body=None):
				kwargs = {'org': Org, 'orguri': Orguri, 'info': Info}
				return self._REST('/users/' + str(self._get('Uid')) + '/distros', 'GET', body, **kwargs)
			
		
		class _Stats(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/stats
			def Get(self, Type, body=None):
				kwargs = {'type': Type}
				return self._REST('/users/' + str(self._get('Uid')) + '/stats', 'GET', body, **kwargs)
			
		
		class _Mysoftware(_CommonAPIClass):
			def __call__(self, Msid=None):
				self.Msid = Msid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Licenses = Api._Users._Mysoftware._Licenses(self)
				self.Pkgs = Api._Users._Mysoftware._Pkgs(self)
				self.Appliances = Api._Users._Mysoftware._Appliances(self)
				pass
			
			#URL: users/{uid}/mysoftware
			def Getall(self, Name=None, Version=None, body=None):
				kwargs = {'name': Name, 'version': Version}
				return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware', 'GET', body, **kwargs)
			
			#URL: users/{uid}/mysoftware
			def Create(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware', 'POST', body, **kwargs)
			
			#URL: users/{uid}/mysoftware/{msid}
			def Delete(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '', 'DELETE', body, **kwargs)
			
			#URL: users/{uid}/mysoftware/{msid}
			def Update(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '', 'PUT', body, **kwargs)
			
			#URL: users/{uid}/mysoftware/{msid}
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '', 'GET', body, **kwargs)
			class _Licenses(_CommonAPIClass):
				def __call__(self, Mslid=None, Filename=None):
					self.Mslid = Mslid
					self.Filename = Filename
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/mysoftware/{msid}/licenses/{mslid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/licenses/{mslid}', 'DELETE', body, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/licenses/{mslid}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/licenses/{mslid}', 'GET', body, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/licenses/{mslid}/{fileName}
				def Upload(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/licenses/{mslid}/' + str(self._get('Filename')) + '', 'POST', body, **kwargs)
				
			
			class _Pkgs(_CommonAPIClass):
				def __call__(self, Mspackid=None):
					self.Mspackid = Mspackid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Bin = Api._Users._Mysoftware._Pkgs._Bin(self)
					pass
				
				#URL: users/{uid}/mysoftware/{msid}/pkgs/{mspackid}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/pkgs/' + str(self._get('Mspackid')) + '', 'GET', body, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/pkgs/{mspackid}
				def Update(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/pkgs/' + str(self._get('Mspackid')) + '', 'PUT', body, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/pkgs
				def Getall(self, Filename=None, body=None):
					kwargs = {'filename': Filename}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/pkgs', 'GET', body, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/pkgs/{mspackid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/pkgs/' + str(self._get('Mspackid')) + '', 'DELETE', body, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/pkgs
				def Update(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/pkgs', 'PUT', body, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/pkgs
				def Add(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/pkgs', 'POST', body, **kwargs)
				
				#URL: users/{uid}/mysoftware/{msid}/pkgs
				def Deleteall(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/pkgs', 'DELETE', body, **kwargs)
				class _Bin(_CommonAPIClass):
					def __call__(self, Filename=None):
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/mysoftware/{msid}/pkgs/{mspackid}/bin
					def Download(self, Downloadid=None, body=None):
						kwargs = {'downloadId': Downloadid}
						return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/pkgs/' + str(self._get('Mspackid')) + '/bin', 'GET', body, **kwargs)
					
					#URL: users/{uid}/mysoftware/{msid}/pkgs/{mspackid}/bin/{fileName}
					def Upload(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/pkgs/' + str(self._get('Mspackid')) + '/bin/' + str(self._get('Filename')) + '', 'POST', body, **kwargs)
					
					#URL: users/{uid}/mysoftware/{msid}/pkgs/{mspackid}/bin/{fileName}
					def Downloadfilename(self, Downloadid, body=None):
						kwargs = {'downloadId': Downloadid}
						return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/pkgs/' + str(self._get('Mspackid')) + '/bin/' + str(self._get('Filename')) + '', 'GET', body, **kwargs)
					
				
			
			class _Appliances(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/mysoftware/{msid}/appliances
				def Getall(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/mysoftware/' + str(self._get('Msid')) + '/appliances', 'GET', body, **kwargs)
				
			
		
		class _Migrations(_CommonAPIClass):
			def __call__(self, Mid=None):
				self.Mid = Mid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Scannedinstances = Api._Users._Migrations._Scannedinstances(self)
				pass
			
			#URL: users/{uid}/migrations
			def Create(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/migrations', 'POST', body, **kwargs)
			class _Scannedinstances(_CommonAPIClass):
				def __call__(self, Siid=None):
					self.Siid = Siid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Scans = Api._Users._Migrations._Scannedinstances._Scans(self)
					pass
				
				class _Scans(_CommonAPIClass):
					def __call__(self, Sid=None):
						self.Sid = Sid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Files = Api._Users._Migrations._Scannedinstances._Scans._Files(self)
						self.Packages = Api._Users._Migrations._Scannedinstances._Scans._Packages(self)
						self.Overlay = Api._Users._Migrations._Scannedinstances._Scans._Overlay(self)
						pass
					
					#URL: users/{uid}/migrations/{mid}/scannedinstances/{siid}/scans
					def Create(self, Acceptall, Crc, Reportfilename, Name=None, body=None):
						kwargs = {'acceptAll': Acceptall, 'crc': Crc, 'reportFileName': Reportfilename, 'name': Name}
						return self._REST('/users/' + str(self._get('Uid')) + '/migrations/{mid}/scannedinstances/' + str(self._get('Siid')) + '/scans', 'POST', body, **kwargs)
					
					#URL: users/{uid}/migrations/{mid}/scannedinstances/{siid}/scans
					def Createmultipart(self, Name, Acceptall, Crc, body=None):
						kwargs = {'name': Name, 'acceptAll': Acceptall, 'crc': Crc}
						return self._REST('/users/' + str(self._get('Uid')) + '/migrations/{mid}/scannedinstances/' + str(self._get('Siid')) + '/scans', 'POST', body, **kwargs)
					
					#URL: users/{uid}/migrations/{mid}/scannedinstances/{siid}/scans
					def Get(self, Ongoing, Includestats, Delta, Name=None, body=None):
						kwargs = {'ongoing': Ongoing, 'includeStats': Includestats, 'delta': Delta, 'name': Name}
						return self._REST('/users/' + str(self._get('Uid')) + '/migrations/{mid}/scannedinstances/' + str(self._get('Siid')) + '/scans', 'GET', body, **kwargs)
					
					#URL: users/{uid}/migrations/{mid}/scannedinstances/{siid}/scans/{sid}
					def Get(self, Pkgfiles, Dir, Rellevel, Delta, Comparewith, Validated=None, Pkgs=None, Added=None, body=None):
						kwargs = {'pkgFiles': Pkgfiles, 'dir': Dir, 'rellevel': Rellevel, 'delta': Delta, 'compareWith': Comparewith, 'validated': Validated, 'pkgs': Pkgs, 'added': Added}
						return self._REST('/users/' + str(self._get('Uid')) + '/migrations/{mid}/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '', 'GET', body, **kwargs)
					class _Files(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/migrations/{mid}/scannedinstances/{siid}/scans/{sid}/files
						def Get(self, Comparewith, Limit, Added, Pkgfiles, Dir, Rellevel, Delta, body=None):
							kwargs = {'compareWith': Comparewith, 'limit': Limit, 'added': Added, 'pkgFiles': Pkgfiles, 'dir': Dir, 'rellevel': Rellevel, 'delta': Delta}
							return self._REST('/users/' + str(self._get('Uid')) + '/migrations/{mid}/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/files', 'GET', body, **kwargs)
						
					
					class _Packages(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/migrations/{mid}/scannedinstances/{siid}/scans/{sid}/packages
						def Get(self, All, Comparewith, Excludefiles=None, Fromrepo=None, Uploaded=None, Notselected=None, body=None):
							kwargs = {'all': All, 'compareWith': Comparewith, 'excludeFiles': Excludefiles, 'fromRepo': Fromrepo, 'uploaded': Uploaded, 'notSelected': Notselected}
							return self._REST('/users/' + str(self._get('Uid')) + '/migrations/{mid}/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/packages', 'GET', body, **kwargs)
						
					
					class _Overlay(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/migrations/{mid}/scannedinstances/{siid}/scans/{sid}/overlay
						def Multipartupload(self, Crc, body=None):
							kwargs = {'crc': Crc}
							return self._REST('/users/' + str(self._get('Uid')) + '/migrations/{mid}/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/overlay', 'POST', body, **kwargs)
						
						#URL: users/{uid}/migrations/{mid}/scannedinstances/{siid}/scans/{sid}/overlay
						def Upload(self, Crc, Overlayname, body=None):
							kwargs = {'crc': Crc, 'overlayName': Overlayname}
							return self._REST('/users/' + str(self._get('Uid')) + '/migrations/{mid}/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/overlay', 'POST', body, **kwargs)
						
					
				
			
		
		class _Photo(_CommonAPIClass):
			def __call__(self, Photoid=None, Filename=None):
				self.Photoid = Photoid
				self.Filename = Filename
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/photo/{photoId}/{fileName}
			def Upload(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/photo/' + str(self._get('Photoid')) + '/' + str(self._get('Filename')) + '', 'POST', body, **kwargs)
			
			#URL: users/{uid}/photo/{photoId}
			def Delete(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/photo/' + str(self._get('Photoid')) + '', 'DELETE', body, **kwargs)
			
			#URL: users/{uid}/photo/{photoId}/{fileName}
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/photo/' + str(self._get('Photoid')) + '/' + str(self._get('Filename')) + '', 'GET', body, **kwargs)
			
		
		class _Usage(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/usage
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/usage', 'GET', body, **kwargs)
			
		
		class _Scans(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/scans
			def Get(self, Id=None, Index=None, Max=None, Orderby=None, Asc=None, body=None):
				kwargs = {'id': Id, 'index': Index, 'max': Max, 'orderby': Orderby, 'asc': Asc}
				return self._REST('/users/' + str(self._get('Uid')) + '/scans', 'GET', body, **kwargs)
			
			#URL: users/{uid}/scans
			def Delete(self, Id=None, body=None):
				kwargs = {'id': Id}
				return self._REST('/users/' + str(self._get('Uid')) + '/scans', 'DELETE', body, **kwargs)
			
		
		class _Activities(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/activities
			def Getactivity(self, Type, Nblatestresults, Order, Fromdate, Todate, body=None):
				kwargs = {'type': Type, 'nbLatestResults': Nblatestresults, 'order': Order, 'fromDate': Fromdate, 'toDate': Todate}
				return self._REST('/users/' + str(self._get('Uid')) + '/activities', 'GET', body, **kwargs)
			
		
		class _Workspaces(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/workspaces
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/workspaces', 'GET', body, **kwargs)
			
			#URL: users/{uid}/workspaces
			def Create(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/workspaces', 'POST', body, **kwargs)
			
		
		class _Forgotpassword(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/forgotpassword
			def Reset(self, body=None):
				kwargs = {}
				return self._REST('/users/forgotpassword', 'PUT', body, **kwargs)
			
		
		class _Sshkeys(_CommonAPIClass):
			def __call__(self, Sshid=None):
				self.Sshid = Sshid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/sshkeys/{sshid}
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/sshkeys/' + str(self._get('Sshid')) + '', 'GET', body, **kwargs)
			
			#URL: users/{uid}/sshkeys
			def Getall(self, Name=None, body=None):
				kwargs = {'name': Name}
				return self._REST('/users/' + str(self._get('Uid')) + '/sshkeys', 'GET', body, **kwargs)
			
			#URL: users/{uid}/sshkeys/{sshid}
			def Delete(self, Force, body=None):
				kwargs = {'force': Force}
				return self._REST('/users/' + str(self._get('Uid')) + '/sshkeys/' + str(self._get('Sshid')) + '', 'DELETE', body, **kwargs)
			
			#URL: users/{uid}/sshkeys
			def Create(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/sshkeys', 'POST', body, **kwargs)
			
		
		class _Blueprints(_CommonAPIClass):
			def __call__(self, Bpid=None):
				self.Bpid = Bpid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Layers = Api._Users._Blueprints._Layers(self)
				self.Zones = Api._Users._Blueprints._Zones(self)
				self.Exports = Api._Users._Blueprints._Exports(self)
				self.Logo = Api._Users._Blueprints._Logo(self)
				pass
			
			#URL: users/{uid}/blueprints
			def Getall(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/blueprints', 'GET', body, **kwargs)
			
			#URL: users/{uid}/blueprints/{bpid}
			def Update(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '', 'PUT', body, **kwargs)
			
			#URL: users/{uid}/blueprints/{bpid}
			def Delete(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '', 'DELETE', body, **kwargs)
			
			#URL: users/{uid}/blueprints
			def Create(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/blueprints', 'POST', body, **kwargs)
			
			#URL: users/{uid}/blueprints/{bpid}
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '', 'GET', body, **kwargs)
			class _Layers(_CommonAPIClass):
				def __call__(self, Bplid=None):
					self.Bplid = Bplid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Installprofile = Api._Users._Blueprints._Layers._Installprofile(self)
					self.Securitygroup = Api._Users._Blueprints._Layers._Securitygroup(self)
					pass
				
				#URL: users/{uid}/blueprints/{bpid}/layers/{bplid}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/layers/' + str(self._get('Bplid')) + '', 'GET', body, **kwargs)
				
				#URL: users/{uid}/blueprints/{bpid}/layers
				def Getall(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/layers', 'GET', body, **kwargs)
				
				#URL: users/{uid}/blueprints/{bpid}/layers/{bplid}
				def Update(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/layers/' + str(self._get('Bplid')) + '', 'PUT', body, **kwargs)
				
				#URL: users/{uid}/blueprints/{bpid}/layers
				def Create(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/layers', 'POST', body, **kwargs)
				
				#URL: users/{uid}/blueprints/{bpid}/layers/{bplid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/layers/' + str(self._get('Bplid')) + '', 'DELETE', body, **kwargs)
				class _Installprofile(_CommonAPIClass):
					def __call__(self, Bpiid=None):
						self.Bpiid = Bpiid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/blueprints/{bpid}/layers/{bplid}/installProfile/{bpiid}
					def Updateinstallprofile(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/layers/' + str(self._get('Bplid')) + '/installProfile/' + str(self._get('Bpiid')) + '', 'PUT', body, **kwargs)
					
				
				class _Securitygroup(_CommonAPIClass):
					def __call__(self, Segid=None):
						self.Segid = Segid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Rules = Api._Users._Blueprints._Layers._Securitygroup._Rules(self)
						pass
					
					#URL: users/{uid}/blueprints/{bpid}/layers/{bplid}/securitygroup/{segid}
					def Delete(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/layers/' + str(self._get('Bplid')) + '/securitygroup/' + str(self._get('Segid')) + '', 'DELETE', body, **kwargs)
					
					#URL: users/{uid}/blueprints/{bpid}/layers/{bplid}/securitygroup
					def Create(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/layers/' + str(self._get('Bplid')) + '/securitygroup', 'POST', body, **kwargs)
					class _Rules(_CommonAPIClass):
						def __call__(self, Ruid=None):
							self.Ruid = Ruid
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/blueprints/{bpid}/layers/{bplid}/securitygroup/{segid}/rules/{ruid}
						def Delete(self, body=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/layers/' + str(self._get('Bplid')) + '/securitygroup/' + str(self._get('Segid')) + '/rules/' + str(self._get('Ruid')) + '', 'DELETE', body, **kwargs)
						
						#URL: users/{uid}/blueprints/{bpid}/layers/{bplid}/securitygroup/{segid}/rules
						def Create(self, body=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/layers/' + str(self._get('Bplid')) + '/securitygroup/' + str(self._get('Segid')) + '/rules', 'POST', body, **kwargs)
						
					
				
			
			class _Zones(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/blueprints/{bpid}/zones
				def Getallzones(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/zones', 'GET', body, **kwargs)
				
			
			class _Exports(_CommonAPIClass):
				def __call__(self, Epid=None):
					self.Epid = Epid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Images = Api._Users._Blueprints._Exports._Images(self)
					self.Status = Api._Users._Blueprints._Exports._Status(self)
					self.Downloads = Api._Users._Blueprints._Exports._Downloads(self)
					pass
				
				#URL: users/{uid}/blueprints/{bpid}/exports
				def Getall(self, Status, body=None):
					kwargs = {'status': Status}
					return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/exports', 'GET', body, **kwargs)
				
				#URL: users/{uid}/blueprints/{bpid}/exports/{epid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/exports/' + str(self._get('Epid')) + '', 'DELETE', body, **kwargs)
				
				#URL: users/{uid}/blueprints/{bpid}/exports
				def Create(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/exports', 'POST', body, **kwargs)
				
				#URL: users/{uid}/blueprints/{bpid}/exports/{epid}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/exports/' + str(self._get('Epid')) + '', 'GET', body, **kwargs)
				class _Images(_CommonAPIClass):
					def __call__(self, Epiid=None, Ovfid=None):
						self.Epiid = Epiid
						self.Ovfid = Ovfid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Status = Api._Users._Blueprints._Exports._Images._Status(self)
						self.Pimages = Api._Users._Blueprints._Exports._Images._Pimages(self)
						pass
					
					#URL: users/{uid}/blueprints/{bpid}/exports/{epid}/images/{ovfid}
					def Delete(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/exports/' + str(self._get('Epid')) + '/images/{ovfid}', 'DELETE', body, **kwargs)
					class _Status(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/blueprints/{bpid}/exports/{epid}/images/{ovfid}/status
						def Get(self, body=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/exports/' + str(self._get('Epid')) + '/images/' + str(self._get('Ovfid')) + '/status', 'GET', body, **kwargs)
						
						#URL: users/{uid}/blueprints/{bpid}/exports/{epid}/images/{ovfid}/status
						def Cancel(self, body=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/exports/' + str(self._get('Epid')) + '/images/' + str(self._get('Ovfid')) + '/status', 'DELETE', body, **kwargs)
						
					
					class _Pimages(_CommonAPIClass):
						def __call__(self, Pitid=None):
							self.Pitid = Pitid
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							self.Status = Api._Users._Blueprints._Exports._Images._Pimages._Status(self)
							self.Cancel = Api._Users._Blueprints._Exports._Images._Pimages._Cancel(self)
							pass
						
						#URL: users/{uid}/blueprints/{bpid}/exports/{epid}/images/{epiid}/pimages/{pitid}
						def Get(self, body=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/exports/' + str(self._get('Epid')) + '/images/' + str(self._get('Epiid')) + '/pimages/' + str(self._get('Pitid')) + '', 'GET', body, **kwargs)
						
						#URL: users/{uid}/blueprints/{bpid}/exports/{epid}/images/{epiid}/pimages
						def Publish(self, body=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/exports/' + str(self._get('Epid')) + '/images/' + str(self._get('Epiid')) + '/pimages', 'POST', body, **kwargs)
						
						#URL: users/{uid}/blueprints/{bpid}/exports/{epid}/images/{epiid}/pimages/{pitid}
						def Delete(self, body=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/exports/' + str(self._get('Epid')) + '/images/' + str(self._get('Epiid')) + '/pimages/' + str(self._get('Pitid')) + '', 'DELETE', body, **kwargs)
						class _Status(_CommonAPIClass):
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								pass
							
							#URL: users/{uid}/blueprints/{bpid}/exports/{epid}/images/{epiid}/pimages/{pitid}/status
							def Get(self, body=None):
								kwargs = {}
								return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/exports/' + str(self._get('Epid')) + '/images/' + str(self._get('Epiid')) + '/pimages/' + str(self._get('Pitid')) + '/status', 'GET', body, **kwargs)
							
						
						class _Cancel(_CommonAPIClass):
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								pass
							
							#URL: users/{uid}/blueprints/{bpid}/exports/{epid}/images/{epiid}/pimages/{pitid}/cancel
							def Cancel(self, body=None):
								kwargs = {}
								return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/exports/' + str(self._get('Epid')) + '/images/' + str(self._get('Epiid')) + '/pimages/' + str(self._get('Pitid')) + '/cancel', 'DELETE', body, **kwargs)
							
						
					
				
				class _Status(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/blueprints/{bpid}/exports/{epid}/status
					def Getstatus(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/exports/' + str(self._get('Epid')) + '/status', 'GET', body, **kwargs)
					
					#URL: users/{uid}/blueprints/{bpid}/exports/{epid}/status
					def Cancel(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/exports/' + str(self._get('Epid')) + '/status', 'DELETE', body, **kwargs)
					
				
				class _Downloads(_CommonAPIClass):
					def __call__(self, Filename=None):
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/blueprints/{bpid}/exports/{epid}/downloads
					def Download(self, Downloadid, body=None):
						kwargs = {'downloadId': Downloadid}
						return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/exports/' + str(self._get('Epid')) + '/downloads', 'GET', body, **kwargs)
					
				
			
			class _Logo(_CommonAPIClass):
				def __call__(self, Logoid=None, Filename=None):
					self.Logoid = Logoid
					self.Filename = Filename
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: users/{uid}/blueprints/{bpid}/logo/{logoId}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/logo/' + str(self._get('Logoid')) + '', 'GET', body, **kwargs)
				
				#URL: users/{uid}/blueprints/{bpid}/logo/{logoId}/{fileName}
				def Upload(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/blueprints/' + str(self._get('Bpid')) + '/logo/' + str(self._get('Logoid')) + '/' + str(self._get('Filename')) + '', 'POST', body, **kwargs)
				
			
		
		class _Roles(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/roles
			def Update(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/roles', 'PUT', body, **kwargs)
			
			#URL: users/{uid}/roles
			def Getall(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/roles', 'GET', body, **kwargs)
			
		
		class _Pimages(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/pimages
			def Get(self, Pimg=None, Status=None, body=None):
				kwargs = {'pimg': Pimg, 'status': Status}
				return self._REST('/users/' + str(self._get('Uid')) + '/pimages', 'GET', body, **kwargs)
			
		
		class _Scannedinstances(_CommonAPIClass):
			def __call__(self, Siid=None):
				self.Siid = Siid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Scans = Api._Users._Scannedinstances._Scans(self)
				pass
			
			#URL: users/{uid}/scannedinstances/{siid}
			def Delete(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '', 'DELETE', body, **kwargs)
			
			#URL: users/{uid}/scannedinstances
			def Create(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances', 'POST', body, **kwargs)
			
			#URL: users/{uid}/scannedinstances/{siid}
			def Get(self, Includescans=None, Delta=None, body=None):
				kwargs = {'includeScans': Includescans, 'delta': Delta}
				return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '', 'GET', body, **kwargs)
			
			#URL: users/{uid}/scannedinstances
			def Getall(self, Delta, Mac=None, Name=None, Id=None, Index=None, Max=None, Orderby=None, Asc=None, Includescans=None, body=None):
				kwargs = {'delta': Delta, 'mac': Mac, 'name': Name, 'id': Id, 'index': Index, 'max': Max, 'orderby': Orderby, 'asc': Asc, 'includeScans': Includescans}
				return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances', 'GET', body, **kwargs)
			
			#URL: users/{uid}/scannedinstances
			def Deleteall(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances', 'DELETE', body, **kwargs)
			class _Scans(_CommonAPIClass):
				def __call__(self, Sid=None):
					self.Sid = Sid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Status = Api._Users._Scannedinstances._Scans._Status(self)
					self.Files = Api._Users._Scannedinstances._Scans._Files(self)
					self.Rawparts = Api._Users._Scannedinstances._Scans._Rawparts(self)
					self.Overlay = Api._Users._Scannedinstances._Scans._Overlay(self)
					self.Imports = Api._Users._Scannedinstances._Scans._Imports(self)
					self.Reports = Api._Users._Scannedinstances._Scans._Reports(self)
					self.Images = Api._Users._Scannedinstances._Scans._Images(self)
					self.Installprofile = Api._Users._Scannedinstances._Scans._Installprofile(self)
					self.Packages = Api._Users._Scannedinstances._Scans._Packages(self)
					pass
				
				#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}
				def Get(self, Validated, Pkgs, Added, Pkgfiles=None, Dir=None, Rellevel=None, Delta=None, Comparewith=None, body=None):
					kwargs = {'validated': Validated, 'pkgs': Pkgs, 'added': Added, 'pkgFiles': Pkgfiles, 'dir': Dir, 'rellevel': Rellevel, 'delta': Delta, 'compareWith': Comparewith}
					return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '', 'GET', body, **kwargs)
				
				#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '', 'DELETE', body, **kwargs)
				
				#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}
				def Update(self, Acceptall, body=None):
					kwargs = {'acceptAll': Acceptall}
					return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '', 'PUT', body, **kwargs)
				
				#URL: users/{uid}/scannedinstances/{siid}/scans
				def Deleteall(self, body=None):
					kwargs = {}
					return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans', 'DELETE', body, **kwargs)
				
				#URL: users/{uid}/scannedinstances/{siid}/scans
				def Create(self, Acceptall, Crc, Reportfilename, Name=None, body=None):
					kwargs = {'acceptAll': Acceptall, 'crc': Crc, 'reportFileName': Reportfilename, 'name': Name}
					return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans', 'POST', body, **kwargs)
				
				#URL: users/{uid}/scannedinstances/{siid}/scans
				def Multipartcreate(self, Name, Acceptall, Crc, body=None):
					kwargs = {'name': Name, 'acceptAll': Acceptall, 'crc': Crc}
					return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans', 'POST', body, **kwargs)
				
				#URL: users/{uid}/scannedinstances/{siid}/scans
				def Getall(self, Ongoing, Includestats, Delta, Name=None, body=None):
					kwargs = {'ongoing': Ongoing, 'includeStats': Includestats, 'delta': Delta, 'name': Name}
					return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans', 'GET', body, **kwargs)
				class _Status(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/status
					def Cancel(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/status', 'DELETE', body, **kwargs)
					
				
				class _Files(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/files
					def Get(self, Comparewith=None, Limit=None, Added=None, Pkgfiles=None, Dir=None, Rellevel=None, Delta=None, body=None):
						kwargs = {'compareWith': Comparewith, 'limit': Limit, 'added': Added, 'pkgFiles': Pkgfiles, 'dir': Dir, 'rellevel': Rellevel, 'delta': Delta}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/files', 'GET', body, **kwargs)
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/files
					def Get(self, Limit=None, Comparewith=None, body=None):
						kwargs = {'limit': Limit, 'compareWith': Comparewith}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/files', 'GET', body, **kwargs)
					
				
				class _Rawparts(_CommonAPIClass):
					def __call__(self, Filename=None):
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/rawparts/{fileName}
					def Upload(self, Partitionname, Crc=None, body=None):
						kwargs = {'partitionName': Partitionname, 'crc': Crc}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/rawparts/' + str(self._get('Filename')) + '', 'POST', body, **kwargs)
					
				
				class _Overlay(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/overlay
					def Upload(self, Overlayname, Crc=None, body=None):
						kwargs = {'overlayName': Overlayname, 'crc': Crc}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/overlay', 'POST', body, **kwargs)
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/overlay
					def Download(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/overlay', 'GET', body, **kwargs)
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/overlay
					def Multipartupload(self, Crc=None, body=None):
						kwargs = {'crc': Crc}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/overlay', 'POST', body, **kwargs)
					
				
				class _Imports(_CommonAPIClass):
					def __call__(self, Iid=None):
						self.Iid = Iid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Status = Api._Users._Scannedinstances._Scans._Imports._Status(self)
						pass
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/imports
					def Get(self, Status=None, I=None, body=None):
						kwargs = {'status': Status, 'i': I}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/imports', 'GET', body, **kwargs)
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/imports
					def Import(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/imports', 'POST', body, **kwargs)
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/imports/{iid}
					def Delete(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/imports/' + str(self._get('Iid')) + '', 'DELETE', body, **kwargs)
					class _Status(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/imports/{iid}/status
						def Cancel(self, body=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/imports/' + str(self._get('Iid')) + '/status', 'DELETE', body, **kwargs)
						
					
				
				class _Reports(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/reports
					def Create(self, Nowarnings, Email, body=None):
						kwargs = {'noWarnings': Nowarnings, 'email': Email}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/reports', 'POST', body, **kwargs)
					
				
				class _Images(_CommonAPIClass):
					def __call__(self, Itid=None, Sitid=None):
						self.Itid = Itid
						self.Sitid = Sitid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Status = Api._Users._Scannedinstances._Scans._Images._Status(self)
						self.Pimages = Api._Users._Scannedinstances._Scans._Images._Pimages(self)
						self.Downloads = Api._Users._Scannedinstances._Scans._Images._Downloads(self)
						pass
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images
					def Get(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images', 'GET', body, **kwargs)
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{sitid}
					def Delete(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Sitid')) + '', 'DELETE', body, **kwargs)
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{sitid}
					def Get(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Sitid')) + '', 'GET', body, **kwargs)
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images
					def Generate(self, body=None):
						kwargs = {}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images', 'POST', body, **kwargs)
					class _Status(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{sitid}/status
						def Cancel(self, body=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Sitid')) + '/status', 'DELETE', body, **kwargs)
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{sitid}/status
						def Get(self, body=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Sitid')) + '/status', 'GET', body, **kwargs)
						
					
					class _Pimages(_CommonAPIClass):
						def __call__(self, Pitid=None):
							self.Pitid = Pitid
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							self.Status = Api._Users._Scannedinstances._Scans._Images._Pimages._Status(self)
							self.Cancel = Api._Users._Scannedinstances._Scans._Images._Pimages._Cancel(self)
							pass
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{itid}/pimages/{pitid}
						def Delete(self, body=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '', 'DELETE', body, **kwargs)
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{itid}/pimages/{pitid}
						def Get(self, body=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '', 'GET', body, **kwargs)
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{itid}/pimages
						def Publish(self, body=None):
							kwargs = {}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Itid')) + '/pimages', 'POST', body, **kwargs)
						class _Status(_CommonAPIClass):
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								pass
							
							#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{itid}/pimages/{pitid}/status
							def Get(self, body=None):
								kwargs = {}
								return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/status', 'GET', body, **kwargs)
							
						
						class _Cancel(_CommonAPIClass):
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								pass
							
							#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{itid}/pimages/{pitid}/cancel
							def Cancel(self, body=None):
								kwargs = {}
								return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/cancel', 'DELETE', body, **kwargs)
							
						
					
					class _Downloads(_CommonAPIClass):
						def __call__(self, Filename=None):
							self.Filename = Filename
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{itid}/downloads
						def Downloadnoauth(self, Downloadid, body=None):
							kwargs = {'downloadId': Downloadid}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/{siid}/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Itid')) + '/downloads', 'GET', body, **kwargs)
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/images/{itid}/downloads/{fileName}
						def Download(self, Downloadid=None, body=None):
							kwargs = {'downloadId': Downloadid}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/{siid}/scans/' + str(self._get('Sid')) + '/images/' + str(self._get('Itid')) + '/downloads/' + str(self._get('Filename')) + '', 'GET', body, **kwargs)
						
					
				
				class _Installprofile(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/installprofile
					def Get(self, Validated, Pkgs, Added, Pkgfiles=None, Dir=None, Rellevel=None, Delta=None, Comparewith=None, body=None):
						kwargs = {'validated': Validated, 'pkgs': Pkgs, 'added': Added, 'pkgFiles': Pkgfiles, 'dir': Dir, 'rellevel': Rellevel, 'delta': Delta, 'compareWith': Comparewith}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/installprofile', 'GET', body, **kwargs)
					
				
				class _Packages(_CommonAPIClass):
					def __call__(self, Pid=None):
						self.Pid = Pid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Bin = Api._Users._Scannedinstances._Scans._Packages._Bin(self)
						self.Files = Api._Users._Scannedinstances._Scans._Packages._Files(self)
						pass
					
					#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/packages
					def Get(self, Excludefiles=None, All=None, Fromrepo=None, Uploaded=None, Notselected=None, Comparewith=None, body=None):
						kwargs = {'excludeFiles': Excludefiles, 'all': All, 'fromRepo': Fromrepo, 'uploaded': Uploaded, 'notSelected': Notselected, 'compareWith': Comparewith}
						return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/packages', 'GET', body, **kwargs)
					class _Bin(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/packages/{pid}/bin
						def Get(self, Downloadtoken, body=None):
							kwargs = {'downloadToken': Downloadtoken}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/packages/' + str(self._get('Pid')) + '/bin', 'GET', body, **kwargs)
						
					
					class _Files(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: users/{uid}/scannedinstances/{siid}/scans/{sid}/packages/{pid}/files
						def Get(self, Dir=None, Rellevel=None, Delta=None, body=None):
							kwargs = {'dir': Dir, 'rellevel': Rellevel, 'delta': Delta}
							return self._REST('/users/' + str(self._get('Uid')) + '/scannedinstances/' + str(self._get('Siid')) + '/scans/' + str(self._get('Sid')) + '/packages/' + str(self._get('Pid')) + '/files', 'GET', body, **kwargs)
						
					
				
			
		
		class _Formats(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/formats
			def Getall(self, Org, Orguri, body=None):
				kwargs = {'org': Org, 'orguri': Orguri}
				return self._REST('/users/' + str(self._get('Uid')) + '/formats', 'GET', body, **kwargs)
			
			#URL: users/{uid}/formats
			def Update(self, Org, Orguri, body=None):
				kwargs = {'org': Org, 'orguri': Orguri}
				return self._REST('/users/' + str(self._get('Uid')) + '/formats', 'PUT', body, **kwargs)
			
		
		class _Orgs(_CommonAPIClass):
			def __call__(self, Oid=None):
				self.Oid = Oid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: users/{uid}/orgs
			def Add(self, Admin, Publisher, body=None):
				kwargs = {'admin': Admin, 'publisher': Publisher}
				return self._REST('/users/' + str(self._get('Uid')) + '/orgs', 'POST', body, **kwargs)
			
			#URL: users/{uid}/orgs
			def Getall(self, Name=None, body=None):
				kwargs = {'name': Name}
				return self._REST('/users/' + str(self._get('Uid')) + '/orgs', 'GET', body, **kwargs)
			
			#URL: users/{uid}/orgs/{oid}
			def Change(self, Admin, body=None):
				kwargs = {'admin': Admin}
				return self._REST('/users/' + str(self._get('Uid')) + '/orgs/' + str(self._get('Oid')) + '', 'PUT', body, **kwargs)
			
			#URL: users/{uid}/orgs/{oid}
			def Remove(self, body=None):
				kwargs = {}
				return self._REST('/users/' + str(self._get('Uid')) + '/orgs/' + str(self._get('Oid')) + '', 'DELETE', body, **kwargs)
			
		
	
	class _Galleries(_CommonAPIClass):
		def __call__(self, Gid=None):
			self.Gid = Gid
			return self
	
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			self.Templates = Api._Galleries._Templates(self)
			self.Publishers = Api._Galleries._Publishers(self)
			self.Members = Api._Galleries._Members(self)
			self.Partners = Api._Galleries._Partners(self)
			self.Notifications = Api._Galleries._Notifications(self)
			self.Groups = Api._Galleries._Groups(self)
			pass
		
		#URL: galleries/{gid}
		def Get(self, body=None):
			kwargs = {}
			return self._REST('/galleries/' + str(self._get('Gid')) + '', 'GET', body, **kwargs)
		class _Templates(_CommonAPIClass):
			def __call__(self, Tid=None):
				self.Tid = Tid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Status = Api._Galleries._Templates._Status(self)
				self.Osprofile = Api._Galleries._Templates._Osprofile(self)
				self.Vote = Api._Galleries._Templates._Vote(self)
				self.Notifications = Api._Galleries._Templates._Notifications(self)
				self.Oas = Api._Galleries._Templates._Oas(self)
				self.Comments = Api._Galleries._Templates._Comments(self)
				self.Confmgmtplts = Api._Galleries._Templates._Confmgmtplts(self)
				self.Logo = Api._Galleries._Templates._Logo(self)
				self.Images = Api._Galleries._Templates._Images(self)
				self.Stats = Api._Galleries._Templates._Stats(self)
				self.Installprofile = Api._Galleries._Templates._Installprofile(self)
				self.Projects = Api._Galleries._Templates._Projects(self)
				pass
			
			#URL: galleries/{gid}/templates/{tid}
			def Delete(self, Force=None, body=None):
				kwargs = {'force': Force}
				return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '', 'DELETE', body, **kwargs)
			
			#URL: galleries/{gid}/templates
			def Share(self, body=None):
				kwargs = {}
				return self._REST('/galleries/' + str(self._get('Gid')) + '/templates', 'POST', body, **kwargs)
			
			#URL: galleries/{gid}/templates
			def Get(self, Orderby=None, Asc=None, Desc=None, Search=None, Category=None, Os=None, Index=None, Max=None, Version=None, Published=None, P=None, body=None):
				kwargs = {'orderby': Orderby, 'asc': Asc, 'desc': Desc, 'search': Search, 'category': Category, 'os': Os, 'index': Index, 'max': Max, 'version': Version, 'published': Published, 'p': P}
				return self._REST('/galleries/' + str(self._get('Gid')) + '/templates', 'GET', body, **kwargs)
			
			#URL: galleries/{gid}/templates/{tid}
			def Update(self, body=None):
				kwargs = {}
				return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '', 'PUT', body, **kwargs)
			
			#URL: galleries/{gid}/templates/{tid}
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '', 'GET', body, **kwargs)
			class _Status(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: galleries/{gid}/templates/{tid}/status
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/status', 'GET', body, **kwargs)
				
				#URL: galleries/{gid}/templates/{tid}/status
				def Cancel(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/status', 'DELETE', body, **kwargs)
				
			
			class _Osprofile(_CommonAPIClass):
				def __call__(self, Ospid=None):
					self.Ospid = Ospid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Pkgs = Api._Galleries._Templates._Osprofile._Pkgs(self)
					pass
				
				class _Pkgs(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: galleries/{gid}/templates/{tid}/osprofile/{ospid}/pkgs
					def Get(self, body=None):
						kwargs = {}
						return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/osprofile/' + str(self._get('Ospid')) + '/pkgs', 'GET', body, **kwargs)
					
				
			
			class _Vote(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: galleries/{gid}/templates/{tid}/vote
				def Vote(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/vote', 'POST', body, **kwargs)
				
			
			class _Notifications(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: galleries/{gid}/templates/{tid}/notifications
				def Watch(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/notifications', 'POST', body, **kwargs)
				
				#URL: galleries/{gid}/templates/{tid}/notifications
				def Unwatch(self, User=None, body=None):
					kwargs = {'user': User}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/notifications', 'DELETE', body, **kwargs)
				
			
			class _Oas(_CommonAPIClass):
				def __call__(self, Oaspkgid=None):
					self.Oaspkgid = Oaspkgid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: galleries/{gid}/templates/{tid}/oas/{oaspkgid}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/oas/' + str(self._get('Oaspkgid')) + '', 'GET', body, **kwargs)
				
			
			class _Comments(_CommonAPIClass):
				def __call__(self, Cid=None):
					self.Cid = Cid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Abuses = Api._Galleries._Templates._Comments._Abuses(self)
					self.Replies = Api._Galleries._Templates._Comments._Replies(self)
					pass
				
				#URL: galleries/{gid}/templates/{tid}/comments/{cid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/comments/' + str(self._get('Cid')) + '', 'DELETE', body, **kwargs)
				
				#URL: galleries/{gid}/templates/{tid}/comments
				def Create(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/comments', 'POST', body, **kwargs)
				
				#URL: galleries/{gid}/templates/{tid}/comments/{cid}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/comments/' + str(self._get('Cid')) + '', 'GET', body, **kwargs)
				
				#URL: galleries/{gid}/templates/{tid}/comments
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/comments', 'DELETE', body, **kwargs)
				
				#URL: galleries/{gid}/templates/{tid}/comments
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/comments', 'GET', body, **kwargs)
				
				#URL: galleries/{gid}/templates/{tid}/comments/{cid}
				def Update(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/comments/' + str(self._get('Cid')) + '', 'PUT', body, **kwargs)
				class _Abuses(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: galleries/{gid}/templates/{tid}/comments/{cid}/abuses
					def Reportabuse(self, body=None):
						kwargs = {}
						return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/comments/' + str(self._get('Cid')) + '/abuses', 'POST', body, **kwargs)
					
				
				class _Replies(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: galleries/{gid}/templates/{tid}/comments/{cid}/replies
					def Reply(self, body=None):
						kwargs = {}
						return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/comments/' + str(self._get('Cid')) + '/replies', 'POST', body, **kwargs)
					
				
			
			class _Confmgmtplts(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: galleries/{gid}/templates/{tid}/confmgmtplts
				def Getall(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/confmgmtplts', 'GET', body, **kwargs)
				
			
			class _Logo(_CommonAPIClass):
				def __call__(self, Lid=None, Logofilename=None):
					self.Lid = Lid
					self.Logofilename = Logofilename
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: galleries/{gid}/templates/{tid}/logo/{lid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/logo/' + str(self._get('Lid')) + '', 'DELETE', body, **kwargs)
				
				#URL: galleries/{gid}/templates/{tid}/logo/{lid}/{logoFileName}
				def Upload(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/logo/' + str(self._get('Lid')) + '/' + str(self._get('Logofilename')) + '', 'POST', body, **kwargs)
				
				#URL: galleries/{gid}/templates/{tid}/logo/{lid}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/logo/' + str(self._get('Lid')) + '', 'GET', body, **kwargs)
				
			
			class _Images(_CommonAPIClass):
				def __call__(self, Itid=None):
					self.Itid = Itid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Status = Api._Galleries._Templates._Images._Status(self)
					self.Pimages = Api._Galleries._Templates._Images._Pimages(self)
					self.Downloads = Api._Galleries._Templates._Images._Downloads(self)
					self.Pkgs = Api._Galleries._Templates._Images._Pkgs(self)
					pass
				
				#URL: galleries/{gid}/templates/{tid}/images/{itid}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/images/' + str(self._get('Itid')) + '', 'GET', body, **kwargs)
				
				#URL: galleries/{gid}/templates/{tid}/images
				def Getall(self, Format, Latest, body=None):
					kwargs = {'format': Format, 'latest': Latest}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/images', 'GET', body, **kwargs)
				
				#URL: galleries/{gid}/templates/{tid}/images/{itid}
				def Regenerate(self, Force=None, body=None):
					kwargs = {'force': Force}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/images/' + str(self._get('Itid')) + '', 'POST', body, **kwargs)
				
				#URL: galleries/{gid}/templates/{tid}/images
				def Generate(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/images', 'POST', body, **kwargs)
				
				#URL: galleries/{gid}/templates/{tid}/images/{itid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/images/' + str(self._get('Itid')) + '', 'DELETE', body, **kwargs)
				class _Status(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: galleries/{gid}/templates/{tid}/images/{itid}/status
					def Cancel(self, body=None):
						kwargs = {}
						return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/images/' + str(self._get('Itid')) + '/status', 'DELETE', body, **kwargs)
					
					#URL: galleries/{gid}/templates/{tid}/images/{itid}/status
					def Get(self, body=None):
						kwargs = {}
						return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/images/' + str(self._get('Itid')) + '/status', 'GET', body, **kwargs)
					
				
				class _Pimages(_CommonAPIClass):
					def __call__(self, Pitid=None):
						self.Pitid = Pitid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Status = Api._Galleries._Templates._Images._Pimages._Status(self)
						self.Instances = Api._Galleries._Templates._Images._Pimages._Instances(self)
						self.Cancel = Api._Galleries._Templates._Images._Pimages._Cancel(self)
						pass
					
					#URL: galleries/{gid}/templates/{tid}/images/{itid}/pimages
					def Publish(self, body=None):
						kwargs = {}
						return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/images/' + str(self._get('Itid')) + '/pimages', 'POST', body, **kwargs)
					
					#URL: galleries/{gid}/templates/{tid}/images/{itid}/pimages/{pitid}
					def Get(self, body=None):
						kwargs = {}
						return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '', 'GET', body, **kwargs)
					
					#URL: galleries/{gid}/templates/{tid}/images/{itid}/pimages/{pitid}
					def Delete(self, body=None):
						kwargs = {}
						return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '', 'DELETE', body, **kwargs)
					class _Status(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: galleries/{gid}/templates/{tid}/images/{itid}/pimages/{pitid}/status
						def Get(self, body=None):
							kwargs = {}
							return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/status', 'GET', body, **kwargs)
						
					
					class _Instances(_CommonAPIClass):
						def __call__(self, Riid=None):
							self.Riid = Riid
							return self
					
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							self.Status = Api._Galleries._Templates._Images._Pimages._Instances._Status(self)
							self.States = Api._Galleries._Templates._Images._Pimages._Instances._States(self)
							pass
						
						#URL: galleries/{gid}/templates/{tid}/images/{itid}/pimages/{pitid}/instances/{riid}
						def Get(self, body=None):
							kwargs = {}
							return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/instances/' + str(self._get('Riid')) + '', 'GET', body, **kwargs)
						
						#URL: galleries/{gid}/templates/{tid}/images/{itid}/pimages/{pitid}/instances/{riid}
						def Delete(self, Force=None, body=None):
							kwargs = {'force': Force}
							return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/instances/' + str(self._get('Riid')) + '', 'DELETE', body, **kwargs)
						
						#URL: galleries/{gid}/templates/{tid}/images/{itid}/pimages/{pitid}/instances
						def Start(self, body=None):
							kwargs = {}
							return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/instances', 'POST', body, **kwargs)
						class _Status(_CommonAPIClass):
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								pass
							
							#URL: galleries/{gid}/templates/{tid}/images/{itid}/pimages/{pitid}/instances/{riid}/status
							def Get(self, body=None):
								kwargs = {}
								return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/instances/' + str(self._get('Riid')) + '/status', 'GET', body, **kwargs)
							
						
						class _States(_CommonAPIClass):
							def __init__(self, parent, **kwargs):
								self._parent = parent
								self.__dict__.update(kwargs)
								pass
							
							#URL: galleries/{gid}/templates/{tid}/images/{itid}/pimages/{pitid}/instances/{riid}/states
							def Change(self, Action, body=None):
								kwargs = {'action': Action}
								return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/instances/' + str(self._get('Riid')) + '/states', 'PUT', body, **kwargs)
							
						
					
					class _Cancel(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: galleries/{gid}/templates/{tid}/images/{itid}/pimages/{pitid}/cancel
						def Cancel(self, body=None):
							kwargs = {}
							return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/images/' + str(self._get('Itid')) + '/pimages/' + str(self._get('Pitid')) + '/cancel', 'DELETE', body, **kwargs)
						
					
				
				class _Downloads(_CommonAPIClass):
					def __call__(self, Filename=None):
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: galleries/{gid}/templates/{tid}/images/{itid}/downloads/{fileName}
					def Download(self, Downloadid=None, body=None):
						kwargs = {'downloadId': Downloadid}
						return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/images/' + str(self._get('Itid')) + '/downloads/' + str(self._get('Filename')) + '', 'GET', body, **kwargs)
					
				
				class _Pkgs(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: galleries/{gid}/templates/{tid}/images/{itid}/pkgs
					def Getall(self, body=None):
						kwargs = {}
						return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/images/' + str(self._get('Itid')) + '/pkgs', 'GET', body, **kwargs)
					
				
			
			class _Stats(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: galleries/{gid}/templates/{tid}/stats
				def Get(self, Fromdate=None, Todate=None, body=None):
					kwargs = {'fromDate': Fromdate, 'toDate': Todate}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/stats', 'GET', body, **kwargs)
				
			
			class _Installprofile(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: galleries/{gid}/templates/{tid}/installProfile
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/installProfile', 'GET', body, **kwargs)
				
			
			class _Projects(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: galleries/{gid}/templates/{tid}/projects
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/galleries/' + str(self._get('Gid')) + '/templates/' + str(self._get('Tid')) + '/projects', 'GET', body, **kwargs)
				
			
		
		class _Publishers(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: galleries/{gid}/publishers
			def Delete(self, User, body=None):
				kwargs = {'user': User}
				return self._REST('/galleries/' + str(self._get('Gid')) + '/publishers', 'DELETE', body, **kwargs)
			
			#URL: galleries/{gid}/publishers
			def Create(self, body=None):
				kwargs = {}
				return self._REST('/galleries/' + str(self._get('Gid')) + '/publishers', 'POST', body, **kwargs)
			
			#URL: galleries/{gid}/publishers
			def Get(self, User, body=None):
				kwargs = {'user': User}
				return self._REST('/galleries/' + str(self._get('Gid')) + '/publishers', 'GET', body, **kwargs)
			
		
		class _Members(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: galleries/{gid}/members
			def Get(self, User, body=None):
				kwargs = {'user': User}
				return self._REST('/galleries/' + str(self._get('Gid')) + '/members', 'GET', body, **kwargs)
			
		
		class _Partners(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: galleries/{gid}/partners
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/galleries/' + str(self._get('Gid')) + '/partners', 'GET', body, **kwargs)
			
		
		class _Notifications(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: galleries/{gid}/notifications
			def Get(self, User=None, body=None):
				kwargs = {'user': User}
				return self._REST('/galleries/' + str(self._get('Gid')) + '/notifications', 'GET', body, **kwargs)
			
		
		class _Groups(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: galleries/{gid}/groups
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/galleries/' + str(self._get('Gid')) + '/groups', 'GET', body, **kwargs)
			
		
	
	class _Usage(_CommonAPIClass):
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			pass
		
		#URL: usage
		def Get(self, User=None, From=None, To=None, body=None):
			kwargs = {'user': User, 'from': From, 'to': To}
			return self._REST('/usage', 'GET', body, **kwargs)
		
	
	class _Usergroups(_CommonAPIClass):
		def __call__(self, Ugid=None):
			self.Ugid = Ugid
			return self
	
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			self.Members = Api._Usergroups._Members(self)
			pass
		
		#URL: usergroups
		def Getall(self, Name, body=None):
			kwargs = {'name': Name}
			return self._REST('/usergroups', 'GET', body, **kwargs)
		
		#URL: usergroups/{ugid}
		def Delete(self, body=None):
			kwargs = {}
			return self._REST('/usergroups/' + str(self._get('Ugid')) + '', 'DELETE', body, **kwargs)
		
		#URL: usergroups
		def Create(self, Org, Publisher=None, Admin=None, Force=None, body=None):
			kwargs = {'org': Org, 'publisher': Publisher, 'admin': Admin, 'force': Force}
			return self._REST('/usergroups', 'POST', body, **kwargs)
		class _Members(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: usergroups/{ugid}/members
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/usergroups/' + str(self._get('Ugid')) + '/members', 'GET', body, **kwargs)
			
			#URL: usergroups/{ugid}/members
			def Add(self, body=None):
				kwargs = {}
				return self._REST('/usergroups/' + str(self._get('Ugid')) + '/members', 'POST', body, **kwargs)
			
			#URL: usergroups/{ugid}/members
			def Delete(self, User, body=None):
				kwargs = {'user': User}
				return self._REST('/usergroups/' + str(self._get('Ugid')) + '/members', 'DELETE', body, **kwargs)
			
		
	
	class _Uforge(_CommonAPIClass):
		def __call__(self, Uid=None):
			self.Uid = Uid
			return self
	
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			self.Lic = Api._Uforge._Lic(self)
			pass
		
		#URL: uforge/{uid}
		def Updatemachineid(self, body=None):
			kwargs = {}
			return self._REST('/uforge/' + str(self._get('Uid')) + '', 'PUT', body, **kwargs)
		
		#URL: uforge
		def Register(self, body=None):
			kwargs = {}
			return self._REST('/uforge', 'POST', body, **kwargs)
		
		#URL: uforge/{uid}
		def Get(self, body=None):
			kwargs = {}
			return self._REST('/uforge/' + str(self._get('Uid')) + '', 'GET', body, **kwargs)
		class _Lic(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: uforge/{uid}/lic
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/uforge/' + str(self._get('Uid')) + '/lic', 'GET', body, **kwargs)
			
		
	
	class _Entitlements(_CommonAPIClass):
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			pass
		
		#URL: entitlements
		def Getall(self, body=None):
			kwargs = {}
			return self._REST('/entitlements', 'GET', body, **kwargs)
		
	
	class _Orgs(_CommonAPIClass):
		def __call__(self, Oid=None):
			self.Oid = Oid
			return self
	
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			self.Logos = Api._Orgs._Logos(self)
			self.Stats = Api._Orgs._Stats(self)
			self.Roles = Api._Orgs._Roles(self)
			self.Subscriptions = Api._Orgs._Subscriptions(self)
			self.Repositories = Api._Orgs._Repositories(self)
			self.Companies = Api._Orgs._Companies(self)
			self.Categories = Api._Orgs._Categories(self)
			self.Members = Api._Orgs._Members(self)
			self.Formats = Api._Orgs._Formats(self)
			self.Licenses = Api._Orgs._Licenses(self)
			self.Workspaces = Api._Orgs._Workspaces(self)
			self.Distributions = Api._Orgs._Distributions(self)
			self.Projects = Api._Orgs._Projects(self)
			pass
		
		#URL: orgs/{oid}
		def Get(self, body=None):
			kwargs = {}
			return self._REST('/orgs/' + str(self._get('Oid')) + '', 'GET', body, **kwargs)
		
		#URL: orgs
		def Create(self, Autoactivate=None, Hasgallery=None, body=None):
			kwargs = {'autoActivate': Autoactivate, 'hasGallery': Hasgallery}
			return self._REST('/orgs', 'POST', body, **kwargs)
		
		#URL: orgs
		def Getall(self, body=None):
			kwargs = {}
			return self._REST('/orgs', 'GET', body, **kwargs)
		class _Logos(_CommonAPIClass):
			def __call__(self, Slogoid=None, Filename=None):
				self.Slogoid = Slogoid
				self.Filename = Filename
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: orgs/{oid}/logos/{slogoid}
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/logos/' + str(self._get('Slogoid')) + '', 'GET', body, **kwargs)
			
		
		class _Stats(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: orgs/{oid}/stats
			def Get(self, Type, Filter, Fromdate, Todate, Graphtype, Periodicity, Nb, Order, Groupby, body=None):
				kwargs = {'type': Type, 'filter': Filter, 'fromDate': Fromdate, 'toDate': Todate, 'graphType': Graphtype, 'periodicity': Periodicity, 'nb': Nb, 'order': Order, 'groupby': Groupby}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/stats', 'GET', body, **kwargs)
			
		
		class _Roles(_CommonAPIClass):
			def __call__(self, Rolename=None):
				self.Rolename = Rolename
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: orgs/{oid}/roles
			def Getall(self, body=None):
				kwargs = {}
				return self._REST('/orgs/{oid}/roles', 'GET', body, **kwargs)
			
			#URL: orgs/{oid}/roles
			def Create(self, body=None):
				kwargs = {}
				return self._REST('/orgs/{oid}/roles', 'POST', body, **kwargs)
			
			#URL: orgs/{oid}/roles/{rolename}
			def Delete(self, body=None):
				kwargs = {}
				return self._REST('/orgs/{oid}/roles/' + str(self._get('Rolename')) + '', 'DELETE', body, **kwargs)
			
			#URL: orgs/{oid}/roles
			def Update(self, body=None):
				kwargs = {}
				return self._REST('/orgs/{oid}/roles', 'PUT', body, **kwargs)
			
		
		class _Subscriptions(_CommonAPIClass):
			def __call__(self, Spid=None):
				self.Spid = Spid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Admins = Api._Orgs._Subscriptions._Admins(self)
				self.Formats = Api._Orgs._Subscriptions._Formats(self)
				self.Quotas = Api._Orgs._Subscriptions._Quotas(self)
				self.Roles = Api._Orgs._Subscriptions._Roles(self)
				self.Distros = Api._Orgs._Subscriptions._Distros(self)
				pass
			
			#URL: orgs/{oid}/subscriptions
			def Add(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions', 'POST', body, **kwargs)
			
			#URL: orgs/{oid}/subscriptions/{spid}
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '', 'GET', body, **kwargs)
			
			#URL: orgs/{oid}/subscriptions/{spid}
			def Update(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '', 'PUT', body, **kwargs)
			
			#URL: orgs/{oid}/subscriptions/{spid}
			def Remove(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '', 'DELETE', body, **kwargs)
			
			#URL: orgs/{oid}/subscriptions
			def Getall(self, Search, body=None):
				kwargs = {'search': Search}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions', 'GET', body, **kwargs)
			class _Admins(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/subscriptions/{spid}/admins
				def Update(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '/admins', 'PUT', body, **kwargs)
				
			
			class _Formats(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/subscriptions/{spid}/formats
				def Update(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '/formats', 'PUT', body, **kwargs)
				
			
			class _Quotas(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/subscriptions/{spid}/quotas
				def Update(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '/quotas', 'PUT', body, **kwargs)
				
			
			class _Roles(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/subscriptions/{spid}/roles
				def Update(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '/roles', 'PUT', body, **kwargs)
				
			
			class _Distros(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/subscriptions/{spid}/distros
				def Update(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/subscriptions/' + str(self._get('Spid')) + '/distros', 'PUT', body, **kwargs)
				
			
		
		class _Repositories(_CommonAPIClass):
			def __call__(self, Rid=None):
				self.Rid = Rid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Distributions = Api._Orgs._Repositories._Distributions(self)
				pass
			
			#URL: orgs/{oid}/repositories
			def Getall(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/repositories', 'GET', body, **kwargs)
			
			#URL: orgs/{oid}/repositories/{rid}
			def Update(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/repositories/' + str(self._get('Rid')) + '', 'PUT', body, **kwargs)
			
			#URL: orgs/{oid}/repositories/{rid}
			def Delete(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/repositories/' + str(self._get('Rid')) + '', 'DELETE', body, **kwargs)
			
			#URL: orgs/{oid}/repositories
			def Create(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/repositories', 'POST', body, **kwargs)
			class _Distributions(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/repositories/{rid}/distributions
				def Getall(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/repositories/' + str(self._get('Rid')) + '/distributions', 'GET', body, **kwargs)
				
			
		
		class _Companies(_CommonAPIClass):
			def __call__(self, Cid=None):
				self.Cid = Cid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Logos = Api._Orgs._Companies._Logos(self)
				pass
			
			#URL: orgs/{oid}/companies
			def Getall(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/companies', 'GET', body, **kwargs)
			class _Logos(_CommonAPIClass):
				def __call__(self, Sclogoid=None, Filename=None):
					self.Sclogoid = Sclogoid
					self.Filename = Filename
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/companies/{cid}/logos/{sclogoid}/{fileName}
				def Upload(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/companies/' + str(self._get('Cid')) + '/logos/' + str(self._get('Sclogoid')) + '/' + str(self._get('Filename')) + '', 'POST', body, **kwargs)
				
				#URL: orgs/{oid}/companies/{cid}/logos/{sclogoid}/{fileName}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/companies/' + str(self._get('Cid')) + '/logos/' + str(self._get('Sclogoid')) + '/' + str(self._get('Filename')) + '', 'GET', body, **kwargs)
				
				#URL: orgs/{oid}/companies/{cid}/logos/{sclogoid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/companies/' + str(self._get('Cid')) + '/logos/' + str(self._get('Sclogoid')) + '', 'DELETE', body, **kwargs)
				
			
		
		class _Categories(_CommonAPIClass):
			def __call__(self, Cid=None):
				self.Cid = Cid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: orgs/{oid}/categories
			def Create(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/categories', 'POST', body, **kwargs)
			
			#URL: orgs/{oid}/categories
			def Getall(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/categories', 'GET', body, **kwargs)
			
			#URL: orgs/{oid}/categories
			def Delete(self, Id, Reset=None, body=None):
				kwargs = {'id': Id, 'reset': Reset}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/categories', 'DELETE', body, **kwargs)
			
			#URL: orgs/{oid}/categories/{cid}
			def Delete(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/categories/' + str(self._get('Cid')) + '', 'DELETE', body, **kwargs)
			
		
		class _Members(_CommonAPIClass):
			def __call__(self, Uid=None):
				self.Uid = Uid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: orgs/{oid}/members
			def Add(self, Admin, Publisher, body=None):
				kwargs = {'admin': Admin, 'publisher': Publisher}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/members', 'POST', body, **kwargs)
			
			#URL: orgs/{oid}/members/{uid}
			def Change(self, Admin, body=None):
				kwargs = {'admin': Admin}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/members/' + str(self._get('Uid')) + '', 'PUT', body, **kwargs)
			
			#URL: orgs/{oid}/members
			def Getall(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/members', 'GET', body, **kwargs)
			
			#URL: orgs/{oid}/members/{uid}
			def Remove(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/members/' + str(self._get('Uid')) + '', 'DELETE', body, **kwargs)
			
		
		class _Formats(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: orgs/{oid}/formats
			def Getall(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/formats', 'GET', body, **kwargs)
			
			#URL: orgs/{oid}/formats
			def Update(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/formats', 'PUT', body, **kwargs)
			
		
		class _Licenses(_CommonAPIClass):
			def __call__(self, Slid=None):
				self.Slid = Slid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: orgs/{oid}/licenses/{slid}
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/licenses/' + str(self._get('Slid')) + '', 'GET', body, **kwargs)
			
			#URL: orgs/{oid}/licenses
			def Getall(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/licenses', 'GET', body, **kwargs)
			
		
		class _Workspaces(_CommonAPIClass):
			def __call__(self, Wid=None):
				self.Wid = Wid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Memberships = Api._Orgs._Workspaces._Memberships(self)
				self.Templates = Api._Orgs._Workspaces._Templates(self)
				self.Comments = Api._Orgs._Workspaces._Comments(self)
				pass
			
			#URL: orgs/{oid}/workspaces
			def Getall(self, Name, body=None):
				kwargs = {'name': Name}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces', 'GET', body, **kwargs)
			
			#URL: orgs/{oid}/workspaces/{wid}
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '', 'GET', body, **kwargs)
			
			#URL: orgs/{oid}/workspaces/{wid}
			def Delete(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '', 'DELETE', body, **kwargs)
			
			#URL: orgs/{oid}/workspaces
			def Create(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces', 'POST', body, **kwargs)
			class _Memberships(_CommonAPIClass):
				def __call__(self, Mid=None):
					self.Mid = Mid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/workspaces/{wid}/memberships
				def Add(self, Pi, body=None):
					kwargs = {'pi': Pi}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/memberships', 'POST', body, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/memberships
				def Update(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/memberships', 'PUT', body, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/memberships/{mid}
				def Update(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/memberships/' + str(self._get('Mid')) + '', 'PUT', body, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/memberships
				def Delete(self, Email=None, Login=None, body=None):
					kwargs = {'email': Email, 'login': Login}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/memberships', 'DELETE', body, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/memberships/{mid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/memberships/' + str(self._get('Mid')) + '', 'DELETE', body, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/memberships
				def Get(self, User=None, body=None):
					kwargs = {'user': User}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/memberships', 'GET', body, **kwargs)
				
			
			class _Templates(_CommonAPIClass):
				def __call__(self, Tid=None):
					self.Tid = Tid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Status = Api._Orgs._Workspaces._Templates._Status(self)
					self.Stats = Api._Orgs._Workspaces._Templates._Stats(self)
					self.Osprofile = Api._Orgs._Workspaces._Templates._Osprofile(self)
					self.Comments = Api._Orgs._Workspaces._Templates._Comments(self)
					self.Oas = Api._Orgs._Workspaces._Templates._Oas(self)
					self.Confmgmtplts = Api._Orgs._Workspaces._Templates._Confmgmtplts(self)
					self.Vote = Api._Orgs._Workspaces._Templates._Vote(self)
					self.Logo = Api._Orgs._Workspaces._Templates._Logo(self)
					self.Installprofile = Api._Orgs._Workspaces._Templates._Installprofile(self)
					self.Projects = Api._Orgs._Workspaces._Templates._Projects(self)
					pass
				
				#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}
				def Delete(self, Force=None, body=None):
					kwargs = {'force': Force}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '', 'DELETE', body, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/templates
				def Share(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates', 'POST', body, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/templates
				def Get(self, Orderby, Asc=None, Desc=None, Search=None, Category=None, Os=None, Index=None, Max=None, Version=None, Published=None, P=None, body=None):
					kwargs = {'orderby': Orderby, 'asc': Asc, 'desc': Desc, 'search': Search, 'category': Category, 'os': Os, 'index': Index, 'max': Max, 'version': Version, 'published': Published, 'p': P}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates', 'GET', body, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '', 'GET', body, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}
				def Update(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '', 'PUT', body, **kwargs)
				class _Status(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/status
					def Get(self, body=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/status', 'GET', body, **kwargs)
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/status
					def Cancel(self, body=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/status', 'DELETE', body, **kwargs)
					
				
				class _Stats(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/stats
					def Get(self, Fromdate=None, Todate=None, body=None):
						kwargs = {'fromDate': Fromdate, 'toDate': Todate}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/stats', 'GET', body, **kwargs)
					
				
				class _Osprofile(_CommonAPIClass):
					def __call__(self, Ospid=None):
						self.Ospid = Ospid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Pkgs = Api._Orgs._Workspaces._Templates._Osprofile._Pkgs(self)
						pass
					
					class _Pkgs(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/osprofile/{ospid}/pkgs
						def Get(self, body=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/osprofile/' + str(self._get('Ospid')) + '/pkgs', 'GET', body, **kwargs)
						
					
				
				class _Comments(_CommonAPIClass):
					def __call__(self, Cid=None):
						self.Cid = Cid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						self.Replies = Api._Orgs._Workspaces._Templates._Comments._Replies(self)
						self.Abuses = Api._Orgs._Workspaces._Templates._Comments._Abuses(self)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/comments
					def Get(self, body=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/comments', 'GET', body, **kwargs)
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/comments
					def Create(self, body=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/comments', 'POST', body, **kwargs)
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/comments/{cid}
					def Get(self, body=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/comments/' + str(self._get('Cid')) + '', 'GET', body, **kwargs)
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/comments
					def Delete(self, body=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/comments', 'DELETE', body, **kwargs)
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/comments/{cid}
					def Delete(self, body=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/comments/' + str(self._get('Cid')) + '', 'DELETE', body, **kwargs)
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/comments/{cid}
					def Update(self, body=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/comments/' + str(self._get('Cid')) + '', 'PUT', body, **kwargs)
					class _Replies(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/comments/{cid}/replies
						def Reply(self, body=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/comments/' + str(self._get('Cid')) + '/replies', 'POST', body, **kwargs)
						
					
					class _Abuses(_CommonAPIClass):
						def __init__(self, parent, **kwargs):
							self._parent = parent
							self.__dict__.update(kwargs)
							pass
						
						#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/comments/{cid}/abuses
						def Reportabuse(self, body=None):
							kwargs = {}
							return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/comments/' + str(self._get('Cid')) + '/abuses', 'POST', body, **kwargs)
						
					
				
				class _Oas(_CommonAPIClass):
					def __call__(self, Oaspkgid=None):
						self.Oaspkgid = Oaspkgid
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/oas/{oaspkgid}
					def Get(self, body=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/oas/' + str(self._get('Oaspkgid')) + '', 'GET', body, **kwargs)
					
				
				class _Confmgmtplts(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/confmgmtplts
					def Getall(self, body=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/confmgmtplts', 'GET', body, **kwargs)
					
				
				class _Vote(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/vote
					def Vote(self, body=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/vote', 'POST', body, **kwargs)
					
				
				class _Logo(_CommonAPIClass):
					def __call__(self, Lid=None, Filename=None):
						self.Lid = Lid
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/logo/{lid}
					def Get(self, body=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/logo/' + str(self._get('Lid')) + '', 'GET', body, **kwargs)
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/logo/{lid}/{fileName}
					def Upload(self, body=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/logo/' + str(self._get('Lid')) + '/' + str(self._get('Filename')) + '', 'POST', body, **kwargs)
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/logo/{lid}
					def Delete(self, body=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/logo/' + str(self._get('Lid')) + '', 'DELETE', body, **kwargs)
					
				
				class _Installprofile(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/installProfile
					def Get(self, body=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/installProfile', 'GET', body, **kwargs)
					
				
				class _Projects(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/templates/{tid}/projects
					def Get(self, body=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/templates/' + str(self._get('Tid')) + '/projects', 'GET', body, **kwargs)
					
				
			
			class _Comments(_CommonAPIClass):
				def __call__(self, Cid=None):
					self.Cid = Cid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Abuses = Api._Orgs._Workspaces._Comments._Abuses(self)
					self.Replies = Api._Orgs._Workspaces._Comments._Replies(self)
					pass
				
				#URL: orgs/{oid}/workspaces/{wid}/comments
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/comments', 'DELETE', body, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/comments/{cid}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/comments/' + str(self._get('Cid')) + '', 'GET', body, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/comments/{cid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/comments/' + str(self._get('Cid')) + '', 'DELETE', body, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/comments
				def Getall(self, Index=None, Max=None, body=None):
					kwargs = {'index': Index, 'max': Max}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/comments', 'GET', body, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/comments/{cid}
				def Update(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/comments/' + str(self._get('Cid')) + '', 'PUT', body, **kwargs)
				
				#URL: orgs/{oid}/workspaces/{wid}/comments
				def Create(self, Notification=None, body=None):
					kwargs = {'notification': Notification}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/comments', 'POST', body, **kwargs)
				class _Abuses(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/comments/{cid}/abuses
					def Reportabuse(self, body=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/comments/' + str(self._get('Cid')) + '/abuses', 'POST', body, **kwargs)
					
				
				class _Replies(_CommonAPIClass):
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: orgs/{oid}/workspaces/{wid}/comments/{cid}/replies
					def Reply(self, body=None):
						kwargs = {}
						return self._REST('/orgs/' + str(self._get('Oid')) + '/workspaces/' + str(self._get('Wid')) + '/comments/' + str(self._get('Cid')) + '/replies', 'POST', body, **kwargs)
					
				
			
		
		class _Distributions(_CommonAPIClass):
			def __call__(self, Did=None):
				self.Did = Did
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Goldens = Api._Orgs._Distributions._Goldens(self)
				pass
			
			#URL: orgs/{oid}/distributions
			def Createdistribution(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/distributions', 'POST', body, **kwargs)
			
			#URL: orgs/{oid}/distributions
			def Update(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/distributions', 'PUT', body, **kwargs)
			
			#URL: orgs/{oid}/distributions
			def Getall(self, Name=None, Version=None, Arch=None, Info=None, body=None):
				kwargs = {'name': Name, 'version': Version, 'arch': Arch, 'info': Info}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/distributions', 'GET', body, **kwargs)
			class _Goldens(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: orgs/{oid}/distributions/{did}/goldens
				def Create(self, Language, Edition, Type, Goldendate, Filename, body=None):
					kwargs = {'language': Language, 'edition': Edition, 'type': Type, 'goldenDate': Goldendate, 'fileName': Filename}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/distributions/' + str(self._get('Did')) + '/goldens', 'POST', body, **kwargs)
				
				#URL: orgs/{oid}/distributions/{did}/goldens
				def Getall(self, body=None):
					kwargs = {}
					return self._REST('/orgs/' + str(self._get('Oid')) + '/distributions/' + str(self._get('Did')) + '/goldens', 'GET', body, **kwargs)
				
			
		
		class _Projects(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: orgs/{oid}/projects
			def Create(self, body=None):
				kwargs = {}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/projects', 'POST', body, **kwargs)
			
			#URL: orgs/{oid}/projects
			def Getall(self, Distribid=None, Forceall=None, body=None):
				kwargs = {'distribId': Distribid, 'forceall': Forceall}
				return self._REST('/orgs/' + str(self._get('Oid')) + '/projects', 'GET', body, **kwargs)
			
		
	
	class _Oas(_CommonAPIClass):
		def __call__(self, Uid=None):
			self.Uid = Uid
			return self
	
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			self.Lic = Api._Oas._Lic(self)
			pass
		
		#URL: oas
		def Register(self, body=None):
			kwargs = {}
			return self._REST('/oas', 'POST', body, **kwargs)
		
		#URL: oas/{uid}
		def Update(self, body=None):
			kwargs = {}
			return self._REST('/oas/' + str(self._get('Uid')) + '', 'PUT', body, **kwargs)
		
		#URL: oas/{uid}
		def Get(self, body=None):
			kwargs = {}
			return self._REST('/oas/' + str(self._get('Uid')) + '', 'GET', body, **kwargs)
		class _Lic(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: oas/{uid}/lic
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/oas/' + str(self._get('Uid')) + '/lic', 'GET', body, **kwargs)
			
		
	
	class _Distributions(_CommonAPIClass):
		def __call__(self, Id=None, Org=None, Name=None, Version=None):
			self.Id = Id
			self.Org = Org
			self.Name = Name
			self.Version = Version
			return self
	
		def __init__(self, parent, **kwargs):
			self._parent = parent
			self.__dict__.update(kwargs)
			self.Files = Api._Distributions._Files(self)
			self.Milestones = Api._Distributions._Milestones(self)
			self.License = Api._Distributions._License(self)
			self.Profiles = Api._Distributions._Profiles(self)
			self.Pkgs = Api._Distributions._Pkgs(self)
			self.Changeactivestatus = Api._Distributions._Changeactivestatus(self)
			self.Services = Api._Distributions._Services(self)
			self.Logo = Api._Distributions._Logo(self)
			self.Projects = Api._Distributions._Projects(self)
			pass
		
		#URL: distributions/{id}
		def Deletedistribution(self, body=None):
			kwargs = {}
			return self._REST('/distributions/' + str(self._get('Id')) + '', 'DELETE', body, **kwargs)
		
		#URL: distributions
		def Getall(self, Name=None, Version=None, Arch=None, Access=None, body=None):
			kwargs = {'name': Name, 'version': Version, 'arch': Arch, 'access': Access}
			return self._REST('/distributions', 'GET', body, **kwargs)
		
		#URL: distributions/{id}
		def Get(self, body=None):
			kwargs = {}
			return self._REST('/distributions/' + str(self._get('Id')) + '', 'GET', body, **kwargs)
		
		#URL: distributions/{org}/{name}/{version}
		def Createdistribution(self, Flavor, Isactive, Isdefault, Arch=None, body=None):
			kwargs = {'flavor': Flavor, 'isActive': Isactive, 'isDefault': Isdefault, 'arch': Arch}
			return self._REST('/distributions/' + str(self._get('Org')) + '/' + str(self._get('Name')) + '/' + str(self._get('Version')) + '', 'POST', body, **kwargs)
		
		#URL: distributions/{id}
		def Updatedistribution(self, body=None):
			kwargs = {}
			return self._REST('/distributions/' + str(self._get('Id')) + '', 'PUT', body, **kwargs)
		class _Files(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: distributions/{id}/files
			def Getall(self, Ignoremissing, body=None):
				kwargs = {'ignoremissing': Ignoremissing}
				return self._REST('/distributions/' + str(self._get('Id')) + '/files', 'POST', body, **kwargs)
			
		
		class _Milestones(_CommonAPIClass):
			def __call__(self, Mid=None):
				self.Mid = Mid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: distributions/{id}/milestones
			def Getall(self, Search=None, Orgid=None, From=None, To=None, Singlesearch=None, Cs=None, body=None):
				kwargs = {'search': Search, 'orgId': Orgid, 'from': From, 'to': To, 'singleSearch': Singlesearch, 'cs': Cs}
				return self._REST('/distributions/' + str(self._get('Id')) + '/milestones', 'GET', body, **kwargs)
			
			#URL: distributions/{id}/milestones
			def Create(self, Orgid=None, body=None):
				kwargs = {'orgId': Orgid}
				return self._REST('/distributions/' + str(self._get('Id')) + '/milestones', 'POST', body, **kwargs)
			
			#URL: distributions/{id}/milestones/{mid}
			def Update(self, Orgid=None, body=None):
				kwargs = {'orgId': Orgid}
				return self._REST('/distributions/' + str(self._get('Id')) + '/milestones/' + str(self._get('Mid')) + '', 'PUT', body, **kwargs)
			
			#URL: distributions/{id}/milestones/{mid}
			def Delete(self, Orgid=None, body=None):
				kwargs = {'orgId': Orgid}
				return self._REST('/distributions/' + str(self._get('Id')) + '/milestones/' + str(self._get('Mid')) + '', 'DELETE', body, **kwargs)
			
			#URL: distributions/{id}/milestones/{mid}
			def Get(self, Orgid=None, body=None):
				kwargs = {'orgId': Orgid}
				return self._REST('/distributions/' + str(self._get('Id')) + '/milestones/' + str(self._get('Mid')) + '', 'GET', body, **kwargs)
			
		
		class _License(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: distributions/{id}/license
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/distributions/' + str(self._get('Id')) + '/license', 'GET', body, **kwargs)
			
		
		class _Profiles(_CommonAPIClass):
			def __call__(self, Prid=None):
				self.Prid = Prid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Pkgs = Api._Distributions._Profiles._Pkgs(self)
				pass
			
			#URL: distributions/{id}/profiles/{prid}
			def Update(self, body=None):
				kwargs = {}
				return self._REST('/distributions/' + str(self._get('Id')) + '/profiles/' + str(self._get('Prid')) + '', 'PUT', body, **kwargs)
			
			#URL: distributions/{id}/profiles/{prid}
			def Delete(self, body=None):
				kwargs = {}
				return self._REST('/distributions/' + str(self._get('Id')) + '/profiles/' + str(self._get('Prid')) + '', 'DELETE', body, **kwargs)
			
			#URL: distributions/{id}/profiles
			def Getall(self, Name=None, body=None):
				kwargs = {'name': Name}
				return self._REST('/distributions/' + str(self._get('Id')) + '/profiles', 'GET', body, **kwargs)
			
			#URL: distributions/{id}/profiles
			def Create(self, Basedon, body=None):
				kwargs = {'basedOn': Basedon}
				return self._REST('/distributions/' + str(self._get('Id')) + '/profiles', 'POST', body, **kwargs)
			
			#URL: distributions/{id}/profiles/{prid}
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/distributions/' + str(self._get('Id')) + '/profiles/' + str(self._get('Prid')) + '', 'GET', body, **kwargs)
			class _Pkgs(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: distributions/{id}/profiles/{prid}/pkgs
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/distributions/' + str(self._get('Id')) + '/profiles/' + str(self._get('Prid')) + '/pkgs', 'GET', body, **kwargs)
				
			
		
		class _Pkgs(_CommonAPIClass):
			def __call__(self, Pid=None):
				self.Pid = Pid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Updateinfo = Api._Distributions._Pkgs._Updateinfo(self)
				pass
			
			#URL: distributions/{id}/pkgs
			def Getall(self, Search=None, Version=None, Release=None, Arch=None, To=None, Singlesearch=None, Orgid=None, Cs=None, body=None):
				kwargs = {'search': Search, 'version': Version, 'release': Release, 'arch': Arch, 'to': To, 'singleSearch': Singlesearch, 'orgId': Orgid, 'cs': Cs}
				return self._REST('/distributions/' + str(self._get('Id')) + '/pkgs', 'GET', body, **kwargs)
			
			#URL: distributions/{id}/pkgs/{pid}
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/distributions/' + str(self._get('Id')) + '/pkgs/' + str(self._get('Pid')) + '', 'GET', body, **kwargs)
			class _Updateinfo(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: distributions/{id}/pkgs/{pid}/updateinfo
				def Getupdateinfo(self, body=None):
					kwargs = {}
					return self._REST('/distributions/' + str(self._get('Id')) + '/pkgs/' + str(self._get('Pid')) + '/updateinfo', 'GET', body, **kwargs)
				
			
		
		class _Changeactivestatus(_CommonAPIClass):
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: distributions/{id}/changeActiveStatus
			def Changedistributionactivestatus(self, Active, body=None):
				kwargs = {'active': Active}
				return self._REST('/distributions/' + str(self._get('Id')) + '/changeActiveStatus', 'PUT', body, **kwargs)
			
		
		class _Services(_CommonAPIClass):
			def __call__(self, Dsid=None):
				self.Dsid = Dsid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Pkgs = Api._Distributions._Services._Pkgs(self)
				pass
			
			#URL: distributions/{id}/services/{dsid}
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/distributions/' + str(self._get('Id')) + '/services/' + str(self._get('Dsid')) + '', 'GET', body, **kwargs)
			
			#URL: distributions/{id}/services
			def Getall(self, Name=None, body=None):
				kwargs = {'name': Name}
				return self._REST('/distributions/' + str(self._get('Id')) + '/services', 'GET', body, **kwargs)
			class _Pkgs(_CommonAPIClass):
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: distributions/{id}/services/{dsid}/pkgs
				def Getall(self, To, body=None):
					kwargs = {'to': To}
					return self._REST('/distributions/' + str(self._get('Id')) + '/services/' + str(self._get('Dsid')) + '/pkgs', 'GET', body, **kwargs)
				
			
		
		class _Logo(_CommonAPIClass):
			def __call__(self, Filename=None):
				self.Filename = Filename
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				pass
			
			#URL: distributions/{id}/logo
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/distributions/' + str(self._get('Id')) + '/logo', 'GET', body, **kwargs)
			
		
		class _Projects(_CommonAPIClass):
			def __call__(self, Pid=None):
				self.Pid = Pid
				return self
		
			def __init__(self, parent, **kwargs):
				self._parent = parent
				self.__dict__.update(kwargs)
				self.Licenses = Api._Distributions._Projects._Licenses(self)
				self.Pkgs = Api._Distributions._Projects._Pkgs(self)
				pass
			
			#URL: distributions/{id}/projects/{pid}
			def Get(self, body=None):
				kwargs = {}
				return self._REST('/distributions/' + str(self._get('Id')) + '/projects/' + str(self._get('Pid')) + '', 'GET', body, **kwargs)
			
			#URL: distributions/{id}/projects/{pid}
			def Update(self, body=None):
				kwargs = {}
				return self._REST('/distributions/' + str(self._get('Id')) + '/projects/' + str(self._get('Pid')) + '', 'PUT', body, **kwargs)
			
			#URL: distributions/{id}/projects
			def Getall(self, Org=None, Name=None, Version=None, Release=None, Tag=None, Forceall=None, Regexp=None, body=None):
				kwargs = {'org': Org, 'name': Name, 'version': Version, 'release': Release, 'tag': Tag, 'forceall': Forceall, 'regexp': Regexp}
				return self._REST('/distributions/' + str(self._get('Id')) + '/projects', 'GET', body, **kwargs)
			
			#URL: distributions/{id}/projects/{pid}
			def Delete(self, Erase=None, body=None):
				kwargs = {'erase': Erase}
				return self._REST('/distributions/' + str(self._get('Id')) + '/projects/' + str(self._get('Pid')) + '', 'DELETE', body, **kwargs)
			class _Licenses(_CommonAPIClass):
				def __call__(self, Projectlid=None, Filename=None):
					self.Projectlid = Projectlid
					self.Filename = Filename
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					pass
				
				#URL: distributions/{id}/projects/{pid}/licenses/{projectlid}
				def Multipartupload(self, body=None):
					kwargs = {}
					return self._REST('/distributions/' + str(self._get('Id')) + '/projects/' + str(self._get('Pid')) + '/licenses/' + str(self._get('Projectlid')) + '', 'POST', body, **kwargs)
				
				#URL: distributions/{id}/projects/{pid}/licenses/{projectlid}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/distributions/' + str(self._get('Id')) + '/projects/' + str(self._get('Pid')) + '/licenses/' + str(self._get('Projectlid')) + '', 'GET', body, **kwargs)
				
				#URL: distributions/{id}/projects/{pid}/licenses/{projectlid}/{fileName}
				def Upload(self, body=None):
					kwargs = {}
					return self._REST('/distributions/' + str(self._get('Id')) + '/projects/' + str(self._get('Pid')) + '/licenses/' + str(self._get('Projectlid')) + '/' + str(self._get('Filename')) + '', 'POST', body, **kwargs)
				
				#URL: distributions/{id}/projects/{pid}/licenses/{projectlid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/distributions/' + str(self._get('Id')) + '/projects/' + str(self._get('Pid')) + '/licenses/' + str(self._get('Projectlid')) + '', 'DELETE', body, **kwargs)
				
			
			class _Pkgs(_CommonAPIClass):
				def __call__(self, Pkgid=None, Mspackid=None):
					self.Pkgid = Pkgid
					self.Mspackid = Mspackid
					return self
			
				def __init__(self, parent, **kwargs):
					self._parent = parent
					self.__dict__.update(kwargs)
					self.Bin = Api._Distributions._Projects._Pkgs._Bin(self)
					pass
				
				#URL: distributions/{id}/projects/{pid}/pkgs/{pkgid}
				def Delete(self, body=None):
					kwargs = {}
					return self._REST('/distributions/' + str(self._get('Id')) + '/projects/' + str(self._get('Pid')) + '/pkgs/' + str(self._get('Pkgid')) + '', 'DELETE', body, **kwargs)
				
				#URL: distributions/{id}/projects/{pid}/pkgs
				def Getall(self, Filename=None, body=None):
					kwargs = {'filename': Filename}
					return self._REST('/distributions/' + str(self._get('Id')) + '/projects/' + str(self._get('Pid')) + '/pkgs', 'GET', body, **kwargs)
				
				#URL: distributions/{id}/projects/{pid}/pkgs/{pkgid}
				def Get(self, body=None):
					kwargs = {}
					return self._REST('/distributions/' + str(self._get('Id')) + '/projects/' + str(self._get('Pid')) + '/pkgs/' + str(self._get('Pkgid')) + '', 'GET', body, **kwargs)
				
				#URL: distributions/{id}/projects/{pid}/pkgs/{pkgid}
				def Update(self, body=None):
					kwargs = {}
					return self._REST('/distributions/' + str(self._get('Id')) + '/projects/' + str(self._get('Pid')) + '/pkgs/' + str(self._get('Pkgid')) + '', 'PUT', body, **kwargs)
				
				#URL: distributions/{id}/projects/{pid}/pkgs
				def Deleteall(self, body=None):
					kwargs = {}
					return self._REST('/distributions/' + str(self._get('Id')) + '/projects/' + str(self._get('Pid')) + '/pkgs', 'DELETE', body, **kwargs)
				
				#URL: distributions/{id}/projects/{pid}/pkgs
				def Create(self, body=None):
					kwargs = {}
					return self._REST('/distributions/' + str(self._get('Id')) + '/projects/' + str(self._get('Pid')) + '/pkgs', 'POST', body, **kwargs)
				
				#URL: distributions/{id}/projects/{pid}/pkgs
				def Update(self, body=None):
					kwargs = {}
					return self._REST('/distributions/' + str(self._get('Id')) + '/projects/' + str(self._get('Pid')) + '/pkgs', 'PUT', body, **kwargs)
				class _Bin(_CommonAPIClass):
					def __call__(self, Filename=None):
						self.Filename = Filename
						return self
				
					def __init__(self, parent, **kwargs):
						self._parent = parent
						self.__dict__.update(kwargs)
						pass
					
					#URL: distributions/{id}/projects/{pid}/pkgs/{pkgid}/bin/{fileName}
					def Upload(self, body=None):
						kwargs = {}
						return self._REST('/distributions/' + str(self._get('Id')) + '/projects/' + str(self._get('Pid')) + '/pkgs/' + str(self._get('Pkgid')) + '/bin/' + str(self._get('Filename')) + '', 'POST', body, **kwargs)
					
					#URL: distributions/{id}/projects/{pid}/pkgs/{mspackid}/bin/{fileName}
					def Downloadfilename(self, Downloadid, body=None):
						kwargs = {'downloadId': Downloadid}
						return self._REST('/distributions/' + str(self._get('Id')) + '/projects/' + str(self._get('Pid')) + '/pkgs/{mspackid}/bin/{fileName}', 'GET', body, **kwargs)
					
					#URL: distributions/{id}/projects/{pid}/pkgs/{pkgid}/bin
					def Download(self, Downloadid, body=None):
						kwargs = {'downloadId': Downloadid}
						return self._REST('/distributions/' + str(self._get('Id')) + '/projects/' + str(self._get('Pid')) + '/pkgs/' + str(self._get('Pkgid')) + '/bin', 'GET', body, **kwargs)
					
				
			
		
	
