# UMLS API Client

## Overview

This Python package provides an interface to interact with the Unified Medical Language System (UMLS) REST APIs. It enables users to search for terms, retrieve CUIs (Concept Unique Identifiers), access semantic networks, crosswalk vocabularies, and transform UMLS data into RDF format. The package offers a flexible and powerful interface to work with UMLS content in various formats.

### Key Features:
- Search UMLS terms via the **SearchAPI**.
- Retrieve source concepts, atoms, and hierarchical structures using the **SourceAPI**.
- Fetch semantic type information using **SemanticNetworkAPI**.
- Crosswalk vocabularies using CUIs via **CrosswalkAPI**.
- Transform UMLS JSON data to RDF format for use with semantic web technologies.
- Save API responses to files in structured formats.

