# unity-sps-ogc-processes-api-python-client
This document is an API definition document provided alongside the OGC API - Processes standard. The OGC API - Processes Standard specifies a processing interface to communicate over a RESTful protocol using JavaScript Object Notation (JSON) encodings. The specification allows for the wrapping of computational tasks into executable processes that can be offered by a server and be invoked by a client application.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Generator version: 7.5.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import unity_sps_ogc_processes_api_python_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import unity_sps_ogc_processes_api_python_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import unity_sps_ogc_processes_api_python_client
from unity_sps_ogc_processes_api_python_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = unity_sps_ogc_processes_api_python_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): bearerAuth
configuration = unity_sps_ogc_processes_api_python_client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with unity_sps_ogc_processes_api_python_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = unity_sps_ogc_processes_api_python_client.DefaultApi(api_client)

    try:
        # Information about standards that this API conforms to
        api_response = api_instance.conformance_declaration_conformance_get()
        print("The response of DefaultApi->conformance_declaration_conformance_get:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->conformance_declaration_conformance_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**conformance_declaration_conformance_get**](docs/DefaultApi.md#conformance_declaration_conformance_get) | **GET** /conformance | Information about standards that this API conforms to
*DefaultApi* | [**deploy_process_processes_post**](docs/DefaultApi.md#deploy_process_processes_post) | **POST** /processes | Deploy a process
*DefaultApi* | [**dismiss_jobs_job_id_delete**](docs/DefaultApi.md#dismiss_jobs_job_id_delete) | **DELETE** /jobs/{job_id} | Cancel a job execution, remove a finished job
*DefaultApi* | [**execute_processes_process_id_execution_post**](docs/DefaultApi.md#execute_processes_process_id_execution_post) | **POST** /processes/{process_id}/execution | Execute a process
*DefaultApi* | [**get_health_health_get**](docs/DefaultApi.md#get_health_health_get) | **GET** /health | Perform a Health Check
*DefaultApi* | [**job_list_jobs_get**](docs/DefaultApi.md#job_list_jobs_get) | **GET** /jobs | Retrieve the list of jobs
*DefaultApi* | [**landing_page_get**](docs/DefaultApi.md#landing_page_get) | **GET** / | Landing page of this API
*DefaultApi* | [**process_description_processes_process_id_get**](docs/DefaultApi.md#process_description_processes_process_id_get) | **GET** /processes/{process_id} | Retrieve a process description
*DefaultApi* | [**process_list_processes_get**](docs/DefaultApi.md#process_list_processes_get) | **GET** /processes | Retrieve the list of available processes
*DefaultApi* | [**results_jobs_job_id_results_get**](docs/DefaultApi.md#results_jobs_job_id_results_get) | **GET** /jobs/{job_id}/results | Retrieve the result(s) of a job
*DefaultApi* | [**status_jobs_job_id_get**](docs/DefaultApi.md#status_jobs_job_id_get) | **GET** /jobs/{job_id} | Retrieve the status of a job
*DefaultApi* | [**undeploy_process_processes_process_id_delete**](docs/DefaultApi.md#undeploy_process_processes_process_id_delete) | **DELETE** /processes/{process_id} | Undeploy a process


## Documentation For Models

 - [Bbox](docs/Bbox.md)
 - [ConfClasses](docs/ConfClasses.md)
 - [Crs](docs/Crs.md)
 - [Crs5](docs/Crs5.md)
 - [Exception](docs/Exception.md)
 - [Execute](docs/Execute.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [HealthCheck](docs/HealthCheck.md)
 - [InputValueInput](docs/InputValueInput.md)
 - [InputValueNoObjectInput](docs/InputValueNoObjectInput.md)
 - [InputValueNoObjectOutput](docs/InputValueNoObjectOutput.md)
 - [InputValueOutput](docs/InputValueOutput.md)
 - [JobControlOptions](docs/JobControlOptions.md)
 - [JobList](docs/JobList.md)
 - [LandingPage](docs/LandingPage.md)
 - [Link](docs/Link.md)
 - [Metadata](docs/Metadata.md)
 - [Metadata1](docs/Metadata1.md)
 - [Metadata2](docs/Metadata2.md)
 - [ProcessInput](docs/ProcessInput.md)
 - [ProcessList](docs/ProcessList.md)
 - [ProcessOutput](docs/ProcessOutput.md)
 - [ProcessSummary](docs/ProcessSummary.md)
 - [StatusCode](docs/StatusCode.md)
 - [StatusInfo](docs/StatusInfo.md)
 - [Subscriber](docs/Subscriber.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)
 - [Value](docs/Value.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="bearerAuth"></a>
### bearerAuth

- **Type**: Bearer authentication (JWT)


## Author
