# coding: utf-8

"""
    Unity Processing API conforming to the Draft of OGC API - Processes - Part 2: Deploy, Replace, Undeploy

    This document is an API definition document provided alongside the OGC API - Processes standard. The OGC API - Processes Standard specifies a processing interface to communicate over a RESTful protocol using JavaScript Object Notation (JSON) encodings. The specification allows for the wrapping of computational tasks into executable processes that can be offered by a server and be invoked by a client application.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field
from typing_extensions import Self

from unity_sps_ogc_processes_api_python_client.models.cpumax import Cpumax
from unity_sps_ogc_processes_api_python_client.models.cpumin import Cpumin
from unity_sps_ogc_processes_api_python_client.models.jobtimeout import Jobtimeout
from unity_sps_ogc_processes_api_python_client.models.memorymax import Memorymax
from unity_sps_ogc_processes_api_python_client.models.memorymin import Memorymin
from unity_sps_ogc_processes_api_python_client.models.storageoutputsmin import (
    Storageoutputsmin,
)
from unity_sps_ogc_processes_api_python_client.models.storagetempmin import (
    Storagetempmin,
)


class ExecutionUnitConfig(BaseModel):
    """
    Hardware requirements and configuration properties for executing the process.
    """  # noqa: E501

    additional_properties: Optional[Dict[str, Any]] = None
    cpu_max: Optional[Cpumax] = Field(default=None, alias="cpuMax")
    cpu_min: Optional[Cpumin] = Field(default=None, alias="cpuMin")
    job_timeout: Optional[Jobtimeout] = Field(default=None, alias="jobTimeout")
    memory_max: Optional[Memorymax] = Field(default=None, alias="memoryMax")
    memory_min: Optional[Memorymin] = Field(default=None, alias="memoryMin")
    storage_outputs_min: Optional[Storageoutputsmin] = Field(
        default=None, alias="storageOutputsMin"
    )
    storage_temp_min: Optional[Storagetempmin] = Field(
        default=None, alias="storageTempMin"
    )
    __properties: ClassVar[List[str]] = [
        "additional_properties",
        "cpuMax",
        "cpuMin",
        "jobTimeout",
        "memoryMax",
        "memoryMin",
        "storageOutputsMin",
        "storageTempMin",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExecutionUnitConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cpu_max
        if self.cpu_max:
            _dict["cpuMax"] = self.cpu_max.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cpu_min
        if self.cpu_min:
            _dict["cpuMin"] = self.cpu_min.to_dict()
        # override the default output from pydantic by calling `to_dict()` of job_timeout
        if self.job_timeout:
            _dict["jobTimeout"] = self.job_timeout.to_dict()
        # override the default output from pydantic by calling `to_dict()` of memory_max
        if self.memory_max:
            _dict["memoryMax"] = self.memory_max.to_dict()
        # override the default output from pydantic by calling `to_dict()` of memory_min
        if self.memory_min:
            _dict["memoryMin"] = self.memory_min.to_dict()
        # override the default output from pydantic by calling `to_dict()` of storage_outputs_min
        if self.storage_outputs_min:
            _dict["storageOutputsMin"] = self.storage_outputs_min.to_dict()
        # override the default output from pydantic by calling `to_dict()` of storage_temp_min
        if self.storage_temp_min:
            _dict["storageTempMin"] = self.storage_temp_min.to_dict()
        # set to None if cpu_max (nullable) is None
        # and model_fields_set contains the field
        if self.cpu_max is None and "cpu_max" in self.model_fields_set:
            _dict["cpuMax"] = None

        # set to None if cpu_min (nullable) is None
        # and model_fields_set contains the field
        if self.cpu_min is None and "cpu_min" in self.model_fields_set:
            _dict["cpuMin"] = None

        # set to None if job_timeout (nullable) is None
        # and model_fields_set contains the field
        if self.job_timeout is None and "job_timeout" in self.model_fields_set:
            _dict["jobTimeout"] = None

        # set to None if memory_max (nullable) is None
        # and model_fields_set contains the field
        if self.memory_max is None and "memory_max" in self.model_fields_set:
            _dict["memoryMax"] = None

        # set to None if memory_min (nullable) is None
        # and model_fields_set contains the field
        if self.memory_min is None and "memory_min" in self.model_fields_set:
            _dict["memoryMin"] = None

        # set to None if storage_outputs_min (nullable) is None
        # and model_fields_set contains the field
        if (
            self.storage_outputs_min is None
            and "storage_outputs_min" in self.model_fields_set
        ):
            _dict["storageOutputsMin"] = None

        # set to None if storage_temp_min (nullable) is None
        # and model_fields_set contains the field
        if (
            self.storage_temp_min is None
            and "storage_temp_min" in self.model_fields_set
        ):
            _dict["storageTempMin"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExecutionUnitConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "additional_properties": obj.get("additional_properties"),
                "cpuMax": (
                    Cpumax.from_dict(obj["cpuMax"])
                    if obj.get("cpuMax") is not None
                    else None
                ),
                "cpuMin": (
                    Cpumin.from_dict(obj["cpuMin"])
                    if obj.get("cpuMin") is not None
                    else None
                ),
                "jobTimeout": (
                    Jobtimeout.from_dict(obj["jobTimeout"])
                    if obj.get("jobTimeout") is not None
                    else None
                ),
                "memoryMax": (
                    Memorymax.from_dict(obj["memoryMax"])
                    if obj.get("memoryMax") is not None
                    else None
                ),
                "memoryMin": (
                    Memorymin.from_dict(obj["memoryMin"])
                    if obj.get("memoryMin") is not None
                    else None
                ),
                "storageOutputsMin": (
                    Storageoutputsmin.from_dict(obj["storageOutputsMin"])
                    if obj.get("storageOutputsMin") is not None
                    else None
                ),
                "storageTempMin": (
                    Storagetempmin.from_dict(obj["storageTempMin"])
                    if obj.get("storageTempMin") is not None
                    else None
                ),
            }
        )
        return _obj
