# coding: utf-8

"""
    Unity Processing API conforming to the Draft of OGC API - Processes - Part 2: Deploy, Replace, Undeploy

    This document is an API definition document provided alongside the OGC API - Processes standard. The OGC API - Processes Standard specifies a processing interface to communicate over a RESTful protocol using JavaScript Object Notation (JSON) encodings. The specification allows for the wrapping of computational tasks into executable processes that can be offered by a server and be invoked by a client application.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import TYPE_CHECKING, Any, Dict, Optional, Set, Union

from pydantic import BaseModel, ValidationError, field_validator
from typing_extensions import Self

from unity_sps_ogc_processes_api_python_client.models.metadata_one_of import (
    MetadataOneOf,
)
from unity_sps_ogc_processes_api_python_client.models.metadata_one_of1 import (
    MetadataOneOf1,
)

METADATAINPUT_ANY_OF_SCHEMAS = ["MetadataOneOf", "MetadataOneOf1"]


class MetadataInput(BaseModel):
    """
    MetadataInput
    """

    # data type: MetadataOneOf
    anyof_schema_1_validator: Optional[MetadataOneOf] = None
    # data type: MetadataOneOf1
    anyof_schema_2_validator: Optional[MetadataOneOf1] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[MetadataOneOf, MetadataOneOf1]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = {"MetadataOneOf", "MetadataOneOf1"}

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError(
                    "If a position argument is used, only 1 is allowed to set `actual_instance`"
                )
            if kwargs:
                raise ValueError(
                    "If a position argument is used, keyword arguments cannot be used."
                )
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator("actual_instance")
    def actual_instance_must_validate_anyof(cls, v):
        MetadataInput.model_construct()
        error_messages = []
        # validate data type: MetadataOneOf
        if not isinstance(v, MetadataOneOf):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `MetadataOneOf`"
            )
        else:
            return v

        # validate data type: MetadataOneOf1
        if not isinstance(v, MetadataOneOf1):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `MetadataOneOf1`"
            )
        else:
            return v

        if error_messages:
            # no match
            raise ValueError(
                "No match found when setting the actual_instance in MetadataInput with anyOf schemas: MetadataOneOf, MetadataOneOf1. Details: "
                + ", ".join(error_messages)
            )
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[MetadataOneOf] = None
        try:
            instance.actual_instance = MetadataOneOf.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[MetadataOneOf1] = None
        try:
            instance.actual_instance = MetadataOneOf1.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError(
                "No match found when deserializing the JSON string into MetadataInput with anyOf schemas: MetadataOneOf, MetadataOneOf1. Details: "
                + ", ".join(error_messages)
            )
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(
            self.actual_instance.to_json
        ):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], MetadataOneOf, MetadataOneOf1]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(
            self.actual_instance.to_dict
        ):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())
