# coding: utf-8

"""
    Unity Processing API conforming to the OGC API - Processes - Part 1 standard

    This document is an API definition document provided alongside the OGC API - Processes standard. The OGC API - Processes Standard specifies a processing interface to communicate over a RESTful protocol using JavaScript Object Notation (JSON) encodings. The specification allows for the wrapping of computational tasks into executable processes that can be offered by a server and be invoked by a client application.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict
from typing_extensions import Self

from unity_sps_ogc_processes_api_python_client.models.subscriber import Subscriber


class Execute(BaseModel):
    """
    Execute
    """  # noqa: E501

    inputs: Optional[Any] = None
    outputs: Optional[Any] = None
    subscriber: Optional[Subscriber] = None
    __properties: ClassVar[List[str]] = ["inputs", "outputs", "subscriber"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Execute from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of inputs
        if self.inputs:
            _dict["inputs"] = self.inputs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of outputs
        if self.outputs:
            _dict["outputs"] = self.outputs.to_dict()
        # override the default output from pydantic by calling `to_dict()` of subscriber
        if self.subscriber:
            _dict["subscriber"] = self.subscriber.to_dict()
        # set to None if inputs (nullable) is None
        # and model_fields_set contains the field
        if self.inputs is None and "inputs" in self.model_fields_set:
            _dict["inputs"] = None

        # set to None if outputs (nullable) is None
        # and model_fields_set contains the field
        if self.outputs is None and "outputs" in self.model_fields_set:
            _dict["outputs"] = None

        # set to None if subscriber (nullable) is None
        # and model_fields_set contains the field
        if self.subscriber is None and "subscriber" in self.model_fields_set:
            _dict["subscriber"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Execute from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "inputs": (
                    AnyOf.from_dict(obj["inputs"])  # noqa: F821
                    if obj.get("inputs") is not None
                    else None
                ),
                "outputs": (
                    AnyOf.from_dict(obj["outputs"])  # noqa: F821
                    if obj.get("outputs") is not None
                    else None
                ),
                "subscriber": (
                    Subscriber.from_dict(obj["subscriber"])
                    if obj.get("subscriber") is not None
                    else None
                ),
            }
        )
        return _obj
