# coding: utf-8

"""
    DNS Configuration API

    The DNS application is a Universal DDI service that provides cloud-based DNS configuration with on-prem host serving DNS protocol. It is part of the full-featured Universal DDI solution that enables customers the ability to deploy large numbers of protocol servers in the delivery of DNS and DHCP throughout their enterprise network.   

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from dns_config.models.dtc_policy import DTCPolicy
from dns_config.models.ttl_inheritance import TTLInheritance
from typing import Optional, Set
from typing_extensions import Self


class LBDN(BaseModel):
    """
    A LBDN (_dtc/lbdn_) represents a load-balanced domain name
    """ # noqa: E501
    comment: Optional[StrictStr] = Field(
        default=None, description="Optional. Comment for __LBDN__.")
    disabled: Optional[StrictBool] = Field(
        default=None,
        description=
        "Optional. _true_ to disable object. A disabled object is effectively non-existent when generating configuration."
    )
    dtc_policy: Optional[DTCPolicy] = Field(
        default=None, description="Optional. __DTC Policy__ information.")
    id: Optional[StrictStr] = Field(default=None,
                                    description="The resource identifier.")
    inheritance_sources: Optional[TTLInheritance] = Field(
        default=None, description="Optional. The inheritance configuration.")
    name: StrictStr = Field(description="Name of __LBDN__.")
    precedence: Optional[StrictInt] = Field(
        default=None, description="Optional. Precedence.")
    tags: Optional[Dict[str, Any]] = Field(
        default=None,
        description="Optional. The tags for __LBDN__ in JSON format.")
    ttl: Optional[StrictInt] = Field(
        default=None,
        description=
        "Optional. Time to live value (in seconds) to be used for records in DTC response. Unsigned integer, min: 0, max 2147483647 (31-bits per RFC-2181)."
    )
    view: StrictStr = Field(description="The resource identifier.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "comment", "disabled", "dtc_policy", "id", "inheritance_sources",
        "name", "precedence", "tags", "ttl", "view"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LBDN from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "id",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of dtc_policy
        if self.dtc_policy:
            _dict['dtc_policy'] = self.dtc_policy.to_dict()
        # override the default output from pydantic by calling `to_dict()` of inheritance_sources
        if self.inheritance_sources:
            _dict['inheritance_sources'] = self.inheritance_sources.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LBDN from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "comment":
            obj.get("comment"),
            "disabled":
            obj.get("disabled"),
            "dtc_policy":
            DTCPolicy.from_dict(obj["dtc_policy"])
            if obj.get("dtc_policy") is not None else None,
            "id":
            obj.get("id"),
            "inheritance_sources":
            TTLInheritance.from_dict(obj["inheritance_sources"])
            if obj.get("inheritance_sources") is not None else None,
            "name":
            obj.get("name"),
            "precedence":
            obj.get("precedence"),
            "tags":
            obj.get("tags"),
            "ttl":
            obj.get("ttl"),
            "view":
            obj.get("view")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
