# coding: utf-8

"""
    DNS Configuration API

    The DNS application is a Universal DDI service that provides cloud-based DNS configuration with on-prem host serving DNS protocol. It is part of the full-featured Universal DDI solution that enables customers the ability to deploy large numbers of protocol servers in the delivery of DNS and DHCP throughout their enterprise network.   

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from dns_config.models.inheritance2_inherited_bool import Inheritance2InheritedBool
from dns_config.models.inheritance2_inherited_string import Inheritance2InheritedString
from dns_config.models.inheritance2_inherited_u_int32 import Inheritance2InheritedUInt32
from dns_config.models.inherited_acl_items import InheritedACLItems
from dns_config.models.inherited_custom_root_ns_block import InheritedCustomRootNSBlock
from dns_config.models.inherited_dnssec_validation_block import InheritedDNSSECValidationBlock
from dns_config.models.inherited_ecs_block import InheritedECSBlock
from dns_config.models.inherited_forwarders_block import InheritedForwardersBlock
from dns_config.models.inherited_kerberos_keys import InheritedKerberosKeys
from dns_config.models.inherited_sort_list_items import InheritedSortListItems
from typing import Optional, Set
from typing_extensions import Self


class ServerInheritance(BaseModel):
    """
    Inheritance configuration specifies how and which fields _Server_ object inherits from _Global_ parent.
    """ # noqa: E501
    add_edns_option_in_outgoing_query: Optional[
        Inheritance2InheritedBool] = Field(
            default=None,
            description=
            "Field config for _add_edns_option_in_outgoing_query_ field from _Server_ object."
        )
    custom_root_ns_block: Optional[InheritedCustomRootNSBlock] = Field(
        default=None,
        description=
        "Optional. Field config for _custom_root_ns_block_ field from _Server_ object."
    )
    dnssec_validation_block: Optional[InheritedDNSSECValidationBlock] = Field(
        default=None,
        description=
        "Optional. Field config for _dnssec_validation_block_ field from _Server_ object."
    )
    ecs_block: Optional[InheritedECSBlock] = Field(
        default=None,
        description=
        "Optional. Field config for _ecs_block_ field from _Server_ object.")
    filter_aaaa_acl: Optional[InheritedACLItems] = Field(
        default=None,
        description=
        "Optional. Field config for _filter_aaaa_acl_ field from _Server_ object."
    )
    filter_aaaa_on_v4: Optional[Inheritance2InheritedString] = Field(
        default=None,
        description=
        "Optional. Field config for _filter_aaaa_on_v4_ field from _Server_ object."
    )
    forwarders_block: Optional[InheritedForwardersBlock] = Field(
        default=None,
        description=
        "Optional. Field config for _forwarders_block_ field from _Server_ object."
    )
    gss_tsig_enabled: Optional[Inheritance2InheritedBool] = Field(
        default=None,
        description=
        "Optional. Field config for _gss_tsig_enabled_ field from _Server_ object."
    )
    kerberos_keys: Optional[InheritedKerberosKeys] = Field(
        default=None,
        description=
        "Optional. Field config for _kerberos_keys_ field from _Server_ object."
    )
    lame_ttl: Optional[Inheritance2InheritedUInt32] = Field(
        default=None,
        description=
        "Optional. Field config for _lame_ttl_ field from _Server_ object.")
    log_query_response: Optional[Inheritance2InheritedBool] = Field(
        default=None,
        description=
        "Optional. Field config for _log_queries_response_ field from _Server_ object."
    )
    match_recursive_only: Optional[Inheritance2InheritedBool] = Field(
        default=None,
        description=
        "Optional. Field config for _match_recursive_only_ field from _Server_ object."
    )
    max_cache_ttl: Optional[Inheritance2InheritedUInt32] = Field(
        default=None,
        description=
        "Optional. Field config for _max_cache_ttl_ field from _Server_ object."
    )
    max_negative_ttl: Optional[Inheritance2InheritedUInt32] = Field(
        default=None,
        description=
        "Optional. Field config for _max_negative_ttl_ field from _Server_ object."
    )
    minimal_responses: Optional[Inheritance2InheritedBool] = Field(
        default=None,
        description=
        "Optional. Field config for _minimal_responses_ field from _Server_ object."
    )
    notify: Optional[Inheritance2InheritedBool] = Field(
        default=None,
        description="Field config for _notify_ field from _Server_ object.")
    query_acl: Optional[InheritedACLItems] = Field(
        default=None,
        description=
        "Optional. Field config for _query_acl_ field from _Server_ object.")
    query_port: Optional[Inheritance2InheritedUInt32] = Field(
        default=None,
        description=
        "Optional. Field config for _query_port_ field from _Server_ object.")
    recursion_acl: Optional[InheritedACLItems] = Field(
        default=None,
        description=
        "Optional. Field config for _recursion_acl_ field from _Server_ object."
    )
    recursion_enabled: Optional[Inheritance2InheritedBool] = Field(
        default=None,
        description=
        "Optional. Field config for _recursion_enabled_ field from _Server_ object."
    )
    recursive_clients: Optional[Inheritance2InheritedUInt32] = Field(
        default=None,
        description=
        "Optional. Field config for _recursive_clients_ field from _Server_ object."
    )
    resolver_query_timeout: Optional[Inheritance2InheritedUInt32] = Field(
        default=None,
        description=
        "Optional. Field config for _resolver_query_timeout_ field from _Server_ object."
    )
    secondary_axfr_query_limit: Optional[Inheritance2InheritedUInt32] = Field(
        default=None,
        description=
        "Optional. Field config for _secondary_axfr_query_limit_ field from _Server_ object."
    )
    secondary_soa_query_limit: Optional[Inheritance2InheritedUInt32] = Field(
        default=None,
        description=
        "Optional. Field config for _secondary_soa_query_limit_ field from _Server_ object."
    )
    sort_list: Optional[InheritedSortListItems] = Field(
        default=None,
        description=
        "Optional. Field config for _sort_list_ field from _Server object.")
    synthesize_address_records_from_https: Optional[
        Inheritance2InheritedBool] = Field(
            default=None,
            description=
            "Field config for _synthesize_address_records_from_https_ field from _Server_ object."
        )
    transfer_acl: Optional[InheritedACLItems] = Field(
        default=None,
        description=
        "Optional. Field config for _transfer_acl_ field from _Server_ object."
    )
    update_acl: Optional[InheritedACLItems] = Field(
        default=None,
        description=
        "Optional. Field config for _update_acl_ field from _Server_ object.")
    use_forwarders_for_subzones: Optional[Inheritance2InheritedBool] = Field(
        default=None,
        description=
        "Optional. Field config for _use_forwarders_for_subzones_ field from _Server_ object."
    )
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "add_edns_option_in_outgoing_query", "custom_root_ns_block",
        "dnssec_validation_block", "ecs_block", "filter_aaaa_acl",
        "filter_aaaa_on_v4", "forwarders_block", "gss_tsig_enabled",
        "kerberos_keys", "lame_ttl", "log_query_response",
        "match_recursive_only", "max_cache_ttl", "max_negative_ttl",
        "minimal_responses", "notify", "query_acl", "query_port",
        "recursion_acl", "recursion_enabled", "recursive_clients",
        "resolver_query_timeout", "secondary_axfr_query_limit",
        "secondary_soa_query_limit", "sort_list",
        "synthesize_address_records_from_https", "transfer_acl", "update_acl",
        "use_forwarders_for_subzones"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ServerInheritance from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of add_edns_option_in_outgoing_query
        if self.add_edns_option_in_outgoing_query:
            _dict[
                'add_edns_option_in_outgoing_query'] = self.add_edns_option_in_outgoing_query.to_dict(
                )
        # override the default output from pydantic by calling `to_dict()` of custom_root_ns_block
        if self.custom_root_ns_block:
            _dict['custom_root_ns_block'] = self.custom_root_ns_block.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dnssec_validation_block
        if self.dnssec_validation_block:
            _dict[
                'dnssec_validation_block'] = self.dnssec_validation_block.to_dict(
                )
        # override the default output from pydantic by calling `to_dict()` of ecs_block
        if self.ecs_block:
            _dict['ecs_block'] = self.ecs_block.to_dict()
        # override the default output from pydantic by calling `to_dict()` of filter_aaaa_acl
        if self.filter_aaaa_acl:
            _dict['filter_aaaa_acl'] = self.filter_aaaa_acl.to_dict()
        # override the default output from pydantic by calling `to_dict()` of filter_aaaa_on_v4
        if self.filter_aaaa_on_v4:
            _dict['filter_aaaa_on_v4'] = self.filter_aaaa_on_v4.to_dict()
        # override the default output from pydantic by calling `to_dict()` of forwarders_block
        if self.forwarders_block:
            _dict['forwarders_block'] = self.forwarders_block.to_dict()
        # override the default output from pydantic by calling `to_dict()` of gss_tsig_enabled
        if self.gss_tsig_enabled:
            _dict['gss_tsig_enabled'] = self.gss_tsig_enabled.to_dict()
        # override the default output from pydantic by calling `to_dict()` of kerberos_keys
        if self.kerberos_keys:
            _dict['kerberos_keys'] = self.kerberos_keys.to_dict()
        # override the default output from pydantic by calling `to_dict()` of lame_ttl
        if self.lame_ttl:
            _dict['lame_ttl'] = self.lame_ttl.to_dict()
        # override the default output from pydantic by calling `to_dict()` of log_query_response
        if self.log_query_response:
            _dict['log_query_response'] = self.log_query_response.to_dict()
        # override the default output from pydantic by calling `to_dict()` of match_recursive_only
        if self.match_recursive_only:
            _dict['match_recursive_only'] = self.match_recursive_only.to_dict()
        # override the default output from pydantic by calling `to_dict()` of max_cache_ttl
        if self.max_cache_ttl:
            _dict['max_cache_ttl'] = self.max_cache_ttl.to_dict()
        # override the default output from pydantic by calling `to_dict()` of max_negative_ttl
        if self.max_negative_ttl:
            _dict['max_negative_ttl'] = self.max_negative_ttl.to_dict()
        # override the default output from pydantic by calling `to_dict()` of minimal_responses
        if self.minimal_responses:
            _dict['minimal_responses'] = self.minimal_responses.to_dict()
        # override the default output from pydantic by calling `to_dict()` of notify
        if self.notify:
            _dict['notify'] = self.notify.to_dict()
        # override the default output from pydantic by calling `to_dict()` of query_acl
        if self.query_acl:
            _dict['query_acl'] = self.query_acl.to_dict()
        # override the default output from pydantic by calling `to_dict()` of query_port
        if self.query_port:
            _dict['query_port'] = self.query_port.to_dict()
        # override the default output from pydantic by calling `to_dict()` of recursion_acl
        if self.recursion_acl:
            _dict['recursion_acl'] = self.recursion_acl.to_dict()
        # override the default output from pydantic by calling `to_dict()` of recursion_enabled
        if self.recursion_enabled:
            _dict['recursion_enabled'] = self.recursion_enabled.to_dict()
        # override the default output from pydantic by calling `to_dict()` of recursive_clients
        if self.recursive_clients:
            _dict['recursive_clients'] = self.recursive_clients.to_dict()
        # override the default output from pydantic by calling `to_dict()` of resolver_query_timeout
        if self.resolver_query_timeout:
            _dict[
                'resolver_query_timeout'] = self.resolver_query_timeout.to_dict(
                )
        # override the default output from pydantic by calling `to_dict()` of secondary_axfr_query_limit
        if self.secondary_axfr_query_limit:
            _dict[
                'secondary_axfr_query_limit'] = self.secondary_axfr_query_limit.to_dict(
                )
        # override the default output from pydantic by calling `to_dict()` of secondary_soa_query_limit
        if self.secondary_soa_query_limit:
            _dict[
                'secondary_soa_query_limit'] = self.secondary_soa_query_limit.to_dict(
                )
        # override the default output from pydantic by calling `to_dict()` of sort_list
        if self.sort_list:
            _dict['sort_list'] = self.sort_list.to_dict()
        # override the default output from pydantic by calling `to_dict()` of synthesize_address_records_from_https
        if self.synthesize_address_records_from_https:
            _dict[
                'synthesize_address_records_from_https'] = self.synthesize_address_records_from_https.to_dict(
                )
        # override the default output from pydantic by calling `to_dict()` of transfer_acl
        if self.transfer_acl:
            _dict['transfer_acl'] = self.transfer_acl.to_dict()
        # override the default output from pydantic by calling `to_dict()` of update_acl
        if self.update_acl:
            _dict['update_acl'] = self.update_acl.to_dict()
        # override the default output from pydantic by calling `to_dict()` of use_forwarders_for_subzones
        if self.use_forwarders_for_subzones:
            _dict[
                'use_forwarders_for_subzones'] = self.use_forwarders_for_subzones.to_dict(
                )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ServerInheritance from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "add_edns_option_in_outgoing_query":
            Inheritance2InheritedBool.from_dict(
                obj["add_edns_option_in_outgoing_query"]) if
            obj.get("add_edns_option_in_outgoing_query") is not None else None,
            "custom_root_ns_block":
            InheritedCustomRootNSBlock.from_dict(obj["custom_root_ns_block"])
            if obj.get("custom_root_ns_block") is not None else None,
            "dnssec_validation_block":
            InheritedDNSSECValidationBlock.from_dict(
                obj["dnssec_validation_block"])
            if obj.get("dnssec_validation_block") is not None else None,
            "ecs_block":
            InheritedECSBlock.from_dict(obj["ecs_block"])
            if obj.get("ecs_block") is not None else None,
            "filter_aaaa_acl":
            InheritedACLItems.from_dict(obj["filter_aaaa_acl"])
            if obj.get("filter_aaaa_acl") is not None else None,
            "filter_aaaa_on_v4":
            Inheritance2InheritedString.from_dict(obj["filter_aaaa_on_v4"])
            if obj.get("filter_aaaa_on_v4") is not None else None,
            "forwarders_block":
            InheritedForwardersBlock.from_dict(obj["forwarders_block"])
            if obj.get("forwarders_block") is not None else None,
            "gss_tsig_enabled":
            Inheritance2InheritedBool.from_dict(obj["gss_tsig_enabled"])
            if obj.get("gss_tsig_enabled") is not None else None,
            "kerberos_keys":
            InheritedKerberosKeys.from_dict(obj["kerberos_keys"])
            if obj.get("kerberos_keys") is not None else None,
            "lame_ttl":
            Inheritance2InheritedUInt32.from_dict(obj["lame_ttl"])
            if obj.get("lame_ttl") is not None else None,
            "log_query_response":
            Inheritance2InheritedBool.from_dict(obj["log_query_response"])
            if obj.get("log_query_response") is not None else None,
            "match_recursive_only":
            Inheritance2InheritedBool.from_dict(obj["match_recursive_only"])
            if obj.get("match_recursive_only") is not None else None,
            "max_cache_ttl":
            Inheritance2InheritedUInt32.from_dict(obj["max_cache_ttl"])
            if obj.get("max_cache_ttl") is not None else None,
            "max_negative_ttl":
            Inheritance2InheritedUInt32.from_dict(obj["max_negative_ttl"])
            if obj.get("max_negative_ttl") is not None else None,
            "minimal_responses":
            Inheritance2InheritedBool.from_dict(obj["minimal_responses"])
            if obj.get("minimal_responses") is not None else None,
            "notify":
            Inheritance2InheritedBool.from_dict(obj["notify"])
            if obj.get("notify") is not None else None,
            "query_acl":
            InheritedACLItems.from_dict(obj["query_acl"])
            if obj.get("query_acl") is not None else None,
            "query_port":
            Inheritance2InheritedUInt32.from_dict(obj["query_port"])
            if obj.get("query_port") is not None else None,
            "recursion_acl":
            InheritedACLItems.from_dict(obj["recursion_acl"])
            if obj.get("recursion_acl") is not None else None,
            "recursion_enabled":
            Inheritance2InheritedBool.from_dict(obj["recursion_enabled"])
            if obj.get("recursion_enabled") is not None else None,
            "recursive_clients":
            Inheritance2InheritedUInt32.from_dict(obj["recursive_clients"])
            if obj.get("recursive_clients") is not None else None,
            "resolver_query_timeout":
            Inheritance2InheritedUInt32.from_dict(
                obj["resolver_query_timeout"])
            if obj.get("resolver_query_timeout") is not None else None,
            "secondary_axfr_query_limit":
            Inheritance2InheritedUInt32.from_dict(
                obj["secondary_axfr_query_limit"])
            if obj.get("secondary_axfr_query_limit") is not None else None,
            "secondary_soa_query_limit":
            Inheritance2InheritedUInt32.from_dict(
                obj["secondary_soa_query_limit"])
            if obj.get("secondary_soa_query_limit") is not None else None,
            "sort_list":
            InheritedSortListItems.from_dict(obj["sort_list"])
            if obj.get("sort_list") is not None else None,
            "synthesize_address_records_from_https":
            Inheritance2InheritedBool.from_dict(
                obj["synthesize_address_records_from_https"])
            if obj.get("synthesize_address_records_from_https") is not None
            else None,
            "transfer_acl":
            InheritedACLItems.from_dict(obj["transfer_acl"])
            if obj.get("transfer_acl") is not None else None,
            "update_acl":
            InheritedACLItems.from_dict(obj["update_acl"])
            if obj.get("update_acl") is not None else None,
            "use_forwarders_for_subzones":
            Inheritance2InheritedBool.from_dict(
                obj["use_forwarders_for_subzones"])
            if obj.get("use_forwarders_for_subzones") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
