# coding: utf-8

"""
    Infoblox FW API

    Infoblox Threat Defense Cloud is an extension of the Infoblox Suite that provides visibility into infected and compromised off-premises devices, roaming users, remote sites, and branch offices. You can subscribe to Infoblox Cloud and use its functionality to mitigate and control malware as well as provide unprecedented insight into your network security posture and enable timely action. Infoblox Cloud also offers unified policy management, reporting, and threat analytics across the entire spectrum. Using automated and high-quality threat intelligence feeds and unique behavioral analytics, it automatically stops device communications with C&Cs/botnets and prevents DNS based data exfiltration.  The mission-critical DNS infrastructure can become a vulnerable component in your network when it is inadequately protected by traditional security solutions and consequently used as an attack surface. Compromised DNS services can result in catastrophic network and system failures. To fully protect your network in today’s cyber security threat environment, Infoblox sets a new DNS security standard by offering scalable, enterprise-grade, and integrated protection for your DNS infrastructure.  Through the Infoblox Cloud Services Portal, you can view the status of your subscription and threat intelligence feeds, manage your network scope and roaming end users, and learn more about threats on your networks through the Infoblox Threat Lookup tool and predefined reports. 

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import unittest

from fw.api.named_lists_api import NamedListsApi

from universal_ddi_client.api_client import ApiClient


class TestNamedListsApi(unittest.TestCase):
    """NamedListsApi unit test stubs"""

    def setUp(self) -> None:
        api_instance = ApiClient()
        self.api = NamedListsApi(api_instance)

    def tearDown(self) -> None:
        pass

    def test_create_named_list(self) -> None:
        """Test case for create_named_list

        Create Named List.
        """
        pass

    def test_delete_named_lists(self) -> None:
        """Test case for delete_named_lists

        Delete Named Lists.
        """
        pass

    def test_delete_single_named_lists(self) -> None:
        """Test case for delete_single_named_lists

        Delete Named Lists.
        """
        pass

    def test_list_named_lists(self) -> None:
        """Test case for list_named_lists

        List Named Lists.
        """
        pass

    def test_list_named_lists_csv(self) -> None:
        """Test case for list_named_lists_csv

        List Named Lists in CSV format.
        """
        pass

    def test_multi_list_update(self) -> None:
        """Test case for multi_list_update

        Patch Multiple Named Lists.
        """
        pass

    def test_read_named_list(self) -> None:
        """Test case for read_named_list

        Read Named List.
        """
        pass

    def test_update_named_list(self) -> None:
        """Test case for update_named_list

        Update Named List.
        """
        pass

    def test_update_named_list_partial(self) -> None:
        """Test case for update_named_list_partial

        Patch TI List.
        """
        pass


if __name__ == '__main__':
    unittest.main()
