# coding: utf-8

"""
    Infrastructure Management API

    The **Infrastructure Management API** provides a RESTful interface to manage Infrastructure Hosts and Services objects.  The following is a list of the different Services and their string types (the string types are to be used with the APIs for the `service_type` field):  | Service name | Service type |   | ------ | ------ |   | Access Authentication | authn |   | Anycast | anycast |   | Data Connector | cdc |   | DHCP | dhcp |   | DNS | dns |   | DNS Forwarding Proxy | dfp |   | NIOS Grid Connector | orpheus |   | MS AD Sync | msad |   | NTP | ntp |   | BGP | bgp |   | RIP | rip |   | OSPF | ospf |    ---   ### Hosts API  The Hosts API is used to manage the Infrastructure Host resources. These include various operations related to hosts such as viewing, creating, updating, replacing, disconnecting, and deleting Hosts. Management of Hosts is done from the Cloud Services Portal (CSP) by navigating to the Manage -> Infrastructure -> Hosts tab.  ---   ### Services API  The Services API is used to manage the Infrastructure Service resources (a.k.a. NIOS-X applications). These include various operations related to hosts such as viewing, creating, updating, starting/stopping, configuring, and deleting Services. Management of Services is done from the Cloud Services Portal (CSP) by navigating to the Manage -> Infrastructure -> Services tab.  ---   ### Detail APIs  The Detail APIs are read-only APIs used to list all the Infrastructure resources (Hosts and Services). Each resource record returned also contains information about its other associated resources and the status information for itself and the associated resource(s) (i.e., Host/Service status).  ---   

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infra_mgmt.models.detail_location import DetailLocation
from infra_mgmt.models.detail_service_host import DetailServiceHost
from infra_mgmt.models.pool_info import PoolInfo
from typing import Optional, Set
from typing_extensions import Self


class DetailService(BaseModel):
    """
    DetailService
    """

  # noqa: E501
    composite_state: Optional[StrictStr] = Field(
        default=None,
        description=
        "Composite State of this Service (`started`, `stopped`, `stopping`, `starting`, `error`)."
    )
    composite_status: Optional[StrictStr] = Field(
        default=None,
        description=
        "Composite Status of this Service (`online`, `stopped`, `degraded`, `error`)."
    )
    created_at: Optional[datetime] = Field(
        default=None, description="Timestamp of creation of Service.")
    current_version: Optional[StrictStr] = Field(
        default=None, description="Current version of this Service.")
    description: Optional[StrictStr] = Field(
        default=None, description="The description of the Service.")
    desired_state: Optional[StrictStr] = Field(
        default=None,
        description=
        "The desired state of the Service (`\"start\"` or `\"stop\"`).")
    desired_version: Optional[StrictStr] = Field(
        default=None, description="The desired version of the Service.")
    hosts: Optional[List[DetailServiceHost]] = Field(
        default=None,
        description="List of Hosts on which this Service is deployed.")
    id: Optional[StrictStr] = Field(default=None,
                                    description="The resource identifier.")
    interface_labels: Optional[List[StrictStr]] = Field(
        default=None,
        description="List of interfaces on which this Service can operate.")
    location: Optional[DetailLocation] = Field(
        default=None,
        description="Location that this Host is associated with.")
    name: Optional[StrictStr] = Field(default=None,
                                      description="The name of the Service.")
    pool: Optional[PoolInfo] = Field(
        default=None,
        description="Pool information for this Service (internal).")
    service_type: Optional[StrictStr] = Field(
        default=None,
        description=
        "The type of the Service deployed on the Host (`dns`, `cdc`, etc.).")
    tags: Optional[Dict[str, Any]] = Field(
        default=None, description="Tags associated with this Service.")
    updated_at: Optional[datetime] = Field(
        default=None, description="Timestamp of the latest update on Service.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "composite_state", "composite_status", "created_at", "current_version",
        "description", "desired_state", "desired_version", "hosts", "id",
        "interface_labels", "location", "name", "pool", "service_type", "tags",
        "updated_at"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DetailService from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "id",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in hosts (list)
        _items = []
        if self.hosts:
            for _item in self.hosts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['hosts'] = _items
        # override the default output from pydantic by calling `to_dict()` of location
        if self.location:
            _dict['location'] = self.location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pool
        if self.pool:
            _dict['pool'] = self.pool.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DetailService from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "composite_state":
            obj.get("composite_state"),
            "composite_status":
            obj.get("composite_status"),
            "created_at":
            obj.get("created_at"),
            "current_version":
            obj.get("current_version"),
            "description":
            obj.get("description"),
            "desired_state":
            obj.get("desired_state"),
            "desired_version":
            obj.get("desired_version"),
            "hosts":
            [DetailServiceHost.from_dict(_item) for _item in obj["hosts"]]
            if obj.get("hosts") is not None else None,
            "id":
            obj.get("id"),
            "interface_labels":
            obj.get("interface_labels"),
            "location":
            DetailLocation.from_dict(obj["location"])
            if obj.get("location") is not None else None,
            "name":
            obj.get("name"),
            "pool":
            PoolInfo.from_dict(obj["pool"])
            if obj.get("pool") is not None else None,
            "service_type":
            obj.get("service_type"),
            "tags":
            obj.get("tags"),
            "updated_at":
            obj.get("updated_at")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
