# coding: utf-8

"""
    IP Address Management API

    The IPAM/DHCP Application is a Universal DDI service providing IP address management and DHCP protocol features. The IPAM component provides visibility into and provisioning tools to manage networking spaces, monitoring and reporting of entire IP address infrastructures, and integration with DNS and DHCP protocols. The DHCP component provides DHCP protocol configuration service with on-prem host serving DHCP protocol. It is part of the full-featured, DDI cloud solution that enables customers to deploy large numbers of protocol servers to deliver DNS and DHCP throughout their enterprise network.

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class Nameserver(BaseModel):
    """
    Nameserver
    """

  # noqa: E501
    client_principal: Optional[StrictStr] = Field(
        default=None,
        description=
        "The Kerberos principal name. It uses the typical Kerberos notation: <SERVICE-NAME>/<server-domain-name>@<REALM>.  Defaults to empty."
    )
    gss_tsig_fallback: Optional[StrictBool] = Field(
        default=None,
        description=
        "The behavior when GSS-TSIG should be used (a matching external DNS server is configured) but no GSS-TSIG key is available. If configured to _false_ (the default) this DNS server is skipped, if configured to _true_ the DNS server is ignored and the DNS update is sent with the configured DHCP-DDNS protection e.g. TSIG key or without any protection when none was configured.  Defaults to _false_."
    )
    kerberos_rekey_interval: Optional[StrictInt] = Field(
        default=None,
        description=
        "Time interval (in seconds) the keys for each configured external DNS server are checked for rekeying, i.e. a new key is created to replace the current usable one when its age is greater than the _kerberos_rekey_interval_ value.  Defaults to 120 seconds."
    )
    kerberos_retry_interval: Optional[StrictInt] = Field(
        default=None,
        description=
        "Time interval (in seconds) to retry to create a key if any error occurred previously for any configured external DNS server.  Defaults to 30 seconds."
    )
    kerberos_tkey_lifetime: Optional[StrictInt] = Field(
        default=None,
        description=
        "Lifetime (in seconds) of GSS-TSIG keys in the TKEY protocol.  Defaults to 160 seconds."
    )
    kerberos_tkey_protocol: Optional[StrictStr] = Field(
        default=None,
        description=
        "Determines which protocol is used to establish the security context with the external DNS servers, TCP or UDP.  Defaults to _tcp_."
    )
    nameserver: Optional[StrictStr] = None
    server_principal: Optional[StrictStr] = Field(
        default=None,
        description=
        "The Kerberos principal name of this DNS server that will receive updates.  Defaults to empty."
    )
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "client_principal", "gss_tsig_fallback", "kerberos_rekey_interval",
        "kerberos_retry_interval", "kerberos_tkey_lifetime",
        "kerberos_tkey_protocol", "nameserver", "server_principal"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Nameserver from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Nameserver from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "client_principal":
            obj.get("client_principal"),
            "gss_tsig_fallback":
            obj.get("gss_tsig_fallback"),
            "kerberos_rekey_interval":
            obj.get("kerberos_rekey_interval"),
            "kerberos_retry_interval":
            obj.get("kerberos_retry_interval"),
            "kerberos_tkey_lifetime":
            obj.get("kerberos_tkey_lifetime"),
            "kerberos_tkey_protocol":
            obj.get("kerberos_tkey_protocol"),
            "nameserver":
            obj.get("nameserver"),
            "server_principal":
            obj.get("server_principal")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
