# coding: utf-8

"""
    Infoblox Redirect API

    You can configure Infoblox Threat Defense Cloud to redirect traffic to the Infoblox server that displays the default or customized redirect page. You can redirect traffic to a custom destination using custom redirects. 

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class CustomRedirect(BaseModel):
    """
    The Custom Redirect object.  You can configure Infoblox Cloud to redirect traffic to the Infoblox redirect page or a custom redirect destination. Infoblox Cloud allows you to apply multiple redirect actions and integrate Infoblox Cloud with third-party proxies, secure web gateways, blackholes, honeypots and sinkhole solutions.
    """ # noqa: E501
    created_time: Optional[datetime] = Field(
        default=None,
        description="The time when this Custom Redirect object was created.")
    data: Optional[StrictStr] = Field(
        default=None,
        description=
        "The list of csv custom IPv4/IPv6 or a single domain redirect address."
    )
    id: Optional[StrictInt] = Field(
        default=None, description="The Custom Redirect object identifier.")
    name: Optional[StrictStr] = Field(
        default=None, description="The name of the custom redirect.")
    policy_ids: Optional[List[StrictInt]] = Field(
        default=None,
        description=
        "The list of the security policy identifiers with which the named list is associated."
    )
    policy_names: Optional[List[StrictStr]] = Field(
        default=None,
        description=
        "The list of the security policy names with which the custom redirect is associated."
    )
    updated_time: Optional[datetime] = Field(
        default=None,
        description=
        "The time when this Custom Redirect object was last updated.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "created_time", "data", "id", "name", "policy_ids", "policy_names",
        "updated_time"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CustomRedirect from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "created_time",
            "id",
            "policy_ids",
            "policy_names",
            "updated_time",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CustomRedirect from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "created_time": obj.get("created_time"),
            "data": obj.get("data"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "policy_ids": obj.get("policy_ids"),
            "policy_names": obj.get("policy_names"),
            "updated_time": obj.get("updated_time")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
