# coding: utf-8

"""
    Universal DDI Anycast API

    Anycast capability enables HA (High Availability) configuration of Universal DDI applications that run on equipment located on customer's premises (on-prem hosts). Anycast supports DNS, as well as DNS-forwarding services.  Anycast-enabled application setups use multiple on-premises installations for one particular application type. Multiple application instances are configured to use the same endpoint address. Anycast capability is collocated with such application instance, monitoring the local application instance and advertising to the upstream router (a customer equipment) a per-instance, local route to the common application endpoint address, as long as the local application instance is available. Depending on the type of the upstream router, the customer may configure local route advertisement via either BGP (Boarder Gateway Protocol) or OSPF (Open Shortest Path First) routing protocols. Both protocols may be enabled as well. Multiple routes to the common application service address provide redundancy without the need to reconfigure application clients.  Should an application instance become unavailable, the local route advertisements stop, resulting in withdrawal of the route (in the upstream router) to the application instance that has gone out of service and ensuring that subsequent application requests thus get routed to the remaining available application instances.  

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import unittest

from anycast.api.on_prem_anycast_manager_api import OnPremAnycastManagerApi

from universal_ddi_client.api_client import ApiClient


class TestOnPremAnycastManagerApi(unittest.TestCase):
    """OnPremAnycastManagerApi unit test stubs"""

    def setUp(self) -> None:
        api_instance = ApiClient()
        self.api = OnPremAnycastManagerApi(api_instance)

    def tearDown(self) -> None:
        pass

    def test_create_anycast_config(self) -> None:
        """Test case for create_anycast_config

        Create Anycast Configuration
        """
        pass

    def test_create_anycast_version(self) -> None:
        """Test case for create_anycast_version

        Create Anycast Version
        """
        pass

    def test_delete_anycast_config(self) -> None:
        """Test case for delete_anycast_config

        Delete Anycast Configuration
        """
        pass

    def test_delete_anycast_version(self) -> None:
        """Test case for delete_anycast_version

        Delete anycast version
        """
        pass

    def test_delete_onprem_host(self) -> None:
        """Test case for delete_onprem_host

        Delete On-Prem Host
        """
        pass

    def test_get_anycast_config(self) -> None:
        """Test case for get_anycast_config

        Retrieve Anycast Configuration
        """
        pass

    def test_get_anycast_config_list(self) -> None:
        """Test case for get_anycast_config_list

        Retrieve Multiple Anycast Configurations
        """
        pass

    def test_get_anycast_version(self) -> None:
        """Test case for get_anycast_version

        Retrieve Anycast Version
        """
        pass

    def test_get_onprem_config(self) -> None:
        """Test case for get_onprem_config

        Retrieve Generated, Per-Host Anycast Configuration
        """
        pass

    def test_get_onprem_config2(self) -> None:
        """Test case for get_onprem_config2

        Retrieve Generated, Per-Host Anycast Configuration
        """
        pass

    def test_get_onprem_host(self) -> None:
        """Test case for get_onprem_host

        Retrieve On-Prem Host
        """
        pass

    def test_get_status(self) -> None:
        """Test case for get_status

        Retrieve Configuration Status
        """
        pass

    def test_get_status2(self) -> None:
        """Test case for get_status2

        Retrieve Configuration Status
        """
        pass

    def test_list_anycast_configs_with_runtime_status(self) -> None:
        """Test case for list_anycast_configs_with_runtime_status

        Read list of Anycast Configurations
        """
        pass

    def test_read_anycast_config_with_runtime_status(self) -> None:
        """Test case for read_anycast_config_with_runtime_status

        Read Anycast Configuration
        """
        pass

    def test_update_anycast_config(self) -> None:
        """Test case for update_anycast_config

        Create or Update Anycast Configuration
        """
        pass

    def test_update_onprem_host(self) -> None:
        """Test case for update_onprem_host

        Create or Update On-Prem Host
        """
        pass


if __name__ == '__main__':
    unittest.main()
