# coding: utf-8

# flake8: noqa

"""
    DFP API

    Infoblox Cloud is a SaaS offering designed to provide protection to devices on and off-premises, including roaming, remote, and branch offices. It provides visibility into infected and compromised devices, prevents DNS-based data exfiltration, and automatically stops device communications with command-and-control servers (C&Cs) and botnets, in addition to providing recursive DNS services in the cloud. You can access the services by deploying the Infoblox Endpoint agent or the DNS forwarding proxy.  For remote office deployments or in cases where installing an endpoint agent is not desirable or possible, you can use the DNS forwarding proxy. It is a software that runs on bare-metal, VM infrastructures, or Infoblox NIOS appliances; and it embeds the client IPs in DNS queries before forwarding them to Infoblox Cloud. The communications are encrypted and client visibility is maintained. The proxy also provides DNS resolution to local DNS zones when you configure local resolvers. Once you set up a DNS forwarding proxy, it becomes the main DNS server for your remote site. It will also cache responses to speed resolution of future queries.  By implementing the DNS forwarding proxy, you can rest assured that Infoblox Cloud effectively enforces DNS client-based security policies at your remote sites. On-premises devices that send DNS queries reveal their actual client IP addresses (instead of their NAT IP address), which allows Infoblox Cloud to apply the security policies applicable to the respective endpoints and identify infected clients. 

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

__version__ = "0.1.0"

# import apis into sdk package
from dfp.api.accounts_api import AccountsApi
from dfp.api.infra_services_api import InfraServicesApi

# import models into sdk package
from dfp.models.dns_protocol import DNSProtocol
from dfp.models.dfp import Dfp
from dfp.models.dfp_create_or_update_payload import DfpCreateOrUpdatePayload
from dfp.models.dfp_create_or_update_response import DfpCreateOrUpdateResponse
from dfp.models.dfp_host import DfpHost
from dfp.models.dfp_list_response import DfpListResponse
from dfp.models.dfp_read_response import DfpReadResponse
from dfp.models.infra_services_create_or_update_dfp_service400_response import InfraServicesCreateOrUpdateDfpService400Response
from dfp.models.infra_services_create_or_update_dfp_service400_response_error import InfraServicesCreateOrUpdateDfpService400ResponseError
from dfp.models.infra_services_create_or_update_dfp_service404_response import InfraServicesCreateOrUpdateDfpService404Response
from dfp.models.infra_services_create_or_update_dfp_service404_response_error import InfraServicesCreateOrUpdateDfpService404ResponseError
from dfp.models.infra_services_list_dfp_services500_response import InfraServicesListDfpServices500Response
from dfp.models.infra_services_list_dfp_services500_response_error import InfraServicesListDfpServices500ResponseError
from dfp.models.net_addr_policy_assignment import NetAddrPolicyAssignment
from dfp.models.resolver import Resolver
from dfp.models.types_config_check_request import TypesConfigCheckRequest
from dfp.models.types_config_check_response import TypesConfigCheckResponse
from dfp.models.types_config_check_result import TypesConfigCheckResult
