# coding: utf-8

"""
    DFP API

    Infoblox Cloud is a SaaS offering designed to provide protection to devices on and off-premises, including roaming, remote, and branch offices. It provides visibility into infected and compromised devices, prevents DNS-based data exfiltration, and automatically stops device communications with command-and-control servers (C&Cs) and botnets, in addition to providing recursive DNS services in the cloud. You can access the services by deploying the Infoblox Endpoint agent or the DNS forwarding proxy.  For remote office deployments or in cases where installing an endpoint agent is not desirable or possible, you can use the DNS forwarding proxy. It is a software that runs on bare-metal, VM infrastructures, or Infoblox NIOS appliances; and it embeds the client IPs in DNS queries before forwarding them to Infoblox Cloud. The communications are encrypted and client visibility is maintained. The proxy also provides DNS resolution to local DNS zones when you configure local resolvers. Once you set up a DNS forwarding proxy, it becomes the main DNS server for your remote site. It will also cache responses to speed resolution of future queries.  By implementing the DNS forwarding proxy, you can rest assured that Infoblox Cloud effectively enforces DNS client-based security policies at your remote sites. On-premises devices that send DNS queries reveal their actual client IP addresses (instead of their NAT IP address), which allows Infoblox Cloud to apply the security policies applicable to the respective endpoints and identify infected clients. 

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from dfp.models.dfp_create_or_update_payload import DfpCreateOrUpdatePayload
from dfp.models.dfp_create_or_update_response import DfpCreateOrUpdateResponse
from dfp.models.dfp_list_response import DfpListResponse
from dfp.models.dfp_read_response import DfpReadResponse
from dfp import models

from universal_ddi_client.api_client import ApiClient, RequestSerialized
from universal_ddi_client.api_response import ApiResponse
from universal_ddi_client.rest import RESTResponseType


class InfraServicesApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def create_or_update_dfp_service(
        self,
        payload_service_id: Annotated[
            StrictStr,
            Field(description=
                  "The DNS Forwarding Proxy Service ID object identifier.")],
        body: Annotated[DfpCreateOrUpdatePayload,
                        Field(description="The DNS Forwarding Proxy object.")],
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DfpCreateOrUpdateResponse:
        """Update DNS Forwarding Proxy services.

        Use this method to update resolvers for the specified DNS Forwarding Proxy Service. 

        :param payload_service_id: The DNS Forwarding Proxy Service ID object identifier. (required)
        :type payload_service_id: str
        :param body: The DNS Forwarding Proxy object. (required)
        :type body: DfpCreateOrUpdatePayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_or_update_dfp_service_serialize(
            payload_service_id=payload_service_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "DfpCreateOrUpdateResponse",
            '400': "InfraServicesCreateOrUpdateDfpService400Response",
            '404': "InfraServicesCreateOrUpdateDfpService404Response",
            '500': "InfraServicesListDfpServices500Response",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            models=models,
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def create_or_update_dfp_service_with_http_info(
        self,
        payload_service_id: Annotated[
            StrictStr,
            Field(description=
                  "The DNS Forwarding Proxy Service ID object identifier.")],
        body: Annotated[DfpCreateOrUpdatePayload,
                        Field(description="The DNS Forwarding Proxy object.")],
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DfpCreateOrUpdateResponse]:
        """Update DNS Forwarding Proxy services.

        Use this method to update resolvers for the specified DNS Forwarding Proxy Service. 

        :param payload_service_id: The DNS Forwarding Proxy Service ID object identifier. (required)
        :type payload_service_id: str
        :param body: The DNS Forwarding Proxy object. (required)
        :type body: DfpCreateOrUpdatePayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_or_update_dfp_service_serialize(
            payload_service_id=payload_service_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "DfpCreateOrUpdateResponse",
            '400': "InfraServicesCreateOrUpdateDfpService400Response",
            '404': "InfraServicesCreateOrUpdateDfpService404Response",
            '500': "InfraServicesListDfpServices500Response",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            models=models,
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def create_or_update_dfp_service_without_preload_content(
        self,
        payload_service_id: Annotated[
            StrictStr,
            Field(description=
                  "The DNS Forwarding Proxy Service ID object identifier.")],
        body: Annotated[DfpCreateOrUpdatePayload,
                        Field(description="The DNS Forwarding Proxy object.")],
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update DNS Forwarding Proxy services.

        Use this method to update resolvers for the specified DNS Forwarding Proxy Service. 

        :param payload_service_id: The DNS Forwarding Proxy Service ID object identifier. (required)
        :type payload_service_id: str
        :param body: The DNS Forwarding Proxy object. (required)
        :type body: DfpCreateOrUpdatePayload
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_or_update_dfp_service_serialize(
            payload_service_id=payload_service_id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "DfpCreateOrUpdateResponse",
            '400': "InfraServicesCreateOrUpdateDfpService400Response",
            '404': "InfraServicesCreateOrUpdateDfpService404Response",
            '500': "InfraServicesListDfpServices500Response",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _create_or_update_dfp_service_serialize(
        self,
        payload_service_id,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if payload_service_id is not None:
            _path_params[
                'payload.service_id'] = self.api_client.path_param_value(
                    'payload.service_id',
                    payload_service_id,
                    value_type='resource_id')
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    ['application/json']))
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method='PUT',
            base_path='/api/atcdfp/v1',
            resource_path='/dfp_services/{payload.service_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)

    @validate_call
    def list_dfp_services(
        self,
        filter: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "A collection of response resources can be filtered by a logical expression string that includes JSON tag references to values in each resource, literal values, and logical operators. If a resource does not have the specified tag, its value is assumed to be null.  Literal values include numbers (integer and floating-point), and quoted (both single- or double-quoted) literal strings, and 'null'.  You can filter by following fields:  | Name                    | type     | Supported Op                | | ----------------------- | -------- | --------------------------- | | service_name            | string   | !=, ==, ~, !~, >, <, <=, >= | | internal_domain_lists   | [int32]  | !=, ==, ~, !~, >, <, <=, >= | | policy_id               | int32    | !=, ==, >, <, <=, >=        | | default_security_policy | bool     | !=, ==                      |   In addition groupping operators are supported:  | Op  | Description          | | --- | -------------------- | | and | Logical AND          | | or  | Logical OR           | | not | Logical NOT          | | ()  | Groupping Operators  |  Example: ``` ?_filter=\"((service_name=='dfp1')or(policy_id~'oph'))and(default_security_policy!='true')\" ``` "
            )] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "  A collection of response resources can be transformed by specifying a set of JSON tags to be returned. For a “flat” resource, the tag name is straightforward. If field selection is allowed on non-flat hierarchical resources, the service should implement a qualified naming scheme such as dot-qualification to reference data down the hierarchy. If a resource does not have the specified tag, the tag does not appear in the output resource.  Specify this parameter as a comma-separated list of JSON tag names.        "
            )] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description=
                "  The integer index (zero-origin) of the offset into a collection of resources. If omitted or null the value is assumed to be '0'.         "
            )] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description=
                "  The integer number of resources to be returned in the response. The service may impose maximum value. If omitted the service may impose a default value.         "
            )] = None,
        page_token: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "  The service-defined string used to identify a page of resources. A null value indicates the first page.         "
            )] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DfpListResponse:
        """List DNS Forwarding Proxy services.

        Use this method to retrieve information on all DNS Forwarding Proxy services.  

        :param filter: A collection of response resources can be filtered by a logical expression string that includes JSON tag references to values in each resource, literal values, and logical operators. If a resource does not have the specified tag, its value is assumed to be null.  Literal values include numbers (integer and floating-point), and quoted (both single- or double-quoted) literal strings, and 'null'.  You can filter by following fields:  | Name                    | type     | Supported Op                | | ----------------------- | -------- | --------------------------- | | service_name            | string   | !=, ==, ~, !~, >, <, <=, >= | | internal_domain_lists   | [int32]  | !=, ==, ~, !~, >, <, <=, >= | | policy_id               | int32    | !=, ==, >, <, <=, >=        | | default_security_policy | bool     | !=, ==                      |   In addition groupping operators are supported:  | Op  | Description          | | --- | -------------------- | | and | Logical AND          | | or  | Logical OR           | | not | Logical NOT          | | ()  | Groupping Operators  |  Example: ``` ?_filter=\"((service_name=='dfp1')or(policy_id~'oph'))and(default_security_policy!='true')\" ``` 
        :type filter: str
        :param fields:   A collection of response resources can be transformed by specifying a set of JSON tags to be returned. For a “flat” resource, the tag name is straightforward. If field selection is allowed on non-flat hierarchical resources, the service should implement a qualified naming scheme such as dot-qualification to reference data down the hierarchy. If a resource does not have the specified tag, the tag does not appear in the output resource.  Specify this parameter as a comma-separated list of JSON tag names.        
        :type fields: str
        :param offset:   The integer index (zero-origin) of the offset into a collection of resources. If omitted or null the value is assumed to be '0'.         
        :type offset: int
        :param limit:   The integer number of resources to be returned in the response. The service may impose maximum value. If omitted the service may impose a default value.         
        :type limit: int
        :param page_token:   The service-defined string used to identify a page of resources. A null value indicates the first page.         
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_dfp_services_serialize(filter=filter,
                                                   fields=fields,
                                                   offset=offset,
                                                   limit=limit,
                                                   page_token=page_token,
                                                   _request_auth=_request_auth,
                                                   _content_type=_content_type,
                                                   _headers=_headers,
                                                   _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DfpListResponse",
            '500': "InfraServicesListDfpServices500Response",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            models=models,
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def list_dfp_services_with_http_info(
        self,
        filter: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "A collection of response resources can be filtered by a logical expression string that includes JSON tag references to values in each resource, literal values, and logical operators. If a resource does not have the specified tag, its value is assumed to be null.  Literal values include numbers (integer and floating-point), and quoted (both single- or double-quoted) literal strings, and 'null'.  You can filter by following fields:  | Name                    | type     | Supported Op                | | ----------------------- | -------- | --------------------------- | | service_name            | string   | !=, ==, ~, !~, >, <, <=, >= | | internal_domain_lists   | [int32]  | !=, ==, ~, !~, >, <, <=, >= | | policy_id               | int32    | !=, ==, >, <, <=, >=        | | default_security_policy | bool     | !=, ==                      |   In addition groupping operators are supported:  | Op  | Description          | | --- | -------------------- | | and | Logical AND          | | or  | Logical OR           | | not | Logical NOT          | | ()  | Groupping Operators  |  Example: ``` ?_filter=\"((service_name=='dfp1')or(policy_id~'oph'))and(default_security_policy!='true')\" ``` "
            )] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "  A collection of response resources can be transformed by specifying a set of JSON tags to be returned. For a “flat” resource, the tag name is straightforward. If field selection is allowed on non-flat hierarchical resources, the service should implement a qualified naming scheme such as dot-qualification to reference data down the hierarchy. If a resource does not have the specified tag, the tag does not appear in the output resource.  Specify this parameter as a comma-separated list of JSON tag names.        "
            )] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description=
                "  The integer index (zero-origin) of the offset into a collection of resources. If omitted or null the value is assumed to be '0'.         "
            )] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description=
                "  The integer number of resources to be returned in the response. The service may impose maximum value. If omitted the service may impose a default value.         "
            )] = None,
        page_token: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "  The service-defined string used to identify a page of resources. A null value indicates the first page.         "
            )] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DfpListResponse]:
        """List DNS Forwarding Proxy services.

        Use this method to retrieve information on all DNS Forwarding Proxy services.  

        :param filter: A collection of response resources can be filtered by a logical expression string that includes JSON tag references to values in each resource, literal values, and logical operators. If a resource does not have the specified tag, its value is assumed to be null.  Literal values include numbers (integer and floating-point), and quoted (both single- or double-quoted) literal strings, and 'null'.  You can filter by following fields:  | Name                    | type     | Supported Op                | | ----------------------- | -------- | --------------------------- | | service_name            | string   | !=, ==, ~, !~, >, <, <=, >= | | internal_domain_lists   | [int32]  | !=, ==, ~, !~, >, <, <=, >= | | policy_id               | int32    | !=, ==, >, <, <=, >=        | | default_security_policy | bool     | !=, ==                      |   In addition groupping operators are supported:  | Op  | Description          | | --- | -------------------- | | and | Logical AND          | | or  | Logical OR           | | not | Logical NOT          | | ()  | Groupping Operators  |  Example: ``` ?_filter=\"((service_name=='dfp1')or(policy_id~'oph'))and(default_security_policy!='true')\" ``` 
        :type filter: str
        :param fields:   A collection of response resources can be transformed by specifying a set of JSON tags to be returned. For a “flat” resource, the tag name is straightforward. If field selection is allowed on non-flat hierarchical resources, the service should implement a qualified naming scheme such as dot-qualification to reference data down the hierarchy. If a resource does not have the specified tag, the tag does not appear in the output resource.  Specify this parameter as a comma-separated list of JSON tag names.        
        :type fields: str
        :param offset:   The integer index (zero-origin) of the offset into a collection of resources. If omitted or null the value is assumed to be '0'.         
        :type offset: int
        :param limit:   The integer number of resources to be returned in the response. The service may impose maximum value. If omitted the service may impose a default value.         
        :type limit: int
        :param page_token:   The service-defined string used to identify a page of resources. A null value indicates the first page.         
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_dfp_services_serialize(filter=filter,
                                                   fields=fields,
                                                   offset=offset,
                                                   limit=limit,
                                                   page_token=page_token,
                                                   _request_auth=_request_auth,
                                                   _content_type=_content_type,
                                                   _headers=_headers,
                                                   _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DfpListResponse",
            '500': "InfraServicesListDfpServices500Response",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            models=models,
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def list_dfp_services_without_preload_content(
        self,
        filter: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "A collection of response resources can be filtered by a logical expression string that includes JSON tag references to values in each resource, literal values, and logical operators. If a resource does not have the specified tag, its value is assumed to be null.  Literal values include numbers (integer and floating-point), and quoted (both single- or double-quoted) literal strings, and 'null'.  You can filter by following fields:  | Name                    | type     | Supported Op                | | ----------------------- | -------- | --------------------------- | | service_name            | string   | !=, ==, ~, !~, >, <, <=, >= | | internal_domain_lists   | [int32]  | !=, ==, ~, !~, >, <, <=, >= | | policy_id               | int32    | !=, ==, >, <, <=, >=        | | default_security_policy | bool     | !=, ==                      |   In addition groupping operators are supported:  | Op  | Description          | | --- | -------------------- | | and | Logical AND          | | or  | Logical OR           | | not | Logical NOT          | | ()  | Groupping Operators  |  Example: ``` ?_filter=\"((service_name=='dfp1')or(policy_id~'oph'))and(default_security_policy!='true')\" ``` "
            )] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "  A collection of response resources can be transformed by specifying a set of JSON tags to be returned. For a “flat” resource, the tag name is straightforward. If field selection is allowed on non-flat hierarchical resources, the service should implement a qualified naming scheme such as dot-qualification to reference data down the hierarchy. If a resource does not have the specified tag, the tag does not appear in the output resource.  Specify this parameter as a comma-separated list of JSON tag names.        "
            )] = None,
        offset: Annotated[
            Optional[StrictInt],
            Field(
                description=
                "  The integer index (zero-origin) of the offset into a collection of resources. If omitted or null the value is assumed to be '0'.         "
            )] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description=
                "  The integer number of resources to be returned in the response. The service may impose maximum value. If omitted the service may impose a default value.         "
            )] = None,
        page_token: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "  The service-defined string used to identify a page of resources. A null value indicates the first page.         "
            )] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List DNS Forwarding Proxy services.

        Use this method to retrieve information on all DNS Forwarding Proxy services.  

        :param filter: A collection of response resources can be filtered by a logical expression string that includes JSON tag references to values in each resource, literal values, and logical operators. If a resource does not have the specified tag, its value is assumed to be null.  Literal values include numbers (integer and floating-point), and quoted (both single- or double-quoted) literal strings, and 'null'.  You can filter by following fields:  | Name                    | type     | Supported Op                | | ----------------------- | -------- | --------------------------- | | service_name            | string   | !=, ==, ~, !~, >, <, <=, >= | | internal_domain_lists   | [int32]  | !=, ==, ~, !~, >, <, <=, >= | | policy_id               | int32    | !=, ==, >, <, <=, >=        | | default_security_policy | bool     | !=, ==                      |   In addition groupping operators are supported:  | Op  | Description          | | --- | -------------------- | | and | Logical AND          | | or  | Logical OR           | | not | Logical NOT          | | ()  | Groupping Operators  |  Example: ``` ?_filter=\"((service_name=='dfp1')or(policy_id~'oph'))and(default_security_policy!='true')\" ``` 
        :type filter: str
        :param fields:   A collection of response resources can be transformed by specifying a set of JSON tags to be returned. For a “flat” resource, the tag name is straightforward. If field selection is allowed on non-flat hierarchical resources, the service should implement a qualified naming scheme such as dot-qualification to reference data down the hierarchy. If a resource does not have the specified tag, the tag does not appear in the output resource.  Specify this parameter as a comma-separated list of JSON tag names.        
        :type fields: str
        :param offset:   The integer index (zero-origin) of the offset into a collection of resources. If omitted or null the value is assumed to be '0'.         
        :type offset: int
        :param limit:   The integer number of resources to be returned in the response. The service may impose maximum value. If omitted the service may impose a default value.         
        :type limit: int
        :param page_token:   The service-defined string used to identify a page of resources. A null value indicates the first page.         
        :type page_token: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_dfp_services_serialize(filter=filter,
                                                   fields=fields,
                                                   offset=offset,
                                                   limit=limit,
                                                   page_token=page_token,
                                                   _request_auth=_request_auth,
                                                   _content_type=_content_type,
                                                   _headers=_headers,
                                                   _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DfpListResponse",
            '500': "InfraServicesListDfpServices500Response",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _list_dfp_services_serialize(
        self,
        filter,
        fields,
        offset,
        limit,
        page_token,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if filter is not None:

            _query_params.append(('_filter', filter))

        if fields is not None:

            _query_params.append(('_fields', fields))

        if offset is not None:

            _query_params.append(('_offset', offset))

        if limit is not None:

            _query_params.append(('_limit', limit))

        if page_token is not None:

            _query_params.append(('_page_token', page_token))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method='GET',
            base_path='/api/atcdfp/v1',
            resource_path='/dfp_services',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)

    @validate_call
    def read_dfp_service(
        self,
        service_id: Annotated[
            StrictStr,
            Field(
                description=
                "The On-Prem Application Service identifier. For internal Use only"
            )],
        id: Annotated[
            Optional[StrictInt],
            Field(description="The DNS Forwarding Proxy object identifier."
                  )] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "  A collection of response resources can be transformed by specifying a set of JSON tags to be returned. For a “flat” resource, the tag name is straightforward. If field selection is allowed on non-flat hierarchical resources, the service should implement a qualified naming scheme such as dot-qualification to reference data down the hierarchy. If a resource does not have the specified tag, the tag does not appear in the output resource.  Specify this parameter as a comma-separated list of JSON tag names.        "
            )] = None,
        name: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "The name of the DNS Forwarding Proxy. Used only if the 'id' field is empty."
            )] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DfpReadResponse:
        """Read DNS Forwarding Proxy services.

        Use this method to retrieve information on the specified DNS Forwarding Proxy service. 

        :param service_id: The On-Prem Application Service identifier. For internal Use only (required)
        :type service_id: str
        :param id: The DNS Forwarding Proxy object identifier.
        :type id: int
        :param fields:   A collection of response resources can be transformed by specifying a set of JSON tags to be returned. For a “flat” resource, the tag name is straightforward. If field selection is allowed on non-flat hierarchical resources, the service should implement a qualified naming scheme such as dot-qualification to reference data down the hierarchy. If a resource does not have the specified tag, the tag does not appear in the output resource.  Specify this parameter as a comma-separated list of JSON tag names.        
        :type fields: str
        :param name: The name of the DNS Forwarding Proxy. Used only if the 'id' field is empty.
        :type name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_dfp_service_serialize(service_id=service_id,
                                                  id=id,
                                                  fields=fields,
                                                  name=name,
                                                  _request_auth=_request_auth,
                                                  _content_type=_content_type,
                                                  _headers=_headers,
                                                  _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DfpReadResponse",
            '404': "InfraServicesCreateOrUpdateDfpService404Response",
            '500': "InfraServicesListDfpServices500Response",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            models=models,
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def read_dfp_service_with_http_info(
        self,
        service_id: Annotated[
            StrictStr,
            Field(
                description=
                "The On-Prem Application Service identifier. For internal Use only"
            )],
        id: Annotated[
            Optional[StrictInt],
            Field(description="The DNS Forwarding Proxy object identifier."
                  )] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "  A collection of response resources can be transformed by specifying a set of JSON tags to be returned. For a “flat” resource, the tag name is straightforward. If field selection is allowed on non-flat hierarchical resources, the service should implement a qualified naming scheme such as dot-qualification to reference data down the hierarchy. If a resource does not have the specified tag, the tag does not appear in the output resource.  Specify this parameter as a comma-separated list of JSON tag names.        "
            )] = None,
        name: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "The name of the DNS Forwarding Proxy. Used only if the 'id' field is empty."
            )] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DfpReadResponse]:
        """Read DNS Forwarding Proxy services.

        Use this method to retrieve information on the specified DNS Forwarding Proxy service. 

        :param service_id: The On-Prem Application Service identifier. For internal Use only (required)
        :type service_id: str
        :param id: The DNS Forwarding Proxy object identifier.
        :type id: int
        :param fields:   A collection of response resources can be transformed by specifying a set of JSON tags to be returned. For a “flat” resource, the tag name is straightforward. If field selection is allowed on non-flat hierarchical resources, the service should implement a qualified naming scheme such as dot-qualification to reference data down the hierarchy. If a resource does not have the specified tag, the tag does not appear in the output resource.  Specify this parameter as a comma-separated list of JSON tag names.        
        :type fields: str
        :param name: The name of the DNS Forwarding Proxy. Used only if the 'id' field is empty.
        :type name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_dfp_service_serialize(service_id=service_id,
                                                  id=id,
                                                  fields=fields,
                                                  name=name,
                                                  _request_auth=_request_auth,
                                                  _content_type=_content_type,
                                                  _headers=_headers,
                                                  _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DfpReadResponse",
            '404': "InfraServicesCreateOrUpdateDfpService404Response",
            '500': "InfraServicesListDfpServices500Response",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        response_data.read()
        return self.api_client.response_deserialize(
            models=models,
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def read_dfp_service_without_preload_content(
        self,
        service_id: Annotated[
            StrictStr,
            Field(
                description=
                "The On-Prem Application Service identifier. For internal Use only"
            )],
        id: Annotated[
            Optional[StrictInt],
            Field(description="The DNS Forwarding Proxy object identifier."
                  )] = None,
        fields: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "  A collection of response resources can be transformed by specifying a set of JSON tags to be returned. For a “flat” resource, the tag name is straightforward. If field selection is allowed on non-flat hierarchical resources, the service should implement a qualified naming scheme such as dot-qualification to reference data down the hierarchy. If a resource does not have the specified tag, the tag does not appear in the output resource.  Specify this parameter as a comma-separated list of JSON tag names.        "
            )] = None,
        name: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "The name of the DNS Forwarding Proxy. Used only if the 'id' field is empty."
            )] = None,
        _request_timeout: Union[None, Annotated[StrictFloat,
                                                Field(gt=0)],
                                Tuple[Annotated[StrictFloat,
                                                Field(gt=0)],
                                      Annotated[StrictFloat,
                                                Field(gt=0)]]] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Read DNS Forwarding Proxy services.

        Use this method to retrieve information on the specified DNS Forwarding Proxy service. 

        :param service_id: The On-Prem Application Service identifier. For internal Use only (required)
        :type service_id: str
        :param id: The DNS Forwarding Proxy object identifier.
        :type id: int
        :param fields:   A collection of response resources can be transformed by specifying a set of JSON tags to be returned. For a “flat” resource, the tag name is straightforward. If field selection is allowed on non-flat hierarchical resources, the service should implement a qualified naming scheme such as dot-qualification to reference data down the hierarchy. If a resource does not have the specified tag, the tag does not appear in the output resource.  Specify this parameter as a comma-separated list of JSON tag names.        
        :type fields: str
        :param name: The name of the DNS Forwarding Proxy. Used only if the 'id' field is empty.
        :type name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._read_dfp_service_serialize(service_id=service_id,
                                                  id=id,
                                                  fields=fields,
                                                  name=name,
                                                  _request_auth=_request_auth,
                                                  _content_type=_content_type,
                                                  _headers=_headers,
                                                  _host_index=_host_index)

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DfpReadResponse",
            '404': "InfraServicesCreateOrUpdateDfpService404Response",
            '500': "InfraServicesListDfpServices500Response",
        }
        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout)
        return response_data.response

    def _read_dfp_service_serialize(
        self,
        service_id,
        id,
        fields,
        name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if service_id is not None:
            _path_params['service_id'] = self.api_client.path_param_value(
                'service_id', service_id, value_type='resource_id')
        # process the query parameters
        if id is not None:

            _query_params.append(('id', id))

        if fields is not None:

            _query_params.append(('_fields', fields))

        if name is not None:

            _query_params.append(('name', name))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])

        # authentication setting
        _auth_settings: List[str] = []

        return self.api_client.param_serialize(
            method='GET',
            base_path='/api/atcdfp/v1',
            resource_path='/dfp_services/{service_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth)
