# coding: utf-8

"""
    IP Address Management API

    The IPAM/DHCP Application is a Universal DDI service providing IP address management and DHCP protocol features. The IPAM component provides visibility into and provisioning tools to manage networking spaces, monitoring and reporting of entire IP address infrastructures, and integration with DNS and DHCP protocols. The DHCP component provides DHCP protocol configuration service with on-prem host serving DHCP protocol. It is part of the full-featured, DDI cloud solution that enables customers to deploy large numbers of protocol servers to deliver DNS and DHCP throughout their enterprise network.

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class BulkCopyIPSpace(BaseModel):
    """
    BulkCopyIPSpace
    """

  # noqa: E501
    copy_dhcp_options: Optional[StrictBool] = Field(
        default=None,
        description=
        "Indicates whether dhcp options for IPv4 should be copied or not when objects (_ipam/address_block_ and _ipam/subnet_ only) are copied.  Defaults to _false_."
    )
    copy_objects: List[StrictStr] = Field(
        description="The resource identifier.")
    recursive: Optional[StrictBool] = Field(
        default=None,
        description=
        "Indicates whether child objects should be copied or not.  Defaults to _false_."
    )
    retain_child_compartment: Optional[StrictBool] = Field(
        default=None,
        description=
        "Indicates whether the child objects are going to retain their compartment_id, or inherit from the object to copy into.  Defaults to false"
    )
    skip_on_error: Optional[StrictBool] = Field(
        default=None,
        description=
        "Indicates whether copying should skip object in case of error and continue with next, or abort copying in case of error.  Defaults to _false_."
    )
    target: StrictStr = Field(description="The resource identifier.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "copy_dhcp_options", "copy_objects", "recursive",
        "retain_child_compartment", "skip_on_error", "target"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BulkCopyIPSpace from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BulkCopyIPSpace from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "copy_dhcp_options":
            obj.get("copy_dhcp_options"),
            "copy_objects":
            obj.get("copy_objects"),
            "recursive":
            obj.get("recursive"),
            "retain_child_compartment":
            obj.get("retain_child_compartment"),
            "skip_on_error":
            obj.get("skip_on_error"),
            "target":
            obj.get("target")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
