# coding: utf-8

"""
    IP Address Management API

    The IPAM/DHCP Application is a Universal DDI service providing IP address management and DHCP protocol features. The IPAM component provides visibility into and provisioning tools to manage networking spaces, monitoring and reporting of entire IP address infrastructures, and integration with DNS and DHCP protocols. The DHCP component provides DHCP protocol configuration service with on-prem host serving DHCP protocol. It is part of the full-featured, DDI cloud solution that enables customers to deploy large numbers of protocol servers to deliver DNS and DHCP throughout their enterprise network.

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ipam.models.ddns_zone import DDNSZone
from ipam.models.kerberos_key import KerberosKey
from typing import Optional, Set
from typing_extensions import Self


class DDNSBlock(BaseModel):
    """
    The dynamic DNS configuration.
    """

  # noqa: E501
    client_principal: Optional[StrictStr] = Field(
        default=None,
        description=
        "The Kerberos principal name. It uses the typical Kerberos notation: <SERVICE-NAME>/<server-domain-name>@<REALM>.  Defaults to empty."
    )
    ddns_domain: Optional[StrictStr] = Field(
        default=None, description="The domain name for DDNS.")
    ddns_enabled: Optional[StrictBool] = Field(
        default=None, description="Indicates if DDNS is enabled.")
    ddns_send_updates: Optional[StrictBool] = Field(
        default=None,
        description="Determines if DDNS updates are enabled at this level.")
    ddns_zones: Optional[List[DDNSZone]] = Field(
        default=None, description="The list of DDNS zones.")
    gss_tsig_fallback: Optional[StrictBool] = Field(
        default=None,
        description=
        "The behavior when GSS-TSIG should be used (a matching external DNS server is configured) but no GSS-TSIG key is available. If configured to _false_ (the default) this DNS server is skipped, if configured to _true_ the DNS server is ignored and the DNS update is sent with the configured DHCP-DDNS protection e.g. TSIG key or without any protection when none was configured.  Defaults to _false_."
    )
    kerberos_kdc: Optional[StrictStr] = Field(
        default=None,
        description=
        "Address of Kerberos Key Distribution Center.  Defaults to empty.")
    kerberos_keys: Optional[List[KerberosKey]] = Field(
        default=None,
        description=
        "_kerberos_keys_ contains a list of keys for GSS-TSIG signed dynamic updates.  Defaults to empty."
    )
    kerberos_rekey_interval: Optional[StrictInt] = Field(
        default=None,
        description=
        "Time interval (in seconds) the keys for each configured external DNS server are checked for rekeying, i.e. a new key is created to replace the current usable one when its age is greater than the rekey_interval value.  Defaults to 120 seconds."
    )
    kerberos_retry_interval: Optional[StrictInt] = Field(
        default=None,
        description=
        "Time interval (in seconds) to retry to create a key if any error occurred previously for any configured external DNS server.  Defaults to 30 seconds."
    )
    kerberos_tkey_lifetime: Optional[StrictInt] = Field(
        default=None,
        description=
        "Lifetime (in seconds) of GSS-TSIG keys in the TKEY protocol.  Defaults to 160 seconds."
    )
    kerberos_tkey_protocol: Optional[StrictStr] = Field(
        default=None,
        description=
        "Determines which protocol is used to establish the security context with the external DNS servers, TCP or UDP.  Defaults to _tcp_."
    )
    server_principal: Optional[StrictStr] = Field(
        default=None,
        description=
        "The Kerberos principal name of the external DNS server that will receive updates.  Defaults to empty."
    )
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "client_principal", "ddns_domain", "ddns_enabled", "ddns_send_updates",
        "ddns_zones", "gss_tsig_fallback", "kerberos_kdc", "kerberos_keys",
        "kerberos_rekey_interval", "kerberos_retry_interval",
        "kerberos_tkey_lifetime", "kerberos_tkey_protocol", "server_principal"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DDNSBlock from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in ddns_zones (list)
        _items = []
        if self.ddns_zones:
            for _item in self.ddns_zones:
                if _item:
                    _items.append(_item.to_dict())
            _dict['ddns_zones'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in kerberos_keys (list)
        _items = []
        if self.kerberos_keys:
            for _item in self.kerberos_keys:
                if _item:
                    _items.append(_item.to_dict())
            _dict['kerberos_keys'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DDNSBlock from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "client_principal":
            obj.get("client_principal"),
            "ddns_domain":
            obj.get("ddns_domain"),
            "ddns_enabled":
            obj.get("ddns_enabled"),
            "ddns_send_updates":
            obj.get("ddns_send_updates"),
            "ddns_zones":
            [DDNSZone.from_dict(_item) for _item in obj["ddns_zones"]]
            if obj.get("ddns_zones") is not None else None,
            "gss_tsig_fallback":
            obj.get("gss_tsig_fallback"),
            "kerberos_kdc":
            obj.get("kerberos_kdc"),
            "kerberos_keys":
            [KerberosKey.from_dict(_item) for _item in obj["kerberos_keys"]]
            if obj.get("kerberos_keys") is not None else None,
            "kerberos_rekey_interval":
            obj.get("kerberos_rekey_interval"),
            "kerberos_retry_interval":
            obj.get("kerberos_retry_interval"),
            "kerberos_tkey_lifetime":
            obj.get("kerberos_tkey_lifetime"),
            "kerberos_tkey_protocol":
            obj.get("kerberos_tkey_protocol"),
            "server_principal":
            obj.get("server_principal")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
