# coding: utf-8

"""
    IP Address Management API

    The IPAM/DHCP Application is a Universal DDI service providing IP address management and DHCP protocol features. The IPAM component provides visibility into and provisioning tools to manage networking spaces, monitoring and reporting of entire IP address infrastructures, and integration with DNS and DHCP protocols. The DHCP component provides DHCP protocol configuration service with on-prem host serving DHCP protocol. It is part of the full-featured, DDI cloud solution that enables customers to deploy large numbers of protocol servers to deliver DNS and DHCP throughout their enterprise network.

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from ipam.models.inheritance_inherited_bool import InheritanceInheritedBool
from ipam.models.inheritance_inherited_u_int32 import InheritanceInheritedUInt32
from ipam.models.inherited_dhcp_config_filter_list import InheritedDHCPConfigFilterList
from ipam.models.inherited_dhcp_config_ignore_item_list import InheritedDHCPConfigIgnoreItemList
from typing import Optional, Set
from typing_extensions import Self


class InheritedDHCPConfig(BaseModel):
    """
    The inheritance configuration for a field of type _DHCPConfig_.
    """ # noqa: E501
    abandoned_reclaim_time: Optional[InheritanceInheritedUInt32] = Field(
        default=None,
        description=
        "The inheritance configuration for _abandoned_reclaim_time_ field from _DHCPConfig_ object."
    )
    abandoned_reclaim_time_v6: Optional[InheritanceInheritedUInt32] = Field(
        default=None,
        description=
        "The inheritance configuration for _abandoned_reclaim_time_v6_ field from _DHCPConfig_ object."
    )
    allow_unknown: Optional[InheritanceInheritedBool] = Field(
        default=None,
        description=
        "The inheritance configuration for _allow_unknown_ field from _DHCPConfig_ object."
    )
    allow_unknown_v6: Optional[InheritanceInheritedBool] = Field(
        default=None,
        description=
        "The inheritance configuration for _allow_unknown_v6_ field from _DHCPConfig_ object."
    )
    echo_client_id: Optional[InheritanceInheritedBool] = Field(
        default=None,
        description=
        "The inheritance configuration for _echo_client_id_ field from _DHCPConfig_ object."
    )
    filters: Optional[InheritedDHCPConfigFilterList] = Field(
        default=None,
        description=
        "The inheritance configuration for filters field from _DHCPConfig_ object."
    )
    filters_v6: Optional[InheritedDHCPConfigFilterList] = Field(
        default=None,
        description=
        "The inheritance configuration for _filters_v6_ field from _DHCPConfig_ object."
    )
    ignore_client_uid: Optional[InheritanceInheritedBool] = Field(
        default=None,
        description=
        "The inheritance configuration for _ignore_client_uid_ field from _DHCPConfig_ object."
    )
    ignore_list: Optional[InheritedDHCPConfigIgnoreItemList] = Field(
        default=None,
        description=
        "The inheritance configuration for _ignore_list_ field from _DHCPConfig_ object."
    )
    lease_time: Optional[InheritanceInheritedUInt32] = Field(
        default=None,
        description=
        "The inheritance configuration for _lease_time_ field from _DHCPConfig_ object."
    )
    lease_time_v6: Optional[InheritanceInheritedUInt32] = Field(
        default=None,
        description=
        "The inheritance configuration for _lease_time_v6_ field from _DHCPConfig_ object."
    )
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "abandoned_reclaim_time", "abandoned_reclaim_time_v6", "allow_unknown",
        "allow_unknown_v6", "echo_client_id", "filters", "filters_v6",
        "ignore_client_uid", "ignore_list", "lease_time", "lease_time_v6"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of InheritedDHCPConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of abandoned_reclaim_time
        if self.abandoned_reclaim_time:
            _dict[
                'abandoned_reclaim_time'] = self.abandoned_reclaim_time.to_dict(
                )
        # override the default output from pydantic by calling `to_dict()` of abandoned_reclaim_time_v6
        if self.abandoned_reclaim_time_v6:
            _dict[
                'abandoned_reclaim_time_v6'] = self.abandoned_reclaim_time_v6.to_dict(
                )
        # override the default output from pydantic by calling `to_dict()` of allow_unknown
        if self.allow_unknown:
            _dict['allow_unknown'] = self.allow_unknown.to_dict()
        # override the default output from pydantic by calling `to_dict()` of allow_unknown_v6
        if self.allow_unknown_v6:
            _dict['allow_unknown_v6'] = self.allow_unknown_v6.to_dict()
        # override the default output from pydantic by calling `to_dict()` of echo_client_id
        if self.echo_client_id:
            _dict['echo_client_id'] = self.echo_client_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of filters
        if self.filters:
            _dict['filters'] = self.filters.to_dict()
        # override the default output from pydantic by calling `to_dict()` of filters_v6
        if self.filters_v6:
            _dict['filters_v6'] = self.filters_v6.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ignore_client_uid
        if self.ignore_client_uid:
            _dict['ignore_client_uid'] = self.ignore_client_uid.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ignore_list
        if self.ignore_list:
            _dict['ignore_list'] = self.ignore_list.to_dict()
        # override the default output from pydantic by calling `to_dict()` of lease_time
        if self.lease_time:
            _dict['lease_time'] = self.lease_time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of lease_time_v6
        if self.lease_time_v6:
            _dict['lease_time_v6'] = self.lease_time_v6.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of InheritedDHCPConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "abandoned_reclaim_time":
            InheritanceInheritedUInt32.from_dict(obj["abandoned_reclaim_time"])
            if obj.get("abandoned_reclaim_time") is not None else None,
            "abandoned_reclaim_time_v6":
            InheritanceInheritedUInt32.from_dict(
                obj["abandoned_reclaim_time_v6"])
            if obj.get("abandoned_reclaim_time_v6") is not None else None,
            "allow_unknown":
            InheritanceInheritedBool.from_dict(obj["allow_unknown"])
            if obj.get("allow_unknown") is not None else None,
            "allow_unknown_v6":
            InheritanceInheritedBool.from_dict(obj["allow_unknown_v6"])
            if obj.get("allow_unknown_v6") is not None else None,
            "echo_client_id":
            InheritanceInheritedBool.from_dict(obj["echo_client_id"])
            if obj.get("echo_client_id") is not None else None,
            "filters":
            InheritedDHCPConfigFilterList.from_dict(obj["filters"])
            if obj.get("filters") is not None else None,
            "filters_v6":
            InheritedDHCPConfigFilterList.from_dict(obj["filters_v6"])
            if obj.get("filters_v6") is not None else None,
            "ignore_client_uid":
            InheritanceInheritedBool.from_dict(obj["ignore_client_uid"])
            if obj.get("ignore_client_uid") is not None else None,
            "ignore_list":
            InheritedDHCPConfigIgnoreItemList.from_dict(obj["ignore_list"])
            if obj.get("ignore_list") is not None else None,
            "lease_time":
            InheritanceInheritedUInt32.from_dict(obj["lease_time"])
            if obj.get("lease_time") is not None else None,
            "lease_time_v6":
            InheritanceInheritedUInt32.from_dict(obj["lease_time_v6"])
            if obj.get("lease_time_v6") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
