# coding: utf-8

"""
    IP Address Management API

    The IPAM/DHCP Application is a Universal DDI service providing IP address management and DHCP protocol features. The IPAM component provides visibility into and provisioning tools to manage networking spaces, monitoring and reporting of entire IP address infrastructures, and integration with DNS and DHCP protocols. The DHCP component provides DHCP protocol configuration service with on-prem host serving DHCP protocol. It is part of the full-featured, DDI cloud solution that enables customers to deploy large numbers of protocol servers to deliver DNS and DHCP throughout their enterprise network.

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from ipam.models.host_address import HostAddress
from ipam.models.host_name import HostName
from typing import Optional, Set
from typing_extensions import Self


class IpamHost(BaseModel):
    """
    The __IpamHost__ object (_ipam/host_) represents any network connected equipment that is assigned one or more IP addresses.
    """ # noqa: E501
    addresses: Optional[List[HostAddress]] = Field(
        default=None,
        description=
        "The list of all addresses associated with the IPAM host, which may be in different IP spaces."
    )
    auto_generate_records: Optional[StrictBool] = Field(
        default=None,
        description=
        "This flag specifies if resource records have to be auto generated for the host."
    )
    comment: Optional[StrictStr] = Field(
        default=None,
        description=
        "The description for the IPAM host. May contain 0 to 1024 characters. Can include UTF-8."
    )
    created_at: Optional[datetime] = Field(
        default=None, description="Time when the object has been created.")
    host_names: Optional[List[HostName]] = Field(
        default=None,
        description=
        "The name records to be generated for the host.  This field is required if _auto_generate_records_ is true."
    )
    id: Optional[StrictStr] = Field(default=None,
                                    description="The resource identifier.")
    name: StrictStr = Field(
        description=
        "The name of the IPAM host. Must contain 1 to 256 characters. Can include UTF-8."
    )
    tags: Optional[Dict[str, Any]] = Field(
        default=None, description="The tags for the IPAM host in JSON format.")
    updated_at: Optional[datetime] = Field(
        default=None,
        description=
        "Time when the object has been updated. Equals to _created_at_ if not updated after creation."
    )
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "addresses", "auto_generate_records", "comment", "created_at",
        "host_names", "id", "name", "tags", "updated_at"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of IpamHost from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "created_at",
            "id",
            "updated_at",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in addresses (list)
        _items = []
        if self.addresses:
            for _item in self.addresses:
                if _item:
                    _items.append(_item.to_dict())
            _dict['addresses'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in host_names (list)
        _items = []
        if self.host_names:
            for _item in self.host_names:
                if _item:
                    _items.append(_item.to_dict())
            _dict['host_names'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of IpamHost from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "addresses":
            [HostAddress.from_dict(_item) for _item in obj["addresses"]]
            if obj.get("addresses") is not None else None,
            "auto_generate_records":
            obj.get("auto_generate_records"),
            "comment":
            obj.get("comment"),
            "created_at":
            obj.get("created_at"),
            "host_names":
            [HostName.from_dict(_item) for _item in obj["host_names"]]
            if obj.get("host_names") is not None else None,
            "id":
            obj.get("id"),
            "name":
            obj.get("name"),
            "tags":
            obj.get("tags"),
            "updated_at":
            obj.get("updated_at")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
