#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# SPDX-License-Identifier: Apache-2.0
# Copyright 2024 Inria

import numpy as np

import uplot

v1 = np.array(
    [
        0.35189867,
        0.33440887,
        0.31187567,
        0.29372533,
        0.28205933,
        0.28579414,
        0.29055172,
        0.29449164,
        0.28745652,
        0.27642006,
        0.26409361,
        0.24920144,
        0.21968901,
        0.1903474,
        0.14416688,
        0.1013935,
        0.06975446,
        0.05133968,
        0.0492436,
        0.05916173,
        0.06069822,
        0.05255136,
        0.03641129,
        0.01232885,
        -0.02340249,
        -0.06951351,
        -0.12411359,
        -0.18078907,
        -0.23323237,
        -0.27583448,
        -0.31259793,
        -0.33245975,
        -0.32182605,
        -0.27193381,
        -0.1870999,
        -0.09126389,
        -0.01173261,
        0.01668092,
        0.00449685,
        -0.03245584,
        -0.07189206,
        -0.09525084,
    ]
)
v2 = np.array(
    [
        0.40215528,
        0.38603891,
        0.35140285,
        0.3215263,
        0.27873781,
        0.27077387,
        0.24593958,
        0.28406281,
        0.29895396,
        0.28722011,
        0.25734356,
        0.27006701,
        0.27350706,
        0.25635396,
        0.21898472,
        0.17379291,
        0.08331504,
        0.03039491,
        -0.00202633,
        -0.00801106,
        0.01757721,
        0.03845309,
        0.04877323,
        0.03812323,
        0.03562566,
        0.03322234,
        -0.01041438,
        -0.06894225,
        -0.13345486,
        -0.18703472,
        -0.24862564,
        -0.31921723,
        -0.40314488,
        -0.44697009,
        -0.40724466,
        -0.29188537,
        -0.12044866,
        0.03199712,
        0.10329557,
        0.10706548,
        0.01050863,
        -0.04231725,
    ]
)
u = np.array(
    [
        6.31617203,
        6.14966762,
        5.69570748,
        4.84433587,
        4.62913678,
        4.51132705,
        3.91756604,
        4.66997748,
        4.9165925,
        5.0029863,
        4.78307482,
        4.5333182,
        4.75794207,
        4.43121644,
        3.68980057,
        2.83057498,
        1.02101761,
        0.04555309,
        0.18064158,
        -0.02199115,
        0.40840704,
        0.80896011,
        0.94561939,
        0.69272118,
        0.49480084,
        0.44610616,
        -0.0408407,
        -1.22836273,
        -2.37975644,
        -3.24212362,
        -4.06836249,
        -5.40353936,
        -6.76227819,
        -7.06544188,
        -6.70572952,
        -5.23703495,
        -1.99805293,
        0.25289821,
        1.52053084,
        1.53623881,
        0.01413717,
        -0.73356188,
    ]
)

if __name__ == "__main__":
    t = np.linspace(0.0, 1.0, len(v1))
    uplot.plot2(
        t,
        left=[v1, v2],
        right=[u],
        title="Plot with left and right axes",
        left_labels=["v1", "v2"],
        right_labels=["u"],
    )
