# coding: utf-8

"""
    Upstox Developer API

    Build your App on the Upstox platform  ![Banner](https://api-v2.upstox.com/api-docs/images/banner.jpg \"banner\")  # Introduction  Upstox API is a set of rest APIs that provide data required to build a complete investment and trading platform. Execute orders in real time, manage user portfolio, stream live market data (using Websocket), and more, with the easy to understand API collection.  All requests are over HTTPS and the requests are sent with the content-type ‘application/json’. Developers have the option of choosing the response type as JSON or CSV for a few API calls.  To be able to use these APIs you need to create an App in the Developer Console and generate your **apiKey** and **apiSecret**. You can use a redirect URL which will be called after the login flow.  If you are a **trader**, you can directly create apps from Upstox mobile app or the desktop platform itself from **Apps** sections inside the **Account** Tab. Head over to <a href=\"http://account.upstox.com/developer/apps\" target=\"_blank\">account.upstox.com/developer/apps</a>.</br> If you are a **business** looking to integrate Upstox APIs, reach out to us and we will get a custom app created for you in no time.  It is highly recommended that you do not embed the **apiSecret** in your frontend app. Create a remote backend which does the handshake on behalf of the frontend app. Marking the apiSecret in the frontend app will make your app vulnerable to threats and potential issues.   # noqa: E501

    OpenAPI spec version: v2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class TokenRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'code': 'str',
        'client_id': 'str',
        'client_secret': 'str',
        'redirect_uri': 'str',
        'grant_type': 'str'
    }

    attribute_map = {
        'code': 'code',
        'client_id': 'client_id',
        'client_secret': 'client_secret',
        'redirect_uri': 'redirect_uri',
        'grant_type': 'grant_type'
    }

    def __init__(self, code=None, client_id=None, client_secret=None, redirect_uri=None, grant_type=None):  # noqa: E501
        """TokenRequest - a model defined in Swagger"""  # noqa: E501
        self._code = None
        self._client_id = None
        self._client_secret = None
        self._redirect_uri = None
        self._grant_type = None
        self.discriminator = None
        self.code = code
        self.client_id = client_id
        self.client_secret = client_secret
        self.redirect_uri = redirect_uri
        self.grant_type = grant_type

    @property
    def code(self):
        """Gets the code of this TokenRequest.  # noqa: E501


        :return: The code of this TokenRequest.  # noqa: E501
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """Sets the code of this TokenRequest.


        :param code: The code of this TokenRequest.  # noqa: E501
        :type: str
        """
        if code is None:
            raise ValueError("Invalid value for `code`, must not be `None`")  # noqa: E501

        self._code = code

    @property
    def client_id(self):
        """Gets the client_id of this TokenRequest.  # noqa: E501

        OAuth API key that is a public identifier for app  # noqa: E501

        :return: The client_id of this TokenRequest.  # noqa: E501
        :rtype: str
        """
        return self._client_id

    @client_id.setter
    def client_id(self, client_id):
        """Sets the client_id of this TokenRequest.

        OAuth API key that is a public identifier for app  # noqa: E501

        :param client_id: The client_id of this TokenRequest.  # noqa: E501
        :type: str
        """
        if client_id is None:
            raise ValueError("Invalid value for `client_id`, must not be `None`")  # noqa: E501

        self._client_id = client_id

    @property
    def client_secret(self):
        """Gets the client_secret of this TokenRequest.  # noqa: E501

        OAuth client secret that is a private secret known only to app and authorization server  # noqa: E501

        :return: The client_secret of this TokenRequest.  # noqa: E501
        :rtype: str
        """
        return self._client_secret

    @client_secret.setter
    def client_secret(self, client_secret):
        """Sets the client_secret of this TokenRequest.

        OAuth client secret that is a private secret known only to app and authorization server  # noqa: E501

        :param client_secret: The client_secret of this TokenRequest.  # noqa: E501
        :type: str
        """
        if client_secret is None:
            raise ValueError("Invalid value for `client_secret`, must not be `None`")  # noqa: E501

        self._client_secret = client_secret

    @property
    def redirect_uri(self):
        """Gets the redirect_uri of this TokenRequest.  # noqa: E501

        Authorization server will redirect the user back to the application via redirect url  # noqa: E501

        :return: The redirect_uri of this TokenRequest.  # noqa: E501
        :rtype: str
        """
        return self._redirect_uri

    @redirect_uri.setter
    def redirect_uri(self, redirect_uri):
        """Sets the redirect_uri of this TokenRequest.

        Authorization server will redirect the user back to the application via redirect url  # noqa: E501

        :param redirect_uri: The redirect_uri of this TokenRequest.  # noqa: E501
        :type: str
        """
        if redirect_uri is None:
            raise ValueError("Invalid value for `redirect_uri`, must not be `None`")  # noqa: E501

        self._redirect_uri = redirect_uri

    @property
    def grant_type(self):
        """Gets the grant_type of this TokenRequest.  # noqa: E501

        Type of grant used to get an access token  # noqa: E501

        :return: The grant_type of this TokenRequest.  # noqa: E501
        :rtype: str
        """
        return self._grant_type

    @grant_type.setter
    def grant_type(self, grant_type):
        """Sets the grant_type of this TokenRequest.

        Type of grant used to get an access token  # noqa: E501

        :param grant_type: The grant_type of this TokenRequest.  # noqa: E501
        :type: str
        """
        if grant_type is None:
            raise ValueError("Invalid value for `grant_type`, must not be `None`")  # noqa: E501

        self._grant_type = grant_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TokenRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TokenRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
