# coding: utf-8

"""
    Upstox Developer API

    Build your App on the Upstox platform  ![Banner](https://api-v2.upstox.com/api-docs/images/banner.jpg \"banner\")  # Introduction  Upstox API is a set of rest APIs that provide data required to build a complete investment and trading platform. Execute orders in real time, manage user portfolio, stream live market data (using Websocket), and more, with the easy to understand API collection.  All requests are over HTTPS and the requests are sent with the content-type ‘application/json’. Developers have the option of choosing the response type as JSON or CSV for a few API calls.  To be able to use these APIs you need to create an App in the Developer Console and generate your **apiKey** and **apiSecret**. You can use a redirect URL which will be called after the login flow.  If you are a **trader**, you can directly create apps from Upstox mobile app or the desktop platform itself from **Apps** sections inside the **Account** Tab. Head over to <a href=\"http://account.upstox.com/developer/apps\" target=\"_blank\">account.upstox.com/developer/apps</a>.</br> If you are a **business** looking to integrate Upstox APIs, reach out to us and we will get a custom app created for you in no time.  It is highly recommended that you do not embed the **apiSecret** in your frontend app. Create a remote backend which does the handshake on behalf of the frontend app. Marking the apiSecret in the frontend app will make your app vulnerable to threats and potential issues.   # noqa: E501

    OpenAPI spec version: v2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from upstox_client.api_client import ApiClient


class TradeProfitAndLossApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_profit_and_loss_charges(self, segment, financial_year, api_version, **kwargs):  # noqa: E501
        """Get profit and loss on trades  # noqa: E501

        This API gives the charges incurred by users for their trades  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_profit_and_loss_charges(segment, financial_year, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str segment: Segment for which data is requested can be from the following options EQ - Equity,   FO - Futures and Options,   COM  - Commodity,   CD - Currency Derivatives (required)
        :param str financial_year: Financial year for which data has been requested. Concatenation of last 2 digits of from year and to year Sample:for 2021-2022, financial_year will be 2122 (required)
        :param str api_version: API Version Header (required)
        :param str from_date: Date from which data needs to be fetched. from_date and to_date should fall under the same financial year as mentioned in financial_year attribute. Date in dd-mm-yyyy format
        :param str to_date: Date till which data needs to be fetched. from_date and to_date should fall under the same financial year as mentioned in financial_year attribute. Date in dd-mm-yyyy format
        :return: GetProfitAndLossChargesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_profit_and_loss_charges_with_http_info(segment, financial_year, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.get_profit_and_loss_charges_with_http_info(segment, financial_year, api_version, **kwargs)  # noqa: E501
            return data

    def get_profit_and_loss_charges_with_http_info(self, segment, financial_year, api_version, **kwargs):  # noqa: E501
        """Get profit and loss on trades  # noqa: E501

        This API gives the charges incurred by users for their trades  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_profit_and_loss_charges_with_http_info(segment, financial_year, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str segment: Segment for which data is requested can be from the following options EQ - Equity,   FO - Futures and Options,   COM  - Commodity,   CD - Currency Derivatives (required)
        :param str financial_year: Financial year for which data has been requested. Concatenation of last 2 digits of from year and to year Sample:for 2021-2022, financial_year will be 2122 (required)
        :param str api_version: API Version Header (required)
        :param str from_date: Date from which data needs to be fetched. from_date and to_date should fall under the same financial year as mentioned in financial_year attribute. Date in dd-mm-yyyy format
        :param str to_date: Date till which data needs to be fetched. from_date and to_date should fall under the same financial year as mentioned in financial_year attribute. Date in dd-mm-yyyy format
        :return: GetProfitAndLossChargesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['segment', 'financial_year', 'api_version', 'from_date', 'to_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_profit_and_loss_charges" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'segment' is set
        if ('segment' not in params or
                params['segment'] is None):
            raise ValueError("Missing the required parameter `segment` when calling `get_profit_and_loss_charges`")  # noqa: E501
        # verify the required parameter 'financial_year' is set
        if ('financial_year' not in params or
                params['financial_year'] is None):
            raise ValueError("Missing the required parameter `financial_year` when calling `get_profit_and_loss_charges`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `get_profit_and_loss_charges`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'from_date' in params:
            query_params.append(('from_date', params['from_date']))  # noqa: E501
        if 'to_date' in params:
            query_params.append(('to_date', params['to_date']))  # noqa: E501
        if 'segment' in params:
            query_params.append(('segment', params['segment']))  # noqa: E501
        if 'financial_year' in params:
            query_params.append(('financial_year', params['financial_year']))  # noqa: E501

        header_params = {}
        if 'api_version' in params:
            header_params['Api-Version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', '*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAUTH2']  # noqa: E501

        return self.api_client.call_api(
            '/trade/profit-loss/charges', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetProfitAndLossChargesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_trade_wise_profit_and_loss_data(self, segment, financial_year, page_number, page_size, api_version, **kwargs):  # noqa: E501
        """Get Trade-wise Profit and Loss Report Data  # noqa: E501

        This API gives the data of the realised Profit and Loss report requested by a user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trade_wise_profit_and_loss_data(segment, financial_year, page_number, page_size, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str segment: Segment for which data is requested can be from the following options EQ - Equity,   FO - Futures and Options,   COM  - Commodity,   CD - Currency Derivatives (required)
        :param str financial_year: Financial year for which data has been requested. Concatenation of last 2 digits of from year and to year Sample:for 2021-2022, financial_year will be 2122 (required)
        :param int page_number: Page Number, the pages are starting from 1 (required)
        :param int page_size: Page size for pagination. The maximum page size value is obtained from P and L report metadata API. (required)
        :param str api_version: API Version Header (required)
        :param str from_date: Date from which data needs to be fetched. from_date and to_date should fall under the same financial year as mentioned in financial_year attribute. Date in dd-mm-yyyy format
        :param str to_date: Date till which data needs to be fetched. from_date and to_date should fall under the same financial year as mentioned in financial_year attribute. Date in dd-mm-yyyy format
        :return: GetTradeWiseProfitAndLossDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_trade_wise_profit_and_loss_data_with_http_info(segment, financial_year, page_number, page_size, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.get_trade_wise_profit_and_loss_data_with_http_info(segment, financial_year, page_number, page_size, api_version, **kwargs)  # noqa: E501
            return data

    def get_trade_wise_profit_and_loss_data_with_http_info(self, segment, financial_year, page_number, page_size, api_version, **kwargs):  # noqa: E501
        """Get Trade-wise Profit and Loss Report Data  # noqa: E501

        This API gives the data of the realised Profit and Loss report requested by a user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trade_wise_profit_and_loss_data_with_http_info(segment, financial_year, page_number, page_size, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str segment: Segment for which data is requested can be from the following options EQ - Equity,   FO - Futures and Options,   COM  - Commodity,   CD - Currency Derivatives (required)
        :param str financial_year: Financial year for which data has been requested. Concatenation of last 2 digits of from year and to year Sample:for 2021-2022, financial_year will be 2122 (required)
        :param int page_number: Page Number, the pages are starting from 1 (required)
        :param int page_size: Page size for pagination. The maximum page size value is obtained from P and L report metadata API. (required)
        :param str api_version: API Version Header (required)
        :param str from_date: Date from which data needs to be fetched. from_date and to_date should fall under the same financial year as mentioned in financial_year attribute. Date in dd-mm-yyyy format
        :param str to_date: Date till which data needs to be fetched. from_date and to_date should fall under the same financial year as mentioned in financial_year attribute. Date in dd-mm-yyyy format
        :return: GetTradeWiseProfitAndLossDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['segment', 'financial_year', 'page_number', 'page_size', 'api_version', 'from_date', 'to_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trade_wise_profit_and_loss_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'segment' is set
        if ('segment' not in params or
                params['segment'] is None):
            raise ValueError("Missing the required parameter `segment` when calling `get_trade_wise_profit_and_loss_data`")  # noqa: E501
        # verify the required parameter 'financial_year' is set
        if ('financial_year' not in params or
                params['financial_year'] is None):
            raise ValueError("Missing the required parameter `financial_year` when calling `get_trade_wise_profit_and_loss_data`")  # noqa: E501
        # verify the required parameter 'page_number' is set
        if ('page_number' not in params or
                params['page_number'] is None):
            raise ValueError("Missing the required parameter `page_number` when calling `get_trade_wise_profit_and_loss_data`")  # noqa: E501
        # verify the required parameter 'page_size' is set
        if ('page_size' not in params or
                params['page_size'] is None):
            raise ValueError("Missing the required parameter `page_size` when calling `get_trade_wise_profit_and_loss_data`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `get_trade_wise_profit_and_loss_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'from_date' in params:
            query_params.append(('from_date', params['from_date']))  # noqa: E501
        if 'to_date' in params:
            query_params.append(('to_date', params['to_date']))  # noqa: E501
        if 'segment' in params:
            query_params.append(('segment', params['segment']))  # noqa: E501
        if 'financial_year' in params:
            query_params.append(('financial_year', params['financial_year']))  # noqa: E501
        if 'page_number' in params:
            query_params.append(('page_number', params['page_number']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}
        if 'api_version' in params:
            header_params['Api-Version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', '*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAUTH2']  # noqa: E501

        return self.api_client.call_api(
            '/trade/profit-loss/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetTradeWiseProfitAndLossDataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_trade_wise_profit_and_loss_meta_data(self, segment, financial_year, api_version, **kwargs):  # noqa: E501
        """Get profit and loss meta data on trades  # noqa: E501

        This API gives the data of the realised Profit and Loss report requested by a user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trade_wise_profit_and_loss_meta_data(segment, financial_year, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str segment: Segment for which data is requested can be from the following options EQ - Equity,   FO - Futures and Options,   COM  - Commodity,   CD - Currency Derivatives (required)
        :param str financial_year: Financial year for which data has been requested. Concatenation of last 2 digits of from year and to year Sample:for 2021-2022, financial_year will be 2122 (required)
        :param str api_version: API Version Header (required)
        :param str from_date: Date from which data needs to be fetched. from_date and to_date should fall under the same financial year as mentioned in financial_year attribute. Date in dd-mm-yyyy format
        :param str to_date: Date till which data needs to be fetched. from_date and to_date should fall under the same financial year as mentioned in financial_year attribute. Date in dd-mm-yyyy format
        :return: GetTradeWiseProfitAndLossMetaDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_trade_wise_profit_and_loss_meta_data_with_http_info(segment, financial_year, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.get_trade_wise_profit_and_loss_meta_data_with_http_info(segment, financial_year, api_version, **kwargs)  # noqa: E501
            return data

    def get_trade_wise_profit_and_loss_meta_data_with_http_info(self, segment, financial_year, api_version, **kwargs):  # noqa: E501
        """Get profit and loss meta data on trades  # noqa: E501

        This API gives the data of the realised Profit and Loss report requested by a user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trade_wise_profit_and_loss_meta_data_with_http_info(segment, financial_year, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str segment: Segment for which data is requested can be from the following options EQ - Equity,   FO - Futures and Options,   COM  - Commodity,   CD - Currency Derivatives (required)
        :param str financial_year: Financial year for which data has been requested. Concatenation of last 2 digits of from year and to year Sample:for 2021-2022, financial_year will be 2122 (required)
        :param str api_version: API Version Header (required)
        :param str from_date: Date from which data needs to be fetched. from_date and to_date should fall under the same financial year as mentioned in financial_year attribute. Date in dd-mm-yyyy format
        :param str to_date: Date till which data needs to be fetched. from_date and to_date should fall under the same financial year as mentioned in financial_year attribute. Date in dd-mm-yyyy format
        :return: GetTradeWiseProfitAndLossMetaDataResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['segment', 'financial_year', 'api_version', 'from_date', 'to_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trade_wise_profit_and_loss_meta_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'segment' is set
        if ('segment' not in params or
                params['segment'] is None):
            raise ValueError("Missing the required parameter `segment` when calling `get_trade_wise_profit_and_loss_meta_data`")  # noqa: E501
        # verify the required parameter 'financial_year' is set
        if ('financial_year' not in params or
                params['financial_year'] is None):
            raise ValueError("Missing the required parameter `financial_year` when calling `get_trade_wise_profit_and_loss_meta_data`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if ('api_version' not in params or
                params['api_version'] is None):
            raise ValueError("Missing the required parameter `api_version` when calling `get_trade_wise_profit_and_loss_meta_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'from_date' in params:
            query_params.append(('from_date', params['from_date']))  # noqa: E501
        if 'to_date' in params:
            query_params.append(('to_date', params['to_date']))  # noqa: E501
        if 'segment' in params:
            query_params.append(('segment', params['segment']))  # noqa: E501
        if 'financial_year' in params:
            query_params.append(('financial_year', params['financial_year']))  # noqa: E501

        header_params = {}
        if 'api_version' in params:
            header_params['Api-Version'] = params['api_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', '*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAUTH2']  # noqa: E501

        return self.api_client.call_api(
            '/trade/profit-loss/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetTradeWiseProfitAndLossMetaDataResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
