# coding: utf-8

"""
    OpenAPI definition

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from upstox_client.api_client import ApiClient


class ExpiredInstrumentApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_expired_future_contracts(self, instrument_key, expiry_date, **kwargs):  # noqa: E501
        """Expired instruments - Get future contracts  # noqa: E501

        This API provides the functionality to retrieve expired future contracts for a given instrument key and expiry date.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_expired_future_contracts(instrument_key, expiry_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instrument_key: Instrument Key of asset (required)
        :param str expiry_date: Expiry date of the instrument (required)
        :return: GetExpiredFuturesContractResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_expired_future_contracts_with_http_info(instrument_key, expiry_date, **kwargs)  # noqa: E501
        else:
            (data) = self.get_expired_future_contracts_with_http_info(instrument_key, expiry_date, **kwargs)  # noqa: E501
            return data

    def get_expired_future_contracts_with_http_info(self, instrument_key, expiry_date, **kwargs):  # noqa: E501
        """Expired instruments - Get future contracts  # noqa: E501

        This API provides the functionality to retrieve expired future contracts for a given instrument key and expiry date.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_expired_future_contracts_with_http_info(instrument_key, expiry_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instrument_key: Instrument Key of asset (required)
        :param str expiry_date: Expiry date of the instrument (required)
        :return: GetExpiredFuturesContractResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrument_key', 'expiry_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_expired_future_contracts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrument_key' is set
        if ('instrument_key' not in params or
                params['instrument_key'] is None):
            raise ValueError("Missing the required parameter `instrument_key` when calling `get_expired_future_contracts`")  # noqa: E501
        # verify the required parameter 'expiry_date' is set
        if ('expiry_date' not in params or
                params['expiry_date'] is None):
            raise ValueError("Missing the required parameter `expiry_date` when calling `get_expired_future_contracts`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'instrument_key' in params:
            query_params.append(('instrument_key', params['instrument_key']))  # noqa: E501
        if 'expiry_date' in params:
            query_params.append(('expiry_date', params['expiry_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', '*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAUTH2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/expired-instruments/future/contract', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetExpiredFuturesContractResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_expired_historical_candle_data(self, expired_instrument_key, interval, to_date, from_date, **kwargs):  # noqa: E501
        """Expired Historical candle data  # noqa: E501

        Get Expired OHLC values for all instruments across various timeframes. Expired Historical data can be fetched for the following durations. 1minute: last 1 month candles till endDate 30minute: last 1 year candles till endDate day: last 1 year candles till endDate week: last 10 year candles till endDate month: last 10 year candles till endDate  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_expired_historical_candle_data(expired_instrument_key, interval, to_date, from_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str expired_instrument_key: Expired Instrument Key of asset (required)
        :param str interval: Interval to get expired ohlc data (required)
        :param str to_date: to date (required)
        :param str from_date: from date (required)
        :return: GetHistoricalCandleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_expired_historical_candle_data_with_http_info(expired_instrument_key, interval, to_date, from_date, **kwargs)  # noqa: E501
        else:
            (data) = self.get_expired_historical_candle_data_with_http_info(expired_instrument_key, interval, to_date, from_date, **kwargs)  # noqa: E501
            return data

    def get_expired_historical_candle_data_with_http_info(self, expired_instrument_key, interval, to_date, from_date, **kwargs):  # noqa: E501
        """Expired Historical candle data  # noqa: E501

        Get Expired OHLC values for all instruments across various timeframes. Expired Historical data can be fetched for the following durations. 1minute: last 1 month candles till endDate 30minute: last 1 year candles till endDate day: last 1 year candles till endDate week: last 10 year candles till endDate month: last 10 year candles till endDate  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_expired_historical_candle_data_with_http_info(expired_instrument_key, interval, to_date, from_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str expired_instrument_key: Expired Instrument Key of asset (required)
        :param str interval: Interval to get expired ohlc data (required)
        :param str to_date: to date (required)
        :param str from_date: from date (required)
        :return: GetHistoricalCandleResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['expired_instrument_key', 'interval', 'to_date', 'from_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_expired_historical_candle_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'expired_instrument_key' is set
        if ('expired_instrument_key' not in params or
                params['expired_instrument_key'] is None):
            raise ValueError("Missing the required parameter `expired_instrument_key` when calling `get_expired_historical_candle_data`")  # noqa: E501
        # verify the required parameter 'interval' is set
        if ('interval' not in params or
                params['interval'] is None):
            raise ValueError("Missing the required parameter `interval` when calling `get_expired_historical_candle_data`")  # noqa: E501
        # verify the required parameter 'to_date' is set
        if ('to_date' not in params or
                params['to_date'] is None):
            raise ValueError("Missing the required parameter `to_date` when calling `get_expired_historical_candle_data`")  # noqa: E501
        # verify the required parameter 'from_date' is set
        if ('from_date' not in params or
                params['from_date'] is None):
            raise ValueError("Missing the required parameter `from_date` when calling `get_expired_historical_candle_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'expired_instrument_key' in params:
            path_params['expired_instrument_key'] = params['expired_instrument_key']  # noqa: E501
        if 'interval' in params:
            path_params['interval'] = params['interval']  # noqa: E501
        if 'to_date' in params:
            path_params['to_date'] = params['to_date']  # noqa: E501
        if 'from_date' in params:
            path_params['from_date'] = params['from_date']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', '*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAUTH2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/expired-instruments/historical-candle/{expired_instrument_key}/{interval}/{to_date}/{from_date}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetHistoricalCandleResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_expired_option_contracts(self, instrument_key, expiry_date, **kwargs):  # noqa: E501
        """Get expired option contracts  # noqa: E501

        This API provides the functionality to retrieve the expired option contracts  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_expired_option_contracts(instrument_key, expiry_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instrument_key: Instrument key for an underlying symbol (required)
        :param str expiry_date: Expiry date in format: YYYY-mm-dd (required)
        :return: GetOptionContractResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_expired_option_contracts_with_http_info(instrument_key, expiry_date, **kwargs)  # noqa: E501
        else:
            (data) = self.get_expired_option_contracts_with_http_info(instrument_key, expiry_date, **kwargs)  # noqa: E501
            return data

    def get_expired_option_contracts_with_http_info(self, instrument_key, expiry_date, **kwargs):  # noqa: E501
        """Get expired option contracts  # noqa: E501

        This API provides the functionality to retrieve the expired option contracts  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_expired_option_contracts_with_http_info(instrument_key, expiry_date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instrument_key: Instrument key for an underlying symbol (required)
        :param str expiry_date: Expiry date in format: YYYY-mm-dd (required)
        :return: GetOptionContractResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrument_key', 'expiry_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_expired_option_contracts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrument_key' is set
        if ('instrument_key' not in params or
                params['instrument_key'] is None):
            raise ValueError("Missing the required parameter `instrument_key` when calling `get_expired_option_contracts`")  # noqa: E501
        # verify the required parameter 'expiry_date' is set
        if ('expiry_date' not in params or
                params['expiry_date'] is None):
            raise ValueError("Missing the required parameter `expiry_date` when calling `get_expired_option_contracts`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'instrument_key' in params:
            query_params.append(('instrument_key', params['instrument_key']))  # noqa: E501
        if 'expiry_date' in params:
            query_params.append(('expiry_date', params['expiry_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', '*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAUTH2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/expired-instruments/option/contract', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetOptionContractResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_expiries(self, instrument_key, **kwargs):  # noqa: E501
        """Expired instruments - Get expiries  # noqa: E501

        This API provides the functionality to retrieve expiry dates for a given instrument key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_expiries(instrument_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instrument_key: Instrument Key of asset (required)
        :return: GetExpiriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_expiries_with_http_info(instrument_key, **kwargs)  # noqa: E501
        else:
            (data) = self.get_expiries_with_http_info(instrument_key, **kwargs)  # noqa: E501
            return data

    def get_expiries_with_http_info(self, instrument_key, **kwargs):  # noqa: E501
        """Expired instruments - Get expiries  # noqa: E501

        This API provides the functionality to retrieve expiry dates for a given instrument key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_expiries_with_http_info(instrument_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str instrument_key: Instrument Key of asset (required)
        :return: GetExpiriesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instrument_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_expiries" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instrument_key' is set
        if ('instrument_key' not in params or
                params['instrument_key'] is None):
            raise ValueError("Missing the required parameter `instrument_key` when calling `get_expiries`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'instrument_key' in params:
            query_params.append(('instrument_key', params['instrument_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', '*/*'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAUTH2']  # noqa: E501

        return self.api_client.call_api(
            '/v2/expired-instruments/expiries', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetExpiriesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
