# coding: utf-8

"""
    Upstox Developer API

    Build your App on the Upstox platform  ![Banner](https://api.upstox.com/api-docs/images/banner.jpg \"banner\")  # Introduction  Upstox API is a set of rest APIs that provide data required to build a complete investment and trading platform. Execute orders in real time, manage user portfolio, stream live market data (using Websocket), and more, with the easy to understand API collection.  All requests are over HTTPS and the requests are sent with the content-type ‘application/json’. Developers have the option of choosing the response type as JSON or CSV for a few API calls.  To be able to use these APIs you need to create an App in the Developer Console and generate your **apiKey** and **apiSecret**. You can use a redirect URL which will be called after the login flow.  If you are a **trader**, you can directly create apps from Upstox mobile app or the desktop platform itself from **Apps** sections inside the **Account** Tab. Head over to <a href=\"http://account.upstox.com/developer/apps\" target=\"_blank\">account.upstox.com/developer/apps</a>.</br> If you are a **business** looking to integrate Upstox APIs, reach out to us and we will get a custom app created for you in no time.  It is highly recommended that you do not embed the **apiSecret** in your frontend app. Create a remote backend which does the handshake on behalf of the frontend app. Marking the apiSecret in the frontend app will make your app vulnerable to threats and potential issues.   # noqa: E501

    OpenAPI spec version: v2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ModifyOrderRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'quantity': 'int',
        'validity': 'str',
        'price': 'float',
        'order_id': 'str',
        'order_type': 'str',
        'disclosed_quantity': 'int',
        'trigger_price': 'float'
    }

    attribute_map = {
        'quantity': 'quantity',
        'validity': 'validity',
        'price': 'price',
        'order_id': 'order_id',
        'order_type': 'order_type',
        'disclosed_quantity': 'disclosed_quantity',
        'trigger_price': 'trigger_price'
    }

    def __init__(self, quantity=None, validity=None, price=None, order_id=None, order_type=None, disclosed_quantity=None, trigger_price=None):  # noqa: E501
        """ModifyOrderRequest - a model defined in Swagger"""  # noqa: E501
        self._quantity = None
        self._validity = None
        self._price = None
        self._order_id = None
        self._order_type = None
        self._disclosed_quantity = None
        self._trigger_price = None
        self.discriminator = None
        if quantity is not None:
            self.quantity = quantity
        self.validity = validity
        self.price = price
        self.order_id = order_id
        self.order_type = order_type
        if disclosed_quantity is not None:
            self.disclosed_quantity = disclosed_quantity
        self.trigger_price = trigger_price

    @property
    def quantity(self):
        """Gets the quantity of this ModifyOrderRequest.  # noqa: E501

        Quantity with which the order was placed  # noqa: E501

        :return: The quantity of this ModifyOrderRequest.  # noqa: E501
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this ModifyOrderRequest.

        Quantity with which the order was placed  # noqa: E501

        :param quantity: The quantity of this ModifyOrderRequest.  # noqa: E501
        :type: int
        """

        self._quantity = quantity

    @property
    def validity(self):
        """Gets the validity of this ModifyOrderRequest.  # noqa: E501

        Order validity (DAY- Day and IOC- Immediate or Cancel (IOC) order)  # noqa: E501

        :return: The validity of this ModifyOrderRequest.  # noqa: E501
        :rtype: str
        """
        return self._validity

    @validity.setter
    def validity(self, validity):
        """Sets the validity of this ModifyOrderRequest.

        Order validity (DAY- Day and IOC- Immediate or Cancel (IOC) order)  # noqa: E501

        :param validity: The validity of this ModifyOrderRequest.  # noqa: E501
        :type: str
        """
        if validity is None:
            raise ValueError("Invalid value for `validity`, must not be `None`")  # noqa: E501
        allowed_values = ["DAY", "IOC"]  # noqa: E501
        if validity not in allowed_values:
            raise ValueError(
                "Invalid value for `validity` ({0}), must be one of {1}"  # noqa: E501
                .format(validity, allowed_values)
            )

        self._validity = validity

    @property
    def price(self):
        """Gets the price of this ModifyOrderRequest.  # noqa: E501

        Price at which the order was placed  # noqa: E501

        :return: The price of this ModifyOrderRequest.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this ModifyOrderRequest.

        Price at which the order was placed  # noqa: E501

        :param price: The price of this ModifyOrderRequest.  # noqa: E501
        :type: float
        """
        if price is None:
            raise ValueError("Invalid value for `price`, must not be `None`")  # noqa: E501

        self._price = price

    @property
    def order_id(self):
        """Gets the order_id of this ModifyOrderRequest.  # noqa: E501

        The order ID for which the order must be modified  # noqa: E501

        :return: The order_id of this ModifyOrderRequest.  # noqa: E501
        :rtype: str
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """Sets the order_id of this ModifyOrderRequest.

        The order ID for which the order must be modified  # noqa: E501

        :param order_id: The order_id of this ModifyOrderRequest.  # noqa: E501
        :type: str
        """
        if order_id is None:
            raise ValueError("Invalid value for `order_id`, must not be `None`")  # noqa: E501

        self._order_id = order_id

    @property
    def order_type(self):
        """Gets the order_type of this ModifyOrderRequest.  # noqa: E501

        Type of order. It can be one of the following MARKET refers to market order LIMILT refers to Limit Order SL refers to Stop Loss Limit SL-M refers to Stop Loss Market  # noqa: E501

        :return: The order_type of this ModifyOrderRequest.  # noqa: E501
        :rtype: str
        """
        return self._order_type

    @order_type.setter
    def order_type(self, order_type):
        """Sets the order_type of this ModifyOrderRequest.

        Type of order. It can be one of the following MARKET refers to market order LIMILT refers to Limit Order SL refers to Stop Loss Limit SL-M refers to Stop Loss Market  # noqa: E501

        :param order_type: The order_type of this ModifyOrderRequest.  # noqa: E501
        :type: str
        """
        if order_type is None:
            raise ValueError("Invalid value for `order_type`, must not be `None`")  # noqa: E501
        allowed_values = ["MARKET", "LIMIT", "SL", "SL-M"]  # noqa: E501
        if order_type not in allowed_values:
            raise ValueError(
                "Invalid value for `order_type` ({0}), must be one of {1}"  # noqa: E501
                .format(order_type, allowed_values)
            )

        self._order_type = order_type

    @property
    def disclosed_quantity(self):
        """Gets the disclosed_quantity of this ModifyOrderRequest.  # noqa: E501

        The quantity that should be disclosed in the market depth  # noqa: E501

        :return: The disclosed_quantity of this ModifyOrderRequest.  # noqa: E501
        :rtype: int
        """
        return self._disclosed_quantity

    @disclosed_quantity.setter
    def disclosed_quantity(self, disclosed_quantity):
        """Sets the disclosed_quantity of this ModifyOrderRequest.

        The quantity that should be disclosed in the market depth  # noqa: E501

        :param disclosed_quantity: The disclosed_quantity of this ModifyOrderRequest.  # noqa: E501
        :type: int
        """

        self._disclosed_quantity = disclosed_quantity

    @property
    def trigger_price(self):
        """Gets the trigger_price of this ModifyOrderRequest.  # noqa: E501

        If the order is a stop loss order then the trigger price to be set is mentioned here  # noqa: E501

        :return: The trigger_price of this ModifyOrderRequest.  # noqa: E501
        :rtype: float
        """
        return self._trigger_price

    @trigger_price.setter
    def trigger_price(self, trigger_price):
        """Sets the trigger_price of this ModifyOrderRequest.

        If the order is a stop loss order then the trigger price to be set is mentioned here  # noqa: E501

        :param trigger_price: The trigger_price of this ModifyOrderRequest.  # noqa: E501
        :type: float
        """
        if trigger_price is None:
            raise ValueError("Invalid value for `trigger_price`, must not be `None`")  # noqa: E501

        self._trigger_price = trigger_price

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ModifyOrderRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ModifyOrderRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
