# coding: utf-8

"""
    Upstox Developer API

    Build your App on the Upstox platform  ![Banner](https://api.upstox.com/api-docs/images/banner.jpg \"banner\")  # Introduction  Upstox API is a set of rest APIs that provide data required to build a complete investment and trading platform. Execute orders in real time, manage user portfolio, stream live market data (using Websocket), and more, with the easy to understand API collection.  All requests are over HTTPS and the requests are sent with the content-type ‘application/json’. Developers have the option of choosing the response type as JSON or CSV for a few API calls.  To be able to use these APIs you need to create an App in the Developer Console and generate your **apiKey** and **apiSecret**. You can use a redirect URL which will be called after the login flow.  If you are a **trader**, you can directly create apps from Upstox mobile app or the desktop platform itself from **Apps** sections inside the **Account** Tab. Head over to <a href=\"http://account.upstox.com/developer/apps\" target=\"_blank\">account.upstox.com/developer/apps</a>.</br> If you are a **business** looking to integrate Upstox APIs, reach out to us and we will get a custom app created for you in no time.  It is highly recommended that you do not embed the **apiSecret** in your frontend app. Create a remote backend which does the handshake on behalf of the frontend app. Marking the apiSecret in the frontend app will make your app vulnerable to threats and potential issues.   # noqa: E501

    OpenAPI spec version: v2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class TradeWiseMetaData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'trades_count': 'int',
        'page_size_limit': 'int'
    }

    attribute_map = {
        'trades_count': 'trades_count',
        'page_size_limit': 'page_size_limit'
    }

    def __init__(self, trades_count=None, page_size_limit=None):  # noqa: E501
        """TradeWiseMetaData - a model defined in Swagger"""  # noqa: E501
        self._trades_count = None
        self._page_size_limit = None
        self.discriminator = None
        if trades_count is not None:
            self.trades_count = trades_count
        if page_size_limit is not None:
            self.page_size_limit = page_size_limit

    @property
    def trades_count(self):
        """Gets the trades_count of this TradeWiseMetaData.  # noqa: E501

        Total count of trades in the trade wise P and L report  # noqa: E501

        :return: The trades_count of this TradeWiseMetaData.  # noqa: E501
        :rtype: int
        """
        return self._trades_count

    @trades_count.setter
    def trades_count(self, trades_count):
        """Sets the trades_count of this TradeWiseMetaData.

        Total count of trades in the trade wise P and L report  # noqa: E501

        :param trades_count: The trades_count of this TradeWiseMetaData.  # noqa: E501
        :type: int
        """

        self._trades_count = trades_count

    @property
    def page_size_limit(self):
        """Gets the page_size_limit of this TradeWiseMetaData.  # noqa: E501

        Maximum number of trades in a page of the trade wise P and L report API  # noqa: E501

        :return: The page_size_limit of this TradeWiseMetaData.  # noqa: E501
        :rtype: int
        """
        return self._page_size_limit

    @page_size_limit.setter
    def page_size_limit(self, page_size_limit):
        """Sets the page_size_limit of this TradeWiseMetaData.

        Maximum number of trades in a page of the trade wise P and L report API  # noqa: E501

        :param page_size_limit: The page_size_limit of this TradeWiseMetaData.  # noqa: E501
        :type: int
        """

        self._page_size_limit = page_size_limit

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TradeWiseMetaData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TradeWiseMetaData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
