# coding: utf-8

"""
    Upstox Developer API

    Build your App on the Upstox platform  ![Banner](https://api.upstox.com/api-docs/images/banner.jpg \"banner\")  # Introduction  Upstox API is a set of rest APIs that provide data required to build a complete investment and trading platform. Execute orders in real time, manage user portfolio, stream live market data (using Websocket), and more, with the easy to understand API collection.  All requests are over HTTPS and the requests are sent with the content-type ‘application/json’. Developers have the option of choosing the response type as JSON or CSV for a few API calls.  To be able to use these APIs you need to create an App in the Developer Console and generate your **apiKey** and **apiSecret**. You can use a redirect URL which will be called after the login flow.  If you are a **trader**, you can directly create apps from Upstox mobile app or the desktop platform itself from **Apps** sections inside the **Account** Tab. Head over to <a href=\"http://account.upstox.com/developer/apps\" target=\"_blank\">account.upstox.com/developer/apps</a>.</br> If you are a **business** looking to integrate Upstox APIs, reach out to us and we will get a custom app created for you in no time.  It is highly recommended that you do not embed the **apiSecret** in your frontend app. Create a remote backend which does the handshake on behalf of the frontend app. Marking the apiSecret in the frontend app will make your app vulnerable to threats and potential issues.   # noqa: E501

    OpenAPI spec version: v2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class PlaceOrderRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'quantity': 'int',
        'product': 'str',
        'validity': 'str',
        'price': 'float',
        'tag': 'str',
        'instrument_token': 'str',
        'order_type': 'str',
        'transaction_type': 'str',
        'disclosed_quantity': 'int',
        'trigger_price': 'float',
        'is_amo': 'bool'
    }

    attribute_map = {
        'quantity': 'quantity',
        'product': 'product',
        'validity': 'validity',
        'price': 'price',
        'tag': 'tag',
        'instrument_token': 'instrument_token',
        'order_type': 'order_type',
        'transaction_type': 'transaction_type',
        'disclosed_quantity': 'disclosed_quantity',
        'trigger_price': 'trigger_price',
        'is_amo': 'is_amo'
    }

    def __init__(self, quantity=None, product=None, validity=None, price=None, tag=None, instrument_token=None, order_type=None, transaction_type=None, disclosed_quantity=None, trigger_price=None, is_amo=None):  # noqa: E501
        """PlaceOrderRequest - a model defined in Swagger"""  # noqa: E501
        self._quantity = None
        self._product = None
        self._validity = None
        self._price = None
        self._tag = None
        self._instrument_token = None
        self._order_type = None
        self._transaction_type = None
        self._disclosed_quantity = None
        self._trigger_price = None
        self._is_amo = None
        self.discriminator = None
        self.quantity = quantity
        self.product = product
        self.validity = validity
        self.price = price
        if tag is not None:
            self.tag = tag
        self.instrument_token = instrument_token
        self.order_type = order_type
        self.transaction_type = transaction_type
        self.disclosed_quantity = disclosed_quantity
        self.trigger_price = trigger_price
        self.is_amo = is_amo

    @property
    def quantity(self):
        """Gets the quantity of this PlaceOrderRequest.  # noqa: E501

        Quantity with which the order is to be placed  # noqa: E501

        :return: The quantity of this PlaceOrderRequest.  # noqa: E501
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this PlaceOrderRequest.

        Quantity with which the order is to be placed  # noqa: E501

        :param quantity: The quantity of this PlaceOrderRequest.  # noqa: E501
        :type: int
        """
        if quantity is None:
            raise ValueError("Invalid value for `quantity`, must not be `None`")  # noqa: E501

        self._quantity = quantity

    @property
    def product(self):
        """Gets the product of this PlaceOrderRequest.  # noqa: E501

        Signifies if the order was either Intraday, Delivery, CO or OCO  # noqa: E501

        :return: The product of this PlaceOrderRequest.  # noqa: E501
        :rtype: str
        """
        return self._product

    @product.setter
    def product(self, product):
        """Sets the product of this PlaceOrderRequest.

        Signifies if the order was either Intraday, Delivery, CO or OCO  # noqa: E501

        :param product: The product of this PlaceOrderRequest.  # noqa: E501
        :type: str
        """
        if product is None:
            raise ValueError("Invalid value for `product`, must not be `None`")  # noqa: E501
        allowed_values = ["I", "D", "CO", "OCO", "MTF"]  # noqa: E501
        if product not in allowed_values:
            raise ValueError(
                "Invalid value for `product` ({0}), must be one of {1}"  # noqa: E501
                .format(product, allowed_values)
            )

        self._product = product

    @property
    def validity(self):
        """Gets the validity of this PlaceOrderRequest.  # noqa: E501

        It can be one of the following - DAY(default), IOC  # noqa: E501

        :return: The validity of this PlaceOrderRequest.  # noqa: E501
        :rtype: str
        """
        return self._validity

    @validity.setter
    def validity(self, validity):
        """Sets the validity of this PlaceOrderRequest.

        It can be one of the following - DAY(default), IOC  # noqa: E501

        :param validity: The validity of this PlaceOrderRequest.  # noqa: E501
        :type: str
        """
        if validity is None:
            raise ValueError("Invalid value for `validity`, must not be `None`")  # noqa: E501
        allowed_values = ["DAY", "IOC"]  # noqa: E501
        if validity not in allowed_values:
            raise ValueError(
                "Invalid value for `validity` ({0}), must be one of {1}"  # noqa: E501
                .format(validity, allowed_values)
            )

        self._validity = validity

    @property
    def price(self):
        """Gets the price of this PlaceOrderRequest.  # noqa: E501

        Price at which the order will be placed  # noqa: E501

        :return: The price of this PlaceOrderRequest.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this PlaceOrderRequest.

        Price at which the order will be placed  # noqa: E501

        :param price: The price of this PlaceOrderRequest.  # noqa: E501
        :type: float
        """
        if price is None:
            raise ValueError("Invalid value for `price`, must not be `None`")  # noqa: E501

        self._price = price

    @property
    def tag(self):
        """Gets the tag of this PlaceOrderRequest.  # noqa: E501

        Tag for a particular order  # noqa: E501

        :return: The tag of this PlaceOrderRequest.  # noqa: E501
        :rtype: str
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """Sets the tag of this PlaceOrderRequest.

        Tag for a particular order  # noqa: E501

        :param tag: The tag of this PlaceOrderRequest.  # noqa: E501
        :type: str
        """

        self._tag = tag

    @property
    def instrument_token(self):
        """Gets the instrument_token of this PlaceOrderRequest.  # noqa: E501

        Key of the instrument  # noqa: E501

        :return: The instrument_token of this PlaceOrderRequest.  # noqa: E501
        :rtype: str
        """
        return self._instrument_token

    @instrument_token.setter
    def instrument_token(self, instrument_token):
        """Sets the instrument_token of this PlaceOrderRequest.

        Key of the instrument  # noqa: E501

        :param instrument_token: The instrument_token of this PlaceOrderRequest.  # noqa: E501
        :type: str
        """
        if instrument_token is None:
            raise ValueError("Invalid value for `instrument_token`, must not be `None`")  # noqa: E501

        self._instrument_token = instrument_token

    @property
    def order_type(self):
        """Gets the order_type of this PlaceOrderRequest.  # noqa: E501

        Type of order. It can be one of the following MARKET refers to market order LIMIT refers to Limit Order SL refers to Stop Loss Limit SL-M refers to Stop Loss Market  # noqa: E501

        :return: The order_type of this PlaceOrderRequest.  # noqa: E501
        :rtype: str
        """
        return self._order_type

    @order_type.setter
    def order_type(self, order_type):
        """Sets the order_type of this PlaceOrderRequest.

        Type of order. It can be one of the following MARKET refers to market order LIMIT refers to Limit Order SL refers to Stop Loss Limit SL-M refers to Stop Loss Market  # noqa: E501

        :param order_type: The order_type of this PlaceOrderRequest.  # noqa: E501
        :type: str
        """
        if order_type is None:
            raise ValueError("Invalid value for `order_type`, must not be `None`")  # noqa: E501
        allowed_values = ["MARKET", "LIMIT", "SL", "SL-M"]  # noqa: E501
        if order_type not in allowed_values:
            raise ValueError(
                "Invalid value for `order_type` ({0}), must be one of {1}"  # noqa: E501
                .format(order_type, allowed_values)
            )

        self._order_type = order_type

    @property
    def transaction_type(self):
        """Gets the transaction_type of this PlaceOrderRequest.  # noqa: E501

        Indicates whether its a buy or sell order  # noqa: E501

        :return: The transaction_type of this PlaceOrderRequest.  # noqa: E501
        :rtype: str
        """
        return self._transaction_type

    @transaction_type.setter
    def transaction_type(self, transaction_type):
        """Sets the transaction_type of this PlaceOrderRequest.

        Indicates whether its a buy or sell order  # noqa: E501

        :param transaction_type: The transaction_type of this PlaceOrderRequest.  # noqa: E501
        :type: str
        """
        if transaction_type is None:
            raise ValueError("Invalid value for `transaction_type`, must not be `None`")  # noqa: E501
        allowed_values = ["BUY", "SELL"]  # noqa: E501
        if transaction_type not in allowed_values:
            raise ValueError(
                "Invalid value for `transaction_type` ({0}), must be one of {1}"  # noqa: E501
                .format(transaction_type, allowed_values)
            )

        self._transaction_type = transaction_type

    @property
    def disclosed_quantity(self):
        """Gets the disclosed_quantity of this PlaceOrderRequest.  # noqa: E501

        The quantity that should be disclosed in the market depth  # noqa: E501

        :return: The disclosed_quantity of this PlaceOrderRequest.  # noqa: E501
        :rtype: int
        """
        return self._disclosed_quantity

    @disclosed_quantity.setter
    def disclosed_quantity(self, disclosed_quantity):
        """Sets the disclosed_quantity of this PlaceOrderRequest.

        The quantity that should be disclosed in the market depth  # noqa: E501

        :param disclosed_quantity: The disclosed_quantity of this PlaceOrderRequest.  # noqa: E501
        :type: int
        """
        if disclosed_quantity is None:
            raise ValueError("Invalid value for `disclosed_quantity`, must not be `None`")  # noqa: E501

        self._disclosed_quantity = disclosed_quantity

    @property
    def trigger_price(self):
        """Gets the trigger_price of this PlaceOrderRequest.  # noqa: E501

        If the order is a stop loss order then the trigger price to be set is mentioned here  # noqa: E501

        :return: The trigger_price of this PlaceOrderRequest.  # noqa: E501
        :rtype: float
        """
        return self._trigger_price

    @trigger_price.setter
    def trigger_price(self, trigger_price):
        """Sets the trigger_price of this PlaceOrderRequest.

        If the order is a stop loss order then the trigger price to be set is mentioned here  # noqa: E501

        :param trigger_price: The trigger_price of this PlaceOrderRequest.  # noqa: E501
        :type: float
        """
        if trigger_price is None:
            raise ValueError("Invalid value for `trigger_price`, must not be `None`")  # noqa: E501

        self._trigger_price = trigger_price

    @property
    def is_amo(self):
        """Gets the is_amo of this PlaceOrderRequest.  # noqa: E501

        Signifies if the order is an After Market Order  # noqa: E501

        :return: The is_amo of this PlaceOrderRequest.  # noqa: E501
        :rtype: bool
        """
        return self._is_amo

    @is_amo.setter
    def is_amo(self, is_amo):
        """Sets the is_amo of this PlaceOrderRequest.

        Signifies if the order is an After Market Order  # noqa: E501

        :param is_amo: The is_amo of this PlaceOrderRequest.  # noqa: E501
        :type: bool
        """
        if is_amo is None:
            raise ValueError("Invalid value for `is_amo`, must not be `None`")  # noqa: E501

        self._is_amo = is_amo

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PlaceOrderRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PlaceOrderRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
