# coding: utf-8

"""
    Upstox Developer API

    Build your App on the Upstox platform  ![Banner](https://api.upstox.com/api-docs/images/banner.jpg \"banner\")  # Introduction  Upstox API is a set of rest APIs that provide data required to build a complete investment and trading platform. Execute orders in real time, manage user portfolio, stream live market data (using Websocket), and more, with the easy to understand API collection.  All requests are over HTTPS and the requests are sent with the content-type ‘application/json’. Developers have the option of choosing the response type as JSON or CSV for a few API calls.  To be able to use these APIs you need to create an App in the Developer Console and generate your **apiKey** and **apiSecret**. You can use a redirect URL which will be called after the login flow.  If you are a **trader**, you can directly create apps from Upstox mobile app or the desktop platform itself from **Apps** sections inside the **Account** Tab. Head over to <a href=\"http://account.upstox.com/developer/apps\" target=\"_blank\">account.upstox.com/developer/apps</a>.</br> If you are a **business** looking to integrate Upstox APIs, reach out to us and we will get a custom app created for you in no time.  It is highly recommended that you do not embed the **apiSecret** in your frontend app. Create a remote backend which does the handshake on behalf of the frontend app. Marking the apiSecret in the frontend app will make your app vulnerable to threats and potential issues.   # noqa: E501

    OpenAPI spec version: v2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class TradeData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'exchange': 'str',
        'product': 'str',
        'tradingsymbol': 'str',
        'trading_symbol': 'str',
        'instrument_token': 'str',
        'order_type': 'str',
        'transaction_type': 'str',
        'quantity': 'int',
        'exchange_order_id': 'str',
        'order_id': 'str',
        'exchange_timestamp': 'str',
        'average_price': 'float',
        'trade_id': 'str',
        'order_ref_id': 'str',
        'order_timestamp': 'str'
    }

    attribute_map = {
        'exchange': 'exchange',
        'product': 'product',
        'tradingsymbol': 'tradingsymbol',
        'trading_symbol': 'trading_symbol',
        'instrument_token': 'instrument_token',
        'order_type': 'order_type',
        'transaction_type': 'transaction_type',
        'quantity': 'quantity',
        'exchange_order_id': 'exchange_order_id',
        'order_id': 'order_id',
        'exchange_timestamp': 'exchange_timestamp',
        'average_price': 'average_price',
        'trade_id': 'trade_id',
        'order_ref_id': 'order_ref_id',
        'order_timestamp': 'order_timestamp'
    }

    def __init__(self, exchange=None, product=None, tradingsymbol=None, trading_symbol=None, instrument_token=None, order_type=None, transaction_type=None, quantity=None, exchange_order_id=None, order_id=None, exchange_timestamp=None, average_price=None, trade_id=None, order_ref_id=None, order_timestamp=None):  # noqa: E501
        """TradeData - a model defined in Swagger"""  # noqa: E501
        self._exchange = None
        self._product = None
        self._tradingsymbol = None
        self._trading_symbol = None
        self._instrument_token = None
        self._order_type = None
        self._transaction_type = None
        self._quantity = None
        self._exchange_order_id = None
        self._order_id = None
        self._exchange_timestamp = None
        self._average_price = None
        self._trade_id = None
        self._order_ref_id = None
        self._order_timestamp = None
        self.discriminator = None
        if exchange is not None:
            self.exchange = exchange
        if product is not None:
            self.product = product
        if tradingsymbol is not None:
            self.tradingsymbol = tradingsymbol
        if trading_symbol is not None:
            self.trading_symbol = trading_symbol
        if instrument_token is not None:
            self.instrument_token = instrument_token
        if order_type is not None:
            self.order_type = order_type
        if transaction_type is not None:
            self.transaction_type = transaction_type
        if quantity is not None:
            self.quantity = quantity
        if exchange_order_id is not None:
            self.exchange_order_id = exchange_order_id
        if order_id is not None:
            self.order_id = order_id
        if exchange_timestamp is not None:
            self.exchange_timestamp = exchange_timestamp
        if average_price is not None:
            self.average_price = average_price
        if trade_id is not None:
            self.trade_id = trade_id
        if order_ref_id is not None:
            self.order_ref_id = order_ref_id
        if order_timestamp is not None:
            self.order_timestamp = order_timestamp

    @property
    def exchange(self):
        """Gets the exchange of this TradeData.  # noqa: E501

        Exchange to which the order is associated  # noqa: E501

        :return: The exchange of this TradeData.  # noqa: E501
        :rtype: str
        """
        return self._exchange

    @exchange.setter
    def exchange(self, exchange):
        """Sets the exchange of this TradeData.

        Exchange to which the order is associated  # noqa: E501

        :param exchange: The exchange of this TradeData.  # noqa: E501
        :type: str
        """

        self._exchange = exchange

    @property
    def product(self):
        """Gets the product of this TradeData.  # noqa: E501

        Shows if the order was either Intraday, Delivery, CO or OCO  # noqa: E501

        :return: The product of this TradeData.  # noqa: E501
        :rtype: str
        """
        return self._product

    @product.setter
    def product(self, product):
        """Sets the product of this TradeData.

        Shows if the order was either Intraday, Delivery, CO or OCO  # noqa: E501

        :param product: The product of this TradeData.  # noqa: E501
        :type: str
        """

        self._product = product

    @property
    def tradingsymbol(self):
        """Gets the tradingsymbol of this TradeData.  # noqa: E501

        Shows the trading symbol which could be a combination of symbol name, instrument, expiry date etc  # noqa: E501

        :return: The tradingsymbol of this TradeData.  # noqa: E501
        :rtype: str
        """
        return self._tradingsymbol

    @tradingsymbol.setter
    def tradingsymbol(self, tradingsymbol):
        """Sets the tradingsymbol of this TradeData.

        Shows the trading symbol which could be a combination of symbol name, instrument, expiry date etc  # noqa: E501

        :param tradingsymbol: The tradingsymbol of this TradeData.  # noqa: E501
        :type: str
        """

        self._tradingsymbol = tradingsymbol

    @property
    def trading_symbol(self):
        """Gets the trading_symbol of this TradeData.  # noqa: E501

        Shows the trading symbol which could be a combination of symbol name, instrument, expiry date etc  # noqa: E501

        :return: The trading_symbol of this TradeData.  # noqa: E501
        :rtype: str
        """
        return self._trading_symbol

    @trading_symbol.setter
    def trading_symbol(self, trading_symbol):
        """Sets the trading_symbol of this TradeData.

        Shows the trading symbol which could be a combination of symbol name, instrument, expiry date etc  # noqa: E501

        :param trading_symbol: The trading_symbol of this TradeData.  # noqa: E501
        :type: str
        """

        self._trading_symbol = trading_symbol

    @property
    def instrument_token(self):
        """Gets the instrument_token of this TradeData.  # noqa: E501

        Identifier issued by Upstox used for subscribing to live market quotes  # noqa: E501

        :return: The instrument_token of this TradeData.  # noqa: E501
        :rtype: str
        """
        return self._instrument_token

    @instrument_token.setter
    def instrument_token(self, instrument_token):
        """Sets the instrument_token of this TradeData.

        Identifier issued by Upstox used for subscribing to live market quotes  # noqa: E501

        :param instrument_token: The instrument_token of this TradeData.  # noqa: E501
        :type: str
        """

        self._instrument_token = instrument_token

    @property
    def order_type(self):
        """Gets the order_type of this TradeData.  # noqa: E501

        Type of order. It can be one of the following MARKET refers to market order<br>LIMIT refers to Limit Order<br>SL refers to Stop Loss Limit<br>SL-M refers to Stop loss market  # noqa: E501

        :return: The order_type of this TradeData.  # noqa: E501
        :rtype: str
        """
        return self._order_type

    @order_type.setter
    def order_type(self, order_type):
        """Sets the order_type of this TradeData.

        Type of order. It can be one of the following MARKET refers to market order<br>LIMIT refers to Limit Order<br>SL refers to Stop Loss Limit<br>SL-M refers to Stop loss market  # noqa: E501

        :param order_type: The order_type of this TradeData.  # noqa: E501
        :type: str
        """
        allowed_values = ["MARKET", "LIMIT", "SL", "SL-M"]  # noqa: E501
        if order_type not in allowed_values:
            raise ValueError(
                "Invalid value for `order_type` ({0}), must be one of {1}"  # noqa: E501
                .format(order_type, allowed_values)
            )

        self._order_type = order_type

    @property
    def transaction_type(self):
        """Gets the transaction_type of this TradeData.  # noqa: E501

        Indicates whether the order was a buy or sell order  # noqa: E501

        :return: The transaction_type of this TradeData.  # noqa: E501
        :rtype: str
        """
        return self._transaction_type

    @transaction_type.setter
    def transaction_type(self, transaction_type):
        """Sets the transaction_type of this TradeData.

        Indicates whether the order was a buy or sell order  # noqa: E501

        :param transaction_type: The transaction_type of this TradeData.  # noqa: E501
        :type: str
        """
        allowed_values = ["BUY", "SELL"]  # noqa: E501
        if transaction_type not in allowed_values:
            raise ValueError(
                "Invalid value for `transaction_type` ({0}), must be one of {1}"  # noqa: E501
                .format(transaction_type, allowed_values)
            )

        self._transaction_type = transaction_type

    @property
    def quantity(self):
        """Gets the quantity of this TradeData.  # noqa: E501

        The total quantity traded from this particular order  # noqa: E501

        :return: The quantity of this TradeData.  # noqa: E501
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this TradeData.

        The total quantity traded from this particular order  # noqa: E501

        :param quantity: The quantity of this TradeData.  # noqa: E501
        :type: int
        """

        self._quantity = quantity

    @property
    def exchange_order_id(self):
        """Gets the exchange_order_id of this TradeData.  # noqa: E501

        Unique order ID assigned by the exchange for the order placed  # noqa: E501

        :return: The exchange_order_id of this TradeData.  # noqa: E501
        :rtype: str
        """
        return self._exchange_order_id

    @exchange_order_id.setter
    def exchange_order_id(self, exchange_order_id):
        """Sets the exchange_order_id of this TradeData.

        Unique order ID assigned by the exchange for the order placed  # noqa: E501

        :param exchange_order_id: The exchange_order_id of this TradeData.  # noqa: E501
        :type: str
        """

        self._exchange_order_id = exchange_order_id

    @property
    def order_id(self):
        """Gets the order_id of this TradeData.  # noqa: E501

        Unique order ID assigned internally for the order placed  # noqa: E501

        :return: The order_id of this TradeData.  # noqa: E501
        :rtype: str
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """Sets the order_id of this TradeData.

        Unique order ID assigned internally for the order placed  # noqa: E501

        :param order_id: The order_id of this TradeData.  # noqa: E501
        :type: str
        """

        self._order_id = order_id

    @property
    def exchange_timestamp(self):
        """Gets the exchange_timestamp of this TradeData.  # noqa: E501

        User readable time at when the trade occurred  # noqa: E501

        :return: The exchange_timestamp of this TradeData.  # noqa: E501
        :rtype: str
        """
        return self._exchange_timestamp

    @exchange_timestamp.setter
    def exchange_timestamp(self, exchange_timestamp):
        """Sets the exchange_timestamp of this TradeData.

        User readable time at when the trade occurred  # noqa: E501

        :param exchange_timestamp: The exchange_timestamp of this TradeData.  # noqa: E501
        :type: str
        """

        self._exchange_timestamp = exchange_timestamp

    @property
    def average_price(self):
        """Gets the average_price of this TradeData.  # noqa: E501

        Price at which the traded quantity is traded  # noqa: E501

        :return: The average_price of this TradeData.  # noqa: E501
        :rtype: float
        """
        return self._average_price

    @average_price.setter
    def average_price(self, average_price):
        """Sets the average_price of this TradeData.

        Price at which the traded quantity is traded  # noqa: E501

        :param average_price: The average_price of this TradeData.  # noqa: E501
        :type: float
        """

        self._average_price = average_price

    @property
    def trade_id(self):
        """Gets the trade_id of this TradeData.  # noqa: E501

        Trade ID generated from exchange towards traded transaction  # noqa: E501

        :return: The trade_id of this TradeData.  # noqa: E501
        :rtype: str
        """
        return self._trade_id

    @trade_id.setter
    def trade_id(self, trade_id):
        """Sets the trade_id of this TradeData.

        Trade ID generated from exchange towards traded transaction  # noqa: E501

        :param trade_id: The trade_id of this TradeData.  # noqa: E501
        :type: str
        """

        self._trade_id = trade_id

    @property
    def order_ref_id(self):
        """Gets the order_ref_id of this TradeData.  # noqa: E501

        The order reference ID for which the order must be modified  # noqa: E501

        :return: The order_ref_id of this TradeData.  # noqa: E501
        :rtype: str
        """
        return self._order_ref_id

    @order_ref_id.setter
    def order_ref_id(self, order_ref_id):
        """Sets the order_ref_id of this TradeData.

        The order reference ID for which the order must be modified  # noqa: E501

        :param order_ref_id: The order_ref_id of this TradeData.  # noqa: E501
        :type: str
        """

        self._order_ref_id = order_ref_id

    @property
    def order_timestamp(self):
        """Gets the order_timestamp of this TradeData.  # noqa: E501

        User readable timestamp at which the order was placed  # noqa: E501

        :return: The order_timestamp of this TradeData.  # noqa: E501
        :rtype: str
        """
        return self._order_timestamp

    @order_timestamp.setter
    def order_timestamp(self, order_timestamp):
        """Sets the order_timestamp of this TradeData.

        User readable timestamp at which the order was placed  # noqa: E501

        :param order_timestamp: The order_timestamp of this TradeData.  # noqa: E501
        :type: str
        """

        self._order_timestamp = order_timestamp

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TradeData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TradeData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
