# coding: utf-8

"""
    Upstox Developer API

    Build your App on the Upstox platform  ![Banner](https://api-v2.upstox.com/api-docs/images/banner.jpg \"banner\")  # Introduction  Upstox API is a set of rest APIs that provide data required to build a complete investment and trading platform. Execute orders in real time, manage user portfolio, stream live market data (using Websocket), and more, with the easy to understand API collection.  All requests are over HTTPS and the requests are sent with the content-type ‘application/json’. Developers have the option of choosing the response type as JSON or CSV for a few API calls.  To be able to use these APIs you need to create an App in the Developer Console and generate your **apiKey** and **apiSecret**. You can use a redirect URL which will be called after the login flow.  If you are a **trader**, you can directly create apps from Upstox mobile app or the desktop platform itself from **Apps** sections inside the **Account** Tab. Head over to <a href=\"http://account.upstox.com/developer/apps\" target=\"_blank\">account.upstox.com/developer/apps</a>.</br> If you are a **business** looking to integrate Upstox APIs, reach out to us and we will get a custom app created for you in no time.  It is highly recommended that you do not embed the **apiSecret** in your frontend app. Create a remote backend which does the handshake on behalf of the frontend app. Marking the apiSecret in the frontend app will make your app vulnerable to threats and potential issues.   # noqa: E501

    OpenAPI spec version: v2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class HoldingsData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'isin': 'str',
        'cnc_used_quantity': 'int',
        'collateral_type': 'str',
        'company_name': 'str',
        'haircut': 'float',
        'product': 'str',
        'quantity': 'int',
        'tradingsymbol': 'str',
        'last_price': 'float',
        'close_price': 'float',
        'pnl': 'float',
        'day_change': 'float',
        'day_change_percentage': 'float',
        'instrument_token': 'str',
        'average_price': 'float',
        'collateral_quantity': 'int',
        'collateral_update_quantity': 'int',
        't1_quantity': 'int',
        'exchange': 'str'
    }

    attribute_map = {
        'isin': 'isin',
        'cnc_used_quantity': 'cnc_used_quantity',
        'collateral_type': 'collateral_type',
        'company_name': 'company_name',
        'haircut': 'haircut',
        'product': 'product',
        'quantity': 'quantity',
        'tradingsymbol': 'tradingsymbol',
        'last_price': 'last_price',
        'close_price': 'close_price',
        'pnl': 'pnl',
        'day_change': 'day_change',
        'day_change_percentage': 'day_change_percentage',
        'instrument_token': 'instrument_token',
        'average_price': 'average_price',
        'collateral_quantity': 'collateral_quantity',
        'collateral_update_quantity': 'collateral_update_quantity',
        't1_quantity': 't1_quantity',
        'exchange': 'exchange'
    }

    def __init__(self, isin=None, cnc_used_quantity=None, collateral_type=None, company_name=None, haircut=None, product=None, quantity=None, tradingsymbol=None, last_price=None, close_price=None, pnl=None, day_change=None, day_change_percentage=None, instrument_token=None, average_price=None, collateral_quantity=None, collateral_update_quantity=None, t1_quantity=None, exchange=None):  # noqa: E501
        """HoldingsData - a model defined in Swagger"""  # noqa: E501
        self._isin = None
        self._cnc_used_quantity = None
        self._collateral_type = None
        self._company_name = None
        self._haircut = None
        self._product = None
        self._quantity = None
        self._tradingsymbol = None
        self._last_price = None
        self._close_price = None
        self._pnl = None
        self._day_change = None
        self._day_change_percentage = None
        self._instrument_token = None
        self._average_price = None
        self._collateral_quantity = None
        self._collateral_update_quantity = None
        self._t1_quantity = None
        self._exchange = None
        self.discriminator = None
        if isin is not None:
            self.isin = isin
        if cnc_used_quantity is not None:
            self.cnc_used_quantity = cnc_used_quantity
        if collateral_type is not None:
            self.collateral_type = collateral_type
        if company_name is not None:
            self.company_name = company_name
        if haircut is not None:
            self.haircut = haircut
        if product is not None:
            self.product = product
        if quantity is not None:
            self.quantity = quantity
        if tradingsymbol is not None:
            self.tradingsymbol = tradingsymbol
        if last_price is not None:
            self.last_price = last_price
        if close_price is not None:
            self.close_price = close_price
        if pnl is not None:
            self.pnl = pnl
        if day_change is not None:
            self.day_change = day_change
        if day_change_percentage is not None:
            self.day_change_percentage = day_change_percentage
        if instrument_token is not None:
            self.instrument_token = instrument_token
        if average_price is not None:
            self.average_price = average_price
        if collateral_quantity is not None:
            self.collateral_quantity = collateral_quantity
        if collateral_update_quantity is not None:
            self.collateral_update_quantity = collateral_update_quantity
        if t1_quantity is not None:
            self.t1_quantity = t1_quantity
        if exchange is not None:
            self.exchange = exchange

    @property
    def isin(self):
        """Gets the isin of this HoldingsData.  # noqa: E501

        The standard ISIN representing stocks listed on multiple exchanges  # noqa: E501

        :return: The isin of this HoldingsData.  # noqa: E501
        :rtype: str
        """
        return self._isin

    @isin.setter
    def isin(self, isin):
        """Sets the isin of this HoldingsData.

        The standard ISIN representing stocks listed on multiple exchanges  # noqa: E501

        :param isin: The isin of this HoldingsData.  # noqa: E501
        :type: str
        """

        self._isin = isin

    @property
    def cnc_used_quantity(self):
        """Gets the cnc_used_quantity of this HoldingsData.  # noqa: E501

        Quantity either blocked towards open or completed order  # noqa: E501

        :return: The cnc_used_quantity of this HoldingsData.  # noqa: E501
        :rtype: int
        """
        return self._cnc_used_quantity

    @cnc_used_quantity.setter
    def cnc_used_quantity(self, cnc_used_quantity):
        """Sets the cnc_used_quantity of this HoldingsData.

        Quantity either blocked towards open or completed order  # noqa: E501

        :param cnc_used_quantity: The cnc_used_quantity of this HoldingsData.  # noqa: E501
        :type: int
        """

        self._cnc_used_quantity = cnc_used_quantity

    @property
    def collateral_type(self):
        """Gets the collateral_type of this HoldingsData.  # noqa: E501

        Category of collateral assigned by RMS  # noqa: E501

        :return: The collateral_type of this HoldingsData.  # noqa: E501
        :rtype: str
        """
        return self._collateral_type

    @collateral_type.setter
    def collateral_type(self, collateral_type):
        """Sets the collateral_type of this HoldingsData.

        Category of collateral assigned by RMS  # noqa: E501

        :param collateral_type: The collateral_type of this HoldingsData.  # noqa: E501
        :type: str
        """

        self._collateral_type = collateral_type

    @property
    def company_name(self):
        """Gets the company_name of this HoldingsData.  # noqa: E501

        Name of the company  # noqa: E501

        :return: The company_name of this HoldingsData.  # noqa: E501
        :rtype: str
        """
        return self._company_name

    @company_name.setter
    def company_name(self, company_name):
        """Sets the company_name of this HoldingsData.

        Name of the company  # noqa: E501

        :param company_name: The company_name of this HoldingsData.  # noqa: E501
        :type: str
        """

        self._company_name = company_name

    @property
    def haircut(self):
        """Gets the haircut of this HoldingsData.  # noqa: E501

        This is the haircut percentage applied from RMS (applicable incase of collateral)  # noqa: E501

        :return: The haircut of this HoldingsData.  # noqa: E501
        :rtype: float
        """
        return self._haircut

    @haircut.setter
    def haircut(self, haircut):
        """Sets the haircut of this HoldingsData.

        This is the haircut percentage applied from RMS (applicable incase of collateral)  # noqa: E501

        :param haircut: The haircut of this HoldingsData.  # noqa: E501
        :type: float
        """

        self._haircut = haircut

    @property
    def product(self):
        """Gets the product of this HoldingsData.  # noqa: E501

        Shows if the order was either Intraday, Delivery, CO or OCO  # noqa: E501

        :return: The product of this HoldingsData.  # noqa: E501
        :rtype: str
        """
        return self._product

    @product.setter
    def product(self, product):
        """Sets the product of this HoldingsData.

        Shows if the order was either Intraday, Delivery, CO or OCO  # noqa: E501

        :param product: The product of this HoldingsData.  # noqa: E501
        :type: str
        """

        self._product = product

    @property
    def quantity(self):
        """Gets the quantity of this HoldingsData.  # noqa: E501

        The total holding qty  # noqa: E501

        :return: The quantity of this HoldingsData.  # noqa: E501
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this HoldingsData.

        The total holding qty  # noqa: E501

        :param quantity: The quantity of this HoldingsData.  # noqa: E501
        :type: int
        """

        self._quantity = quantity

    @property
    def tradingsymbol(self):
        """Gets the tradingsymbol of this HoldingsData.  # noqa: E501

        Shows the trading symbol of the instrument  # noqa: E501

        :return: The tradingsymbol of this HoldingsData.  # noqa: E501
        :rtype: str
        """
        return self._tradingsymbol

    @tradingsymbol.setter
    def tradingsymbol(self, tradingsymbol):
        """Sets the tradingsymbol of this HoldingsData.

        Shows the trading symbol of the instrument  # noqa: E501

        :param tradingsymbol: The tradingsymbol of this HoldingsData.  # noqa: E501
        :type: str
        """

        self._tradingsymbol = tradingsymbol

    @property
    def last_price(self):
        """Gets the last_price of this HoldingsData.  # noqa: E501

        The last traded price of the instrument  # noqa: E501

        :return: The last_price of this HoldingsData.  # noqa: E501
        :rtype: float
        """
        return self._last_price

    @last_price.setter
    def last_price(self, last_price):
        """Sets the last_price of this HoldingsData.

        The last traded price of the instrument  # noqa: E501

        :param last_price: The last_price of this HoldingsData.  # noqa: E501
        :type: float
        """

        self._last_price = last_price

    @property
    def close_price(self):
        """Gets the close_price of this HoldingsData.  # noqa: E501

        Closing price of the instrument from the last trading day  # noqa: E501

        :return: The close_price of this HoldingsData.  # noqa: E501
        :rtype: float
        """
        return self._close_price

    @close_price.setter
    def close_price(self, close_price):
        """Sets the close_price of this HoldingsData.

        Closing price of the instrument from the last trading day  # noqa: E501

        :param close_price: The close_price of this HoldingsData.  # noqa: E501
        :type: float
        """

        self._close_price = close_price

    @property
    def pnl(self):
        """Gets the pnl of this HoldingsData.  # noqa: E501

        Profit and Loss  # noqa: E501

        :return: The pnl of this HoldingsData.  # noqa: E501
        :rtype: float
        """
        return self._pnl

    @pnl.setter
    def pnl(self, pnl):
        """Sets the pnl of this HoldingsData.

        Profit and Loss  # noqa: E501

        :param pnl: The pnl of this HoldingsData.  # noqa: E501
        :type: float
        """

        self._pnl = pnl

    @property
    def day_change(self):
        """Gets the day_change of this HoldingsData.  # noqa: E501

        Day's change in absolute value for the stock  # noqa: E501

        :return: The day_change of this HoldingsData.  # noqa: E501
        :rtype: float
        """
        return self._day_change

    @day_change.setter
    def day_change(self, day_change):
        """Sets the day_change of this HoldingsData.

        Day's change in absolute value for the stock  # noqa: E501

        :param day_change: The day_change of this HoldingsData.  # noqa: E501
        :type: float
        """

        self._day_change = day_change

    @property
    def day_change_percentage(self):
        """Gets the day_change_percentage of this HoldingsData.  # noqa: E501

        Day's change in percentage for the stock  # noqa: E501

        :return: The day_change_percentage of this HoldingsData.  # noqa: E501
        :rtype: float
        """
        return self._day_change_percentage

    @day_change_percentage.setter
    def day_change_percentage(self, day_change_percentage):
        """Sets the day_change_percentage of this HoldingsData.

        Day's change in percentage for the stock  # noqa: E501

        :param day_change_percentage: The day_change_percentage of this HoldingsData.  # noqa: E501
        :type: float
        """

        self._day_change_percentage = day_change_percentage

    @property
    def instrument_token(self):
        """Gets the instrument_token of this HoldingsData.  # noqa: E501

        Key issued by Upstox for the instrument  # noqa: E501

        :return: The instrument_token of this HoldingsData.  # noqa: E501
        :rtype: str
        """
        return self._instrument_token

    @instrument_token.setter
    def instrument_token(self, instrument_token):
        """Sets the instrument_token of this HoldingsData.

        Key issued by Upstox for the instrument  # noqa: E501

        :param instrument_token: The instrument_token of this HoldingsData.  # noqa: E501
        :type: str
        """

        self._instrument_token = instrument_token

    @property
    def average_price(self):
        """Gets the average_price of this HoldingsData.  # noqa: E501

        Average price at which the net holding quantity was acquired  # noqa: E501

        :return: The average_price of this HoldingsData.  # noqa: E501
        :rtype: float
        """
        return self._average_price

    @average_price.setter
    def average_price(self, average_price):
        """Sets the average_price of this HoldingsData.

        Average price at which the net holding quantity was acquired  # noqa: E501

        :param average_price: The average_price of this HoldingsData.  # noqa: E501
        :type: float
        """

        self._average_price = average_price

    @property
    def collateral_quantity(self):
        """Gets the collateral_quantity of this HoldingsData.  # noqa: E501

        Quantity marked as collateral by RMS on users request  # noqa: E501

        :return: The collateral_quantity of this HoldingsData.  # noqa: E501
        :rtype: int
        """
        return self._collateral_quantity

    @collateral_quantity.setter
    def collateral_quantity(self, collateral_quantity):
        """Sets the collateral_quantity of this HoldingsData.

        Quantity marked as collateral by RMS on users request  # noqa: E501

        :param collateral_quantity: The collateral_quantity of this HoldingsData.  # noqa: E501
        :type: int
        """

        self._collateral_quantity = collateral_quantity

    @property
    def collateral_update_quantity(self):
        """Gets the collateral_update_quantity of this HoldingsData.  # noqa: E501


        :return: The collateral_update_quantity of this HoldingsData.  # noqa: E501
        :rtype: int
        """
        return self._collateral_update_quantity

    @collateral_update_quantity.setter
    def collateral_update_quantity(self, collateral_update_quantity):
        """Sets the collateral_update_quantity of this HoldingsData.


        :param collateral_update_quantity: The collateral_update_quantity of this HoldingsData.  # noqa: E501
        :type: int
        """

        self._collateral_update_quantity = collateral_update_quantity

    @property
    def t1_quantity(self):
        """Gets the t1_quantity of this HoldingsData.  # noqa: E501

        Quantity on T+1 day after order execution  # noqa: E501

        :return: The t1_quantity of this HoldingsData.  # noqa: E501
        :rtype: int
        """
        return self._t1_quantity

    @t1_quantity.setter
    def t1_quantity(self, t1_quantity):
        """Sets the t1_quantity of this HoldingsData.

        Quantity on T+1 day after order execution  # noqa: E501

        :param t1_quantity: The t1_quantity of this HoldingsData.  # noqa: E501
        :type: int
        """

        self._t1_quantity = t1_quantity

    @property
    def exchange(self):
        """Gets the exchange of this HoldingsData.  # noqa: E501

        Exchange of the trading symbol  # noqa: E501

        :return: The exchange of this HoldingsData.  # noqa: E501
        :rtype: str
        """
        return self._exchange

    @exchange.setter
    def exchange(self, exchange):
        """Sets the exchange of this HoldingsData.

        Exchange of the trading symbol  # noqa: E501

        :param exchange: The exchange of this HoldingsData.  # noqa: E501
        :type: str
        """
        allowed_values = ["NSE", "NFO", "CDS", "BSE", "BFO", "BCD", "MCX"]  # noqa: E501
        if exchange not in allowed_values:
            raise ValueError(
                "Invalid value for `exchange` ({0}), must be one of {1}"  # noqa: E501
                .format(exchange, allowed_values)
            )

        self._exchange = exchange

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(HoldingsData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HoldingsData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
