# coding: utf-8

"""
    Upstox Developer API

    Build your App on the Upstox platform  ![Banner](https://api-v2.upstox.com/api-docs/images/banner.jpg \"banner\")  # Introduction  Upstox API is a set of rest APIs that provide data required to build a complete investment and trading platform. Execute orders in real time, manage user portfolio, stream live market data (using Websocket), and more, with the easy to understand API collection.  All requests are over HTTPS and the requests are sent with the content-type ‘application/json’. Developers have the option of choosing the response type as JSON or CSV for a few API calls.  To be able to use these APIs you need to create an App in the Developer Console and generate your **apiKey** and **apiSecret**. You can use a redirect URL which will be called after the login flow.  If you are a **trader**, you can directly create apps from Upstox mobile app or the desktop platform itself from **Apps** sections inside the **Account** Tab. Head over to <a href=\"http://account.upstox.com/developer/apps\" target=\"_blank\">account.upstox.com/developer/apps</a>.</br> If you are a **business** looking to integrate Upstox APIs, reach out to us and we will get a custom app created for you in no time.  It is highly recommended that you do not embed the **apiSecret** in your frontend app. Create a remote backend which does the handshake on behalf of the frontend app. Marking the apiSecret in the frontend app will make your app vulnerable to threats and potential issues.   # noqa: E501

    OpenAPI spec version: v2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ConvertPositionRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'instrument_token': 'str',
        'new_product': 'str',
        'old_product': 'str',
        'transaction_type': 'str',
        'quantity': 'int'
    }

    attribute_map = {
        'instrument_token': 'instrument_token',
        'new_product': 'new_product',
        'old_product': 'old_product',
        'transaction_type': 'transaction_type',
        'quantity': 'quantity'
    }

    def __init__(self, instrument_token=None, new_product=None, old_product=None, transaction_type=None, quantity=None):  # noqa: E501
        """ConvertPositionRequest - a model defined in Swagger"""  # noqa: E501
        self._instrument_token = None
        self._new_product = None
        self._old_product = None
        self._transaction_type = None
        self._quantity = None
        self.discriminator = None
        self.instrument_token = instrument_token
        self.new_product = new_product
        self.old_product = old_product
        self.transaction_type = transaction_type
        self.quantity = quantity

    @property
    def instrument_token(self):
        """Gets the instrument_token of this ConvertPositionRequest.  # noqa: E501

        Key of the instrument  # noqa: E501

        :return: The instrument_token of this ConvertPositionRequest.  # noqa: E501
        :rtype: str
        """
        return self._instrument_token

    @instrument_token.setter
    def instrument_token(self, instrument_token):
        """Sets the instrument_token of this ConvertPositionRequest.

        Key of the instrument  # noqa: E501

        :param instrument_token: The instrument_token of this ConvertPositionRequest.  # noqa: E501
        :type: str
        """
        if instrument_token is None:
            raise ValueError("Invalid value for `instrument_token`, must not be `None`")  # noqa: E501

        self._instrument_token = instrument_token

    @property
    def new_product(self):
        """Gets the new_product of this ConvertPositionRequest.  # noqa: E501

        Indicates the new product to use for the convert positions  # noqa: E501

        :return: The new_product of this ConvertPositionRequest.  # noqa: E501
        :rtype: str
        """
        return self._new_product

    @new_product.setter
    def new_product(self, new_product):
        """Sets the new_product of this ConvertPositionRequest.

        Indicates the new product to use for the convert positions  # noqa: E501

        :param new_product: The new_product of this ConvertPositionRequest.  # noqa: E501
        :type: str
        """
        if new_product is None:
            raise ValueError("Invalid value for `new_product`, must not be `None`")  # noqa: E501
        allowed_values = ["I", "D", "CO", "OCO", "MTF"]  # noqa: E501
        if new_product not in allowed_values:
            raise ValueError(
                "Invalid value for `new_product` ({0}), must be one of {1}"  # noqa: E501
                .format(new_product, allowed_values)
            )

        self._new_product = new_product

    @property
    def old_product(self):
        """Gets the old_product of this ConvertPositionRequest.  # noqa: E501

        Indicates the old product to use for the convert positions  # noqa: E501

        :return: The old_product of this ConvertPositionRequest.  # noqa: E501
        :rtype: str
        """
        return self._old_product

    @old_product.setter
    def old_product(self, old_product):
        """Sets the old_product of this ConvertPositionRequest.

        Indicates the old product to use for the convert positions  # noqa: E501

        :param old_product: The old_product of this ConvertPositionRequest.  # noqa: E501
        :type: str
        """
        if old_product is None:
            raise ValueError("Invalid value for `old_product`, must not be `None`")  # noqa: E501
        allowed_values = ["I", "D", "CO", "OCO", "MTF"]  # noqa: E501
        if old_product not in allowed_values:
            raise ValueError(
                "Invalid value for `old_product` ({0}), must be one of {1}"  # noqa: E501
                .format(old_product, allowed_values)
            )

        self._old_product = old_product

    @property
    def transaction_type(self):
        """Gets the transaction_type of this ConvertPositionRequest.  # noqa: E501

        Indicates whether its a buy(b) or sell(s) order  # noqa: E501

        :return: The transaction_type of this ConvertPositionRequest.  # noqa: E501
        :rtype: str
        """
        return self._transaction_type

    @transaction_type.setter
    def transaction_type(self, transaction_type):
        """Sets the transaction_type of this ConvertPositionRequest.

        Indicates whether its a buy(b) or sell(s) order  # noqa: E501

        :param transaction_type: The transaction_type of this ConvertPositionRequest.  # noqa: E501
        :type: str
        """
        if transaction_type is None:
            raise ValueError("Invalid value for `transaction_type`, must not be `None`")  # noqa: E501
        allowed_values = ["BUY", "SELL"]  # noqa: E501
        if transaction_type not in allowed_values:
            raise ValueError(
                "Invalid value for `transaction_type` ({0}), must be one of {1}"  # noqa: E501
                .format(transaction_type, allowed_values)
            )

        self._transaction_type = transaction_type

    @property
    def quantity(self):
        """Gets the quantity of this ConvertPositionRequest.  # noqa: E501

        Quantity with which the position to convert  # noqa: E501

        :return: The quantity of this ConvertPositionRequest.  # noqa: E501
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this ConvertPositionRequest.

        Quantity with which the position to convert  # noqa: E501

        :param quantity: The quantity of this ConvertPositionRequest.  # noqa: E501
        :type: int
        """
        if quantity is None:
            raise ValueError("Invalid value for `quantity`, must not be `None`")  # noqa: E501

        self._quantity = quantity

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ConvertPositionRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ConvertPositionRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
