# coding: utf-8

"""
    Upstox Developer API

    Build your App on the Upstox platform  ![Banner](https://api-v2.upstox.com/api-docs/images/banner.jpg \"banner\")  # Introduction  Upstox API is a set of rest APIs that provide data required to build a complete investment and trading platform. Execute orders in real time, manage user portfolio, stream live market data (using Websocket), and more, with the easy to understand API collection.  All requests are over HTTPS and the requests are sent with the content-type ‘application/json’. Developers have the option of choosing the response type as JSON or CSV for a few API calls.  To be able to use these APIs you need to create an App in the Developer Console and generate your **apiKey** and **apiSecret**. You can use a redirect URL which will be called after the login flow.  If you are a **trader**, you can directly create apps from Upstox mobile app or the desktop platform itself from **Apps** sections inside the **Account** Tab. Head over to <a href=\"http://account.upstox.com/developer/apps\" target=\"_blank\">account.upstox.com/developer/apps</a>.</br> If you are a **business** looking to integrate Upstox APIs, reach out to us and we will get a custom app created for you in no time.  It is highly recommended that you do not embed the **apiSecret** in your frontend app. Create a remote backend which does the handshake on behalf of the frontend app. Marking the apiSecret in the frontend app will make your app vulnerable to threats and potential issues.   # noqa: E501

    OpenAPI spec version: v2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class OrderBookData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'exchange': 'str',
        'product': 'str',
        'price': 'float',
        'quantity': 'int',
        'status': 'str',
        'guid': 'str',
        'tag': 'str',
        'instrument_token': 'str',
        'placed_by': 'str',
        'tradingsymbol': 'str',
        'trading_symbol': 'str',
        'order_type': 'str',
        'validity': 'str',
        'trigger_price': 'float',
        'disclosed_quantity': 'int',
        'transaction_type': 'str',
        'average_price': 'float',
        'filled_quantity': 'int',
        'pending_quantity': 'int',
        'status_message': 'str',
        'status_message_raw': 'str',
        'exchange_order_id': 'str',
        'parent_order_id': 'str',
        'order_id': 'str',
        'variety': 'str',
        'order_timestamp': 'str',
        'exchange_timestamp': 'str',
        'is_amo': 'bool',
        'order_request_id': 'str',
        'order_ref_id': 'str'
    }

    attribute_map = {
        'exchange': 'exchange',
        'product': 'product',
        'price': 'price',
        'quantity': 'quantity',
        'status': 'status',
        'guid': 'guid',
        'tag': 'tag',
        'instrument_token': 'instrument_token',
        'placed_by': 'placed_by',
        'tradingsymbol': 'tradingsymbol',
        'trading_symbol': 'trading_symbol',
        'order_type': 'order_type',
        'validity': 'validity',
        'trigger_price': 'trigger_price',
        'disclosed_quantity': 'disclosed_quantity',
        'transaction_type': 'transaction_type',
        'average_price': 'average_price',
        'filled_quantity': 'filled_quantity',
        'pending_quantity': 'pending_quantity',
        'status_message': 'status_message',
        'status_message_raw': 'status_message_raw',
        'exchange_order_id': 'exchange_order_id',
        'parent_order_id': 'parent_order_id',
        'order_id': 'order_id',
        'variety': 'variety',
        'order_timestamp': 'order_timestamp',
        'exchange_timestamp': 'exchange_timestamp',
        'is_amo': 'is_amo',
        'order_request_id': 'order_request_id',
        'order_ref_id': 'order_ref_id'
    }

    def __init__(self, exchange=None, product=None, price=None, quantity=None, status=None, guid=None, tag=None, instrument_token=None, placed_by=None, tradingsymbol=None, trading_symbol=None, order_type=None, validity=None, trigger_price=None, disclosed_quantity=None, transaction_type=None, average_price=None, filled_quantity=None, pending_quantity=None, status_message=None, status_message_raw=None, exchange_order_id=None, parent_order_id=None, order_id=None, variety=None, order_timestamp=None, exchange_timestamp=None, is_amo=None, order_request_id=None, order_ref_id=None):  # noqa: E501
        """OrderBookData - a model defined in Swagger"""  # noqa: E501
        self._exchange = None
        self._product = None
        self._price = None
        self._quantity = None
        self._status = None
        self._guid = None
        self._tag = None
        self._instrument_token = None
        self._placed_by = None
        self._tradingsymbol = None
        self._trading_symbol = None
        self._order_type = None
        self._validity = None
        self._trigger_price = None
        self._disclosed_quantity = None
        self._transaction_type = None
        self._average_price = None
        self._filled_quantity = None
        self._pending_quantity = None
        self._status_message = None
        self._status_message_raw = None
        self._exchange_order_id = None
        self._parent_order_id = None
        self._order_id = None
        self._variety = None
        self._order_timestamp = None
        self._exchange_timestamp = None
        self._is_amo = None
        self._order_request_id = None
        self._order_ref_id = None
        self.discriminator = None
        if exchange is not None:
            self.exchange = exchange
        if product is not None:
            self.product = product
        if price is not None:
            self.price = price
        if quantity is not None:
            self.quantity = quantity
        if status is not None:
            self.status = status
        if guid is not None:
            self.guid = guid
        if tag is not None:
            self.tag = tag
        if instrument_token is not None:
            self.instrument_token = instrument_token
        if placed_by is not None:
            self.placed_by = placed_by
        if tradingsymbol is not None:
            self.tradingsymbol = tradingsymbol
        if trading_symbol is not None:
            self.trading_symbol = trading_symbol
        if order_type is not None:
            self.order_type = order_type
        if validity is not None:
            self.validity = validity
        if trigger_price is not None:
            self.trigger_price = trigger_price
        if disclosed_quantity is not None:
            self.disclosed_quantity = disclosed_quantity
        if transaction_type is not None:
            self.transaction_type = transaction_type
        if average_price is not None:
            self.average_price = average_price
        if filled_quantity is not None:
            self.filled_quantity = filled_quantity
        if pending_quantity is not None:
            self.pending_quantity = pending_quantity
        if status_message is not None:
            self.status_message = status_message
        if status_message_raw is not None:
            self.status_message_raw = status_message_raw
        if exchange_order_id is not None:
            self.exchange_order_id = exchange_order_id
        if parent_order_id is not None:
            self.parent_order_id = parent_order_id
        if order_id is not None:
            self.order_id = order_id
        if variety is not None:
            self.variety = variety
        if order_timestamp is not None:
            self.order_timestamp = order_timestamp
        if exchange_timestamp is not None:
            self.exchange_timestamp = exchange_timestamp
        if is_amo is not None:
            self.is_amo = is_amo
        if order_request_id is not None:
            self.order_request_id = order_request_id
        if order_ref_id is not None:
            self.order_ref_id = order_ref_id

    @property
    def exchange(self):
        """Gets the exchange of this OrderBookData.  # noqa: E501

        Exchange to which the order is associated  # noqa: E501

        :return: The exchange of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._exchange

    @exchange.setter
    def exchange(self, exchange):
        """Sets the exchange of this OrderBookData.

        Exchange to which the order is associated  # noqa: E501

        :param exchange: The exchange of this OrderBookData.  # noqa: E501
        :type: str
        """
        allowed_values = ["NSE", "NFO", "CDS", "BSE", "BFO", "BCD", "MCX"]  # noqa: E501
        if exchange not in allowed_values:
            raise ValueError(
                "Invalid value for `exchange` ({0}), must be one of {1}"  # noqa: E501
                .format(exchange, allowed_values)
            )

        self._exchange = exchange

    @property
    def product(self):
        """Gets the product of this OrderBookData.  # noqa: E501

        Shows if the order was either Intraday, Delivery, CoverOrder or OneCancelsOther  # noqa: E501

        :return: The product of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._product

    @product.setter
    def product(self, product):
        """Sets the product of this OrderBookData.

        Shows if the order was either Intraday, Delivery, CoverOrder or OneCancelsOther  # noqa: E501

        :param product: The product of this OrderBookData.  # noqa: E501
        :type: str
        """
        allowed_values = ["I", "D", "CO", "OCO", "MTF"]  # noqa: E501
        if product not in allowed_values:
            raise ValueError(
                "Invalid value for `product` ({0}), must be one of {1}"  # noqa: E501
                .format(product, allowed_values)
            )

        self._product = product

    @property
    def price(self):
        """Gets the price of this OrderBookData.  # noqa: E501

        Price at which the order was placed  # noqa: E501

        :return: The price of this OrderBookData.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this OrderBookData.

        Price at which the order was placed  # noqa: E501

        :param price: The price of this OrderBookData.  # noqa: E501
        :type: float
        """

        self._price = price

    @property
    def quantity(self):
        """Gets the quantity of this OrderBookData.  # noqa: E501

        Quantity with which the order was placed  # noqa: E501

        :return: The quantity of this OrderBookData.  # noqa: E501
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this OrderBookData.

        Quantity with which the order was placed  # noqa: E501

        :param quantity: The quantity of this OrderBookData.  # noqa: E501
        :type: int
        """

        self._quantity = quantity

    @property
    def status(self):
        """Gets the status of this OrderBookData.  # noqa: E501

        Indicates the current status of the order. Valid order status’ are outlined in the table below  # noqa: E501

        :return: The status of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this OrderBookData.

        Indicates the current status of the order. Valid order status’ are outlined in the table below  # noqa: E501

        :param status: The status of this OrderBookData.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def guid(self):
        """Gets the guid of this OrderBookData.  # noqa: E501


        :return: The guid of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._guid

    @guid.setter
    def guid(self, guid):
        """Sets the guid of this OrderBookData.


        :param guid: The guid of this OrderBookData.  # noqa: E501
        :type: str
        """

        self._guid = guid

    @property
    def tag(self):
        """Gets the tag of this OrderBookData.  # noqa: E501

        Tag to uniquely identify an order  # noqa: E501

        :return: The tag of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """Sets the tag of this OrderBookData.

        Tag to uniquely identify an order  # noqa: E501

        :param tag: The tag of this OrderBookData.  # noqa: E501
        :type: str
        """

        self._tag = tag

    @property
    def instrument_token(self):
        """Gets the instrument_token of this OrderBookData.  # noqa: E501

        Identifier issued by Upstox used for subscribing to live market quotes  # noqa: E501

        :return: The instrument_token of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._instrument_token

    @instrument_token.setter
    def instrument_token(self, instrument_token):
        """Sets the instrument_token of this OrderBookData.

        Identifier issued by Upstox used for subscribing to live market quotes  # noqa: E501

        :param instrument_token: The instrument_token of this OrderBookData.  # noqa: E501
        :type: str
        """

        self._instrument_token = instrument_token

    @property
    def placed_by(self):
        """Gets the placed_by of this OrderBookData.  # noqa: E501

        Uniquely identifies the user  # noqa: E501

        :return: The placed_by of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._placed_by

    @placed_by.setter
    def placed_by(self, placed_by):
        """Sets the placed_by of this OrderBookData.

        Uniquely identifies the user  # noqa: E501

        :param placed_by: The placed_by of this OrderBookData.  # noqa: E501
        :type: str
        """

        self._placed_by = placed_by

    @property
    def tradingsymbol(self):
        """Gets the tradingsymbol of this OrderBookData.  # noqa: E501

        Shows the trading symbol of the instrument  # noqa: E501

        :return: The tradingsymbol of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._tradingsymbol

    @tradingsymbol.setter
    def tradingsymbol(self, tradingsymbol):
        """Sets the tradingsymbol of this OrderBookData.

        Shows the trading symbol of the instrument  # noqa: E501

        :param tradingsymbol: The tradingsymbol of this OrderBookData.  # noqa: E501
        :type: str
        """

        self._tradingsymbol = tradingsymbol

    @property
    def trading_symbol(self):
        """Gets the trading_symbol of this OrderBookData.  # noqa: E501

        Shows the trading symbol of the instrument  # noqa: E501

        :return: The trading_symbol of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._trading_symbol

    @trading_symbol.setter
    def trading_symbol(self, trading_symbol):
        """Sets the trading_symbol of this OrderBookData.

        Shows the trading symbol of the instrument  # noqa: E501

        :param trading_symbol: The trading_symbol of this OrderBookData.  # noqa: E501
        :type: str
        """

        self._trading_symbol = trading_symbol

    @property
    def order_type(self):
        """Gets the order_type of this OrderBookData.  # noqa: E501

        Type of order. It can be one of the following MARKET refers to market order<br>LIMIT refers to Limit Order<br>SL refers to Stop Loss Limit<br>SL-M refers to Stop loss market  # noqa: E501

        :return: The order_type of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._order_type

    @order_type.setter
    def order_type(self, order_type):
        """Sets the order_type of this OrderBookData.

        Type of order. It can be one of the following MARKET refers to market order<br>LIMIT refers to Limit Order<br>SL refers to Stop Loss Limit<br>SL-M refers to Stop loss market  # noqa: E501

        :param order_type: The order_type of this OrderBookData.  # noqa: E501
        :type: str
        """
        allowed_values = ["MARKET", "LIMIT", "SL", "SL-M"]  # noqa: E501
        if order_type not in allowed_values:
            raise ValueError(
                "Invalid value for `order_type` ({0}), must be one of {1}"  # noqa: E501
                .format(order_type, allowed_values)
            )

        self._order_type = order_type

    @property
    def validity(self):
        """Gets the validity of this OrderBookData.  # noqa: E501

        Order validity (DAY- Day and IOC- Immediate or Cancel (IOC) order)  # noqa: E501

        :return: The validity of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._validity

    @validity.setter
    def validity(self, validity):
        """Sets the validity of this OrderBookData.

        Order validity (DAY- Day and IOC- Immediate or Cancel (IOC) order)  # noqa: E501

        :param validity: The validity of this OrderBookData.  # noqa: E501
        :type: str
        """
        allowed_values = ["DAY", "IOC"]  # noqa: E501
        if validity not in allowed_values:
            raise ValueError(
                "Invalid value for `validity` ({0}), must be one of {1}"  # noqa: E501
                .format(validity, allowed_values)
            )

        self._validity = validity

    @property
    def trigger_price(self):
        """Gets the trigger_price of this OrderBookData.  # noqa: E501

        If the order was a stop loss order then the trigger price set is mentioned here  # noqa: E501

        :return: The trigger_price of this OrderBookData.  # noqa: E501
        :rtype: float
        """
        return self._trigger_price

    @trigger_price.setter
    def trigger_price(self, trigger_price):
        """Sets the trigger_price of this OrderBookData.

        If the order was a stop loss order then the trigger price set is mentioned here  # noqa: E501

        :param trigger_price: The trigger_price of this OrderBookData.  # noqa: E501
        :type: float
        """

        self._trigger_price = trigger_price

    @property
    def disclosed_quantity(self):
        """Gets the disclosed_quantity of this OrderBookData.  # noqa: E501

        The quantity that should be disclosed in the market depth  # noqa: E501

        :return: The disclosed_quantity of this OrderBookData.  # noqa: E501
        :rtype: int
        """
        return self._disclosed_quantity

    @disclosed_quantity.setter
    def disclosed_quantity(self, disclosed_quantity):
        """Sets the disclosed_quantity of this OrderBookData.

        The quantity that should be disclosed in the market depth  # noqa: E501

        :param disclosed_quantity: The disclosed_quantity of this OrderBookData.  # noqa: E501
        :type: int
        """

        self._disclosed_quantity = disclosed_quantity

    @property
    def transaction_type(self):
        """Gets the transaction_type of this OrderBookData.  # noqa: E501

        Indicates whether the order was a buy or sell order  # noqa: E501

        :return: The transaction_type of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._transaction_type

    @transaction_type.setter
    def transaction_type(self, transaction_type):
        """Sets the transaction_type of this OrderBookData.

        Indicates whether the order was a buy or sell order  # noqa: E501

        :param transaction_type: The transaction_type of this OrderBookData.  # noqa: E501
        :type: str
        """
        allowed_values = ["BUY", "SELL"]  # noqa: E501
        if transaction_type not in allowed_values:
            raise ValueError(
                "Invalid value for `transaction_type` ({0}), must be one of {1}"  # noqa: E501
                .format(transaction_type, allowed_values)
            )

        self._transaction_type = transaction_type

    @property
    def average_price(self):
        """Gets the average_price of this OrderBookData.  # noqa: E501

        Average price at which the qty got traded  # noqa: E501

        :return: The average_price of this OrderBookData.  # noqa: E501
        :rtype: float
        """
        return self._average_price

    @average_price.setter
    def average_price(self, average_price):
        """Sets the average_price of this OrderBookData.

        Average price at which the qty got traded  # noqa: E501

        :param average_price: The average_price of this OrderBookData.  # noqa: E501
        :type: float
        """

        self._average_price = average_price

    @property
    def filled_quantity(self):
        """Gets the filled_quantity of this OrderBookData.  # noqa: E501

        The total quantity traded from this particular order  # noqa: E501

        :return: The filled_quantity of this OrderBookData.  # noqa: E501
        :rtype: int
        """
        return self._filled_quantity

    @filled_quantity.setter
    def filled_quantity(self, filled_quantity):
        """Sets the filled_quantity of this OrderBookData.

        The total quantity traded from this particular order  # noqa: E501

        :param filled_quantity: The filled_quantity of this OrderBookData.  # noqa: E501
        :type: int
        """

        self._filled_quantity = filled_quantity

    @property
    def pending_quantity(self):
        """Gets the pending_quantity of this OrderBookData.  # noqa: E501

        Pending quantity to be filled  # noqa: E501

        :return: The pending_quantity of this OrderBookData.  # noqa: E501
        :rtype: int
        """
        return self._pending_quantity

    @pending_quantity.setter
    def pending_quantity(self, pending_quantity):
        """Sets the pending_quantity of this OrderBookData.

        Pending quantity to be filled  # noqa: E501

        :param pending_quantity: The pending_quantity of this OrderBookData.  # noqa: E501
        :type: int
        """

        self._pending_quantity = pending_quantity

    @property
    def status_message(self):
        """Gets the status_message of this OrderBookData.  # noqa: E501

        Indicates the reason when any order is rejected, not modified or cancelled  # noqa: E501

        :return: The status_message of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._status_message

    @status_message.setter
    def status_message(self, status_message):
        """Sets the status_message of this OrderBookData.

        Indicates the reason when any order is rejected, not modified or cancelled  # noqa: E501

        :param status_message: The status_message of this OrderBookData.  # noqa: E501
        :type: str
        """

        self._status_message = status_message

    @property
    def status_message_raw(self):
        """Gets the status_message_raw of this OrderBookData.  # noqa: E501

        Description of the order's status as received from RMS  # noqa: E501

        :return: The status_message_raw of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._status_message_raw

    @status_message_raw.setter
    def status_message_raw(self, status_message_raw):
        """Sets the status_message_raw of this OrderBookData.

        Description of the order's status as received from RMS  # noqa: E501

        :param status_message_raw: The status_message_raw of this OrderBookData.  # noqa: E501
        :type: str
        """

        self._status_message_raw = status_message_raw

    @property
    def exchange_order_id(self):
        """Gets the exchange_order_id of this OrderBookData.  # noqa: E501

        Unique order ID assigned by the exchange for the order placed  # noqa: E501

        :return: The exchange_order_id of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._exchange_order_id

    @exchange_order_id.setter
    def exchange_order_id(self, exchange_order_id):
        """Sets the exchange_order_id of this OrderBookData.

        Unique order ID assigned by the exchange for the order placed  # noqa: E501

        :param exchange_order_id: The exchange_order_id of this OrderBookData.  # noqa: E501
        :type: str
        """

        self._exchange_order_id = exchange_order_id

    @property
    def parent_order_id(self):
        """Gets the parent_order_id of this OrderBookData.  # noqa: E501

        In case the order is part of the second or third leg of a CO or OCO, the parent order ID is indicated here  # noqa: E501

        :return: The parent_order_id of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._parent_order_id

    @parent_order_id.setter
    def parent_order_id(self, parent_order_id):
        """Sets the parent_order_id of this OrderBookData.

        In case the order is part of the second or third leg of a CO or OCO, the parent order ID is indicated here  # noqa: E501

        :param parent_order_id: The parent_order_id of this OrderBookData.  # noqa: E501
        :type: str
        """

        self._parent_order_id = parent_order_id

    @property
    def order_id(self):
        """Gets the order_id of this OrderBookData.  # noqa: E501

        Unique order ID assigned internally for the order placed  # noqa: E501

        :return: The order_id of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._order_id

    @order_id.setter
    def order_id(self, order_id):
        """Sets the order_id of this OrderBookData.

        Unique order ID assigned internally for the order placed  # noqa: E501

        :param order_id: The order_id of this OrderBookData.  # noqa: E501
        :type: str
        """

        self._order_id = order_id

    @property
    def variety(self):
        """Gets the variety of this OrderBookData.  # noqa: E501

        Order complexity  # noqa: E501

        :return: The variety of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._variety

    @variety.setter
    def variety(self, variety):
        """Sets the variety of this OrderBookData.

        Order complexity  # noqa: E501

        :param variety: The variety of this OrderBookData.  # noqa: E501
        :type: str
        """

        self._variety = variety

    @property
    def order_timestamp(self):
        """Gets the order_timestamp of this OrderBookData.  # noqa: E501

        User readable timestamp at which the order was placed  # noqa: E501

        :return: The order_timestamp of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._order_timestamp

    @order_timestamp.setter
    def order_timestamp(self, order_timestamp):
        """Sets the order_timestamp of this OrderBookData.

        User readable timestamp at which the order was placed  # noqa: E501

        :param order_timestamp: The order_timestamp of this OrderBookData.  # noqa: E501
        :type: str
        """

        self._order_timestamp = order_timestamp

    @property
    def exchange_timestamp(self):
        """Gets the exchange_timestamp of this OrderBookData.  # noqa: E501

        User readable time at which the order was placed or updated  # noqa: E501

        :return: The exchange_timestamp of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._exchange_timestamp

    @exchange_timestamp.setter
    def exchange_timestamp(self, exchange_timestamp):
        """Sets the exchange_timestamp of this OrderBookData.

        User readable time at which the order was placed or updated  # noqa: E501

        :param exchange_timestamp: The exchange_timestamp of this OrderBookData.  # noqa: E501
        :type: str
        """

        self._exchange_timestamp = exchange_timestamp

    @property
    def is_amo(self):
        """Gets the is_amo of this OrderBookData.  # noqa: E501

        Signifies if the order is an After Market Order  # noqa: E501

        :return: The is_amo of this OrderBookData.  # noqa: E501
        :rtype: bool
        """
        return self._is_amo

    @is_amo.setter
    def is_amo(self, is_amo):
        """Sets the is_amo of this OrderBookData.

        Signifies if the order is an After Market Order  # noqa: E501

        :param is_amo: The is_amo of this OrderBookData.  # noqa: E501
        :type: bool
        """

        self._is_amo = is_amo

    @property
    def order_request_id(self):
        """Gets the order_request_id of this OrderBookData.  # noqa: E501

        Apart from 1st order it shows the count of how many requests were sent  # noqa: E501

        :return: The order_request_id of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._order_request_id

    @order_request_id.setter
    def order_request_id(self, order_request_id):
        """Sets the order_request_id of this OrderBookData.

        Apart from 1st order it shows the count of how many requests were sent  # noqa: E501

        :param order_request_id: The order_request_id of this OrderBookData.  # noqa: E501
        :type: str
        """

        self._order_request_id = order_request_id

    @property
    def order_ref_id(self):
        """Gets the order_ref_id of this OrderBookData.  # noqa: E501

        The order reference ID for which the order must be modified  # noqa: E501

        :return: The order_ref_id of this OrderBookData.  # noqa: E501
        :rtype: str
        """
        return self._order_ref_id

    @order_ref_id.setter
    def order_ref_id(self, order_ref_id):
        """Sets the order_ref_id of this OrderBookData.

        The order reference ID for which the order must be modified  # noqa: E501

        :param order_ref_id: The order_ref_id of this OrderBookData.  # noqa: E501
        :type: str
        """

        self._order_ref_id = order_ref_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OrderBookData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrderBookData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
