# coding: utf-8

"""
    Upstox Developer API

    Build your App on the Upstox platform  ![Banner](https://api-v2.upstox.com/api-docs/images/banner.jpg \"banner\")  # Introduction  Upstox API is a set of rest APIs that provide data required to build a complete investment and trading platform. Execute orders in real time, manage user portfolio, stream live market data (using Websocket), and more, with the easy to understand API collection.  All requests are over HTTPS and the requests are sent with the content-type ‘application/json’. Developers have the option of choosing the response type as JSON or CSV for a few API calls.  To be able to use these APIs you need to create an App in the Developer Console and generate your **apiKey** and **apiSecret**. You can use a redirect URL which will be called after the login flow.  If you are a **trader**, you can directly create apps from Upstox mobile app or the desktop platform itself from **Apps** sections inside the **Account** Tab. Head over to <a href=\"http://account.upstox.com/developer/apps\" target=\"_blank\">account.upstox.com/developer/apps</a>.</br> If you are a **business** looking to integrate Upstox APIs, reach out to us and we will get a custom app created for you in no time.  It is highly recommended that you do not embed the **apiSecret** in your frontend app. Create a remote backend which does the handshake on behalf of the frontend app. Marking the apiSecret in the frontend app will make your app vulnerable to threats and potential issues.   # noqa: E501

    OpenAPI spec version: v2
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class TradeWiseProfitAndLossData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'quantity': 'float',
        'isin': 'str',
        'scrip_name': 'str',
        'trade_type': 'str',
        'buy_date': 'str',
        'buy_average': 'float',
        'sell_date': 'str',
        'sell_average': 'float',
        'buy_amount': 'float',
        'sell_amount': 'float'
    }

    attribute_map = {
        'quantity': 'quantity',
        'isin': 'isin',
        'scrip_name': 'scrip_name',
        'trade_type': 'trade_type',
        'buy_date': 'buy_date',
        'buy_average': 'buy_average',
        'sell_date': 'sell_date',
        'sell_average': 'sell_average',
        'buy_amount': 'buy_amount',
        'sell_amount': 'sell_amount'
    }

    def __init__(self, quantity=None, isin=None, scrip_name=None, trade_type=None, buy_date=None, buy_average=None, sell_date=None, sell_average=None, buy_amount=None, sell_amount=None):  # noqa: E501
        """TradeWiseProfitAndLossData - a model defined in Swagger"""  # noqa: E501
        self._quantity = None
        self._isin = None
        self._scrip_name = None
        self._trade_type = None
        self._buy_date = None
        self._buy_average = None
        self._sell_date = None
        self._sell_average = None
        self._buy_amount = None
        self._sell_amount = None
        self.discriminator = None
        if quantity is not None:
            self.quantity = quantity
        if isin is not None:
            self.isin = isin
        if scrip_name is not None:
            self.scrip_name = scrip_name
        if trade_type is not None:
            self.trade_type = trade_type
        if buy_date is not None:
            self.buy_date = buy_date
        if buy_average is not None:
            self.buy_average = buy_average
        if sell_date is not None:
            self.sell_date = sell_date
        if sell_average is not None:
            self.sell_average = sell_average
        if buy_amount is not None:
            self.buy_amount = buy_amount
        if sell_amount is not None:
            self.sell_amount = sell_amount

    @property
    def quantity(self):
        """Gets the quantity of this TradeWiseProfitAndLossData.  # noqa: E501

        The quantity of stock traded  # noqa: E501

        :return: The quantity of this TradeWiseProfitAndLossData.  # noqa: E501
        :rtype: float
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this TradeWiseProfitAndLossData.

        The quantity of stock traded  # noqa: E501

        :param quantity: The quantity of this TradeWiseProfitAndLossData.  # noqa: E501
        :type: float
        """

        self._quantity = quantity

    @property
    def isin(self):
        """Gets the isin of this TradeWiseProfitAndLossData.  # noqa: E501

        ISIN of the stock  # noqa: E501

        :return: The isin of this TradeWiseProfitAndLossData.  # noqa: E501
        :rtype: str
        """
        return self._isin

    @isin.setter
    def isin(self, isin):
        """Sets the isin of this TradeWiseProfitAndLossData.

        ISIN of the stock  # noqa: E501

        :param isin: The isin of this TradeWiseProfitAndLossData.  # noqa: E501
        :type: str
        """

        self._isin = isin

    @property
    def scrip_name(self):
        """Gets the scrip_name of this TradeWiseProfitAndLossData.  # noqa: E501

        Name of the scrip traded  # noqa: E501

        :return: The scrip_name of this TradeWiseProfitAndLossData.  # noqa: E501
        :rtype: str
        """
        return self._scrip_name

    @scrip_name.setter
    def scrip_name(self, scrip_name):
        """Sets the scrip_name of this TradeWiseProfitAndLossData.

        Name of the scrip traded  # noqa: E501

        :param scrip_name: The scrip_name of this TradeWiseProfitAndLossData.  # noqa: E501
        :type: str
        """

        self._scrip_name = scrip_name

    @property
    def trade_type(self):
        """Gets the trade_type of this TradeWiseProfitAndLossData.  # noqa: E501

        FUT - Futures   OPT - Options    EQ - Equity  # noqa: E501

        :return: The trade_type of this TradeWiseProfitAndLossData.  # noqa: E501
        :rtype: str
        """
        return self._trade_type

    @trade_type.setter
    def trade_type(self, trade_type):
        """Sets the trade_type of this TradeWiseProfitAndLossData.

        FUT - Futures   OPT - Options    EQ - Equity  # noqa: E501

        :param trade_type: The trade_type of this TradeWiseProfitAndLossData.  # noqa: E501
        :type: str
        """

        self._trade_type = trade_type

    @property
    def buy_date(self):
        """Gets the buy_date of this TradeWiseProfitAndLossData.  # noqa: E501

        The date on which the stock was bought  # noqa: E501

        :return: The buy_date of this TradeWiseProfitAndLossData.  # noqa: E501
        :rtype: str
        """
        return self._buy_date

    @buy_date.setter
    def buy_date(self, buy_date):
        """Sets the buy_date of this TradeWiseProfitAndLossData.

        The date on which the stock was bought  # noqa: E501

        :param buy_date: The buy_date of this TradeWiseProfitAndLossData.  # noqa: E501
        :type: str
        """

        self._buy_date = buy_date

    @property
    def buy_average(self):
        """Gets the buy_average of this TradeWiseProfitAndLossData.  # noqa: E501

        The average rate at which each quantity of the stock was bought  # noqa: E501

        :return: The buy_average of this TradeWiseProfitAndLossData.  # noqa: E501
        :rtype: float
        """
        return self._buy_average

    @buy_average.setter
    def buy_average(self, buy_average):
        """Sets the buy_average of this TradeWiseProfitAndLossData.

        The average rate at which each quantity of the stock was bought  # noqa: E501

        :param buy_average: The buy_average of this TradeWiseProfitAndLossData.  # noqa: E501
        :type: float
        """

        self._buy_average = buy_average

    @property
    def sell_date(self):
        """Gets the sell_date of this TradeWiseProfitAndLossData.  # noqa: E501

        The date on which the stock was sold  # noqa: E501

        :return: The sell_date of this TradeWiseProfitAndLossData.  # noqa: E501
        :rtype: str
        """
        return self._sell_date

    @sell_date.setter
    def sell_date(self, sell_date):
        """Sets the sell_date of this TradeWiseProfitAndLossData.

        The date on which the stock was sold  # noqa: E501

        :param sell_date: The sell_date of this TradeWiseProfitAndLossData.  # noqa: E501
        :type: str
        """

        self._sell_date = sell_date

    @property
    def sell_average(self):
        """Gets the sell_average of this TradeWiseProfitAndLossData.  # noqa: E501

        The average rate at which each quantity of the stock was sold  # noqa: E501

        :return: The sell_average of this TradeWiseProfitAndLossData.  # noqa: E501
        :rtype: float
        """
        return self._sell_average

    @sell_average.setter
    def sell_average(self, sell_average):
        """Sets the sell_average of this TradeWiseProfitAndLossData.

        The average rate at which each quantity of the stock was sold  # noqa: E501

        :param sell_average: The sell_average of this TradeWiseProfitAndLossData.  # noqa: E501
        :type: float
        """

        self._sell_average = sell_average

    @property
    def buy_amount(self):
        """Gets the buy_amount of this TradeWiseProfitAndLossData.  # noqa: E501

        Total buy amount  # noqa: E501

        :return: The buy_amount of this TradeWiseProfitAndLossData.  # noqa: E501
        :rtype: float
        """
        return self._buy_amount

    @buy_amount.setter
    def buy_amount(self, buy_amount):
        """Sets the buy_amount of this TradeWiseProfitAndLossData.

        Total buy amount  # noqa: E501

        :param buy_amount: The buy_amount of this TradeWiseProfitAndLossData.  # noqa: E501
        :type: float
        """

        self._buy_amount = buy_amount

    @property
    def sell_amount(self):
        """Gets the sell_amount of this TradeWiseProfitAndLossData.  # noqa: E501

        Total sell amount  # noqa: E501

        :return: The sell_amount of this TradeWiseProfitAndLossData.  # noqa: E501
        :rtype: float
        """
        return self._sell_amount

    @sell_amount.setter
    def sell_amount(self, sell_amount):
        """Sets the sell_amount of this TradeWiseProfitAndLossData.

        Total sell amount  # noqa: E501

        :param sell_amount: The sell_amount of this TradeWiseProfitAndLossData.  # noqa: E501
        :type: float
        """

        self._sell_amount = sell_amount

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TradeWiseProfitAndLossData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TradeWiseProfitAndLossData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
