import type { FunctionOptions } from 'aws-cdk-lib/aws-lambda';
import { Function, Runtime } from 'aws-cdk-lib/aws-lambda';
import type { Construct } from 'constructs';
import type { BundlingOptions } from './types';
export interface PythonFunctionProps extends FunctionOptions {
    /**
     * UV project root directory (workspace root)
     */
    readonly rootDir: string;
    /**
     * Optional UV project workspace, used to specify a specific package to be used
     * as a Lambda Function entry.
     */
    readonly workspacePackage?: string;
    /**
     * The runtime
     *
     * @default Runtime.PYTHON_3_12
     */
    readonly runtime?: Runtime;
    /**
     * The path to the index file with the project or (or workspace, if specified) containing the handler.
     *
     * @default index.py
     */
    readonly index?: string;
    /**
     * The name of the exported handler function in the #index
     *
     * @default handler
     */
    readonly handler?: string;
    /**
     * Custom bundling options, including build architecture and bundling container image
     */
    readonly bundling?: BundlingOptions;
}
export declare class PythonFunction extends Function {
    constructor(scope: Construct, id: string, props: PythonFunctionProps);
}
