"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("node:fs");
const path = require("node:path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const bundling_1 = require("./bundling");
class PythonFunction extends aws_lambda_1.Function {
    constructor(scope, id, props) {
        const { workspacePackage, handler = 'handler', index = 'index.py', runtime = aws_lambda_1.Runtime.PYTHON_3_12, } = props;
        const architecture = props.architecture ?? aws_lambda_1.Architecture.ARM_64;
        const rootDir = path.resolve(props.rootDir);
        const resolvedHandler = `${index.slice(0, -3)}.${handler}`.replace(/\//g, '.');
        if (runtime.family !== aws_lambda_1.RuntimeFamily.PYTHON) {
            throw new Error('Only Python runtimes are supported');
        }
        const code = bundling_1.Bundling.bundle({
            rootDir,
            runtime,
            skip: !aws_cdk_lib_1.Stack.of(scope).bundlingRequired,
            architecture,
            workspacePackage,
            ...props.bundling,
        });
        const environment = props.environment ?? {};
        super(scope, id, {
            ...props,
            environment,
            architecture,
            runtime,
            code,
            handler: resolvedHandler,
        });
        const assetPath = (this.node.defaultChild).getMetadata('aws:asset:path');
        if (assetPath) { // TODO - remove - we always need one
            const codePath = path.join(process.env.CDK_OUTDIR, assetPath);
            const pythonPaths = getPthFilePaths(codePath);
            if (pythonPaths.length > 0) {
                let pythonPathValue = environment.PYTHONPATH;
                const addedPaths = pythonPaths.join(':');
                pythonPathValue = pythonPathValue ? `${pythonPathValue}:${addedPaths}` : addedPaths;
                this.addEnvironment('PYTHONPATH', pythonPathValue);
            }
        }
    }
}
exports.PythonFunction = PythonFunction;
_a = JSII_RTTI_SYMBOL_1;
PythonFunction[_a] = { fqn: "uv-python-lambda.PythonFunction", version: "0.0.1" };
function getPthFilePaths(basePath) {
    const pthFiles = fs.readdirSync(basePath).filter(file => file.endsWith('.pth'));
    const pythonPaths = [];
    for (const pthFile of pthFiles) {
        const filePath = path.join(basePath, pthFile);
        const content = fs.readFileSync(filePath, 'utf-8');
        const dirs = content.split('\n').filter(line => line.trim() !== '');
        pythonPaths.push(...dirs.map(dir => path.join('/var/task', path.relative('/asset-output', dir))));
    }
    return pythonPaths;
}
//# sourceMappingURL=data:application/json;base64,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