"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bundling = exports.DEFAULT_ASSET_EXCLUDES = exports.HASHABLE_DEPENDENCIES_EXCLUDE = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("node:path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
exports.HASHABLE_DEPENDENCIES_EXCLUDE = ['*.pyc'];
exports.DEFAULT_ASSET_EXCLUDES = [
    '.venv/',
    'node_modules/',
    'cdk.out/',
    '.git/',
];
/**
 * Bundling options for Python Lambda assets
 */
class Bundling {
    static bundle(options) {
        return aws_lambda_1.Code.fromAsset(options.rootDir, {
            assetHashType: aws_cdk_lib_1.AssetHashType.SOURCE,
            exclude: exports.HASHABLE_DEPENDENCIES_EXCLUDE,
            bundling: options.skip ? undefined : new Bundling(options),
        });
    }
    constructor(props) {
        const { rootDir, workspacePackage, image, runtime, commandHooks, assetExcludes = exports.DEFAULT_ASSET_EXCLUDES, architecture = aws_lambda_1.Architecture.ARM_64, } = props;
        const bundlingCommands = this.createBundlingCommands({
            rootDir,
            workspacePackage,
            assetExcludes,
            commandHooks,
            inputDir: aws_cdk_lib_1.AssetStaging.BUNDLING_INPUT_DIR,
            outputDir: aws_cdk_lib_1.AssetStaging.BUNDLING_OUTPUT_DIR,
        });
        this.image =
            image ??
                aws_cdk_lib_1.DockerImage.fromBuild(path.resolve(__dirname, '..', 'resources'), {
                    buildArgs: {
                        ...props.buildArgs,
                        IMAGE: runtime.bundlingImage.image,
                    },
                    platform: architecture.dockerPlatform,
                });
        this.command = props.command ?? [
            'bash',
            '-c',
            bundlingCommands.join(' && '),
        ];
        this.entrypoint = props.entrypoint;
        this.volumes = props.volumes;
        this.volumesFrom = props.volumesFrom;
        this.environment = props.environment;
        this.workingDirectory = props.workingDirectory;
        this.user = props.user;
        this.securityOpt = props.securityOpt;
        this.network = props.network;
        this.bundlingFileAccess = props.bundlingFileAccess;
    }
    createBundlingCommands(options) {
        const excludeArgs = options.assetExcludes.map((exclude) => `--exclude="${exclude}"`);
        const workspacePackage = options.workspacePackage;
        const uvCommonArgs = `--directory ${options.outputDir}`;
        const uvPackageArgs = workspacePackage ? `--package ${workspacePackage}` : '';
        const reqsFile = `/tmp/requirements${workspacePackage || ''}.txt`;
        const commands = [];
        commands.push(...options.commandHooks?.beforeBundling(options.inputDir, options.outputDir) ?? []);
        commands.push(...[
            `rsync -rLv ${excludeArgs.join(' ')} ${options.inputDir}/ ${options.outputDir}`,
            `cd ${options.outputDir}`, // uv pip install needs to be run from here for editable deps to relative paths to be resolved
            `uv sync ${uvCommonArgs} ${uvPackageArgs} --python-preference=only-system --compile-bytecode --no-dev --frozen --no-editable --link-mode=copy`,
            `uv export ${uvCommonArgs} ${uvPackageArgs} --no-dev --frozen --no-editable > ${reqsFile}`,
            `uv pip install -r ${reqsFile} --target ${options.outputDir} --reinstall --compile-bytecode --link-mode=copy`,
            `rm -rf ${options.outputDir}/.venv`,
        ]);
        commands.push(...options.commandHooks?.afterBundling(options.inputDir, options.outputDir) ?? []);
        return commands;
    }
}
exports.Bundling = Bundling;
_a = JSII_RTTI_SYMBOL_1;
Bundling[_a] = { fqn: "uv-python-lambda.Bundling", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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