"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("node:fs");
const path = require("node:path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const bundling_1 = require("./bundling");
class PythonFunction extends aws_lambda_1.Function {
    constructor(scope, id, props) {
        const { workspacePackage, handler = 'handler', index = 'index.py', runtime = aws_lambda_1.Runtime.PYTHON_3_12, } = props;
        const architecture = props.architecture ?? aws_lambda_1.Architecture.ARM_64;
        const rootDir = path.resolve(props.rootDir);
        // Strip .py from the end of handler if it exists
        const strippedIndex = index.endsWith('.py') ? index.slice(0, -3) : index;
        const resolvedHandler = `${strippedIndex}.${handler}`.replace(/\//g, '.');
        if (runtime.family !== aws_lambda_1.RuntimeFamily.PYTHON) {
            throw new Error('Only Python runtimes are supported');
        }
        const skip = !aws_cdk_lib_1.Stack.of(scope).bundlingRequired;
        const code = bundling_1.Bundling.bundle({
            rootDir,
            runtime,
            skip: skip,
            architecture,
            workspacePackage,
            ...props.bundling,
        });
        const environment = props.environment ?? {};
        super(scope, id, {
            ...props,
            environment,
            architecture,
            runtime,
            code,
            handler: resolvedHandler,
        });
        if (skip) {
            return;
        }
        const assetPath = this.node.defaultChild.getMetadata('aws:asset:path');
        if (!assetPath) {
            return;
        }
        const codePath = path.join(process.env.CDK_OUTDIR, assetPath);
        const pythonPaths = getPthFilePaths(codePath);
        if (pythonPaths.length > 0) {
            let pythonPathValue = environment.PYTHONPATH;
            const addedPaths = pythonPaths.join(':');
            pythonPathValue = pythonPathValue
                ? `${pythonPathValue}:${addedPaths}`
                : addedPaths;
            this.addEnvironment('PYTHONPATH', pythonPathValue);
        }
    }
}
exports.PythonFunction = PythonFunction;
_a = JSII_RTTI_SYMBOL_1;
PythonFunction[_a] = { fqn: "uv-python-lambda.PythonFunction", version: "0.0.5" };
function getPthFilePaths(basePath) {
    const pthFiles = fs
        .readdirSync(basePath)
        .filter((file) => file.endsWith('.pth'));
    const pythonPaths = [];
    for (const pthFile of pthFiles) {
        const filePath = path.join(basePath, pthFile);
        const content = fs.readFileSync(filePath, 'utf-8');
        const dirs = content.split('\n').filter((line) => line.trim() !== '');
        pythonPaths.push(...dirs.map((dir) => path.join('/var/task', path.relative('/asset-output', dir))));
    }
    return pythonPaths;
}
//# sourceMappingURL=data:application/json;base64,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