<a name="readme-top"></a>

# 📦 Value Object Pattern

<p align="center">
    <a href="https://github.com/adriamontoto/value-object-pattern/actions/workflows/ci.yaml?event=push&branch=master" target="_blank">
        <img src="https://github.com/adriamontoto/value-object-pattern/actions/workflows/ci.yaml/badge.svg?event=push&branch=master" alt="CI Pipeline">
    </a>
        <a href="https://coverage-badge.samuelcolvin.workers.dev/redirect/adriamontoto/value-object-pattern" target="_blank">
        <img src="https://coverage-badge.samuelcolvin.workers.dev/adriamontoto/value-object-pattern.svg" alt="Coverage Pipeline">
    </a>
    <a href="https://pypi.org/project/value-object-pattern" target="_blank">
        <img src="https://img.shields.io/pypi/v/value-object-pattern?color=%2334D058&label=pypi%20package" alt="Package Version">
    </a>
    <a href="https://pypi.org/project/value-object-pattern/" target="_blank">
        <img src="https://img.shields.io/pypi/pyversions/value-object-pattern.svg?color=%2334D058" alt="Supported Python Versions">
    </a>
</p>

The **Value Object Pattern** is a Python 🐍 package that streamlines the creation and management of value objects 📦 in your projects. Value objects are immutable, self-validating objects that represent descriptive aspects of the domain with no conceptual identity. This pattern is essential for maintaining clean 🧹, maintainable, and bug-resistant 🐛 codebases by encapsulating domain-specific logic and ensuring consistency across your application 📱.
<br><br>

## Table of Contents

- [📥 Installation](#installation)
- [🤝 Contributing](#contributing)
- [🔑 License](#license)

<p align="right">
    <a href="#readme-top">🔼 Back to top</a>
</p><br><br>

<a name="installation"></a>

## 📥 Installation

You can install **Value Object Pattern** using `pip`:

```bash
pip install value-object-pattern
```

<p align="right">
    <a href="#readme-top">🔼 Back to top</a>
</p><br><br>

<a name="contributing"></a>

## 🤝 Contributing

We love community help! Before you open an issue or pull request, please read:

- [`🤝 How to Contribute`](https://github.com/adriamontoto/value-object-pattern/blob/master/.github/CONTRIBUTING.md)
- [`🧭 Code of Conduct`](https://github.com/adriamontoto/value-object-pattern/blob/master/.github/CODE_OF_CONDUCT.md)
- [`🔐 Security Policy`](https://github.com/adriamontoto/value-object-pattern/blob/master/.github/SECURITY.md)

_Thank you for helping make **📦 Value Object Pattern** package awesome! 🌟_

<p align="right">
    <a href="#readme-top">🔼 Back to top</a>
</p><br><br>

<a name="license"></a>

## 🔑 License

This project is licensed under the terms of the [`MIT license`](https://github.com/adriamontoto/value-object-pattern/blob/master/LICENSE.md).

<p align="right">
    <a href="#readme-top">🔼 Back to top</a>
</p>
