import { ConfigServiceInterface } from './ConfigServiceInterface';
import { EnvironmentVariablesService as CommonEnvironmentVariablesService } from '@aws-lambda-powertools/commons';
/**
 * Class EnvironmentVariablesService
 *
 * This class is used to return environment variables that are available in the runtime of
 * the current Lambda invocation.
 * These variables can be a mix of runtime environment variables set by AWS and
 * variables that can be set by the developer additionally.
 *
 * @class
 * @extends {CommonEnvironmentVariablesService}
 * @implements {ConfigServiceInterface}
 * @see https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime
 * @see https://awslabs.github.io/aws-lambda-powertools-typescript/latest/#environment-variables
 */
declare class EnvironmentVariablesService extends CommonEnvironmentVariablesService implements ConfigServiceInterface {
    private awsRegionVariable;
    private currentEnvironmentVariable;
    private devModeVariable;
    private functionNameVariable;
    private functionVersionVariable;
    private logEventVariable;
    private logLevelVariable;
    private memoryLimitInMBVariable;
    private sampleRateValueVariable;
    /**
     * It returns the value of the AWS_REGION environment variable.
     *
     * @returns {string}
     */
    getAwsRegion(): string;
    /**
     * It returns the value of the ENVIRONMENT environment variable.
     *
     * @returns {string}
     */
    getCurrentEnvironment(): string;
    /**
     * It returns the value of the AWS_LAMBDA_FUNCTION_MEMORY_SIZE environment variable.
     *
     * @returns {string}
     */
    getFunctionMemory(): number;
    /**
     * It returns the value of the AWS_LAMBDA_FUNCTION_NAME environment variable.
     *
     * @returns {string}
     */
    getFunctionName(): string;
    /**
     * It returns the value of the AWS_LAMBDA_FUNCTION_VERSION environment variable.
     *
     * @returns {string}
     */
    getFunctionVersion(): string;
    /**
     * It returns the value of the POWERTOOLS_LOGGER_LOG_EVENT environment variable.
     *
     * @returns {boolean}
     */
    getLogEvent(): boolean;
    /**
     * It returns the value of the LOG_LEVEL environment variable.
     *
     * @returns {string}
     */
    getLogLevel(): string;
    /**
     * It returns the value of the POWERTOOLS_LOGGER_SAMPLE_RATE environment variable.
     *
     * @returns {string|undefined}
     */
    getSampleRateValue(): number | undefined;
    /**
     * It returns true if the POWERTOOLS_DEV environment variable is set to truthy value.
     *
     * @returns {boolean}
     */
    isDevMode(): boolean;
    /**
     * It returns true if the string value represents a boolean true value.
     *
     * @param {string} value
     * @returns boolean
     */
    isValueTrue(value: string): boolean;
}
export { EnvironmentVariablesService, };
