"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProviderService = void 0;
const aws_xray_sdk_core_1 = require("aws-xray-sdk-core");
class ProviderService {
    captureAWS(awssdk) {
        return (0, aws_xray_sdk_core_1.captureAWS)(awssdk);
    }
    captureAWSClient(service) {
        return (0, aws_xray_sdk_core_1.captureAWSClient)(service);
    }
    captureAWSv3Client(service) {
        // Type must be aliased as any because of this https://github.com/aws/aws-xray-sdk-node/issues/439#issuecomment-859715660
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        return (0, aws_xray_sdk_core_1.captureAWSv3Client)(service);
    }
    captureAsyncFunc(name, fcn, _parent) {
        return (0, aws_xray_sdk_core_1.captureAsyncFunc)(name, fcn);
    }
    captureFunc(name, fcn, _parent) {
        return (0, aws_xray_sdk_core_1.captureFunc)(name, fcn);
    }
    captureHTTPsGlobal() {
        // eslint-disable-next-line @typescript-eslint/no-var-requires
        (0, aws_xray_sdk_core_1.captureHTTPsGlobal)(require('http'));
        // eslint-disable-next-line @typescript-eslint/no-var-requires
        (0, aws_xray_sdk_core_1.captureHTTPsGlobal)(require('https'));
    }
    getNamespace() {
        return (0, aws_xray_sdk_core_1.getNamespace)();
    }
    getSegment() {
        return (0, aws_xray_sdk_core_1.getSegment)();
    }
    setContextMissingStrategy(strategy) {
        (0, aws_xray_sdk_core_1.setContextMissingStrategy)(strategy);
    }
    setDaemonAddress(address) {
        (0, aws_xray_sdk_core_1.setDaemonAddress)(address);
    }
    setLogger(logObj) {
        (0, aws_xray_sdk_core_1.setLogger)(logObj);
    }
    setSegment(segment) {
        (0, aws_xray_sdk_core_1.setSegment)(segment);
    }
}
exports.ProviderService = ProviderService;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiUHJvdmlkZXJTZXJ2aWNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL3Byb3ZpZGVyL1Byb3ZpZGVyU2VydmljZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFHQSx5REFBbVE7QUFFblEsTUFBTSxlQUFlO0lBRVosVUFBVSxDQUFJLE1BQVM7UUFDNUIsT0FBTyxJQUFBLDhCQUFVLEVBQUMsTUFBTSxDQUFDLENBQUM7SUFDNUIsQ0FBQztJQUVNLGdCQUFnQixDQUFJLE9BQVU7UUFDbkMsT0FBTyxJQUFBLG9DQUFnQixFQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQ25DLENBQUM7SUFFTSxrQkFBa0IsQ0FBSSxPQUFVO1FBQ3JDLHlIQUF5SDtRQUN6SCw4REFBOEQ7UUFDOUQsT0FBTyxJQUFBLHNDQUFrQixFQUFDLE9BQWMsQ0FBQyxDQUFDO0lBQzVDLENBQUM7SUFFTSxnQkFBZ0IsQ0FBQyxJQUFZLEVBQUUsR0FBeUMsRUFBRSxPQUE4QjtRQUM3RyxPQUFPLElBQUEsb0NBQWdCLEVBQUMsSUFBSSxFQUFFLEdBQUcsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFTSxXQUFXLENBQUMsSUFBWSxFQUFFLEdBQXlDLEVBQUUsT0FBOEI7UUFDeEcsT0FBTyxJQUFBLCtCQUFXLEVBQUMsSUFBSSxFQUFFLEdBQUcsQ0FBQyxDQUFDO0lBQ2hDLENBQUM7SUFFTSxrQkFBa0I7UUFDdkIsOERBQThEO1FBQzlELElBQUEsc0NBQWtCLEVBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7UUFDcEMsOERBQThEO1FBQzlELElBQUEsc0NBQWtCLEVBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUVNLFlBQVk7UUFDakIsT0FBTyxJQUFBLGdDQUFZLEdBQUUsQ0FBQztJQUN4QixDQUFDO0lBRU0sVUFBVTtRQUNmLE9BQU8sSUFBQSw4QkFBVSxHQUFFLENBQUM7SUFDdEIsQ0FBQztJQUVNLHlCQUF5QixDQUFDLFFBQWlCO1FBQ2hELElBQUEsNkNBQXlCLEVBQUMsUUFBa0MsQ0FBQyxDQUFDO0lBQ2hFLENBQUM7SUFFTSxnQkFBZ0IsQ0FBQyxPQUFlO1FBQ3JDLElBQUEsb0NBQWdCLEVBQUMsT0FBTyxDQUFDLENBQUM7SUFDNUIsQ0FBQztJQUVNLFNBQVMsQ0FBQyxNQUFlO1FBQzlCLElBQUEsNkJBQVMsRUFBQyxNQUFnQixDQUFDLENBQUM7SUFDOUIsQ0FBQztJQUVNLFVBQVUsQ0FBQyxPQUE2QjtRQUM3QyxJQUFBLDhCQUFVLEVBQUMsT0FBTyxDQUFDLENBQUM7SUFDdEIsQ0FBQztDQUVGO0FBR0MsMENBQWUifQ==