"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ToolsLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
export class Hello {
  public sayHello() {
    return 'hello, world!';
  }
}
*/
const path = require("path");
//import { AssetCode, LayerVersion, Runtime, LayerVersionProps } from 'aws-cdk-lib/aws-lambda';
//import { Code, LayerVersion, Runtime } from 'aws-cdk-lib/aws-lambda';
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
/**
 * Create a Lambda layer with the PowerTools and other required modules.
 */
class ToolsLayer extends constructs_1.Construct {
    /**
       * @param {Construct} scope
       * @param {string} id
    */
    constructor(scope, id, props) {
        super(scope, id);
        this.layerVersion = new aws_lambda_1.LayerVersion(this, `${props?.layerVersionName}-ToolsLayer`, {
            compatibleRuntimes: [aws_lambda_1.Runtime.NODEJS_16_X],
            code: aws_lambda_1.AssetCode.fromAsset(path.join(__dirname, './powertools')),
            //code: AssetCode.fromAsset('./src/powertools'),
            //code: Code.fromAsset('src/powertools'),
            description: `${props?.layerVersionName} Tools Shared Layer`,
            layerVersionName: `${props?.layerVersionName}-tools`,
        });
    }
}
exports.ToolsLayer = ToolsLayer;
_a = JSII_RTTI_SYMBOL_1;
ToolsLayer[_a] = { fqn: "vaughntech-nodejs-powertools-lambdalayer.ToolsLayer", version: "0.0.11" };
//# sourceMappingURL=data:application/json;base64,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