"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogItem = void 0;
const lodash_pickby_1 = __importDefault(require("lodash.pickby"));
const lodash_merge_1 = __importDefault(require("lodash.merge"));
class LogItem {
    constructor(params) {
        this.attributes = {};
        // Add attributes in the log item in this order:
        // - Base attributes supported by the Powertool by default
        // - Persistent attributes provided by developer, not formatted
        // - Ephemeral attributes provided as parameters for a single log item (done later)
        this.addAttributes(params.baseAttributes);
        this.addAttributes(params.persistentAttributes);
    }
    addAttributes(attributes) {
        this.attributes = (0, lodash_merge_1.default)(this.attributes, attributes);
        return this;
    }
    getAttributes() {
        return this.attributes;
    }
    prepareForPrint() {
        this.setAttributes(this.removeEmptyKeys(this.getAttributes()));
    }
    removeEmptyKeys(attributes) {
        return (0, lodash_pickby_1.default)(attributes, (value) => value !== undefined && value !== '' && value !== null);
    }
    setAttributes(attributes) {
        this.attributes = attributes;
    }
}
exports.LogItem = LogItem;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTG9nSXRlbS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9sb2cvTG9nSXRlbS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSxrRUFBbUM7QUFDbkMsZ0VBQWlDO0FBSWpDLE1BQU0sT0FBTztJQUlYLFlBQW1CLE1BQThFO1FBRnpGLGVBQVUsR0FBa0IsRUFBRSxDQUFDO1FBR3JDLGdEQUFnRDtRQUNoRCwwREFBMEQ7UUFDMUQsK0RBQStEO1FBQy9ELG1GQUFtRjtRQUNuRixJQUFJLENBQUMsYUFBYSxDQUFDLE1BQU0sQ0FBQyxjQUFjLENBQUMsQ0FBQztRQUMxQyxJQUFJLENBQUMsYUFBYSxDQUFDLE1BQU0sQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ2xELENBQUM7SUFFTSxhQUFhLENBQUMsVUFBeUI7UUFDNUMsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFBLHNCQUFLLEVBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxVQUFVLENBQUMsQ0FBQztRQUVyRCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFTSxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQztJQUN6QixDQUFDO0lBRU0sZUFBZTtRQUNwQixJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUNqRSxDQUFDO0lBRU0sZUFBZSxDQUFDLFVBQXlCO1FBQzlDLE9BQU8sSUFBQSx1QkFBTSxFQUFDLFVBQVUsRUFBRSxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsS0FBSyxLQUFLLFNBQVMsSUFBSSxLQUFLLEtBQUssRUFBRSxJQUFJLEtBQUssS0FBSyxJQUFJLENBQUMsQ0FBQztJQUM5RixDQUFDO0lBRU0sYUFBYSxDQUFDLFVBQXlCO1FBQzVDLElBQUksQ0FBQyxVQUFVLEdBQUcsVUFBVSxDQUFDO0lBQy9CLENBQUM7Q0FFRjtBQUdDLDBCQUFPIn0=