declare type LogLevelDebug = 'DEBUG';
declare type LogLevelInfo = 'INFO';
declare type LogLevelWarn = 'WARN';
declare type LogLevelError = 'ERROR';
declare type LogLevel = LogLevelDebug | LogLevelInfo | LogLevelWarn | LogLevelError | string;
declare type LogLevelThresholds = {
    [key in LogLevel]: number;
};
declare type LogAttributeValue = unknown;
declare type LogAttributes = {
    [key: string]: LogAttributeValue;
};
declare type LogAttributesWithMessage = LogAttributes & {
    message: string;
};
declare type Environment = 'dev' | 'local' | 'staging' | 'prod' | string;
export type { LogAttributesWithMessage, LogAttributeValue, Environment, LogLevelThresholds, LogAttributes, LogLevel, };
