"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ToolsLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*
export class Hello {
  public sayHello() {
    return 'hello, world!';
  }
}
*/
//import * as path from 'path';
//import { AssetCode, LayerVersion, Runtime, LayerVersionProps } from 'aws-cdk-lib/aws-lambda';
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const constructs_1 = require("constructs");
/**
 * Create a Lambda layer with the PowerTools and other required modules.
 */
class ToolsLayer extends constructs_1.Construct {
    /**
       * @param {Construct} scope
       * @param {string} id
    */
    constructor(scope, id, props) {
        super(scope, id);
        this.layerVersion = new aws_lambda_1.LayerVersion(this, `${props?.layerVersionName}-ToolsLayer`, {
            compatibleRuntimes: [aws_lambda_1.Runtime.NODEJS_16_X],
            //code: AssetCode.fromAsset(path.join(__dirname, './powertools')),
            code: aws_lambda_1.AssetCode.fromAsset('./src/powertools'),
            description: `${props?.layerVersionName} Tools Shared Layer`,
            layerVersionName: `${props?.layerVersionName}-tools`,
        });
    }
}
exports.ToolsLayer = ToolsLayer;
_a = JSII_RTTI_SYMBOL_1;
ToolsLayer[_a] = { fqn: "vaughntech-nodejs-powertools-lambdalayer.ToolsLayer", version: "0.0.7" };
//# sourceMappingURL=data:application/json;base64,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