vcd-cli
=======

[![Stable Version](https://img.shields.io/pypi/v/vca-cli.svg)](https://pypi.python.org/pypi/vca-cli) [![Build Status](https://img.shields.io/travis/vmware/vcd-cli.svg?style=flat)](https://travis-ci.org/vmware/vcd-cli/)

Command Line Interface for VMware vCloud Director.

This project is under development, the commands and parameters might change over time. This README usually reflects the syntax of the latest version. More information about commands and usage can be found in the [vcd-cli wiki](https://github.com/vmware/vcd-cli/wiki). See the [release notes](https://github.com/vmware/vcd-cli/wiki/ReleaseNotes) for what's new.

`vcd-cli` uses [pyvcloud](https://github.com/vmware/pyvcloud "Title"), a Python SDK for VMware vCloud Director.

Installation:
=============

In general, `vca-cli` can be installed with:

``` shell
$ pip install --user vca-cli
```

Validate installation with:

``` shell
$ vca --version

vca-cli version 18 (pyvcloud: 18.0.2)
```

See [vcd-cli wiki](https://github.com/vmware/vcd-cli/wiki) for additional installation details.


Usage:
======

Login:

When the *password* argument is omitted, `vca-cli` prompts the user for the password. By default `vca-cli` caches the password (encrypted) and automatically re-login when the token expires. Below are some examples:

```shell
# vCA
$ vca login 'email@company.com' --password 'p@$$w0rd' \
            --instance 5a872845-6a7e-4e1d-b92a-99c45844417d \
            --vdc vdc1

# vCHS
$ vca login 'email@company.com' --password 'p@$$w0rd' \
            --host vchs.vmware.com

# vCloud Director
$ vca login 'email@company.com' --password 'p@$$w0rd' \
            --host vcdhost.domain.com --org my-org

# vCloud Director with self-signed SSL certificate
$ vca -i login 'email@company.com' --password 'p@$$w0rd' \
      --host vcdhost.domain.com --org my-org
```

Access to a virtual datacenter:

```
$ vca vdc info
Details of Virtual Data Center 'vdc1', profile 'od':
| Type              | Name                   |
|-------------------+------------------------|
| gateway           | gateway                |
| network           | default-routed-network |
| network           | net-101                |
| vdcStorageProfile | SSD-Accelerated        |
| vdcStorageProfile | Standard               |
Compute capacity:
| Resource    |   Allocated |   Limit |   Reserved |   Used |   Overhead |
|-------------+-------------+---------+------------+--------+------------|
| CPU (MHz)   |           0 |  130000 |          0 |      0 |          0 |
| Memory (MB) |           0 |  102400 |          0 |      0 |          0 |
Gateways:
| Name    | External IPs                  | DHCP   | Firewall   | NAT   | VPN   | Networks                        | Syslog   | Uplinks      | Selected   |
|---------+-------------------------------+--------+------------+-------+-------+---------------------------------+----------+--------------+------------|
| gateway | 107.189.88.182, 107.189.90.65 | On     | Off        | On    | Off   | net-101, default-routed-network |          | d4p14v14-ext | *          |
```

Logout:

```
$ vca logout
Logout successful for profile 'default'
```

vCloud Air Support
---

We are transitioning to a new `vcd-cli` tool that eventually will replace `vca-cli`. The new `vcd-cli` will continue to support vCloud Air.

To login to vCloud Air with the new `vcd-cli`:

- Locate the `vCloud Director API URL` link in the vCloud Air console, for example: `https://p1v17-vcd.vchs.vmware.com:443/cloud/org/20-162/`
- Identify the organization name at the end of the URL, `20-162` in the example.
- Use your email and password in the `login` command.

The general syntax of the `login` command is:

```shell
$ vcd login [OPTIONS] host organization user
```

Sample login to a vCA subscription service:

```shell
$ vcd login p1v17-vcd.vchs.vmware.com 20-162 'user@company.com' \
            --password 'p@$$w0rd' --version 17.0
```

Sample login to a vCA on-demand service:

```shell
$ vcd login us-texas-1-14.vchs.vmware.com/api/compute ad96259e-2d36-44ad-9dd7-4586d45b43ca \
            'user@company.com' \
            --password 'p@$$w0rd' --version 17.0
```
