from enum import IntEnum
from typing import TypedDict

INT32_MAX = 0x7FFFFFFF

class ServerSettings(TypedDict):
    max_players: int
    port: int
    servername: str
    flags: int

class PluginInfo(TypedDict):
    name: str
    plugin_version: str
    plugin_id: int
    api_major_version: int
    api_minor_version: int
    struct_size: int

class WorldBounds(TypedDict):
    min_x: float
    min_y: float
    max_x: float
    max_y: float

class WastedSettings(TypedDict):
    death_timer: int
    fade_timer: int
    fade_in_speed: float
    fade_out_speed: float
    fade_colour: int
    corpse_fade_start: int
    corpse_fade_time: int

class Vector(TypedDict):
    x: float
    y: float
    z: float

class Quaternion(TypedDict):
    x: float
    y: float
    z: float
    w: float

class RGBA(TypedDict):
    red: int
    green: int
    blue: int
    alpha: int

class vcmpError(IntEnum):
    vcmpErrorNone = 0
    vcmpErrorNoSuchEntity = 1
    vcmpErrorBufferTooSmall = 2
    vcmpErrorTooLargeInput = 3
    vcmpErrorArgumentOutOfBounds = 4
    vcmpErrorNullArgument = 5
    vcmpErrorPoolExhausted = 6
    vcmpErrorInvalidName = 7
    vcmpErrorRequestDenied = 8
    forceSizeVcmpError = INT32_MAX

class vcmpEntityPool(IntEnum):
    vcmpEntityPoolVehicle = 1
    vcmpEntityPoolObject = 2
    vcmpEntityPoolPickup = 3
    vcmpEntityPoolRadio = 4
    vcmpEntityPoolBlip = 7
    vcmpEntityPoolCheckPoint = 8
    forceSizeVcmpEntityPool = INT32_MAX

class vcmpDisconnectReason(IntEnum):
    vcmpDisconnectReasonTimeout = 0
    vcmpDisconnectReasonQuit = 1
    vcmpDisconnectReasonKick = 2
    vcmpDisconnectReasonCrash = 3
    vcmpDisconnectReasonAntiCheat = 4
    forceSizeVcmpDisconnectReason = INT32_MAX

class vcmpBodyPart(IntEnum):
    vcmpBodyPartBody = 0
    vcmpBodyPartTorso = 1
    vcmpBodyPartLeftArm = 2
    vcmpBodyPartRightArm = 3
    vcmpBodyPartLeftLeg = 4
    vcmpBodyPartRightLeg = 5
    vcmpBodyPartHead = 6
    vcmpBodyPartInVehicle = 7
    forceSizeVcmpBodyPart = INT32_MAX

class vcmpPlayerState(IntEnum):
    vcmpPlayerStateNone = 0
    vcmpPlayerStateNormal = 1
    vcmpPlayerStateAim = 2
    vcmpPlayerStateDriver = 3
    vcmpPlayerStatePassenger = 4
    vcmpPlayerStateEnterDriver = 5
    vcmpPlayerStateEnterPassenger = 6
    vcmpPlayerStateExit = 7
    vcmpPlayerStateUnspawned = 8
    forceSizeVcmpPlayerState = INT32_MAX

class vcmpPlayerUpdate(IntEnum):
    vcmpPlayerUpdateNormal = 0
    vcmpPlayerUpdateAiming = 1
    vcmpPlayerUpdateDriver = 2
    vcmpPlayerUpdatePassenger = 3
    forceSizeVcmpPlayerUpdate = INT32_MAX

class vcmpPlayerVehicle(IntEnum):
    vcmpPlayerVehicleOut = 0
    vcmpPlayerVehicleEntering = 1
    vcmpPlayerVehicleExiting = 2
    vcmpPlayerVehicleIn = 3
    forceSizeVcmpPlayerVehicle = INT32_MAX

class vcmpVehicleSync(IntEnum):
    vcmpVehicleSyncNone = 0
    vcmpVehicleSyncDriver = 1
    vcmpVehicleSyncPassenger = 3
    vcmpVehicleSyncNear = 4
    forceSizeVcmpVehicleSync = INT32_MAX

class vcmpVehicleUpdate(IntEnum):
    vcmpVehicleUpdateDriverSync = 0
    vcmpVehicleUpdateOtherSync = 1
    vcmpVehicleUpdatePosition = 2
    vcmpVehicleUpdateHealth = 4
    vcmpVehicleUpdateColour = 5
    vcmpVehicleUpdateRotation = 6
    forceSizeVcmpVehicleUpdate = INT32_MAX
    
class vcmpServerOption(IntEnum):
    vcmpServerOptionSyncFrameLimiter = 0
    vcmpServerOptionFrameLimiter = 1
    vcmpServerOptionTaxiBoostJump = 2
    vcmpServerOptionDriveOnWater = 3
    vcmpServerOptionFastSwitch = 4
    vcmpServerOptionFriendlyFire = 5
    vcmpServerOptionDisableDriveBy = 6
    vcmpServerOptionPerfectHandling = 7
    vcmpServerOptionFlyingCars = 8
    vcmpServerOptionJumpSwitch = 9
    vcmpServerOptionShowMarkers = 10
    vcmpServerOptionOnlyShowTeamMarkers = 11
    vcmpServerOptionStuntBike = 12
    vcmpServerOptionShootInAir = 13
    vcmpServerOptionShowNameTags = 14
    vcmpServerOptionJoinMessages = 15
    vcmpServerOptionDeathMessages = 16
    vcmpServerOptionChatTagsEnabled = 17
    vcmpServerOptionUseClasses = 18
    vcmpServerOptionWallGlitch = 19
    vcmpServerOptionDisableBackfaceCulling = 20
    vcmpServerOptionDisableHeliBladeDamage = 21
    forceSizeVcmpServerOption = INT32_MAX

class vcmpPlayerOption(IntEnum):
    vcmpPlayerOptionControllable = 0
    vcmpPlayerOptionDriveBy = 1
    vcmpPlayerOptionWhiteScanlines = 2
    vcmpPlayerOptionGreenScanlines = 3
    vcmpPlayerOptionWidescreen = 4
    vcmpPlayerOptionShowMarkers = 5
    vcmpPlayerOptionCanAttack = 6
    vcmpPlayerOptionHasMarker = 7
    vcmpPlayerOptionChatTagsEnabled = 8
    vcmpPlayerOptionDrunkEffects = 9
    forceSizeVcmpPlayerOption = INT32_MAX

class vcmpVehicleOption(IntEnum):
    vcmpVehicleOptionDoorsLocked = 0
    vcmpVehicleOptionAlarm = 1
    vcmpVehicleOptionLights = 2
    vcmpVehicleOptionRadioLocked = 3
    vcmpVehicleOptionGhost = 4
    vcmpVehicleOptionSiren = 5
    vcmpVehicleOptionSingleUse = 6
    forceSizeVcmpVehicleOption = INT32_MAX

class vcmpPickupOption(IntEnum):
    vcmpPickupOptionSingleUse = 0
    forceSizeVcmpPickupOption = INT32_MAX


def get_server_settings() -> ServerSettings: ...
def get_server_version() -> int: ...

def get_number_of_plugins() -> int: ...
def get_plugin_info(plugin_id: int) -> PluginInfo: ...
def send_plugin_command(plugin_id: int, command: str) -> None: ...

def get_time() -> int: ...

def get_last_error() -> vcmpError: ...

def send_client_script_data(player_id: int, data: bytes) -> None: ...
def send_client_message(player_id: int, color: int, message: str) -> None: ...
def send_game_message(player_id: int, type: int, message: str) -> None: ...

def set_server_name(name: str) -> None: ...
def get_server_name() -> str: ...

def set_max_players(max_players: int) -> None: ...
def get_max_players() -> int: ...

def set_server_password(password: str) -> None: ...
def get_server_password() -> str: ...

def set_game_mode_text(text: str) -> None: ...
def get_game_mode_text() -> str: ...

def shutdown_server() -> None: ...

def set_server_option(option: int, value: bool) -> None: ...
def get_server_option(option: int) -> bool: ...

def set_world_bounds(min_x: float, min_y: float, max_x: float, max_y: float) -> None: ...
def get_world_bounds() -> WorldBounds: ...

def set_wasted_settings(death_timer: int, fade_timer: int, fade_in_speed: float, fade_out_speed: float, fade_colour: int, corpse_fade_start: int, corpse_fade_time: int) -> None: ...
def get_wasted_settings() -> WastedSettings: ...

def set_time_rate(time_rate: int) -> None: ...
def get_time_rate() -> int: ...

def set_hour(hour: int) -> None: ...
def get_hour() -> int: ...

def set_minute(minute: int) -> None: ...
def get_minute() -> int: ...

def set_weather(weather: int) -> None: ...
def get_weather() -> int: ...

def set_gravity(gravity: float) -> None: ...
def get_gravity() -> float: ...

def set_game_speed(game_speed: float) -> None: ...
def get_game_speed() -> float: ...

def set_water_level(water_level: float) -> None: ...
def get_water_level() -> float: ...

def set_maximum_flight_altitude(height: float) -> None: ...
def get_maximum_flight_altitude() -> float: ...

def set_kill_command_delay(delay: int) -> None: ...
def get_kill_command_delay() -> int: ...

def set_vehicles_forced_respawn_height(height: float) -> None: ...
def get_vehicles_forced_respawn_height() -> float: ...

def create_explosion(world_id: int, type: int, x: float, y: float, z: float, responsible_player_id: int, at_ground_level: int): ...
def play_sound(world_id: int, sound_id: int, x: float, y: float, z: float): ...

def hide_map_object(model_id: int, tenth_x: int, tenth_y: int, tenth_z: int) -> None: ...
def show_map_object(model_id: int, tenth_x: int, tenth_y: int, tenth_z: int) -> None: ...
def show_all_map_objects() -> None: ...

def set_weapon_data_value(weapon_id: int, field_id: int, value: float) -> None: ...
def get_weapon_data_value(weapon_id: int, field_id: int) -> float: ...
def reset_weapon_data_value(weapon_id: int, field_id: int) -> None: ...
def is_weapon_data_value_modified(weapon_id: int, field_id: int) -> bool: ...
def reset_weapon_data(weapon_id: int) -> None: ...
def reset_all_weapon_data() -> None: ...

def get_key_bind_unused_slot() -> int: ...
def get_key_bind_data(bind_id: int) -> tuple: ...
def register_key_bind(bind_id: int, is_called_on_release: int, key_one: int, key_two: int, key_three: int) -> None: ...
def remove_key_bind(bind_id: int) -> None: ...
def remove_all_key_binds() -> None: ...

def create_coord_blip(index: int, world: int, x: float, y: float, z: float, scale: int, colour: int, sprite: int) -> int: ...
def destroy_coord_blip(index: int) -> None: ...
def get_coord_blip_info(index: int) -> tuple[int, float, float, float, int, int, int]: ...

def add_radio_stream(radio_id: int, radio_name: str, radio_url: str, is_listed: bool): ...
def remove_radio_stream(radio_id: int): ...

def add_player_class(team_id: int, colour: int, model_index: int, x: float, y: float, z: float, angle: float, weapon_one: int, weapon_one_ammo: int, weapon_two: int, weapon_two_ammo: int, weapon_three: int, weapon_three_ammo: int) -> int: ...
def set_spawn_player_position(x: float, y: float, z: float) -> None: ...
def set_spawn_camera_position(x: float, y: float, z: float) -> None: ...
def set_spawn_camera_look_at(x: float, y: float, z: float) -> None: ...


def is_player_admin(player_id: int) -> bool: ...
def set_player_admin(player_id: int, toggle: bool) -> None: ...
def get_player_ip(player_id: int) -> str: ...
def get_player_uid(player_id: int) -> str: ...
def get_player_uid2(player_id: int) -> str: ...
def kick_player(player_id: int) -> None: ...
def ban_player(player_id: int) -> None: ...
def ban_ip(ip_address: str) -> None: ...
def unban_ip(ip_address: str) -> int: ...
def is_ip_banned(ip_address: str) -> bool: ...
def get_player_id_from_name(name: str) -> int: ...
def is_player_connected(player_id: int) -> bool: ...
def is_player_streamed_for_player(checked_player_id: int, player_id: int) -> bool: ...
def get_player_key(player_id: int) -> int: ...
def get_player_name(player_id: int) -> str: ...
def set_player_name(player_id: int, name: str) -> int: ...
def get_player_state(player_id: int) -> int: ...
def set_player_option(player_id: int, option: int, toggle: bool) -> None: ...
def get_player_option(player_id: int, option: int) -> bool: ...
def set_player_world(player_id: int, world: int) -> None: ...
def get_player_world(player_id: int) -> int: ...
def set_player_secondary_world(player_id: int, secondary_world: int) -> None: ...
def get_player_secondary_world(player_id: int) -> int: ...
def get_player_unique_world(player_id: int) -> int: ...
def is_player_world_compatible(player_id: int, world: int) -> bool: ...
def get_player_class(player_id: int) -> int: ...
def set_player_team(player_id: int, team_id: int) -> None: ...
def get_player_team(player_id: int) -> int: ...
def set_player_skin(player_id: int, skin_id: int) -> None: ...
def get_player_skin(player_id: int) -> int: ...
def set_player_colour(player_id: int, colour: int) -> None: ...
def get_player_colour(player_id: int) -> int: ...
def is_player_spawned(player_id: int) -> bool: ...
def force_player_spawn(player_id: int) -> None: ...
def force_player_select(player_id: int) -> None: ...
def force_all_select() -> None: ...
def is_player_typing(player_id: int) -> bool: ...
def give_player_money(player_id: int, amount: int) -> None: ...
def set_player_money(player_id: int, amount: int) -> None: ...
def get_player_money(player_id: int) -> int: ...
def set_player_score(player_id: int, score: int) -> None: ...
def get_player_score(player_id: int) -> int: ...
def set_player_wanted_level(player_id: int, level: int) -> None: ...
def get_player_wanted_level(player_id: int) -> int: ...
def get_player_ping(player_id: int) -> int: ...
def get_player_fps(player_id: int) -> float: ...
def set_player_health(player_id: int, health: float) -> None: ...
def get_player_health(player_id: int) -> float: ...
def set_player_armour(player_id: int, armour: float) -> None: ...
def get_player_armour(player_id: int) -> float: ...
def set_player_immunity_flags(player_id: int, flags: int) -> None: ...
def get_player_immunity_flags(player_id: int) -> int: ...
def set_player_position(player_id: int, x: float, y: float, z: float) -> None: ...
def get_player_position(player_id: int) -> Vector: ...
def set_player_speed(player_id: int, x: float, y: float, z: float) -> None: ...
def get_player_speed(player_id: int) -> Vector: ...
def add_player_speed(player_id: int, x: float, y: float, z: float) -> None: ...
def set_player_heading(player_id: int, angle: float) -> None: ...
def get_player_heading(player_id: int) -> float: ...
def set_player_alpha(player_id: int, alpha: int, fade_time: int) -> None: ...
def get_player_alpha(player_id: int) -> int: ...
def get_player_aim_position(player_id: int) -> Vector: ...
def get_player_aim_direction(player_id: int) -> Vector: ...
def is_player_on_fire(player_id: int) -> bool: ...
def is_player_crouching(player_id: int) -> bool: ...
def get_player_action(player_id: int) -> int: ...
def get_player_game_keys(player_id: int) -> int: ...
def put_player_in_vehicle(player_id: int, vehicle_id: int, slot_index: int, make_room: int, warp: int) -> None: ...
def remove_player_from_vehicle(player_id: int) -> None: ...
def get_player_in_vehicle_status(player_id: int) -> int: ...
def get_player_in_vehicle_slot(player_id: int) -> int: ...
def get_player_vehicle_id(player_id: int) -> int: ...
def give_player_weapon(player_id: int, weapon_id: int, ammo: int) -> None: ...
def set_player_weapon(player_id: int, weapon_id: int, ammo: int) -> None: ...
def get_player_weapon(player_id: int) -> int: ...
def get_player_weapon_ammo(player_id: int) -> int: ...
def set_player_weapon_slot(player_id: int, slot: int) -> None: ...
def get_player_weapon_slot(player_id: int) -> int: ...
def get_player_weapon_at_slot(player_id: int, slot: int) -> int: ...
def get_player_ammo_at_slot(player_id: int, slot: int) -> int: ...
def remove_player_weapon(player_id: int, weapon_id: int) -> None: ...
def remove_all_weapons(player_id: int) -> None: ...
def set_camera_position(player_id: int, pos_x: float, pos_y: float, pos_z: float, look_x: float, look_y: float, look_z: float) -> None: ...
def restore_camera(player_id: int) -> None: ...
def is_camera_locked(player_id: int) -> bool: ...
def set_player_animation(player_id: int, group_id: int, animation_id: int) -> None: ...
def get_player_standing_on_vehicle(player_id: int) -> int: ...
def get_player_standing_on_object(player_id: int) -> int: ...
def is_player_away(player_id: int) -> bool: ...
def get_player_spectate_target(player_id: int) -> int: ...
def set_player_spectate_target(player_id: int, target_id: int) -> None: ...
def redirect_player_to_server(player_id: int, ip: str, port: int, nick: str, server_password: str, user_password: str) -> None: ...


def create_vehicle(model_index: int, world: int, x: float, y: float, z: float, angle: float, primary_colour: int, secondary_colour: int) -> int: ...
def delete_vehicle(vehicle_id: int) -> None: ...
def set_vehicle_option(vehicle_id: int, option: int, toggle: bool) -> None: ...
def get_vehicle_option(vehicle_id: int, option: int) -> bool: ...
def get_vehicle_sync_source(vehicle_id: int) -> int: ...
def get_vehicle_sync_type(vehicle_id: int) -> int: ...
def is_vehicle_streamed_for_player(vehicle_id: int, player_id: int) -> int: ...
def set_vehicle_world(vehicle_id: int, world: int) -> None: ...
def get_vehicle_world(vehicle_id: int) -> int: ...
def get_vehicle_model(vehicle_id: int) -> int: ...
def get_vehicle_occupant(vehicle_id: int, slot_index: int) -> int: ...
def respawn_vehicle(vehicle_id: int) -> None: ...
def set_vehicle_immunity_flags(vehicle_id: int, immunity_flags: int) -> None: ...
def get_vehicle_immunity_flags(vehicle_id: int) -> int: ...
def explode_vehicle(vehicle_id: int) -> None: ...
def is_vehicle_wrecked(vehicle_id: int) -> bool: ...
def set_vehicle_position(vehicle_id: int, x: float, y: float, z: float, remove_occupants: int) -> None: ...
def get_vehicle_position(vehicle_id: int) -> Vector: ...
def set_vehicle_rotation(vehicle_id: int, x: float, y: float, z: float, w: float) -> None: ...
def set_vehicle_rotation_euler(vehicle_id: int, x: float, y: float, z: float) -> None: ...
def get_vehicle_rotation(vehicle_id: int) -> Quaternion: ...
def get_vehicle_rotation_euler(vehicle_id: int) -> Vector: ...
def set_vehicle_speed(vehicle_id: int, x: float, y: float, z: float, add: bool, relative: bool) -> None: ...
def get_vehicle_speed(vehicle_id: int, relative: bool) -> Vector: ...
def set_vehicle_turn_speed(vehicle_id: int, x: float, y: float, z: float, add: bool, relative: bool) -> None: ...
def get_vehicle_turn_speed(vehicle_id: int, relative: bool) -> Vector: ...
def set_vehicle_spawn_position(vehicle_id: int, x: float, y: float, z: float) -> None: ...
def get_vehicle_spawn_position(vehicle_id: int) -> Vector: ...
def set_vehicle_spawn_rotation(vehicle_id: int, x: float, y: float, z: float, w: float) -> None: ...
def set_vehicle_spawn_rotation_euler(vehicle_id: int, x: float, y: float, z: float) -> None: ...
def get_vehicle_spawn_rotation(vehicle_id: int) -> Quaternion: ...
def get_vehicle_spawn_rotation_euler(vehicle_id: int) -> Vector: ...
def set_vehicle_idle_respawn_timer(vehicle_id: int, millis: int) -> None: ...
def get_vehicle_idle_respawn_timer(vehicle_id: int) -> int: ...
def set_vehicle_health(vehicle_id: int, health: float) -> None: ...
def get_vehicle_health(vehicle_id: int) -> float: ...
def set_vehicle_colour(vehicle_id: int, primary_colour: int, secondary_colour: int) -> None: ...
def get_vehicle_colour(vehicle_id: int) -> tuple[int, int]: ...
def set_vehicle_part_status(vehicle_id: int, part_id: int, status: int) -> None: ...
def get_vehicle_part_status(vehicle_id: int, part_id: int) -> int: ...
def set_vehicle_tyre_status(vehicle_id: int, tyre_id: int, status: int) -> None: ...
def get_vehicle_tyre_status(vehicle_id: int, tyre_id: int) -> int: ...
def set_vehicle_damage_data(vehicle_id: int, damage_data: int) -> None: ...
def get_vehicle_damage_data(vehicle_id: int) -> int: ...
def set_vehicle_radio(vehicle_id: int, radio_id: int) -> None: ...
def get_vehicle_radio(vehicle_id: int) -> int: ...
def get_vehicle_turret_rotation(vehicle_id: int) -> tuple: ...
def reset_all_vehicle_handlings() -> None: ...
def exists_handling_rule(model_index: int, rule_index: int) -> bool: ...
def set_handling_rule(model_index: int, rule_index: int, value: float) -> None: ...
def get_handling_rule(model_index: int, rule_index: int) -> float: ...
def reset_handling_rule(model_index: int, rule_index: int) -> None: ...
def reset_handling(model_index: int) -> None: ...
def exists_inst_handling_rule(vehicle_id: int, rule_index: int) -> bool: ...
def set_inst_handling_rule(vehicle_id: int, rule_index: int, value: float) -> None: ...
def get_inst_handling_rule(vehicle_id: int, rule_index: int) -> float: ...
def reset_inst_handling_rule(vehicle_id: int, rule_index: int) -> None: ...
def reset_inst_handling(vehicle_id: int) -> None: ...
def create_pickup(model_index: int, world: int, quantity: int, x: float, y: float, z: float, alpha: int, is_automatic: int) -> int: ...
def delete_pickup(pickup_id: int) -> None: ...
def is_pickup_streamed_for_player(pickup_id: int, player_id: int) -> int: ...
def set_pickup_world(pickup_id: int, world: int) -> None: ...
def get_pickup_world(pickup_id: int) -> int: ...
def set_pickup_alpha(pickup_id: int, alpha: int) -> None: ...
def get_pickup_alpha(pickup_id: int) -> int: ...
def set_pickup_is_automatic(pickup_id: int, toggle: bool) -> None: ...
def is_pickup_automatic(pickup_id: int) -> int: ...
def set_pickup_auto_timer(pickup_id: int, duration_millis: int) -> None: ...
def get_pickup_auto_timer(pickup_id: int) -> int: ...
def refresh_pickup(pickup_id: int) -> None: ...
def set_pickup_position(pickup_id: int, x: float, y: float, z: float) -> None: ...
def get_pickup_position(pickup_id: int) -> Vector: ...
def get_pickup_model(pickup_id: int) -> int: ...
def get_pickup_quantity(pickup_id: int) -> int: ...
def create_check_point(player_id: int, world: int, is_sphere: int, x: float, y: float, z: float, red: int, green: int, blue: int, alpha: int, radius: float) -> int: ...
def delete_check_point(check_point_id: int) -> None: ...
def is_check_point_streamed_for_player(check_point_id: int, player_id: int) -> bool: ...
def is_check_point_sphere(check_point_id: int) -> bool: ...
def set_check_point_world(check_point_id: int, world: int) -> None: ...
def get_check_point_world(check_point_id: int) -> int: ...
def set_check_point_colour(check_point_id: int, red: int, green: int, blue: int, alpha: int) -> None: ...
def get_check_point_colour(check_point_id: int) -> RGBA: ...
def set_check_point_position(check_point_id: int, x: float, y: float, z: float) -> None: ...
def get_check_point_position(check_point_id: int) -> Vector: ...
def set_check_point_radius(check_point_id: int, radius: float) -> None: ...
def get_check_point_radius(check_point_id: int) -> float: ...
def get_check_point_owner(check_point_id: int) -> int: ...
def create_object(model_index: int, world: int, x: float, y: float, z: float, alpha: int) -> int: ...
def delete_object(object_id: int) -> None: ...
def is_object_streamed_for_player(object_id: int, player_id: int) -> bool: ...
def get_object_model(object_id: int) -> int: ...
def set_object_world(object_id: int, world: int) -> None: ...
def get_object_world(object_id: int) -> int: ...
def set_object_alpha(object_id: int, alpha: int, duration: int) -> None: ...
def get_object_alpha(object_id: int) -> int: ...
def move_object_to(object_id: int, x: float, y: float, z: float, duration: int) -> None: ...
def move_object_by(object_id: int, x: float, y: float, z: float, duration: int) -> None: ...
def set_object_position(object_id: int, x: float, y: float, z: float) -> None: ...
def get_object_position(object_id: int) -> Vector: ...
def rotate_object_to(object_id: int, x: float, y: float, z: float, w: float, duration: int) -> None: ...
def rotate_object_to_euler(object_id: int, x: float, y: float, z: float, duration: int) -> None: ...
def rotate_object_by(object_id: int, x: float, y: float, z: float, w: float, duration: int) -> None: ...
def rotate_object_by_euler(object_id: int, x: float, y: float, z: float, duration: int) -> None: ...
def get_object_rotation(object_id: int) -> Quaternion: ...
def get_object_rotation_euler(object_id: int) -> Vector: ...
def set_object_shot_report_enabled(object_id: int, toggle: bool) -> None: ...
def is_object_shot_report_enabled(object_id: int) -> bool: ...
def set_object_touched_report_enabled(object_id: int, toggle: bool) -> None: ...
def is_object_touched_report_enabled(object_id: int) -> bool: ...
def get_player_module_list(player_id: int) -> None: ...
def set_pickup_option(pickup_id: int, option: int, toggle: bool) -> None: ...
def get_pickup_option(pickup_id: int, option: int) -> bool: ...
def set_fall_timer(time_rate: int) -> None: ...
def get_fall_timer() -> int: ...
def set_vehicle_lights_data(vehicle_id: int, lights_data: int) -> None: ...
def get_vehicle_lights_data(vehicle_id: int) -> int: ...

def check_entity_exists(pool: int, index: int) -> bool: ...

# maybe 0.4.7.0 or high version
def kill_player(player_id: int) -> None: ...
def set_vehicle_3d_arrow_for_player(vehicle_id: int, target_player_id: int, toggle: bool) -> None: ...
def get_vehicle_3d_arrow_for_player(vehicle_id: int, target_player_id: int) -> bool: ...
def set_player_3d_arrow_for_player(player_id: int, target_player_id: int, toggle: bool) -> None: ...
def get_player_3d_arrow_for_player(player_id: int, target_player_id: int) -> bool: ...
def set_player_drunk_handling(player_id: int, drunk_level: int) -> None: ...
def get_player_drunk_handling(player_id: int) -> int: ...
def set_player_drunk_visuals(player_id: int, drunk_level: int) -> None: ...
def get_player_drunk_visuals(player_id: int) -> int: ...
def interpolate_camera_look_at(player_id: int, look_x: float, look_y: float, look_z: float, interp_time_ms: int) -> None: ...
