from typing import Optional
from .player import Player
from vcmp.types import Quaternion, Vector

class Object:
    def __eq__(self, value: 'Object') -> bool: ...
    def __hash__(self) -> int: ...

    @property
    def id(self) -> int: ...

    def add_position(self, vector: Vector) -> None: ...

    @property
    def alpha(self) -> int: ...
    def set_alpha(self, alpha: int, duration: Optional[int] = None) -> None: ...

    def delete(self) -> None: ...

    @property
    def is_alive(self) -> bool: ...

    def is_streamed_for_player(self, player: Player) -> bool: ...

    @property
    def model(self) -> int: ...

    def move_by(self, vector: Vector, duration: Optional[int] = None) -> None: ...
    def move_to(self, vector: Vector, duration: Optional[int] = None) -> None: ...

    @property
    def position(self) -> Vector: ...
    @position.setter
    def position(self, vector: Vector) -> None: ...

    def rotate_by(self, quaternion: Quaternion, duration: Optional[int] = None) -> None: ...
    def rotate_to(self, quaternion: Quaternion, duration: Optional[int] = None) -> None: ...
    def rotate_by_euler(self, vector: Vector, duration: Optional[int] = None) -> None: ...
    def rotate_to_euler(self, vector: Vector, duration: Optional[int] = None) -> None: ...

    @property
    def shot_report(self) -> bool: ...
    @shot_report.setter
    def shot_report(self, enabled: bool) -> None: ...

    @property
    def touched_report(self) -> bool: ...
    @touched_report.setter
    def touched_report(self, enabled: bool) -> None: ...

    @property
    def world(self) -> int: ...
    @world.setter
    def world(self, world: int) -> None: ...

    @property
    def rotation(self) -> Quaternion: ...
    @rotation.setter
    def rotation(self, quaternion: Quaternion) -> None: ...

    @property
    def rotation_euler(self) -> Vector: ...
    @rotation_euler.setter
    def rotation_euler(self, vector: Vector) -> None: ...

def create_object(
    model: int,
    world: int,
    pos: Vector,
    alpha: int,
) -> Object: ...