from typing import Optional, Tuple

from vcmp.types import Vector, RGB
from .player import Player

class CheckPoint:
    @property
    def id(self) -> int: ...
    def __hash__(self) -> int: ...
    def __eq__(self, other: "CheckPoint") -> bool: ...
    def add_position(self, pos: Vector) -> None: ...
    @property
    def color(self) -> RGB: ...
    @color.setter
    def color(self, value: RGB) -> None: ...
    def delete(self) -> None: ...
    @property
    def is_alive(self) -> bool: ...
    def is_streamed_for_player(self, player: Player) -> bool: ...
    @property
    def owner(self) -> Optional[Player]: ...
    @property
    def position(self) -> Vector: ...
    @position.setter
    def position(self, value: Vector) -> None: ...
    @property
    def radius(self) -> float: ...
    @radius.setter
    def radius(self, value: float) -> None: ...
    @property
    def sphere(self) -> bool: ...
    @property
    def world(self) -> int: ...
    @world.setter
    def world(self, value: int) -> None: ...

def create_checkpoint(
    world: int,
    sphere: bool,
    pos: Vector,
    color: RGB,
    radius: float,
    player: Optional[Player] = None,
) -> CheckPoint: ...
