from .player import Player
from vcmp.types import Vector


class Pickup:
    def __hash__(self) -> int: ...
    def __eq__(self, other: "Pickup") -> bool: ...
    @property
    def id(self) -> int: ...
    def add_position(self, position: Vector) -> None: ...
    @property
    def alpha(self) -> int: ...
    @alpha.setter
    def alpha(self, alpha: int) -> None: ...
    @property
    def automatic(self) -> bool: ...
    @automatic.setter
    def automatic(self, automatic: bool) -> None: ...
    def delete(self) -> None: ...
    @property
    def is_alive(self) -> bool: ...
    def is_streamed_for_player(self, player: Player) -> bool: ...
    @property
    def model(self) -> int: ...
    @property
    def position(self) -> Vector: ...
    @position.setter
    def position(self, position: Vector) -> None: ...
    @property
    def quantity(self) -> int: ...
    def refresh(self) -> None: ...
    @property
    def single_use(self) -> bool: ...
    @single_use.setter
    def single_use(self, single_use: bool) -> None: ...
    @property
    def timer(self) -> int: ...
    @timer.setter
    def timer(self, timer: int) -> None: ...
    @property
    def world(self) -> int: ...
    @world.setter
    def world(self, world: int) -> None: ...


def create_pickup(
    model_index: int,
    world: int,
    quantity: int,
    position: Vector,
    alpha: int,
    is_automatic: bool,
) -> Pickup: ...
