# Copyright (c) 2025 Beijing Volcano Engine Technology Co., Ltd. and/or its affiliates.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from abc import ABC, abstractmethod
from typing import Any


class DatabaseType:
    LOCAL = "local"
    RELATIONAL = "relational"
    VECTOR = "vector"
    KV = "kv"


class BaseDatabase(ABC):
    """Base class for database.

    Args:
        type: type of the database

    Note:
        No `update` function support currently.
    """

    def __init__(self):
        pass

    def add(self, texts: list[Any], **kwargs: Any): ...

    @abstractmethod
    def delete(self, **kwargs: Any): ...

    @abstractmethod
    def query(self, query: str, **kwargs: Any) -> list[str]: ...
