# coding: utf-8

"""
    VXC Services API

    API for methods pertaining to all VXC services  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from vincrosscheck.api_client import ApiClient


class VehicleFinanceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_financial_portfolio(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Add financial portfolios  # noqa: E501

        Method to add financial portfolios  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.add_financial_portfolio(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param Request request: The financial portfolios to be added (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.add_financial_portfolio_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.add_financial_portfolio_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def add_financial_portfolio_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Add financial portfolios  # noqa: E501

        Method to add financial portfolios  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.add_financial_portfolio_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param Request request: The financial portfolios to be added (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_financial_portfolio" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `add_financial_portfolio`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `add_financial_portfolio`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `add_financial_portfolio`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/vehicle/financial/portfolio/add', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def financial_portfolio(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Update financial portfolios  # noqa: E501

        Method to update financial portfolios  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.financial_portfolio(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param list[FinancialPortfolioRequest] request: The financial portfolios to update (required)
        :return: list[FinancialPortfolioResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.financial_portfolio_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.financial_portfolio_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def financial_portfolio_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Update financial portfolios  # noqa: E501

        Method to update financial portfolios  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.financial_portfolio_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param list[FinancialPortfolioRequest] request: The financial portfolios to update (required)
        :return: list[FinancialPortfolioResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method financial_portfolio" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `financial_portfolio`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `financial_portfolio`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `financial_portfolio`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/vehicle/financial/portfolio', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[FinancialPortfolioResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def financial_portfolio_alerts(self, x_api_key, x_autotec_id, **kwargs):  # noqa: E501
        """Retrieve financial portfolio alerts  # noqa: E501

        Get Method to retrieve financial portfolio alerts  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.financial_portfolio_alerts(x_api_key, x_autotec_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param str start_date: Start Date for the portfolio alerts
        :param str end_date: End Date for the portfolio alerts
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.financial_portfolio_alerts_with_http_info(x_api_key, x_autotec_id, **kwargs)  # noqa: E501
        else:
            (data) = self.financial_portfolio_alerts_with_http_info(x_api_key, x_autotec_id, **kwargs)  # noqa: E501
            return data

    def financial_portfolio_alerts_with_http_info(self, x_api_key, x_autotec_id, **kwargs):  # noqa: E501
        """Retrieve financial portfolio alerts  # noqa: E501

        Get Method to retrieve financial portfolio alerts  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.financial_portfolio_alerts_with_http_info(x_api_key, x_autotec_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param str start_date: Start Date for the portfolio alerts
        :param str end_date: End Date for the portfolio alerts
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'start_date', 'end_date']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method financial_portfolio_alerts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `financial_portfolio_alerts`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `financial_portfolio_alerts`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'start_date' in params:
            query_params.append(('startDate', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('endDate', params['end_date']))  # noqa: E501

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/vehicle/financial/portfolio/alerts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_financial_portfolio(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Remove financial portfolios  # noqa: E501

        Method to Remove financial portfolios  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.remove_financial_portfolio(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param Request1 request: The financial portfolios to be removed (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.remove_financial_portfolio_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_financial_portfolio_with_http_info(x_api_key, x_autotec_id, request, **kwargs)  # noqa: E501
            return data

    def remove_financial_portfolio_with_http_info(self, x_api_key, x_autotec_id, request, **kwargs):  # noqa: E501
        """Remove financial portfolios  # noqa: E501

        Method to Remove financial portfolios  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.remove_financial_portfolio_with_http_info(x_api_key, x_autotec_id, request, async=True)
        >>> result = thread.get()

        :param async bool
        :param str x_api_key: the AutoTec assigned authentication credential for the calling customer (required)
        :param str x_autotec_id: the AutoTec assigned identification id for the calling customer (required)
        :param Request1 request: The financial portfolios to be removed (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_api_key', 'x_autotec_id', 'request']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_financial_portfolio" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_api_key' is set
        if ('x_api_key' not in params or
                params['x_api_key'] is None):
            raise ValueError("Missing the required parameter `x_api_key` when calling `remove_financial_portfolio`")  # noqa: E501
        # verify the required parameter 'x_autotec_id' is set
        if ('x_autotec_id' not in params or
                params['x_autotec_id'] is None):
            raise ValueError("Missing the required parameter `x_autotec_id` when calling `remove_financial_portfolio`")  # noqa: E501
        # verify the required parameter 'request' is set
        if ('request' not in params or
                params['request'] is None):
            raise ValueError("Missing the required parameter `request` when calling `remove_financial_portfolio`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_api_key' in params:
            header_params['x-api-key'] = params['x_api_key']  # noqa: E501
        if 'x_autotec_id' in params:
            header_params['x-autotec-id'] = params['x_autotec_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request' in params:
            body_params = params['request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['CustomerAuthorizer', 'api_key']  # noqa: E501

        return self.api_client.call_api(
            '/vehicle/financial/portfolio/remove', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
