# vincrosscheck-api-python-client
API for methods pertaining to all VXC services

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.4
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import vincrosscheck 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import vincrosscheck
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import vincrosscheck
from vincrosscheck.rest import ApiException
from pprint import pprint

# Configure API key authorization: CustomerAuthorizer
vincrosscheck.configuration.api_key['Unused'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# vincrosscheck.configuration.api_key_prefix['Unused'] = 'Bearer'
# create an instance of the API class
api_instance = vincrosscheck.BrickFTPApi()
x_api_key = 'x_api_key_example' # str | the AutoTec assigned authentication credential for the calling customer (optional)
x_autotec_id = 'x_autotec_id_example' # str | the AutoTec assigned identification id for the calling customer (optional)

try:
    # Webhook for VXC BrickFTP implementations
    api_response = api_instance.brickftp(x_api_key=x_api_key, x_autotec_id=x_autotec_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BrickFTPApi->brickftp: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://vxc.dev.autotec.com/api/*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BrickFTPApi* | [**brickftp**](docs/BrickFTPApi.md#brickftp) | **GET** /webhook/brickftp/vxc | Webhook for VXC BrickFTP implementations
*BrickFTPApi* | [**brickftp_0**](docs/BrickFTPApi.md#brickftp_0) | **GET** /webhook/brickftp/vxc/compressed | Webhook for VXC compressed file transfer
*BrickFTPApi* | [**brickftp_1**](docs/BrickFTPApi.md#brickftp_1) | **GET** /webhook/brickftp/vxc/encrypted | Webhook for VXC encrypted file transfer
*VehicleFinanceApi* | [**add_financial_portfolio**](docs/VehicleFinanceApi.md#add_financial_portfolio) | **POST** /vehicle/financial/portfolio/add | Add financial portfolios
*VehicleFinanceApi* | [**financial_portfolio_alerts**](docs/VehicleFinanceApi.md#financial_portfolio_alerts) | **GET** /vehicle/financial/portfolio/alerts | Retrieve financial portfolio alerts
*VehicleFinanceApi* | [**remove_financial_portfolio**](docs/VehicleFinanceApi.md#remove_financial_portfolio) | **POST** /vehicle/financial/portfolio/remove | Remove financial portfolios
*DefaultApi* | [**vehicle_financial_portfolio_add_options**](docs/DefaultApi.md#vehicle_financial_portfolio_add_options) | **OPTIONS** /vehicle/financial/portfolio/add | 
*DefaultApi* | [**vehicle_financial_portfolio_alerts_options**](docs/DefaultApi.md#vehicle_financial_portfolio_alerts_options) | **OPTIONS** /vehicle/financial/portfolio/alerts | 
*DefaultApi* | [**vehicle_financial_portfolio_remove_options**](docs/DefaultApi.md#vehicle_financial_portfolio_remove_options) | **OPTIONS** /vehicle/financial/portfolio/remove | 
*DefaultApi* | [**webhook_brickftp_vxc_compressed_options**](docs/DefaultApi.md#webhook_brickftp_vxc_compressed_options) | **OPTIONS** /webhook/brickftp/vxc/compressed | 
*DefaultApi* | [**webhook_brickftp_vxc_encrypted_options**](docs/DefaultApi.md#webhook_brickftp_vxc_encrypted_options) | **OPTIONS** /webhook/brickftp/vxc/encrypted | 
*DefaultApi* | [**webhook_brickftp_vxc_options**](docs/DefaultApi.md#webhook_brickftp_vxc_options) | **OPTIONS** /webhook/brickftp/vxc | 


## Documentation For Models

 - [Empty](docs/Empty.md)
 - [FinancialPortfolioAddRequest](docs/FinancialPortfolioAddRequest.md)
 - [FinancialPortfolioRequest](docs/FinancialPortfolioRequest.md)
 - [FinancialPortfolioResponse](docs/FinancialPortfolioResponse.md)
 - [FinancialPortfolioResponseErrors](docs/FinancialPortfolioResponseErrors.md)
 - [Request](docs/Request.md)
 - [Request1](docs/Request1.md)
 - [VehicleFinanceDealer](docs/VehicleFinanceDealer.md)
 - [VehicleFinanceDetails](docs/VehicleFinanceDetails.md)
 - [VehicleFinanceLocation](docs/VehicleFinanceLocation.md)
 - [VehicleFinanceOdometer](docs/VehicleFinanceOdometer.md)
 - [VehicleFinancePortfolio](docs/VehicleFinancePortfolio.md)
 - [VehicleFinanceRecord](docs/VehicleFinanceRecord.md)
 - [VehiclefinancialportfolioremoveRecords](docs/VehiclefinancialportfolioremoveRecords.md)


## Documentation For Authorization


## CustomerAuthorizer

- **Type**: API key
- **API key parameter name**: Unused
- **Location**: HTTP header

## api_key

- **Type**: API key
- **API key parameter name**: x-api-key
- **Location**: HTTP header


## Author



